/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Chart;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;

public abstract class AbstractAttrValPagePlugin
extends AbstractMobFormPlugin {
    protected static final String showEntryListKey = "showEntryList";
    protected static final String pageLabelKey = "pageLabelKey";
    protected static final String sortDirection = "sortDirection";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String opKey = source.getKey();
        if ("flexpanelap5".equals(opKey)) {
            this.sortPageData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("labellist".equals(name)) {
            this.buildRankPanel();
        }
    }

    public void afterCreateNewData(EventObject e) {
        String pageLabel = (String)this.getView().getFormShowParameter().getCustomParam("attrPageKey");
        this.getPageCache().put(pageLabelKey, pageLabel);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String endDate = String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u622a\u6b62\uff1a%1$s", (String)"AbstractAttrValPagePlugin_afterCreateNewData_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), sdf.format(new Date()));
        this.setControlText("enddate", endDate);
        this.initRankPanel();
        this.buildPageChart();
    }

    private void buildRankPanel() {
        String custEntryStr = this.getPageCache().get("custEntryList");
        List jsonObjects = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        ArrayList<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(jsonObjects.size());
        for (JSONObject jsonObject : jsonObjects) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            custEntryList.add(entry);
        }
        List<CustomerAnalysisEntry> showEntryList = this.getShowEntryList(custEntryList);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = showEntryList.size(); i < custEntryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"rfmentryflex"});
        }
        this.getPageCache().put(showEntryListKey, JsonUtil.encodeToString(showEntryList));
        this.getPageCache().put(sortDirection, "up");
        this.sortPageData();
    }

    private void initRankPanel() {
        JSONArray entryList = (JSONArray)this.getView().getFormShowParameter().getCustomParam("custEntryList");
        int count = entryList.size();
        ArrayList<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(count);
        for (int i = 0; i < count; ++i) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)((JSON)entryList.get(i)), CustomerAnalysisEntry.class);
            custEntryList.add(entry);
        }
        if (custEntryList.size() == 0) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"rfmentryflex"});
        }
        if (custEntryList.size() > 1) {
            this.getModel().batchCreateNewEntryRow("entryentity", custEntryList.size() - 1);
        }
        this.getPageCache().put("custEntryList", JsonUtil.encodeToString(custEntryList));
        this.buildRankPanel();
    }

    protected abstract List<CustomerAnalysisEntry> getShowEntryList(List<CustomerAnalysisEntry> var1);

    public void buildPageChart() {
        Control chartAp = this.getView().getControl("datachart");
        Chart chart = null;
        if (chartAp instanceof Chart) {
            chart = (Chart)chartAp;
        }
        if (chart == null) {
            return;
        }
        chart.clearData();
        this.customizeChartData(chart);
        this.getView().updateView("datachart");
    }

    protected abstract void customizeChartData(Chart var1);

    protected abstract List<String> getRangeAxisList();

    private void setControlText(String key, String val) {
        Label label = (Label)this.getView().getControl(key);
        label.setText(val);
        this.getView().updateView(key);
    }

    protected void sortPageData() {
        String custEntryStr = this.getPageCache().get(showEntryListKey);
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        ArrayList<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            custEntryList.add(entry);
        }
        String direct = this.getPageCache().get(sortDirection);
        this.reSortEntryList(custEntryList, direct);
        if ("down".equals(direct)) {
            this.getPageCache().put(sortDirection, "up");
        } else {
            this.getPageCache().put(sortDirection, "down");
        }
        int count = entryList.size();
        for (int i = 0; i < count; ++i) {
            this.buildCardEntryData((CustomerAnalysisEntry)custEntryList.get(i), i);
        }
    }

    protected abstract void buildCardEntryData(CustomerAnalysisEntry var1, int var2);

    protected void reSortEntryList(List<CustomerAnalysisEntry> entryList, String direct) {
        String pageLabel = this.getPageCache().get(pageLabelKey);
        if ("up".equals(direct)) {
            if ("R".equals(pageLabel)) {
                Collections.sort(entryList, (e1, e2) -> {
                    int val = e2.getrVal().compareTo(e1.getrVal());
                    if (val == 0) {
                        return e2.getrDate().compareTo(e1.getrDate());
                    }
                    return val;
                });
            } else if ("F".equals(pageLabel)) {
                Collections.sort(entryList, (e1, e2) -> {
                    int val = e2.getfVal().compareTo(e1.getfVal());
                    if (val == 0) {
                        return e2.getfTime().compareTo(e1.getfTime());
                    }
                    return val;
                });
            } else if ("M".equals(pageLabel)) {
                Collections.sort(entryList, (e1, e2) -> {
                    int val = e2.getmVal().compareTo(e1.getmVal());
                    if (val == 0) {
                        return e2.getmAmount().compareTo(e1.getmAmount());
                    }
                    return val;
                });
            }
        } else if ("R".equals(pageLabel)) {
            Collections.sort(entryList, (e2, e1) -> {
                int val = e2.getrVal().compareTo(e1.getrVal());
                if (val == 0) {
                    return e2.getrDate().compareTo(e1.getrDate());
                }
                return val;
            });
        } else if ("F".equals(pageLabel)) {
            Collections.sort(entryList, (e2, e1) -> {
                int val = e2.getfVal().compareTo(e1.getfVal());
                if (val == 0) {
                    return e2.getfTime().compareTo(e1.getfTime());
                }
                return val;
            });
        } else if ("M".equals(pageLabel)) {
            Collections.sort(entryList, (e2, e1) -> {
                int val = e2.getmVal().compareTo(e1.getmVal());
                if (val == 0) {
                    return e2.getmAmount().compareTo(e1.getmAmount());
                }
                return val;
            });
        }
    }
}

