/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.scmc.mobsm.business.utils.MobileControlUtils;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;
import kd.scmc.mobsm.common.entity.CustomerAnalysisPlan;
import kd.scmc.mobsm.plugin.form.dataanalysis.customervalue.AbstractAttrValPagePlugin;

public class AttrFvalPagePlugin
extends AbstractAttrValPagePlugin {
    @Override
    protected List<CustomerAnalysisEntry> getShowEntryList(List<CustomerAnalysisEntry> custEntryList) {
        String curOption;
        String customerLabel = null;
        switch (curOption = (String)this.getModel().getValue("labellist")) {
            case "A": {
                customerLabel = CustomerLabelConst.getLoyalCustomer();
                break;
            }
            case "B": {
                customerLabel = CustomerLabelConst.getMatrueCustomer();
                break;
            }
            case "C": {
                customerLabel = CustomerLabelConst.getOldCustomer();
                break;
            }
            case "D": {
                customerLabel = CustomerLabelConst.getNewCustomer();
                break;
            }
        }
        if (customerLabel == null) {
            return custEntryList;
        }
        ArrayList<CustomerAnalysisEntry> showEntryList = new ArrayList<CustomerAnalysisEntry>(custEntryList.size());
        for (CustomerAnalysisEntry entry : custEntryList) {
            if (!entry.getfLabel().equals(customerLabel)) continue;
            showEntryList.add(entry);
        }
        return showEntryList;
    }

    @Override
    protected void customizeChartData(Chart chart) {
        HistogramChart hChart = (HistogramChart)chart;
        hChart.setMargin(Position.top, "5%");
        List<String> rangeAxisList = this.getRangeAxisList();
        this.buildXAxisByChart(hChart, rangeAxisList);
        hChart.setName(new LocaleString(ResManager.loadKDString((String)"\u4ea4\u6613\u9891\u7387\u6784\u6210", (String)"AttrFvalPagePlugin_customizeChartData_0", (String)"scmc-mobsm-form", (Object[])new Object[0])));
        hChart.setMargin(Position.top, "5%");
        BarSeries series = hChart.createSeries(ResManager.loadKDString((String)"\u5ba2\u6237", (String)"AttrFvalPagePlugin_customizeChartData_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(8);
        Map<Integer, Integer> scoreCustNumMap = this.getScoreCustNumMap();
        float totalNum = scoreCustNumMap.values().stream().mapToInt(Integer::intValue).sum();
        for (int i = 0; i < rangeAxisList.size(); ++i) {
            float percentVal = (float)scoreCustNumMap.getOrDefault(i * 2 + 2, 0).intValue() / totalNum * 100.0f;
            ItemValue itemValue = new ItemValue((Number)Float.valueOf(percentVal), "#73D13D");
            itemValues.add(itemValue);
        }
        this.buildYAxisByChart(hChart);
        series.setData(itemValues.toArray(new ItemValue[0]));
        series.setBarWidth("30%");
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        series.setLabel(label);
    }

    private void buildXAxisByChart(HistogramChart hChart, List<String> rangeAxisList) {
        Axis xAxis = hChart.createXAxis(ResManager.loadKDString((String)"X\u8f74", (String)"x_axis", (String)"scmc-mobsm-form", (Object[])new Object[0]), AxisType.category);
        xAxis.setCategorys(rangeAxisList);
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>(3);
        axisLabelMap.put("rotate", "45");
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 10);
        textStyleMap.put("color", "#999999");
        axisLabelMap.put("textStyle", textStyleMap);
        xAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisTick", axisShowMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("axisLine", axisLine);
    }

    private void buildYAxisByChart(HistogramChart hChart) {
        Axis yAxis = hChart.createYAxis(ResManager.loadKDString((String)"Y\u8f74", (String)"y_axis", (String)"scmc-mobsm-form", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        yAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisLine", axisShowMap);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap<String, String> yMap = new HashMap<String, String>(3);
        yMap.put("formatter", "{value} %");
        yAxis.setPropValue("axisLabel", yMap);
    }

    @Override
    protected List<String> getRangeAxisList() {
        ArrayList<String> axisList = new ArrayList<String>(8);
        JSONObject curPlanObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("curPlan");
        CustomerAnalysisPlan curPlan = (CustomerAnalysisPlan)JSON.toJavaObject((JSON)curPlanObj, CustomerAnalysisPlan.class);
        List<Integer> fList = curPlan.getfValList();
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u6b21\u4ee5\u4e0b", (String)"AttrFvalPagePlugin_getRangeAxisList_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), fList.get(3)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u6b21", (String)"AttrFvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), fList.get(3), fList.get(2)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u6b21", (String)"AttrFvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), fList.get(2), fList.get(1)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u6b21", (String)"AttrFvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), fList.get(1), fList.get(0)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u6b21\u4ee5\u4e0a", (String)"AttrFvalPagePlugin_getRangeAxisList_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), fList.get(0)));
        return axisList;
    }

    @Override
    protected void buildCardEntryData(CustomerAnalysisEntry entry, int rowIndex) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.setChildVisible(true, rowIndex, new String[]{"rfmentryflex"});
        this.getModel().setValue("custname", (Object)entry.getCustomerName(), rowIndex);
        this.getModel().setValue("entryval", (Object)entry.getfTime(), rowIndex);
        this.getModel().setValue("entryscore", (Object)entry.getfVal(), rowIndex);
        String color = this.getLabelColor(entry.getfLabel());
        HashMap<String, Object> proData2 = new HashMap<String, Object>(3);
        proData2.put("fc", color);
        proData2.put("text", entry.getfLabel());
        MobileControlUtils.setCardEntryRowProperty(cardEntry, rowIndex, "custlabel", proData2);
    }

    protected Map<Integer, Integer> getScoreCustNumMap() {
        String custEntryStr = this.getPageCache().get("custEntryList");
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        HashMap<Integer, Integer> scoreMap = new HashMap<Integer, Integer>(8);
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            Integer time = scoreMap.getOrDefault(entry.getfVal(), 0);
            scoreMap.put(entry.getfVal(), time + 1);
        }
        return scoreMap;
    }

    private String getLabelColor(String label) {
        String color = "#D49B00";
        if (CustomerLabelConst.getLoyalCustomer().equals(label)) {
            color = "#D49B00";
        }
        if (CustomerLabelConst.getMatrueCustomer().equals(label)) {
            color = "#4E08C7";
        }
        if (CustomerLabelConst.getOldCustomer().equals(label)) {
            color = "#002EA3";
        }
        if (CustomerLabelConst.getNewCustomer().equals(label)) {
            color = "#999999";
        }
        return color;
    }
}

