/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.scmc.mobsm.business.utils.MobileControlUtils;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;
import kd.scmc.mobsm.common.entity.CustomerAnalysisHead;
import kd.scmc.mobsm.common.entity.CustomerAnalysisPlan;
import kd.scmc.mobsm.plugin.form.dataanalysis.customervalue.AbstractAttrValPagePlugin;

public class AttrMvalPagePlugin
extends AbstractAttrValPagePlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String currencySign = (String)this.getView().getFormShowParameter().getCustomParam("currency_sign");
        this.getPageCache().put("currency_sign", currencySign);
        String titleval = "";
        if (StringUtils.isNotBlank((CharSequence)currencySign)) {
            String rValue = ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d(%s)", (String)"AttrMvalPagePlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            titleval = String.format(rValue, currencySign);
        } else {
            titleval = ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d()", (String)"AttrMvalPagePlugin_3", (String)"scmc-mobsm-form", (Object[])new Object[0]);
        }
        String unitlable = "";
        if (StringUtils.isNotBlank((CharSequence)currencySign)) {
            String rValue = ResManager.loadKDString((String)"\u5355\u4f4d:%s", (String)"AttrMvalPagePlugin_4", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            unitlable = String.format(rValue, currencySign);
        } else {
            unitlable = ResManager.loadKDString((String)"\u5355\u4f4d:", (String)"AttrMvalPagePlugin_5", (String)"scmc-mobsm-form", (Object[])new Object[0]);
        }
        this.setControlText("titleval", titleval);
        this.setControlText("unitlable", unitlable);
    }

    @Override
    protected List<CustomerAnalysisEntry> getShowEntryList(List<CustomerAnalysisEntry> custEntryList) {
        String curOption;
        String customerLabel = null;
        switch (curOption = (String)this.getModel().getValue("labellist")) {
            case "A": {
                customerLabel = CustomerLabelConst.getHignContributionCustomer();
                break;
            }
            case "B": {
                customerLabel = CustomerLabelConst.getMediumHignContributionCustomer();
                break;
            }
            case "C": {
                customerLabel = CustomerLabelConst.getMediumContributionCustomer();
                break;
            }
            case "D": {
                customerLabel = CustomerLabelConst.getLowContributionCustomer();
                break;
            }
        }
        if (customerLabel == null) {
            return custEntryList;
        }
        ArrayList<CustomerAnalysisEntry> showEntryList = new ArrayList<CustomerAnalysisEntry>(custEntryList.size());
        for (CustomerAnalysisEntry entry : custEntryList) {
            if (!entry.getmLabel().equals(customerLabel)) continue;
            showEntryList.add(entry);
        }
        return showEntryList;
    }

    @Override
    protected void customizeChartData(Chart chart) {
        BarChart barChart = (BarChart)chart;
        Axis xAxis = barChart.createXAxis("", AxisType.category);
        List<String> rangeAxisList = this.getRangeAxisList();
        xAxis.setCategorys(rangeAxisList);
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>(3);
        axisLabelMap.put("rotate", "45");
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 10);
        textStyleMap.put("color", "#999999");
        axisLabelMap.put("textStyle", textStyleMap);
        xAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("axisLine", axisLine);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisTick", axisShowMap);
        barChart.setName(new LocaleString(ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u4ea4\u6613\u5206\u5e03", (String)"recent_deal", (String)"scmc-mobsm-form", (Object[])new Object[0])));
        barChart.setMargin(Position.top, "5%");
        this.buildYAxisByChart(barChart);
        this.buildSeriesByChart(barChart, rangeAxisList);
    }

    private void buildSeriesByChart(BarChart barChart, List<String> rangeAxisList) {
        BarSeries series = barChart.createSeries(ResManager.loadKDString((String)"\u5ba2\u6237\u6570", (String)"AttrMvalPagePlugin_buildSeriesByChart_0", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(8);
        Map<Integer, Integer> scoreCustNumMap = this.getScoreCustNumMap();
        float totalNum = scoreCustNumMap.values().stream().mapToInt(Integer::intValue).sum();
        for (int i = 0; i < rangeAxisList.size(); ++i) {
            float percentVal = (float)scoreCustNumMap.getOrDefault(i * 2 + 2, 0).intValue() / totalNum * 100.0f;
            ItemValue itemValue = new ItemValue((Number)Float.valueOf(percentVal), "#FFA940");
            itemValues.add(itemValue);
        }
        series.setData(itemValues.toArray(new ItemValue[0]));
        series.setBarWidth("20%");
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        series.setLabel(label);
        ArrayList<ItemValue> itemValues2 = new ArrayList<ItemValue>(8);
        BarSeries amountSeries = barChart.createSeries(ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"AttrMvalPagePlugin_buildSeriesByChart_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        Map<Integer, BigDecimal> scoreCustAmountMap = this.getScoreCustAmountMap();
        if (scoreCustAmountMap.isEmpty()) {
            return;
        }
        BigDecimal totalAmount = scoreCustAmountMap.values().stream().reduce(BigDecimal::add).get();
        if (totalAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        for (int i = 0; i < rangeAxisList.size(); ++i) {
            BigDecimal percentVal = scoreCustAmountMap.getOrDefault(i * 2 + 2, BigDecimal.ZERO).divide(totalAmount, 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(100L));
            ItemValue itemValue = new ItemValue((Number)percentVal, "#FFD666");
            itemValues2.add(itemValue);
        }
        amountSeries.setData(itemValues2.toArray(new ItemValue[0]));
        amountSeries.setBarWidth("20%");
        amountSeries.setLabel(label);
    }

    private void buildYAxisByChart(BarChart barChart) {
        Axis yAxis = barChart.createYAxis(ResManager.loadKDString((String)"Y\u8f74", (String)"y_axis", (String)"scmc-mobsm-form", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        yAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisLine", axisShowMap);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap<String, String> yMap = new HashMap<String, String>(3);
        yMap.put("formatter", "{value} %");
        yAxis.setPropValue("axisLabel", yMap);
    }

    @Override
    protected List<String> getRangeAxisList() {
        ArrayList<String> axisList = new ArrayList<String>(8);
        JSONObject custHeadObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("custHeadKey");
        CustomerAnalysisHead custHead = (CustomerAnalysisHead)JSON.toJavaObject((JSON)custHeadObj, CustomerAnalysisHead.class);
        BigDecimal unitPrice = custHead.getUnitPrice();
        JSONObject curPlanObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("curPlan");
        CustomerAnalysisPlan curPlan = (CustomerAnalysisPlan)JSON.toJavaObject((JSON)curPlanObj, CustomerAnalysisPlan.class);
        List<Double> mList = curPlan.getmValList();
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u4ee5\u4e0b", (String)"AttrMvalPagePlugin_getRangeAxisList_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getDealAmount(mList.get(3), unitPrice)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"AttrMvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getDealAmount(mList.get(3), unitPrice), this.getDealAmount(mList.get(2), unitPrice)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"AttrMvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getDealAmount(mList.get(2), unitPrice), this.getDealAmount(mList.get(1), unitPrice)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"AttrMvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getDealAmount(mList.get(1), unitPrice), this.getDealAmount(mList.get(0), unitPrice)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u4ee5\u4e0a", (String)"AttrMvalPagePlugin_getRangeAxisList_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getDealAmount(mList.get(0), unitPrice)));
        return axisList;
    }

    private Object getDealAmount(Double mVal, BigDecimal unitPrice) {
        if (unitPrice == null) {
            return 0;
        }
        BigDecimal result = BigDecimal.valueOf(mVal).multiply(unitPrice);
        return result.intValue();
    }

    protected Map<Integer, Integer> getScoreCustNumMap() {
        String custEntryStr = this.getPageCache().get("custEntryList");
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        HashMap<Integer, Integer> scoreMap = new HashMap<Integer, Integer>(8);
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            Integer time = scoreMap.getOrDefault(entry.getmVal(), 0);
            scoreMap.put(entry.getmVal(), time + 1);
        }
        return scoreMap;
    }

    protected Map<Integer, BigDecimal> getScoreCustAmountMap() {
        String custEntryStr = this.getPageCache().get("custEntryList");
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        HashMap<Integer, BigDecimal> scoreMap = new HashMap<Integer, BigDecimal>(8);
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            BigDecimal amount = scoreMap.getOrDefault(entry.getmVal(), BigDecimal.ZERO);
            scoreMap.put(entry.getmVal(), amount.add(entry.getmAmount()));
        }
        return scoreMap;
    }

    @Override
    protected void buildCardEntryData(CustomerAnalysisEntry entry, int rowIndex) {
        String cacheSign = this.getPageCache().get("currency_sign");
        String sign = cacheSign == null ? "" : cacheSign;
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.setChildVisible(true, rowIndex, new String[]{"rfmentryflex"});
        this.getModel().setValue("custname", (Object)entry.getCustomerName(), rowIndex);
        this.getModel().setValue("entryval", (Object)(sign + entry.getmAmount().setScale(2)), rowIndex);
        this.getModel().setValue("entryscore", (Object)entry.getmVal(), rowIndex);
        String color = this.getLabelColor(entry.getmLabel());
        HashMap<String, Object> proData = new HashMap<String, Object>(3);
        proData.put("text", entry.getmLabel());
        proData.put("fc", color);
        MobileControlUtils.setCardEntryRowProperty(cardEntry, rowIndex, "custlabel", proData);
    }

    private void setControlText(String key, String val) {
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl(key);
        label.setText(val);
    }

    private String getLabelColor(String label) {
        String color = "#D49B00";
        if (CustomerLabelConst.getHighValueCustomer().equals(label)) {
            color = "#D49B00";
        }
        if (CustomerLabelConst.getMediumHignContributionCustomer().equals(label)) {
            color = "#4E08C7";
        }
        if (CustomerLabelConst.getMediumContributionCustomer().equals(label)) {
            color = "#002EA3";
        }
        if (CustomerLabelConst.getLowContributionCustomer().equals(label)) {
            color = "#999999";
        }
        return color;
    }
}

