/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.scmc.mobsm.business.utils.MobileControlUtils;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;
import kd.scmc.mobsm.common.entity.CustomerAnalysisPlan;
import kd.scmc.mobsm.plugin.form.dataanalysis.customervalue.AbstractAttrValPagePlugin;

public class AttrRvalPagePlugin
extends AbstractAttrValPagePlugin {
    @Override
    protected void customizeChartData(Chart chart) {
        BarChart barChart = (BarChart)chart;
        barChart.setMargin(Position.top, "5%");
        List<String> rangeAxisList = this.getRangeAxisList();
        this.buildYAxisByChart(barChart, rangeAxisList);
        barChart.setName(new LocaleString(ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21\u4ea4\u6613\u5206\u5e03", (String)"recent_deal", (String)"scmc-mobsm-form", (Object[])new Object[0])));
        barChart.setMargin(Position.top, "5%");
        barChart.setMargin(Position.right, "12px");
        this.buildXAxisByChart(barChart);
        BarSeries series = barChart.createSeries(ResManager.loadKDString((String)"\u5ba2\u6237", (String)"AttrFvalPagePlugin_customizeChartData_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(8);
        Map<Integer, Integer> scoreCustNumMap = this.getScoreCustNumMap();
        float totalNum = scoreCustNumMap.values().stream().mapToInt(Integer::intValue).sum();
        for (int i = 0; i < rangeAxisList.size(); ++i) {
            float percentVal = (float)scoreCustNumMap.getOrDefault(i * 2 + 2, 0).intValue() / totalNum * 100.0f;
            ItemValue itemValue = new ItemValue((Number)Float.valueOf(percentVal), "#45DAD1");
            itemValues.add(itemValue);
        }
        series.setData(itemValues.toArray(new ItemValue[0]));
        series.setBarWidth("30%");
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        series.setLabel(label);
    }

    private void buildYAxisByChart(BarChart barChart, List<String> rangeAxisList) {
        Axis yAxis = barChart.createYAxis("", AxisType.category);
        yAxis.setCategorys(rangeAxisList);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap axisLabelMap = new HashMap(3);
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 10);
        textStyleMap.put("color", "#999999");
        axisLabelMap.put("textStyle", textStyleMap);
        yAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("axisLine", axisLine);
    }

    private void buildXAxisByChart(BarChart barChart) {
        Axis xAxis = barChart.createXAxis(ResManager.loadKDString((String)"X\u8f74", (String)"x_axis", (String)"scmc-mobsm-form", (Object[])new Object[0]), AxisType.value);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        xAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        HashMap<String, String> xMap = new HashMap<String, String>(3);
        xMap.put("formatter", "{value}%");
        xAxis.setPropValue("axisLabel", xMap);
        xAxis.setPropValue("boundaryGap", (Object)true);
    }

    @Override
    protected List<String> getRangeAxisList() {
        ArrayList<String> axisList = new ArrayList<String>(8);
        JSONObject curPlanObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("curPlan");
        CustomerAnalysisPlan curPlan = (CustomerAnalysisPlan)JSON.toJavaObject((JSON)curPlanObj, CustomerAnalysisPlan.class);
        List<Integer> rList = curPlan.getrValList();
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u5929\u4ee5\u4e0a", (String)"AttrRvalPagePlugin_getRangeAxisList_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), rList.get(3)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"AttrRvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), rList.get(2), rList.get(3)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"AttrRvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), rList.get(1), rList.get(2)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"AttrRvalPagePlugin_getRangeAxisList_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), rList.get(0), rList.get(1)));
        axisList.add(String.format(ResManager.loadKDString((String)"%1$s\u5929\u4ee5\u4e0b", (String)"AttrRvalPagePlugin_getRangeAxisList_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), rList.get(0)));
        return axisList;
    }

    protected Map<Integer, Integer> getScoreCustNumMap() {
        String custEntryStr = this.getPageCache().get("custEntryList");
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        HashMap<Integer, Integer> scoreMap = new HashMap<Integer, Integer>(8);
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            Integer time = scoreMap.getOrDefault(entry.getrVal(), 0);
            scoreMap.put(entry.getrVal(), time + 1);
        }
        return scoreMap;
    }

    @Override
    protected List<CustomerAnalysisEntry> getShowEntryList(List<CustomerAnalysisEntry> custEntryList) {
        String curOption;
        String customerLabel = null;
        switch (curOption = (String)this.getModel().getValue("labellist")) {
            case "A": {
                customerLabel = CustomerLabelConst.getActiveCustomer();
                break;
            }
            case "B": {
                customerLabel = CustomerLabelConst.getSilenceCustomer();
                break;
            }
            case "C": {
                customerLabel = CustomerLabelConst.getSleepCustomer();
                break;
            }
            case "D": {
                customerLabel = CustomerLabelConst.getLoseCustomer();
                break;
            }
        }
        if (customerLabel == null) {
            return custEntryList;
        }
        ArrayList<CustomerAnalysisEntry> showEntryList = new ArrayList<CustomerAnalysisEntry>(custEntryList.size());
        for (CustomerAnalysisEntry entry : custEntryList) {
            if (!entry.getrLabel().equals(customerLabel)) continue;
            showEntryList.add(entry);
        }
        return showEntryList;
    }

    @Override
    protected void buildCardEntryData(CustomerAnalysisEntry entry, int rowIndex) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        cardEntry.setChildVisible(true, rowIndex, new String[]{"rfmentryflex"});
        this.getModel().setValue("custname", (Object)entry.getCustomerName(), rowIndex);
        this.getModel().setValue("entryval", (Object)entry.getrDate(), rowIndex);
        this.getModel().setValue("entryscore", (Object)entry.getrVal(), rowIndex);
        String color = this.getLabelColor(entry.getrLabel());
        HashMap<String, Object> proData = new HashMap<String, Object>(3);
        proData.put("fc", color);
        proData.put("text", entry.getrLabel());
        MobileControlUtils.setCardEntryRowProperty(cardEntry, rowIndex, "custlabel", proData);
    }

    private String getLabelColor(String label) {
        String color = "#D49B00";
        if (CustomerLabelConst.getActiveCustomer().equals(label)) {
            color = "#D49B00";
        }
        if (CustomerLabelConst.getSilenceCustomer().equals(label)) {
            color = "#4E08C7";
        }
        if (CustomerLabelConst.getSleepCustomer().equals(label)) {
            color = "#002EA3";
        }
        if (CustomerLabelConst.getLoseCustomer().equals(label)) {
            color = "#999999";
        }
        return color;
    }
}

