/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.mobsm.business.utils.MobileControlUtils;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;

public class CustomerValueFilterPagePlugin
extends AbstractMobFormPlugin {
    private static final String apTag = "ap";
    private static final String choiceLabelListKey = "choiceLabelList";
    private static final String choiceApListKey = "choiceApList";
    private static final String choiceFontColor = "#276FF5";
    private static final String fontColor = "#212121";
    private static final String sourcePageKey = "sourcePage";
    public static final String choiceBackColor = "#F2F9FF";
    public static final String choiceBorderStyle = "0.5px_solid_#276FF5";
    public static final String backColor = "#F2F2F2";
    public static final String borderStyle = "0.5px_solid_#f2f2f2";

    public void afterCreateNewData(EventObject e) {
        String sourcePage = (String)this.getView().getFormShowParameter().getCustomParam(sourcePageKey);
        this.getPageCache().put(sourcePageKey, sourcePage);
        JSONArray entryList = (JSONArray)this.getView().getFormShowParameter().getCustomParam("custEntryList");
        this.getPageCache().put("custEntryList", JsonUtil.encodeToString((Object)entryList));
        this.recoverChoicePageData();
    }

    private void recoverChoicePageData() {
        JSONArray apList = (JSONArray)this.getView().getFormShowParameter().getCustomParam(choiceApListKey);
        if (apList == null) {
            this.getPageCache().put(choiceApListKey, JsonUtil.encodeToString(new ArrayList()));
            this.getPageCache().put(choiceLabelListKey, JsonUtil.encodeToString(new ArrayList()));
            return;
        }
        for (Object apKey : apList) {
            Control control = this.getControl((String)apKey);
            MobileControlUtils.controlSetFrontColor(control, choiceFontColor, choiceBackColor, choiceBorderStyle);
        }
        this.getPageCache().put(choiceApListKey, JsonUtil.encodeToString((Object)apList));
        JSONArray labelList = (JSONArray)this.getView().getFormShowParameter().getCustomParam(choiceLabelListKey);
        this.getPageCache().put(choiceLabelListKey, JsonUtil.encodeToString((Object)labelList));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"highvalap", "deepdigap", "generalkeepap", "wakeupap", "potentialap", "retainap", "loseap", "newap", "certainbtn", "resetbtn"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String apKey = source.getKey();
        if (apKey.endsWith(apTag)) {
            this.dealChoiceLabelList(apKey);
        } else if ("certainbtn".equals(apKey)) {
            this.linkToSourcePage();
        } else if ("resetbtn".equals(apKey)) {
            this.clearAndRefreshPage();
        }
    }

    private void clearAndRefreshPage() {
        String choiceApListStr = this.getPageCache().get(choiceApListKey);
        List choiceApList = (List)JsonUtil.decodeFromString((String)choiceApListStr, List.class);
        for (String apKey : choiceApList) {
            Control control = this.getControl(apKey);
            MobileControlUtils.controlSetFrontColor(control, fontColor, backColor, borderStyle);
        }
        this.getPageCache().put(choiceApListKey, JsonUtil.encodeToString(new ArrayList()));
        this.getPageCache().put(choiceLabelListKey, JsonUtil.encodeToString(new ArrayList()));
    }

    private void linkToSourcePage() {
        String choiceLabelListStr = this.getPageCache().get(choiceLabelListKey);
        List choiceLabelList = (List)JsonUtil.decodeFromString((String)choiceLabelListStr, List.class);
        String choiceApStr = this.getPageCache().get(choiceApListKey);
        List choiceApList = (List)JsonUtil.decodeFromString((String)choiceApStr, List.class);
        String custEntryStr = this.getPageCache().get("custEntryList");
        HashMap<String, Object> returnData = new HashMap<String, Object>(5);
        returnData.put(choiceLabelListKey, choiceLabelList);
        returnData.put(choiceApListKey, choiceApList);
        returnData.put("custEntryList", JsonUtil.decodeFromString((String)custEntryStr, JSONArray.class));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void dealChoiceLabelList(String apKey) {
        String choiceLabelListStr = this.getPageCache().get(choiceLabelListKey);
        List choiceLabelList = (List)JsonUtil.decodeFromString((String)choiceLabelListStr, List.class);
        String choiceApListStr = this.getPageCache().get(choiceApListKey);
        List choiceApList = (List)JsonUtil.decodeFromString((String)choiceApListStr, List.class);
        switch (apKey) {
            case "highvalap": {
                this.judgeLabel(apKey, CustomerLabelConst.getHighValueCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "wakeupap": {
                this.judgeLabel(apKey, CustomerLabelConst.getWakeUpCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "deepdigap": {
                this.judgeLabel(apKey, CustomerLabelConst.getDeepDigCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "retainap": {
                this.judgeLabel(apKey, CustomerLabelConst.getRetainCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "potentialap": {
                this.judgeLabel(apKey, CustomerLabelConst.getPotentialCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "newap": {
                this.judgeLabel(apKey, CustomerLabelConst.getNewCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "generalkeepap": {
                this.judgeLabel(apKey, CustomerLabelConst.getGeneralKeepCustomer(), choiceLabelList, choiceApList);
                break;
            }
            case "loseap": {
                this.judgeLabel(apKey, CustomerLabelConst.getLoseCustomer(), choiceLabelList, choiceApList);
                break;
            }
        }
        this.getPageCache().put(choiceLabelListKey, JsonUtil.encodeToString((Object)choiceLabelList));
        this.getPageCache().put(choiceApListKey, JsonUtil.encodeToString((Object)choiceApList));
    }

    private void judgeLabel(String apKey, String label, List<String> choiceLabelList, List<String> choiceApList) {
        Control control = this.getControl(apKey);
        if (choiceLabelList.contains(label)) {
            choiceLabelList.remove(label);
            choiceApList.remove(apKey);
            MobileControlUtils.controlSetFrontColor(control, fontColor, backColor, borderStyle);
        } else {
            choiceLabelList.add(label);
            choiceApList.add(apKey);
            MobileControlUtils.controlSetFrontColor(control, choiceFontColor, choiceBackColor, choiceBorderStyle);
        }
    }
}

