/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;
import kd.scmc.mobsm.common.entity.CustomerAnalysisHead;
import kd.scmc.mobsm.common.entity.CustomerAnalysisPlan;

public class CustomerValueHomeData {
    public CustomerAnalysisPlan curPlan;
    public CustomerAnalysisHead custHead = new CustomerAnalysisHead();
    public List<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(32);
    public Map<String, Integer> custLabelNumMap = new HashMap<String, Integer>(12);
    public Map<String, CustomerAnalysisEntry> custEntryMap = new HashMap<String, CustomerAnalysisEntry>(32);
    private String[][][] rfmLabelArr = new String[2][2][2];
    private Object[] headObj;
    private List<Object[]> entryObjList;
    private final String ROUTE_SCM = "scm";
    private Log log = LogFactory.getLog(CustomerValueHomeData.class);

    public CustomerValueHomeData() {
        this.initRfmLabelArray();
    }

    public boolean getRfmSumData(Long curSaleOrgId) {
        block27: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = sdf.format(new Date());
            Long curUserId = 0L;
            Long curPlanId = 0L;
            String headSql = "select fid,fcurrentdate,fuserid,fsaleorgid,favgday,favgtime,favgamount,favgrval,favgfval,favgmval,funitprice from t_mobsm_custanalysishead where fplanid = ? and fuserid = ? and fsaleorgid = ? and fcurrentdate = ?";
            Object[] headParam = new Object[]{curPlanId, curUserId, curSaleOrgId, curDate};
            this.curPlan = this.getCurrentPlan();
            this.custHead = new CustomerAnalysisHead();
            this.custHead.setPlanId(curPlanId);
            this.custHead.setCurrentDate(curDate);
            this.custHead.setSaleOrgId(curSaleOrgId);
            try (DataSet headSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)headSql, (Object[])headParam);){
                if (headSet.hasNext()) {
                    Row row = headSet.next();
                    this.log.info("CustomerValueHomeData: getRfmSumData\u65b9\u6cd5 CustomerAnalysisHead HeadId = \u3010{}\u3011", (Object)row.getLong("fid"));
                    this.custHead.setAvgDay(row.getInteger("favgday"));
                    this.custHead.setAvgTime(row.getInteger("favgtime"));
                    this.custHead.setAvgAmount(row.getBigDecimal("favgamount"));
                    this.custHead.setAvgrVal(row.getInteger("favgrval"));
                    this.custHead.setAvgfVal(row.getInteger("favgfval"));
                    this.custHead.setAvgmVal(row.getInteger("favgmval"));
                    this.custHead.setId(row.getLong("fid"));
                    this.custHead.setUnitPrice(row.getBigDecimal("funitprice"));
                    String entrySql = "select fcustname,fcustnumber,frval,frlabel,frdate,frday,ffval,fflabel,fftime,fmval,fmlabel,fmamount,frfmval,frfmlabel from t_mobsm_custanalysisentry where fid = ?";
                    Object[] entryParam = new Object[]{this.custHead.getId()};
                    try (DataSet entrySet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)entrySql, (Object[])entryParam);){
                        this.buildEntryData(entrySet);
                        break block27;
                    }
                }
                boolean bl = this.savePlanData(curSaleOrgId);
                return bl;
            }
        }
        return true;
    }

    private void buildEntryData(DataSet entrySet) {
        for (Row row : entrySet) {
            CustomerAnalysisEntry custEntry = new CustomerAnalysisEntry();
            custEntry.setCustomerName(row.getString("fcustname"));
            custEntry.setCustomerNumber(row.getString("fcustnumber"));
            custEntry.setrVal(row.getInteger("frval"));
            custEntry.setfVal(row.getInteger("ffval"));
            custEntry.setmVal(row.getInteger("fmval"));
            custEntry.setrLabel(row.getString("frlabel"));
            custEntry.setfLabel(row.getString("fflabel"));
            custEntry.setmLabel(row.getString("fmlabel"));
            custEntry.setrDate(row.getString("frdate"));
            custEntry.setrDay(row.getInteger("frday"));
            custEntry.setfTime(row.getInteger("fftime"));
            custEntry.setmAmount(row.getBigDecimal("fmamount"));
            custEntry.setRfmVal(row.getBigDecimal("frfmval"));
            custEntry.setRfmLabel(row.getString("frfmlabel"));
            this.custEntryMap.put(custEntry.getCustomerNumber(), custEntry);
            this.custEntryList.add(custEntry);
            Integer count = this.custLabelNumMap.getOrDefault(custEntry.getRfmLabel(), 0);
            this.custLabelNumMap.put(custEntry.getRfmLabel(), count + 1);
        }
    }

    public boolean savePlanData(Long curSaleOrgId) {
        this.log.info("CustomerValueHomeData: savePlanData\u9996\u6b21\u67e5\u8be2 curSaleOrgId = \u3010{}\u3011", (Object)curSaleOrgId);
        String fields = null;
        DataSet dataSet = null;
        DataSet blueDataSet = null;
        QFilter qf = new QFilter("org", "=", (Object)curSaleOrgId);
        qf.and("billstatus", "=", (Object)"C");
        qf.and("customer.name", "is not null", null);
        QFilter datef = new QFilter("bizdate", ">=", (Object)this.curPlan.getStartDate());
        QFilter dateLeF = new QFilter("bizdate", "<=", (Object)new Date());
        QFilter isVirtualFilter = new QFilter("isvirtualbill", "=", (Object)false);
        if (this.curPlan.getDataSource().equals("A")) {
            fields = "billno,bizdate,customer.name as custname,customer.number as custnumber,currency,1 as time,curtotalallamount as totalamount";
            blueDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sm_salorder", (String)fields, (QFilter[])new QFilter[]{qf, datef, dateLeF, isVirtualFilter}, (String)"bizdate desc");
            fields = "billno,bizdate,customer.name as custname,customer.number as custnumber,currency,0 - billentry.curamountandtax as totalamount";
            DataSet returnSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sm_returnapply", (String)fields, (QFilter[])new QFilter[]{qf, datef, dateLeF}, null);
            returnSet = returnSet.groupBy(new String[]{"billno", "bizdate", "custname", "custnumber", "currency", "0 as time"}).sum("totalamount").finish();
            dataSet = blueDataSet.copy().union(returnSet);
        } else {
            QFilter datef1 = new QFilter("biztime", ">=", (Object)this.curPlan.getStartDate());
            QFilter dateLef1 = new QFilter("biztime", "<=", (Object)new Date());
            fields = "billno,biztime as bizdate,customer.name as custname,customer.number as custnumber,billentry.curamountandtax as totalamount,currency";
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_saloutbill", (String)fields, (QFilter[])new QFilter[]{qf, datef1, dateLef1, isVirtualFilter}, null);
            DataSet redDataSet = dataSet.copy().filter("totalamount < 0 ");
            blueDataSet = dataSet.copy().filter("totalamount >= 0 ");
            redDataSet = redDataSet.groupBy(new String[]{"billno", "bizdate", "custname", "custnumber", "currency", "0 as time"}).sum("totalamount").finish();
            blueDataSet = blueDataSet.groupBy(new String[]{"billno", "bizdate", "custname", "custnumber", "currency", "1 as time"}).sum("totalamount").finish();
            dataSet = redDataSet.union(blueDataSet.copy());
        }
        if (!dataSet.hasNext()) {
            return false;
        }
        List<String> onlyRedCustNameList = this.getOnlyHasRedCustNameList(dataSet);
        this.log.info("CustomerValueHomeData: \u53ea\u6709\u7ea2\u5355\u7684\u5ba2\u6237\u6570size = \u3010{}\u3011", (Object)onlyRedCustNameList.size());
        this.dealrValData(blueDataSet);
        this.dealfValData(dataSet, onlyRedCustNameList);
        this.dealmValData(dataSet, onlyRedCustNameList);
        this.dealRfmLabel();
        this.saveInDb();
        return true;
    }

    private void saveInDb() {
        Long headId = this.buildHeadObj();
        this.buildEntryObjs(headId);
        this.custHead.setId(headId);
        String INSERT_HEAD_SQL = "insert into t_mobsm_custanalysishead(fid,fplanid,fcurrentdate,fuserid,fsaleorgid,favgday,favgtime,favgamount,favgrval,favgfval,favgmval,funitprice) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        String INSERT_ENTRY_SQL = "insert into t_mobsm_custanalysisentry(fentryid,fid,fcustname,fcustnumber,frval,frlabel,frdate,frday,ffval,fflabel,fftime,fmval,fmlabel,fmamount,frfmval,frfmlabel) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (TXHandle h = TX.requiresNew();){
            try {
                this.log.info("CustomerValueHomeData: \u5f00\u59cb\u5b58\u5165\u5ba2\u6237\u4ef7\u503cHead\u6570\u636e,\u3010{}\u3011", this.headObj);
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)INSERT_HEAD_SQL, (Object[])this.headObj);
                this.log.info("CustomerValueHomeData: \u5f00\u59cb\u5b58\u5165\u5ba2\u6237\u4ef7\u503cEntry\u6570\u636e,\u3010{}\u3011,\u6570\u91cf\u4e3a\u3010{}\u3011", this.entryObjList, (Object)this.entryObjList.size());
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)INSERT_ENTRY_SQL, this.entryObjList);
                this.log.info("CustomerValueHomeData: \u5ba2\u6237\u4ef7\u503c\u7edf\u8ba1\u6570\u636e\u5b58\u5165DB\u6210\u529f");
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private CustomerAnalysisPlan getCurrentPlan() {
        String field = "billno,daterange,billname,rpercentage,fpercentage,mpercentage";
        DynamicObject planDy = QueryServiceHelper.queryOne((String)"mobsm_rfmbasicset", (String)field, null);
        CustomerAnalysisPlan currentPlan = new CustomerAnalysisPlan();
        currentPlan.setPlanNumber(planDy.getString("billno"));
        currentPlan.setrWeight(planDy.getInt("rpercentage"));
        currentPlan.setfWeight(planDy.getInt("fpercentage"));
        currentPlan.setmWeight(planDy.getInt("mpercentage"));
        currentPlan.setDataSource(planDy.getString("billname"));
        String dateRange = planDy.getString("daterange");
        int intervalMonth = 6;
        if ("A".equals(dateRange)) {
            intervalMonth = 3;
        } else if ("C".equals(dateRange)) {
            intervalMonth = 12;
        } else if ("D".equals(dateRange)) {
            intervalMonth = 24;
        }
        Date startDate = this.getStartDateByIntervalMonth(intervalMonth);
        currentPlan.setStartDate(startDate);
        field = "entryr.minvaluer as rval,entryf.minvaluef as fval,entrym.minvaluem as mval";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"mobsm_rfmbasicset", (String)field, null, null);
        DataSet rValSet = dataSet.copy().groupBy(new String[]{"rval"}).finish();
        ArrayList<Integer> rValList = new ArrayList<Integer>(8);
        for (Row row : rValSet) {
            rValList.add(row.getInteger("rval"));
        }
        rValList.add(3650);
        DataSet fValSet = dataSet.copy().groupBy(new String[]{"fval"}).finish();
        ArrayList<Integer> fValList = new ArrayList<Integer>(8);
        for (Row row : fValSet) {
            fValList.add(row.getInteger("fval"));
        }
        DataSet mValSet = dataSet.groupBy(new String[]{"mval"}).finish();
        ArrayList<Double> mValList = new ArrayList<Double>(8);
        for (Row row : mValSet) {
            mValList.add(row.getDouble("mval"));
        }
        Collections.sort(rValList);
        rValList.remove(0);
        Collections.sort(fValList, (e1, e2) -> e2 - e1);
        Collections.sort(mValList, Comparator.reverseOrder());
        currentPlan.setrValList(rValList);
        currentPlan.setfValList(fValList);
        currentPlan.setmValList(mValList);
        HashMap<Integer, String> rValLabelMap = new HashMap<Integer, String>(8);
        rValLabelMap.put((Integer)rValList.get(0), CustomerLabelConst.getActiveCustomer());
        rValLabelMap.put((Integer)rValList.get(1), CustomerLabelConst.getSilenceCustomer());
        rValLabelMap.put((Integer)rValList.get(2), CustomerLabelConst.getSleepCustomer());
        rValLabelMap.put((Integer)rValList.get(3), CustomerLabelConst.getLoseCustomer());
        rValLabelMap.put((Integer)rValList.get(4), CustomerLabelConst.getLoseCustomer());
        currentPlan.setrValLabelMap(rValLabelMap);
        HashMap<Integer, String> fValLabelMap = new HashMap<Integer, String>(8);
        fValLabelMap.put((Integer)fValList.get(0), CustomerLabelConst.getLoyalCustomer());
        fValLabelMap.put((Integer)fValList.get(1), CustomerLabelConst.getLoyalCustomer());
        fValLabelMap.put((Integer)fValList.get(2), CustomerLabelConst.getMatrueCustomer());
        fValLabelMap.put((Integer)fValList.get(3), CustomerLabelConst.getOldCustomer());
        fValLabelMap.put((Integer)fValList.get(4), CustomerLabelConst.getNewCustomer());
        currentPlan.setfValLabelMap(fValLabelMap);
        HashMap<Double, String> mValLabelMap = new HashMap<Double, String>(8);
        mValLabelMap.put((Double)mValList.get(0), CustomerLabelConst.getHignContributionCustomer());
        mValLabelMap.put((Double)mValList.get(1), CustomerLabelConst.getMediumHignContributionCustomer());
        mValLabelMap.put((Double)mValList.get(2), CustomerLabelConst.getMediumContributionCustomer());
        mValLabelMap.put((Double)mValList.get(3), CustomerLabelConst.getLowContributionCustomer());
        mValLabelMap.put((Double)mValList.get(4), CustomerLabelConst.getLowContributionCustomer());
        currentPlan.setmValLabelMap(mValLabelMap);
        return currentPlan;
    }

    private Date getStartDateByIntervalMonth(int intervalMonth) {
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.set(10, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, -intervalMonth);
        Date beforeDate = calendar.getTime();
        return beforeDate;
    }

    private Long buildHeadObj() {
        this.headObj = new Object[12];
        Long headId = DB.genLongId((String)"t_mobsm_custanalysishead");
        this.headObj[0] = headId;
        this.headObj[1] = this.custHead.getPlanId();
        this.headObj[2] = this.custHead.getCurrentDate();
        this.headObj[3] = 0L;
        this.headObj[4] = this.custHead.getSaleOrgId();
        this.headObj[5] = this.custHead.getAvgDay();
        this.headObj[6] = this.custHead.getAvgTime();
        this.headObj[7] = this.custHead.getAvgAmount();
        this.headObj[8] = this.custHead.getAvgrVal();
        this.headObj[9] = this.custHead.getAvgfVal();
        this.headObj[10] = this.custHead.getAvgmVal();
        this.headObj[11] = this.custHead.getUnitPrice();
        return headId;
    }

    private void buildEntryObjs(Long headId) {
        long[] entryIds = DB.genLongIds((String)"t_mobsm_custanalysisentry", (int)this.custEntryList.size());
        this.entryObjList = new ArrayList<Object[]>(this.custEntryList.size());
        for (int i = 0; i < this.custEntryList.size(); ++i) {
            CustomerAnalysisEntry entry = this.custEntryList.get(i);
            Object[] entryObj = new Object[]{entryIds[i], headId, entry.getCustomerName(), entry.getCustomerNumber(), entry.getrVal(), entry.getrLabel(), entry.getrDate(), entry.getrDay(), entry.getfVal(), entry.getfLabel(), entry.getfTime(), entry.getmVal(), entry.getmLabel(), entry.getmAmount(), entry.getRfmVal(), entry.getRfmLabel()};
            this.entryObjList.add(entryObj);
        }
    }

    private void dealrValData(DataSet dataSet) {
        DataSet rDaySet = dataSet.copy().groupBy(new String[]{"custname", "custnumber"}).max("bizdate").finish();
        int sumDay = 0;
        int sumrVal = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Row row : rDaySet) {
            String custNumber = row.getString("custnumber");
            Date bizTime = row.getDate("bizdate");
            CustomerAnalysisEntry custEntry = this.custEntryMap.getOrDefault(custNumber, new CustomerAnalysisEntry());
            custEntry.setCustomerName(row.getString("custname"));
            custEntry.setCustomerNumber(custNumber);
            int intervalDay = (int)((System.currentTimeMillis() - bizTime.getTime()) / 86400000L);
            sumDay += intervalDay;
            custEntry.setrDate(sdf.format(bizTime));
            custEntry.setrDay(intervalDay);
            int rVal = 10;
            custEntry.setrVal(2);
            custEntry.setrLabel(CustomerLabelConst.getLoseCustomer());
            for (Integer day : this.curPlan.getrValList()) {
                if (intervalDay < day) {
                    custEntry.setrVal(rVal);
                    custEntry.setrLabel(this.curPlan.getrValLabelMap().get(day));
                    sumrVal += rVal;
                    break;
                }
                rVal -= 2;
            }
            this.custEntryMap.put(custEntry.getCustomerNumber(), custEntry);
        }
        this.custHead.setAvgDay(Math.round((float)sumDay / (float)this.custEntryMap.size()));
        this.custHead.setAvgrVal(Math.round((float)sumrVal / (float)this.custEntryMap.size()));
    }

    private List<String> getOnlyHasRedCustNameList(DataSet dataSet) {
        String custNumber;
        DataSet redDateSet = dataSet.copy().filter("time = 0").groupBy(new String[]{"custnumber"}).finish();
        DataSet blueDateSet = dataSet.copy().filter("time = 1").groupBy(new String[]{"custnumber"}).finish();
        ArrayList<String> redCustList = new ArrayList<String>(16);
        ArrayList<String> blueCustList = new ArrayList<String>(16);
        for (Row row : redDateSet) {
            custNumber = row.getString("custnumber");
            redCustList.add(custNumber);
        }
        for (Row row : blueDateSet) {
            custNumber = row.getString("custnumber");
            blueCustList.add(custNumber);
        }
        redCustList.removeAll(blueCustList);
        return redCustList;
    }

    private void dealfValData(DataSet dataSet, List<String> onlyRedCustNameList) {
        DataSet fTimeSet = dataSet.copy().groupBy(new String[]{"custname", "custnumber"}).sum("time").finish();
        int sumTime = 0;
        int sumfVal = 0;
        block0: for (Row row : fTimeSet) {
            String custNumber = row.getString("custnumber");
            if (onlyRedCustNameList.contains(custNumber)) continue;
            int time = row.getInteger("time");
            CustomerAnalysisEntry custEntry = this.custEntryMap.get(custNumber);
            custEntry.setfTime(time);
            sumTime += time;
            int fVal = 10;
            custEntry.setfVal(2);
            custEntry.setfLabel(CustomerLabelConst.getNewCustomer());
            for (int tsTime : this.curPlan.getfValList()) {
                if (time >= tsTime) {
                    custEntry.setfVal(fVal);
                    custEntry.setfLabel(this.curPlan.getfValLabelMap().get(tsTime));
                    sumfVal += fVal;
                    continue block0;
                }
                fVal -= 2;
            }
        }
        this.custHead.setAvgTime(Math.round((float)sumTime / (float)this.custEntryMap.size()));
        this.custHead.setAvgfVal(Math.round((float)sumfVal / (float)this.custEntryMap.size()));
    }

    private void dealmValData(DataSet dataSet, List<String> onlyRedCustNameList) {
        DataSet mAmountSet = dataSet.copy().groupBy(new String[]{"custname", "custnumber"}).sum("totalamount").sum("time").finish();
        DataSet sumAmountSet = mAmountSet.copy().groupBy().sum("totalamount").sum("time").finish();
        double unitPrice = 1.0;
        int summVal = 0;
        if (sumAmountSet.hasNext()) {
            Row row = sumAmountSet.next();
            unitPrice = row.getDouble("totalamount") / (double)row.getInteger("time").intValue();
        }
        this.custHead.setUnitPrice(BigDecimal.valueOf(unitPrice));
        BigDecimal sumAmount = BigDecimal.ZERO;
        block0: for (Row row : mAmountSet) {
            String custNumber = row.getString("custnumber");
            if (onlyRedCustNameList.contains(custNumber)) continue;
            Double amount = row.getDouble("totalamount");
            int orderNum = row.getInteger("time");
            CustomerAnalysisEntry custEntry = this.custEntryMap.get(custNumber);
            int mVal = 10;
            custEntry.setmVal(2);
            custEntry.setmLabel(CustomerLabelConst.getLowContributionCustomer());
            custEntry.setmAmount(BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_UP));
            sumAmount = sumAmount.add(custEntry.getmAmount());
            double orderUnitPrice = amount / (double)orderNum;
            for (double price : this.curPlan.getmValList()) {
                if (orderUnitPrice / unitPrice >= price) {
                    custEntry.setmVal(mVal);
                    custEntry.setmLabel(this.curPlan.getmValLabelMap().get(price));
                    summVal += mVal;
                    continue block0;
                }
                mVal -= 2;
            }
        }
        BigDecimal avgAmount = sumAmount.divide(BigDecimal.valueOf(this.custEntryMap.size()), 2, RoundingMode.HALF_UP);
        this.custHead.setAvgAmount(avgAmount);
        this.custHead.setAvgmVal(summVal / this.custEntryMap.size());
    }

    private void dealRfmLabel() {
        for (CustomerAnalysisEntry entry : this.custEntryMap.values()) {
            this.log.info("\u5ba2\u6237\u5206\u6790\u4ef7\u503c CustomerAnalysisEntry entry \u3010{}\u3011" + entry);
            int x = entry.getrVal() - this.custHead.getAvgrVal() >= 0 ? 1 : 0;
            int y = entry.getfVal() - this.custHead.getAvgfVal() >= 0 ? 1 : 0;
            int z = entry.getmVal() - this.custHead.getAvgmVal() >= 0 ? 1 : 0;
            String rfmLabel = this.rfmLabelArr[x][y][z];
            entry.setRfmLabel(rfmLabel);
            double rfmVal = (double)(entry.getrVal() * this.curPlan.getrWeight() + entry.getfVal() * this.curPlan.getfWeight() + entry.getmVal() * this.curPlan.getmWeight()) / 100.0;
            entry.setRfmVal(BigDecimal.valueOf(rfmVal).setScale(1, RoundingMode.HALF_UP));
            if (entry.getRfmVal().doubleValue() == (double)entry.getRfmVal().intValue()) {
                entry.setRfmVal(entry.getRfmVal().setScale(0));
            }
            this.custEntryList.add(entry);
            Integer count = this.custLabelNumMap.getOrDefault(entry.getRfmLabel(), 0);
            this.custLabelNumMap.put(entry.getRfmLabel(), count + 1);
        }
    }

    private void initRfmLabelArray() {
        this.rfmLabelArr[1][1][1] = CustomerLabelConst.getHighValueCustomer();
        this.rfmLabelArr[0][1][1] = CustomerLabelConst.getWakeUpCustomer();
        this.rfmLabelArr[1][0][1] = CustomerLabelConst.getDeepDigCustomer();
        this.rfmLabelArr[0][0][1] = CustomerLabelConst.getRetainCustomer();
        this.rfmLabelArr[1][1][0] = CustomerLabelConst.getPotentialCustomer();
        this.rfmLabelArr[1][0][0] = CustomerLabelConst.getNewCustomer();
        this.rfmLabelArr[0][1][0] = CustomerLabelConst.getGeneralKeepCustomer();
        this.rfmLabelArr[0][0][0] = CustomerLabelConst.getLoseCustomer();
    }

    public void delRfmData(Long headId) {
        String delHeadSql = "delete from t_mobsm_custanalysishead where fid = ?";
        String delEntrySql = "delete from t_mobsm_custanalysisentry where fid = ?";
        Object[] param = new Object[]{headId};
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)delHeadSql, (Object[])param);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)delEntrySql, (Object[])param);
    }
}

