/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.mobsm.business.helper.OrgHelper;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisHead;
import kd.scmc.mobsm.common.entity.CustomerAnalysisPlan;
import kd.scmc.mobsm.plugin.form.dataanalysis.customervalue.CustomerValueHomeData;

public class CustomerValueHomePagePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private CustomerAnalysisHead custHead;
    private Map<String, Integer> custLabelNumMap;
    private Long curSaleOrgId;
    private List<String> custLabelList = this.getCustLabelList();
    private CustomerValueHomeData customerValueHomeData = new CustomerValueHomeData();
    private Log log = LogFactory.getLog(CustomerValueHomePagePlugin.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object orgId = parameter.getCustomParam("org");
        if (orgId == null) {
            return;
        }
        this.curSaleOrgId = orgId instanceof Integer ? Long.valueOf(((Integer)orgId).longValue()) : (Long)orgId;
        this.getModel().beginInit();
        this.getModel().setValue("salorg", (Object)this.curSaleOrgId);
        this.getModel().endInit();
        this.cacheCurrency();
        this.initPageData();
    }

    public void initPageData() {
        this.getRfmSumData();
        this.buildRfmSumFlex();
        this.buildCustomerPropChart();
        this.buildCustomerNumChart();
    }

    private void cacheCurrency() {
        Map<String, Long> currencyAndExRateTable = this.getCurrencyAndExRateTable(this.curSaleOrgId);
        if (currencyAndExRateTable != null) {
            Long currencyId = currencyAndExRateTable.get("baseCurrencyID");
            QFilter filter = new QFilter("id", "=", (Object)currencyId);
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,name,sign", (QFilter[])filter.toArray());
            this.getPageCache().put("currency_sign", currency.getString("sign"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"linkrfmflex", "recountbtn", "rvalpanel", "fvalpanel", "mvalpanel"});
        BasedataEdit salOrgF7 = (BasedataEdit)this.getControl("salorg");
        salOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Chart propChartAp = (Chart)this.getView().getControl("custpropchart");
        propChartAp.addClickListener((ClickListener)this);
        Chart numChartAp = (Chart)this.getView().getControl("custnumchart");
        numChartAp.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("salorg".equals(name)) {
            DynamicObject salOrg = (DynamicObject)this.getModel().getValue("salorg");
            if (salOrg == null) {
                return;
            }
            this.curSaleOrgId = (Long)salOrg.getPkValue();
            this.cacheCurrency();
            this.initPageData();
        }
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "linkrfmflex": {
                this.linkToRfmScoreForm(null);
                break;
            }
            case "rvalpanel": {
                this.linkToAttrPage("R");
                break;
            }
            case "fvalpanel": {
                this.linkToAttrPage("F");
                break;
            }
            case "mvalpanel": {
                this.linkToAttrPage("M");
                break;
            }
            case "recountbtn": {
                this.reCountCustomerData();
                break;
            }
            case "custpropchart": {
                String labelName = ((ChartClickEvent)e).getName();
                this.linkToRfmScoreForm(labelName);
                break;
            }
            case "custnumchart": {
                String labelName = ((ChartClickEvent)e).getName();
                this.linkToRfmScoreForm(labelName);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("salorg".equals(name)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            List<Long> permSaleOrgIds = OrgHelper.getPermSaleOrgIds(userId);
            formShowParameter.setCustomParam("range", permSaleOrgIds);
        }
    }

    private void linkToAttrPage(String pageLabel) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("salorg");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"CustomerValueHomePagePlugin_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter mobForm = new MobileFormShowParameter();
        mobForm.getOpenStyle().setShowType(ShowType.Floating);
        if ("R".equals(pageLabel)) {
            mobForm.setFormId("mobsm_rvalanalysis");
            mobForm.setCustomParam("attrPageKey", (Object)"R");
        } else if ("F".equals(pageLabel)) {
            mobForm.setFormId("mobsm_fvalanalysis");
            mobForm.setCustomParam("attrPageKey", (Object)"F");
        } else {
            mobForm.setFormId("mobsm_mvalanalysis");
            mobForm.setCustomParam("attrPageKey", (Object)"M");
            mobForm.setCustomParam("currency_sign", (Object)this.getPageCache().get("currency_sign"));
        }
        String custEntryStr = this.getPageCache().get("custEntryList");
        mobForm.setCustomParam("custEntryList", JsonUtil.decodeFromString((String)custEntryStr, List.class));
        String curPlanStr = this.getPageCache().get("curPlan");
        mobForm.setCustomParam("curPlan", JsonUtil.decodeFromString((String)curPlanStr, CustomerAnalysisPlan.class));
        String custHeadStr = this.getPageCache().get("custHeadKey");
        mobForm.setCustomParam("custHeadKey", JsonUtil.decodeFromString((String)custHeadStr, CustomerAnalysisHead.class));
        this.getView().showForm((FormShowParameter)mobForm);
    }

    private void reCountCustomerData() {
        String headId = this.getPageCache().get("headid");
        if ("null".equals(headId)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CustomerValueHomePagePlugin_4", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            return;
        }
        this.customerValueHomeData.delRfmData(Long.valueOf(headId));
        this.curSaleOrgId = Long.valueOf(this.getPageCache().get("salorg"));
        this.initPageData();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cd\u7b97\u6210\u529f\u3002", (String)"CustomerValueHomePagePlugin_5", (String)"scmc-mobsm-form", (Object[])new Object[0]));
    }

    private void linkToRfmScoreForm(String custLabel) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("salorg");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"CustomerValueHomePagePlugin_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter mobForm = new MobileFormShowParameter();
        mobForm.setFormId("mobsm_rfmscore");
        mobForm.getOpenStyle().setShowType(ShowType.Floating);
        String custEntryStr = this.getPageCache().get("custEntryList");
        mobForm.setCustomParam("custEntryList", JsonUtil.decodeFromString((String)custEntryStr, List.class));
        mobForm.setCustomParam("currency_sign", (Object)this.getPageCache().get("currency_sign"));
        if (custLabel != null) {
            mobForm.setCustomParam("custLabelKey", (Object)custLabel);
        }
        this.getView().showForm((FormShowParameter)mobForm);
    }

    private void buildRfmSumFlex() {
        String sign = this.getPageCache().get("currency_sign");
        String avgAmountLabel = "";
        if (StringUtils.isNotBlank((CharSequence)sign)) {
            String rValue = ResManager.loadKDString((String)"\u5e73\u5747\u4ea4\u6613\u91d1\u989d(%s)", (String)"CustomerValueHomePagePlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            avgAmountLabel = String.format(rValue, sign);
        } else {
            avgAmountLabel = ResManager.loadKDString((String)"\u5e73\u5747\u4ea4\u6613\u91d1\u989d()", (String)"CustomerValueHomePagePlugin_3", (String)"scmc-mobsm-form", (Object[])new Object[0]);
        }
        this.setControlText("avgamountlabel", avgAmountLabel);
        if (StringUtils.isBlank((Object)this.custHead.getAvgDay())) {
            this.setControlText("avgday", "0");
            this.setControlText("avgtime", "0");
            this.setControlText("avgamount", "0.00");
        } else {
            this.setControlText("avgday", this.custHead.getAvgDay().toString());
            this.setControlText("avgtime", this.custHead.getAvgTime().toString());
            BigDecimal divide = this.custHead.getAvgAmount().divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
            this.setControlText("avgamount", divide.toString());
        }
    }

    private void setControlText(String key, String val) {
        Label label = (Label)this.getView().getControl(key);
        label.setText(val);
        this.getView().updateView(key);
    }

    private void getRfmSumData() {
        boolean flag = this.customerValueHomeData.getRfmSumData(this.curSaleOrgId);
        if (!flag) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0e\u6240\u9009\u9500\u552e\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CustomerValueHomePagePlugin_2", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        }
        this.custHead = this.customerValueHomeData.custHead;
        this.custLabelNumMap = this.customerValueHomeData.custLabelNumMap;
        this.getPageCache().put("custEntryList", JsonUtil.encodeToString(this.customerValueHomeData.custEntryList));
        this.getPageCache().put("custHeadKey", JsonUtil.encodeToString((Object)this.custHead));
        this.getPageCache().put("curPlan", JsonUtil.encodeToString((Object)this.customerValueHomeData.curPlan));
        this.getPageCache().put("headid", String.valueOf(this.custHead.getId()));
        this.getPageCache().put("salorg", String.valueOf(this.curSaleOrgId));
    }

    private void buildCustomerPropChart() {
        Control pieChartAp = this.getView().getControl("custpropchart");
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart == null) {
            return;
        }
        pieChart.clearData();
        pieChart.setShowLegend(false);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("triggerOn", (Object)"click");
        PieSeries series = pieChart.createSeries("");
        List<String> labelColorList = this.getLabelColorList();
        for (int i = 0; i < this.custLabelList.size(); ++i) {
            String custLabel = this.custLabelList.get(i);
            series.addData(custLabel, (Number)this.custLabelNumMap.getOrDefault(custLabel, 0), labelColorList.get(i));
        }
        this.setControlText("highvalnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getHighValueCustomer(), 0).toString());
        this.setControlText("wakeupnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getWakeUpCustomer(), 0).toString());
        this.setControlText("deepdignum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getDeepDigCustomer(), 0).toString());
        this.setControlText("retainnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getRetainCustomer(), 0).toString());
        this.setControlText("potentialnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getPotentialCustomer(), 0).toString());
        this.setControlText("newnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getNewCustomer(), 0).toString());
        this.setControlText("generalkeepnum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getGeneralKeepCustomer(), 0).toString());
        this.setControlText("losenum", this.custLabelNumMap.getOrDefault(CustomerLabelConst.getLoseCustomer(), 0).toString());
        series.setRadius("50%", "70%");
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        label.setFormatter("{b} : {c}  ({d}%)");
        series.setLabel(label);
        this.getView().updateView("custpropchart");
    }

    private void buildCustomerNumChart() {
        Control barChartAp = this.getView().getControl("custnumchart");
        BarChart barChart = null;
        if (barChartAp instanceof BarChart) {
            barChart = (BarChart)barChartAp;
        }
        if (barChart == null) {
            return;
        }
        barChart.clearData();
        List<String> labelColorList = this.getLabelColorList();
        Collections.reverse(this.custLabelList);
        Collections.reverse(labelColorList);
        this.buildYAxisByNumChart(barChart);
        barChart.setName(new LocaleString(ResManager.loadKDString((String)"\u5404\u7c7b\u5ba2\u6237\u6570\u91cf", (String)"CustomerValueHomePagePlugin_6", (String)"scmc-mobsm-form", (Object[])new Object[0])));
        barChart.setMargin(Position.top, "5%");
        BarSeries series = barChart.createSeries("");
        int maxValue = 0;
        for (int i = 0; i < this.custLabelList.size(); ++i) {
            String custLabel = this.custLabelList.get(i);
            maxValue = Math.max(this.custLabelNumMap.getOrDefault(custLabel, 0), maxValue);
            series.addData(custLabel, (Number)this.custLabelNumMap.getOrDefault(custLabel, null), labelColorList.get(i));
        }
        series.setBarWidth("50%");
        series.setPropValue("barGap", (Object)"30%");
        this.buildXAxisByNumChart(barChart, maxValue);
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(true);
        label.setPosition(Position.insideBottomRight);
        label.setBorderRadius("10px");
        series.setLabel(label);
        this.getView().updateView("custnumchart");
    }

    private void buildYAxisByNumChart(BarChart barChart) {
        Axis yAxis = barChart.createYAxis("", AxisType.category);
        yAxis.setCategorys(this.custLabelList.toArray(new String[0]));
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap axisLabelMap = new HashMap(3);
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 14);
        textStyleMap.put("color", "#666666");
        axisLabelMap.put("textStyle", textStyleMap);
        yAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("axisLine", axisLine);
    }

    private void buildXAxisByNumChart(BarChart barChart, int maxValue) {
        Axis xAxis = barChart.createXAxis("", AxisType.value);
        xAxis.setPropValue("minInterval", (Object)1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        xAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        xAxis.setPropValue("boundaryGap", (Object)true);
        xAxis.setPropValue("max", (Object)(maxValue + 1));
    }

    private List<String> getCustLabelList() {
        ArrayList<String> custLabelList = new ArrayList<String>(12);
        custLabelList.add(CustomerLabelConst.getHighValueCustomer());
        custLabelList.add(CustomerLabelConst.getWakeUpCustomer());
        custLabelList.add(CustomerLabelConst.getDeepDigCustomer());
        custLabelList.add(CustomerLabelConst.getRetainCustomer());
        custLabelList.add(CustomerLabelConst.getPotentialCustomer());
        custLabelList.add(CustomerLabelConst.getNewCustomer());
        custLabelList.add(CustomerLabelConst.getGeneralKeepCustomer());
        custLabelList.add(CustomerLabelConst.getLoseCustomer());
        return custLabelList;
    }

    private List<String> getLabelColorList() {
        ArrayList<String> labelColorList = new ArrayList<String>(12);
        labelColorList.add("#F57582");
        labelColorList.add("#FFA940");
        labelColorList.add("#FFD666");
        labelColorList.add("#73D13D");
        labelColorList.add("#45DAD1");
        labelColorList.add("#40A9FF");
        labelColorList.add("#6682F5");
        labelColorList.add("#999999");
        return labelColorList;
    }

    public Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        if (orgId == null || orgId.equals(0L)) {
            return null;
        }
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg == null || mapOrg.get("id") == null) {
            return null;
        }
        this.log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
        Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
        if (map == null || map.isEmpty()) {
            return null;
        }
        this.log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
        return map;
    }
}

