/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.dataanalysis.customervalue;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobsm.business.utils.MobileControlUtils;
import kd.scmc.mobsm.common.consts.custanalysis.CustomerLabelConst;
import kd.scmc.mobsm.common.entity.CustomerAnalysisEntry;

public class CustomerValueRfmScorePlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    public static final int RFM_LABEL_SIZE = 8;
    private static final String detailBtn = "detailbtn";
    private static final String sortBtn = "flexpanelap4";
    private static final String custLabelPanelAp = "custlabelpanelap";
    private static final String searchControl = "searchap";
    private static final String choiceLabelListKey = "choiceLabelList";
    private static final String choiceApListKey = "choiceApList";
    private static final String showEntryListKey = "showEntryList";
    private static final String tempEntryListKey = "tempEntryList";
    private static final String sortDirection = "sortDirection";
    private static final String BORDER_COLOR = "borc";
    private Log log = LogFactory.getLog(CustomerValueRfmScorePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{detailBtn, sortBtn, searchControl, custLabelPanelAp});
        MobileSearch search = (MobileSearch)this.getControl(searchControl);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("currency_sign");
        this.getPageCache().put("currency_sign", sign);
        String custLabel = (String)this.getView().getFormShowParameter().getCustomParam("custLabelKey");
        this.buildPageData(custLabel);
    }

    private void buildPageData(String custLabel) {
        this.dealEntryFilterData(custLabel);
        this.cacheFilterData(custLabel);
    }

    private void cacheFilterData(String custLabel) {
        ArrayList<String> choiceLabelList = (ArrayList<String>)this.getView().getFormShowParameter().getCustomParam(choiceLabelListKey);
        ArrayList<String> choiceApList = (ArrayList<String>)this.getView().getFormShowParameter().getCustomParam(choiceApListKey);
        if (choiceLabelList == null) {
            choiceLabelList = new ArrayList<String>(2);
        }
        if (choiceApList == null) {
            choiceApList = new ArrayList<String>(2);
        }
        if (custLabel != null) {
            choiceLabelList.add(custLabel);
            choiceApList.add(this.dealApListKey(custLabel));
        }
        this.getPageCache().put(choiceLabelListKey, JsonUtil.encodeToString(choiceLabelList));
        this.getPageCache().put(choiceApListKey, JsonUtil.encodeToString(choiceApList));
    }

    private String dealApListKey(String custLabel) {
        if (CustomerLabelConst.getHighValueCustomer().equals(custLabel)) {
            return "highvalap";
        }
        if (CustomerLabelConst.getWakeUpCustomer().equals(custLabel)) {
            return "wakeupap";
        }
        if (CustomerLabelConst.getDeepDigCustomer().equals(custLabel)) {
            return "deepdigap";
        }
        if (CustomerLabelConst.getRetainCustomer().equals(custLabel)) {
            return "retainap";
        }
        if (CustomerLabelConst.getPotentialCustomer().equals(custLabel)) {
            return "potentialap";
        }
        if (CustomerLabelConst.getNewCustomer().equals(custLabel)) {
            return "newap";
        }
        if (CustomerLabelConst.getGeneralKeepCustomer().equals(custLabel)) {
            return "generalkeepap";
        }
        if (CustomerLabelConst.getLoseCustomer().equals(custLabel)) {
            return "loseap";
        }
        return "";
    }

    private void dealEntryFilterData(String custLabel) {
        int i;
        JSONArray entryList = (JSONArray)this.getView().getFormShowParameter().getCustomParam("custEntryList");
        ArrayList<String> choiceLabelList = (ArrayList<String>)this.getView().getFormShowParameter().getCustomParam(choiceLabelListKey);
        if (choiceLabelList == null) {
            choiceLabelList = new ArrayList<String>(2);
        }
        if (custLabel != null) {
            this.log.info("CustomerValueRfmScorePlugin: dealEntryFilterData \u56fe\u8868\u7a7f\u900f\uff0ccustLabel = \u3010{}\u3011", (Object)custLabel);
            choiceLabelList.add(custLabel);
        }
        if (choiceLabelList.isEmpty() || choiceLabelList.size() == 8) {
            String text = ResManager.loadKDString((String)"\u5168\u90e8", (String)"CustomerValueRfmScorePlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
            this.setControlText("rfmlabelap", text);
        } else {
            String Label2 = choiceLabelList.size() == 1 ? (String)choiceLabelList.get(0) : (String)choiceLabelList.get(0) + "(" + choiceLabelList.size() + ")";
            this.setControlText("rfmlabelap", Label2);
        }
        int count = entryList.size();
        ArrayList<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(count);
        ArrayList<CustomerAnalysisEntry> showEntryList = new ArrayList<CustomerAnalysisEntry>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)((JSON)entryList.get(i2)), CustomerAnalysisEntry.class);
            custEntryList.add(entry);
            if (!choiceLabelList.contains(entry.getRfmLabel())) continue;
            showEntryList.add(entry);
        }
        if (choiceLabelList.size() == 0) {
            showEntryList = custEntryList;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryList.size() - entryRowCount >= 1) {
            this.getModel().batchCreateNewEntryRow("entryentity", entryList.size() - entryRowCount);
        }
        Collections.sort(showEntryList, (e1, e2) -> e2.getRfmVal().compareTo(e1.getRfmVal()));
        this.getPageCache().put(sortDirection, "down");
        for (i = 0; i < showEntryList.size(); ++i) {
            this.buildCardEntryData((CustomerAnalysisEntry)showEntryList.get(i), i);
            cardEntry.setChildVisible(true, i, new String[]{"rfmentryflex"});
        }
        for (i = showEntryList.size(); i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"rfmentryflex"});
        }
        this.getPageCache().put("isShow", "false");
        this.getPageCache().put(showEntryListKey, JsonUtil.encodeToString(showEntryList));
        this.getPageCache().put("custEntryList", JsonUtil.encodeToString(custEntryList));
    }

    private void setControlText(String key, String val) {
        Label label = (Label)this.getView().getControl(key);
        label.setText(val);
        this.getView().updateView(key);
    }

    private void buildCardEntryData(CustomerAnalysisEntry entry, int rowIndex) {
        String cacheSign = this.getPageCache().get("currency_sign");
        String sign = cacheSign == null ? "" : cacheSign;
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        this.getModel().setValue("custname", (Object)entry.getCustomerName(), rowIndex);
        BigDecimal rfmVal = entry.getRfmVal().doubleValue() == (double)entry.getRfmVal().intValue() ? entry.getRfmVal().setScale(0) : entry.getRfmVal().setScale(1);
        this.getModel().setValue("rfmval", (Object)rfmVal, rowIndex);
        this.getModel().setValue("rday", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5929", (String)"CustomerValueRfmScorePlugin_buildCardEntryData_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), entry.getrDay()), rowIndex);
        this.getModel().setValue("ftime", (Object)String.format(ResManager.loadKDString((String)"%1$s\u6b21", (String)"CustomerValueRfmScorePlugin_buildCardEntryData_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), entry.getfTime()), rowIndex);
        this.getModel().setValue("mamount", (Object)(sign + entry.getmAmount().setScale(2, RoundingMode.HALF_UP)), rowIndex);
        HashMap<String, Object> proData = new HashMap<String, Object>(3);
        proData.put("text", entry.getRfmLabel());
        proData.put("fc", this.getLabelColor(entry.getRfmLabel()));
        proData.put(BORDER_COLOR, this.getLabelColor(entry.getRfmLabel()));
        MobileControlUtils.setCardEntryRowProperty(cardEntry, rowIndex, "rfmlabel", proData);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String opKey = source.getKey();
        if (detailBtn.equals(opKey)) {
            this.showRfmDetail();
        } else if (sortBtn.equals(opKey)) {
            this.sortPageData();
        } else if (custLabelPanelAp.equals(opKey)) {
            this.linkToFilterPage();
        }
    }

    private void linkToFilterPage() {
        String sourcePageKey = "sourcePage";
        MobileFormShowParameter mobForm = new MobileFormShowParameter();
        mobForm.setFormId("mobsm_rfmfilter");
        mobForm.getOpenStyle().setShowType(ShowType.Modal);
        mobForm.setCustomParam(sourcePageKey, (Object)"mobsm_rfmscore");
        String custEntryStr = this.getPageCache().get("custEntryList");
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        mobForm.setCustomParam("custEntryList", (Object)entryList);
        String choiceLabelStr = this.getPageCache().get(choiceLabelListKey);
        List choiceLabelList = (List)JsonUtil.decodeFromString((String)choiceLabelStr, List.class);
        mobForm.setCustomParam(choiceLabelListKey, (Object)choiceLabelList);
        String choiceApStr = this.getPageCache().get(choiceApListKey);
        List choiceApList = (List)JsonUtil.decodeFromString((String)choiceApStr, List.class);
        mobForm.setCustomParam(choiceApListKey, (Object)choiceApList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ((Object)((Object)this)).getClass().getName());
        mobForm.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)mobForm);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        List choiceLabelList = (List)returnData.get(choiceLabelListKey);
        List choiceApList = (List)returnData.get(choiceApListKey);
        Object custEntryList = returnData.get("custEntryList");
        this.getView().getFormShowParameter().setCustomParam(choiceLabelListKey, (Object)choiceLabelList);
        this.getView().getFormShowParameter().setCustomParam(choiceApListKey, (Object)choiceApList);
        this.getView().getFormShowParameter().setCustomParam("custEntryList", custEntryList);
        this.buildPageData(null);
        this.searchCustomerEntry();
    }

    private void searchCustomerEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl(searchControl);
        this.log.info("CustomerValueRfmScorePlugin: searchCustomerEntry fuzzy search,search.getText() = {}", (Object)search.getText());
        String custEntryStr = this.getPageCache().get(showEntryListKey);
        List entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        ArrayList<CustomerAnalysisEntry> showList = new ArrayList<CustomerAnalysisEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            if (!entry.getCustomerName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        int showCount = showList.size();
        for (i = 0; i < showCount; ++i) {
            this.buildCardEntryData((CustomerAnalysisEntry)showList.get(i), i);
            cardEntry.setChildVisible(true, i, new String[]{"rfmentryflex"});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{"rfmentryflex"});
        }
        this.getPageCache().put(tempEntryListKey, JsonUtil.encodeToString(showList));
    }

    private void showRfmDetail() {
        Label btnLabel = (Label)this.getView().getControl(detailBtn);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        String isShow = "isShow";
        String showVal = this.getPageCache().get(isShow);
        if ("false".equals(showVal)) {
            btnLabel.setText(ResManager.loadKDString((String)"\u663e\u793a\u660e\u7ec6", (String)"CustomerValueRfmScorePlugin_showRfmDetail_0", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            this.getPageCache().put(isShow, "true");
        } else {
            btnLabel.setText(ResManager.loadKDString((String)"\u9690\u85cf\u660e\u7ec6", (String)"CustomerValueRfmScorePlugin_showRfmDetail_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            this.getPageCache().put(isShow, "false");
        }
        boolean showFlag = Boolean.parseBoolean(showVal);
        for (int i = 0; i < entryRowCount; ++i) {
            cardEntry.setChildVisible(showFlag, i, new String[]{"rfmdetailflex"});
        }
    }

    private void sortPageData() {
        String tempEntryStr = this.getPageCache().get(tempEntryListKey);
        List entryList = (List)JsonUtil.decodeFromString((String)tempEntryStr, List.class);
        if (entryList == null || entryList.isEmpty()) {
            String custEntryStr = this.getPageCache().get(showEntryListKey);
            entryList = (List)JsonUtil.decodeFromString((String)custEntryStr, List.class);
        }
        ArrayList<CustomerAnalysisEntry> custEntryList = new ArrayList<CustomerAnalysisEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            CustomerAnalysisEntry entry = (CustomerAnalysisEntry)JSON.toJavaObject((JSON)jsonObject, CustomerAnalysisEntry.class);
            custEntryList.add(entry);
        }
        String direct = this.getPageCache().get(sortDirection);
        if ("up".equals(direct)) {
            this.getPageCache().put(sortDirection, "down");
            Collections.sort(custEntryList, (e1, e2) -> e2.getRfmVal().compareTo(e1.getRfmVal()));
        } else {
            this.getPageCache().put(sortDirection, "up");
            Collections.sort(custEntryList, Comparator.comparing(CustomerAnalysisEntry::getRfmVal));
        }
        int count = entryList.size();
        for (int i = 0; i < count; ++i) {
            this.buildCardEntryData((CustomerAnalysisEntry)custEntryList.get(i), i);
        }
    }

    private String getLabelColor(String label) {
        String color = "#F57582";
        if (CustomerLabelConst.getHighValueCustomer().equals(label)) {
            color = "#F57582";
        }
        if (CustomerLabelConst.getWakeUpCustomer().equals(label)) {
            color = "#FFA940";
        }
        if (CustomerLabelConst.getDeepDigCustomer().equals(label)) {
            color = "#FFD666";
        }
        if (CustomerLabelConst.getRetainCustomer().equals(label)) {
            color = "#73D13D";
        }
        if (CustomerLabelConst.getPotentialCustomer().equals(label)) {
            color = "#45DAD1";
        }
        if (CustomerLabelConst.getNewCustomer().equals(label)) {
            color = "#40A9FF";
        }
        if (CustomerLabelConst.getGeneralKeepCustomer().equals(label)) {
            color = "#6682F5";
        }
        if (CustomerLabelConst.getLoseCustomer().equals(label)) {
            color = "#999999";
        }
        return color;
    }

    public void focus() {
        this.searchCustomerEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.searchCustomerEntry();
    }
}

