/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobsm.business.helper.PermissionHelper;
import kd.scmc.mobsm.common.utils.DateUtils;

public abstract class AbstractInitDataPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(AbstractInitDataPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit salOrgF7 = (BasedataEdit)this.getControl("org");
        salOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDateOfWeek(new Date());
        Date startDate = startAndEndDate.get("startdate");
        Date endDate = startAndEndDate.get("enddate");
        this.getModel().setValue("daterange_startdate", (Object)startDate);
        this.getModel().setValue("daterange_enddate", (Object)endDate);
        Object orgId = parameter.getCustomParam("org");
        if (orgId == null) {
            return;
        }
        this.getModel().setValue("org", orgId);
        this.assignmentOfCalculationResults(orgId, startDate, endDate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "org": 
            case "daterange_startdate": 
            case "daterange_enddate": {
                this.changeData();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("org".equals(name)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            List<Object> saleOrgColl = PermissionHelper.getAllHasPermSaleOrgs("id");
            formShowParameter.setCustomParam("range", saleOrgColl);
        }
    }

    public abstract void assignmentOfCalculationResults(Object var1, Date var2, Date var3);

    public abstract void changeData();
}

