/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.scmc.mobsm.common.entity.salesanalysisentity.CustOrderDelTimelyRateEntry;
import kd.scmc.mobsm.plugin.form.saleanalysis.AbstractInitDataPlugin;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class CustOrderDelTimelyRatePlugin
extends AbstractInitDataPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    private static String CUSTOMER = "basedatafield";
    private static String EXPIREORDERNUM = "integerfield";
    private static String ONTIMENUM = "integerfield1";
    private static String RATE = "decimalfield";
    private static String ENTRY = "cardentryflexpanelap7";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5", "mobilesearchap"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    @Override
    public void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        List<CustOrderDelTimelyRateEntry> custOrderDelTimelyRateEntries = this.queryData(orgId, startDate, endDate);
        if (!custOrderDelTimelyRateEntries.isEmpty()) {
            this.setDataValue(custOrderDelTimelyRateEntries);
            this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custOrderDelTimelyRateEntries));
        } else {
            this.getPageCache().put("showEntryList", "empty");
        }
    }

    @Override
    public void changeData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().put("showEntryList", "empty");
        } else {
            this.getModel().deleteEntryData("entryentity");
            List<CustOrderDelTimelyRateEntry> custOrderDelTimelyRateEntries = this.queryData(org.getPkValue(), startDate, endDate);
            if (!custOrderDelTimelyRateEntries.isEmpty()) {
                MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
                if (search.getText() == null || search.getText().equals("")) {
                    this.setDataValue(custOrderDelTimelyRateEntries);
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custOrderDelTimelyRateEntries));
                } else {
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custOrderDelTimelyRateEntries));
                    this.searchTimelyRateEntry();
                }
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap5".equals(key)) {
            this.sortEntryData();
        }
    }

    private List<CustOrderDelTimelyRateEntry> queryData(Object orgId, Date startDate, Date endDate) {
        DataSet orderDeliverTimelyRate = QuerySalesAnalysisDataPlugin.getOrderDeliverTimelyRate(((Object)((Object)this)).getClass().getName(), orgId, startDate, endDate);
        ArrayList<CustOrderDelTimelyRateEntry> orderDeliverTimelyRateEntries = new ArrayList<CustOrderDelTimelyRateEntry>(10);
        while (orderDeliverTimelyRate.hasNext()) {
            Row row = orderDeliverTimelyRate.next();
            CustOrderDelTimelyRateEntry custOrderDelTimelyRateEntry = new CustOrderDelTimelyRateEntry();
            custOrderDelTimelyRateEntry.setCustomer(row.getLong("customer"));
            custOrderDelTimelyRateEntry.setCustomerName(row.getString("customername"));
            custOrderDelTimelyRateEntry.setExpireOrderNum(row.getInteger("expireordernum"));
            custOrderDelTimelyRateEntry.setOnTimeNum(row.getInteger("ontimenum"));
            custOrderDelTimelyRateEntry.setDeliverTimelyRate(row.getBigDecimal("delivertimerate"));
            orderDeliverTimelyRateEntries.add(custOrderDelTimelyRateEntry);
        }
        if (!orderDeliverTimelyRateEntries.isEmpty()) {
            Collections.sort(orderDeliverTimelyRateEntries, (e1, e2) -> e2.getDeliverTimelyRate().compareTo(e1.getDeliverTimelyRate()));
        }
        return orderDeliverTimelyRateEntries;
    }

    private void setDataValue(List<CustOrderDelTimelyRateEntry> orderDeliverTimelyRateEntries) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", orderDeliverTimelyRateEntries.size());
        for (int index = 0; index < orderDeliverTimelyRateEntries.size(); ++index) {
            CustOrderDelTimelyRateEntry custOrderDelTimelyRateEntry = orderDeliverTimelyRateEntries.get(index);
            model.setValue(CUSTOMER, (Object)custOrderDelTimelyRateEntry.getCustomer(), index);
            model.setValue(EXPIREORDERNUM, (Object)custOrderDelTimelyRateEntry.getExpireOrderNum(), index);
            model.setValue(ONTIMENUM, (Object)custOrderDelTimelyRateEntry.getOnTimeNum(), index);
            model.setValue(RATE, (Object)custOrderDelTimelyRateEntry.getDeliverTimelyRate(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String custOrderDelTimelyRateEntryStr = this.getPageCache().get("showEntryList");
            if (custOrderDelTimelyRateEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)custOrderDelTimelyRateEntryStr, List.class);
        }
        ArrayList<CustOrderDelTimelyRateEntry> custOrderDelTimelyRateEntryList = new ArrayList<CustOrderDelTimelyRateEntry>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            CustOrderDelTimelyRateEntry entry = (CustOrderDelTimelyRateEntry)JSON.toJavaObject((JSON)jsonObject, CustOrderDelTimelyRateEntry.class);
            custOrderDelTimelyRateEntryList.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            Collections.sort(custOrderDelTimelyRateEntryList, (e1, e2) -> e2.getDeliverTimelyRate().compareTo(e1.getDeliverTimelyRate()));
        } else {
            this.getPageCache().put("sortDirection", "up");
            Collections.sort(custOrderDelTimelyRateEntryList, Comparator.comparing(CustOrderDelTimelyRateEntry::getDeliverTimelyRate));
        }
        this.sortAndSearchSetData(custOrderDelTimelyRateEntryList);
    }

    private void sortAndSearchSetData(List<CustOrderDelTimelyRateEntry> custOrderDelTimelyRateEntryList) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (int index = 0; index < custOrderDelTimelyRateEntryList.size(); ++index) {
            CustOrderDelTimelyRateEntry custOrderDelTimelyRateEntry = custOrderDelTimelyRateEntryList.get(index);
            model.setValue(CUSTOMER, (Object)custOrderDelTimelyRateEntry.getCustomer(), index);
            model.setValue(EXPIREORDERNUM, (Object)custOrderDelTimelyRateEntry.getExpireOrderNum(), index);
            model.setValue(ONTIMENUM, (Object)custOrderDelTimelyRateEntry.getOnTimeNum(), index);
            model.setValue(RATE, (Object)custOrderDelTimelyRateEntry.getDeliverTimelyRate(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchTimelyRateEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchTimelyRateEntry();
    }

    private void searchTimelyRateEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String EntryStr = this.getPageCache().get("showEntryList");
        if (EntryStr == null || EntryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)EntryStr, List.class);
        ArrayList<CustOrderDelTimelyRateEntry> showList = new ArrayList<CustOrderDelTimelyRateEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            CustOrderDelTimelyRateEntry entry = (CustOrderDelTimelyRateEntry)JSON.toJavaObject((JSON)jsonObject, CustOrderDelTimelyRateEntry.class);
            if (!entry.getCustomerName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataValue(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{ENTRY});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{ENTRY});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }
}

