/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.AmountHelper;
import kd.scmc.mobsm.common.entity.salesanalysisentity.CustSalNewsEntry;
import kd.scmc.mobsm.plugin.form.saleanalysis.AbstractInitDataPlugin;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class CustomerSalesNewsPlugin
extends AbstractInitDataPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    private static String CUSTOMER = "basedatafield";
    private static String CURRENCY = "currencyfield";
    private static String AMOUNT = "amountfield";
    private static String ENTRY = "cardentryflexpanelap2";
    private static String QUERY_KEY = "custsal";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5", "mobilesearchap"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    @Override
    public void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        List<CustSalNewsEntry> custSalNewsEntries = this.queryData(orgId, startDate, endDate);
        if (!custSalNewsEntries.isEmpty()) {
            this.setDataValue(custSalNewsEntries);
            this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custSalNewsEntries));
        } else {
            this.getPageCache().put("showEntryList", "empty");
        }
    }

    @Override
    public void changeData() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("daterange_startdate");
        Date endDate = (Date)model.getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().put("showEntryList", "empty");
        } else {
            this.getModel().deleteEntryData("entryentity");
            List<CustSalNewsEntry> custSalNewsEntries = this.queryData(org.getPkValue(), startDate, endDate);
            if (!custSalNewsEntries.isEmpty()) {
                MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
                if (search.getText() == null || search.getText().equals("")) {
                    this.setDataValue(custSalNewsEntries);
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custSalNewsEntries));
                } else {
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(custSalNewsEntries));
                    this.searchCustomerEntry();
                }
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap5".equals(key)) {
            this.sortEntryData();
        }
    }

    private List<CustSalNewsEntry> queryData(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        DataSet custSal = QuerySalesAnalysisDataPlugin.query(((Object)((Object)this)).getClass().getName(), qFilter, QUERY_KEY);
        List<CustSalNewsEntry> custSalNewsEntryColl = this.setEntryInfo(custSal);
        return custSalNewsEntryColl;
    }

    private List<CustSalNewsEntry> setEntryInfo(DataSet custSal) {
        ArrayList<CustSalNewsEntry> custSalNewsEntryColl = new ArrayList<CustSalNewsEntry>(10);
        while (custSal.hasNext()) {
            Row row = custSal.next();
            BigDecimal amount = row.getBigDecimal("curtotalallamount");
            if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            CustSalNewsEntry custSalNewsEntry = new CustSalNewsEntry();
            custSalNewsEntry.setCustomer(row.getLong("customer"));
            custSalNewsEntry.setCustomerName(row.getString("customername"));
            custSalNewsEntry.setOrg(row.getLong("org"));
            custSalNewsEntry.setAmount(AmountHelper.getStripDecimalAmount(amount));
            custSalNewsEntry.setCurrency(row.getLong("currency"));
            custSalNewsEntryColl.add(custSalNewsEntry);
        }
        return custSalNewsEntryColl;
    }

    private void setDataValue(List<CustSalNewsEntry> custSalNewsEntries) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", custSalNewsEntries.size());
        for (int index = 0; index < custSalNewsEntries.size(); ++index) {
            CustSalNewsEntry custSalNewsEntry = custSalNewsEntries.get(index);
            model.setValue(CUSTOMER, (Object)custSalNewsEntry.getCustomer(), index);
            model.setValue(CURRENCY, (Object)custSalNewsEntry.getCurrency(), index);
            model.setValue(AMOUNT, (Object)custSalNewsEntry.getAmount(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String custSalNewsEntryStr = this.getPageCache().get("showEntryList");
            if (custSalNewsEntryStr == null || custSalNewsEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)custSalNewsEntryStr, List.class);
        }
        ArrayList<CustSalNewsEntry> custSalNewsEntryList = new ArrayList<CustSalNewsEntry>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            CustSalNewsEntry entry = (CustSalNewsEntry)JSON.toJavaObject((JSON)jsonObject, CustSalNewsEntry.class);
            custSalNewsEntryList.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            Collections.sort(custSalNewsEntryList, (e1, e2) -> e2.getAmount().compareTo(e1.getAmount()));
        } else {
            this.getPageCache().put("sortDirection", "up");
            Collections.sort(custSalNewsEntryList, Comparator.comparing(CustSalNewsEntry::getAmount));
        }
        this.sortAndSearchSetData(custSalNewsEntryList);
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchCustomerEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchCustomerEntry();
    }

    private void searchCustomerEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String EntryStr = this.getPageCache().get("showEntryList");
        if (EntryStr == null || EntryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)EntryStr, List.class);
        ArrayList<CustSalNewsEntry> showList = new ArrayList<CustSalNewsEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            CustSalNewsEntry entry = (CustSalNewsEntry)JSON.toJavaObject((JSON)jsonObject, CustSalNewsEntry.class);
            if (!entry.getCustomerName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataValue(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{ENTRY});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{ENTRY});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }

    private void sortAndSearchSetData(List<CustSalNewsEntry> custSalNewsEntryList) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (int index = 0; index < custSalNewsEntryList.size(); ++index) {
            CustSalNewsEntry custSalNewsEntry = custSalNewsEntryList.get(index);
            model.setValue(CUSTOMER, (Object)custSalNewsEntry.getCustomer(), index);
            model.setValue(CURRENCY, (Object)custSalNewsEntry.getCurrency(), index);
            model.setValue(AMOUNT, (Object)custSalNewsEntry.getAmount(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

