/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobsm.common.entity.salesanalysisentity.CustomerAmountInfo;
import kd.scmc.mobsm.common.utils.DateUtils;
import kd.scmc.mobsm.plugin.form.saleanalysis.AbstractInitDataPlugin;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class NewCustomerAnalysisPlugin
extends AbstractInitDataPlugin {
    private static final Log LOG = LogFactory.getLog(NewCustomerAnalysisPlugin.class);
    private static String custPropChart = "custpropchart";
    private static String newCustAmount = "newcustamount";
    private static String totalAmount = "totalamount";
    private static String newCustomer = "newcustomer";
    private static String allCustomer = "allcustomer";
    private static String newCustnum = "newcustnum";
    private static String allCustnum = "allcustnum";
    private static String ID = "id";
    private static String newAmount = "amountfield";
    private static String newCurrency = "currencyfield";
    private static String totalAmountField = "amountfield1";
    private static String totalCurrency = "currencyfield1";
    private static String ENDDATE = "enddate";

    @Override
    public void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDate(endDate);
        Date custEndDate = startAndEndDate.get(ENDDATE);
        Map<String, List<Long>> customerColl = this.queryData(orgId, startDate, custEndDate);
        Map<String, CustomerAmountInfo> CustomerAmount = this.queryAmount(customerColl, orgId, startDate, endDate);
        this.setDataValue(customerColl);
        this.buildPropChart(CustomerAmount);
    }

    @Override
    public void changeData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.setLabelText(newCustnum, "0");
            this.setLabelText(allCustnum, "0");
            Control pieChartAp = this.getView().getControl(custPropChart);
            PieChart pieChart = null;
            if (pieChartAp instanceof PieChart) {
                pieChart = (PieChart)pieChartAp;
                pieChart.clearData();
            }
        } else {
            Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDate(endDate);
            Date custEndDate = startAndEndDate.get(ENDDATE);
            Map<String, List<Long>> customerColl = this.queryData(org.getPkValue(), startDate, custEndDate);
            Map<String, CustomerAmountInfo> customerAmount = this.queryAmount(customerColl, org.getPkValue(), startDate, endDate);
            this.setDataValue(customerColl);
            this.buildPropChart(customerAmount);
        }
    }

    private Map<String, List<Long>> queryData(Object orgId, Date startDate, Date endDate) {
        Row row;
        Long org = null;
        if (orgId instanceof Long) {
            org = (Long)orgId;
        } else if (orgId instanceof Integer) {
            org = ((Integer)orgId).longValue();
        }
        DataSet newCustomerData = QuerySalesAnalysisDataPlugin.getNewCustomer(((Object)((Object)this)).getClass().getName(), org, startDate, endDate);
        DataSet allCustomerData = QuerySalesAnalysisDataPlugin.getAllCustomer(((Object)((Object)this)).getClass().getName(), org);
        HashMap<String, List<Long>> customerColl = new HashMap<String, List<Long>>(2);
        ArrayList<Long> newCustomerColl = new ArrayList<Long>(10);
        ArrayList<Long> allCustomerColl = new ArrayList<Long>(10);
        while (newCustomerData.hasNext()) {
            row = newCustomerData.next();
            newCustomerColl.add(row.getLong(ID));
        }
        while (allCustomerData.hasNext()) {
            row = allCustomerData.next();
            allCustomerColl.add(row.getLong(ID));
        }
        customerColl.put(newCustomer, newCustomerColl);
        customerColl.put(allCustomer, allCustomerColl);
        return customerColl;
    }

    private Map<String, CustomerAmountInfo> queryAmount(Map<String, List<Long>> customerColl, Object orgId, Date startDate, Date endDate) {
        DataSet newCustomerAmount = QuerySalesAnalysisDataPlugin.getCustomerAmount(((Object)((Object)this)).getClass().getName(), orgId, customerColl.get(newCustomer), startDate, endDate);
        DataSet allCustomerAmount = QuerySalesAnalysisDataPlugin.getCustomerAmount(((Object)((Object)this)).getClass().getName(), orgId, customerColl.get(allCustomer), startDate, endDate);
        HashMap<String, CustomerAmountInfo> customerAmountInfoList = new HashMap<String, CustomerAmountInfo>(2);
        customerAmountInfoList.put(newCustAmount, this.setDataToInfo(newCustomerAmount));
        customerAmountInfoList.put(totalAmount, this.setDataToInfo(allCustomerAmount));
        return customerAmountInfoList;
    }

    private CustomerAmountInfo setDataToInfo(DataSet CustomerAmount) {
        CustomerAmountInfo customerAmount = new CustomerAmountInfo();
        if (CustomerAmount.isEmpty()) {
            customerAmount.setCurrency(0L);
        } else {
            while (CustomerAmount.hasNext()) {
                Row row = CustomerAmount.next();
                customerAmount.setCurrency(row.getLong("currency"));
                customerAmount.setAmount(row.getBigDecimal("curtotalallamount"));
            }
        }
        return customerAmount;
    }

    private void setDataValue(Map<String, List<Long>> customerColl) {
        List<Long> newCustomerData = customerColl.get(newCustomer);
        List<Long> allCustomerData = customerColl.get(allCustomer);
        this.setLabelText(newCustnum, String.valueOf(newCustomerData.size()));
        this.setLabelText(allCustnum, String.valueOf(allCustomerData.size()));
    }

    private void buildPropChart(Map<String, CustomerAmountInfo> CustomerAmount) {
        Control pieChartAp = this.getView().getControl(custPropChart);
        BigDecimal newCusAmount = CustomerAmount.get(newCustAmount).getAmount() == null ? BigDecimal.ZERO : CustomerAmount.get(newCustAmount).getAmount();
        BigDecimal totalCusAmount = CustomerAmount.get(totalAmount).getAmount() == null ? BigDecimal.ZERO : CustomerAmount.get(totalAmount).getAmount();
        Long newCusAmountCurrency = CustomerAmount.get(newCustAmount).getCurrency();
        Long totalAmountCurrency = CustomerAmount.get(totalAmount).getCurrency();
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(newAmount, (Object)newCusAmount);
        model.setValue(newCurrency, (Object)newCusAmountCurrency);
        model.setValue(totalAmountField, (Object)totalCusAmount);
        model.setValue(totalCurrency, (Object)totalAmountCurrency);
        model.endInit();
        PieChart pieChart = null;
        if (pieChartAp instanceof PieChart) {
            pieChart = (PieChart)pieChartAp;
        }
        if (pieChart != null) {
            pieChart.clearData();
            PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"\u9500\u552e\u5360\u6bd4", (String)"NewCustomerAnalysisPlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            series.addData(ResManager.loadKDString((String)"\u65b0\u589e\u9500\u552e\u5360\u6bd4", (String)"NewCustomerAnalysisPlugin_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), (Number)newCusAmount, "#FFA940");
            series.addData(ResManager.loadKDString((String)"\u603b\u9500\u552e\u989d", (String)"NewCustomerAnalysisPlugin_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), (Number)totalCusAmount.subtract(newCusAmount), "#FFD666");
            series.setRadius("60%", "70%");
            Label label = new Label();
            label.setShow(false);
            label.setPosition(Position.inside);
            label.setFormatter("{d}%");
            series.setLabel(label);
            series.setCenter("50%", "50%");
            this.getView().updateView();
        }
    }

    private void setLabelText(String key, String val) {
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl(key);
        label.setText(val);
    }
}

