/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.AmountHelper;
import kd.scmc.mobsm.common.entity.salesanalysisentity.ProdSalPropEntry;
import kd.scmc.mobsm.plugin.form.saleanalysis.AbstractInitDataPlugin;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class ProdSalPropAnalysisPlugin
extends AbstractInitDataPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static String MATERIAL = "basedatafield";
    private static String QTY = "qtyfield";
    private static String UNIT = "unitfield";
    private static String CURRENCY = "currencyfield";
    private static String AMOUNT = "amountfield";
    private static String RATE = "decimalfield";
    private static String ENTRY = "cardentryflexpanelap7";
    private static String QUERY_KEY = "prodsal";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5", "mobilesearchap"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    @Override
    public void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        List<ProdSalPropEntry> prodSalPropEntries = this.queryData(orgId, startDate, endDate);
        if (!prodSalPropEntries.isEmpty()) {
            this.setDataValue(prodSalPropEntries);
            this.getPageCache().put("showEntryList", JsonUtil.encodeToString(prodSalPropEntries));
        } else {
            this.getPageCache().put("showEntryList", "empty");
        }
    }

    @Override
    public void changeData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().put("showEntryList", "empty");
        } else {
            this.getModel().deleteEntryData("entryentity");
            List<ProdSalPropEntry> prodSalPropEntries = this.queryData(org.getPkValue(), startDate, endDate);
            if (!prodSalPropEntries.isEmpty()) {
                MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
                if (search.getText() == null || search.getText().equals("")) {
                    this.setDataValue(prodSalPropEntries);
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(prodSalPropEntries));
                } else {
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(prodSalPropEntries));
                    this.searchMaterialEntry();
                }
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap5".equals(key)) {
            this.sortEntryData();
        }
    }

    private List<ProdSalPropEntry> queryData(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        DataSet prodSal = QuerySalesAnalysisDataPlugin.query(((Object)((Object)this)).getClass().getName(), qFilter, QUERY_KEY);
        List<ProdSalPropEntry> prodSalPropEntries = this.calculateRate(prodSal);
        return prodSalPropEntries;
    }

    private List<ProdSalPropEntry> calculateRate(DataSet prodSal) {
        ArrayList<ProdSalPropEntry> prodSalPropEntries = new ArrayList<ProdSalPropEntry>(10);
        while (prodSal.hasNext()) {
            Row row = prodSal.next();
            BigDecimal materialAmount = row.getBigDecimal("materialamount");
            if (materialAmount == null || materialAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            ProdSalPropEntry prodSalPropEntry = new ProdSalPropEntry();
            prodSalPropEntry.setMaterial(row.getLong("material"));
            prodSalPropEntry.setMaterialNum(row.getString("materialnum"));
            prodSalPropEntry.setMaterialName(row.getString("materialname"));
            if (row.getString("modelnum") == null) {
                prodSalPropEntry.setModel("");
            } else {
                prodSalPropEntry.setModel(row.getString("modelnum"));
            }
            prodSalPropEntry.setQty(new BigDecimal(AmountHelper.getStripDecimalAmount(row.getBigDecimal("qty")).stripTrailingZeros().toPlainString()));
            prodSalPropEntry.setUnit(row.getLong("salesunit"));
            prodSalPropEntry.setAmount(AmountHelper.getStripDecimalAmount(materialAmount));
            prodSalPropEntry.setCurrency(row.getLong("currency"));
            prodSalPropEntries.add(prodSalPropEntry);
        }
        if (prodSalPropEntries.isEmpty()) {
            return prodSalPropEntries;
        }
        BigDecimal totalAmount = prodSalPropEntries.stream().map(ProdSalPropEntry::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (prodSalPropEntries.size() == 1) {
            for (ProdSalPropEntry prodSalPropEntry : prodSalPropEntries) {
                prodSalPropEntry.setRate(HUNDRED);
            }
        } else {
            BigDecimal sumRate = BigDecimal.ZERO;
            for (int i = prodSalPropEntries.size() - 1; i >= 0; --i) {
                ProdSalPropEntry prodSalPropEntry = (ProdSalPropEntry)prodSalPropEntries.get(i);
                if (i == 0) {
                    BigDecimal rate = HUNDRED.subtract(sumRate);
                    prodSalPropEntry.setRate(rate);
                    continue;
                }
                BigDecimal amount = prodSalPropEntry.getAmount();
                BigDecimal rate = amount.multiply(HUNDRED).divide(totalAmount, 2, 6);
                prodSalPropEntry.setRate(rate);
                sumRate = sumRate.add(rate);
            }
        }
        return prodSalPropEntries;
    }

    private void setDataValue(List<ProdSalPropEntry> prodSalPropEntries) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", prodSalPropEntries.size());
        for (int index = 0; index < prodSalPropEntries.size(); ++index) {
            ProdSalPropEntry prodSalPropEntry = prodSalPropEntries.get(index);
            model.setValue(MATERIAL, (Object)prodSalPropEntry.getMaterial(), index);
            model.setValue(QTY, (Object)prodSalPropEntry.getQty(), index);
            model.setValue(UNIT, (Object)prodSalPropEntry.getUnit(), index);
            model.setValue(AMOUNT, (Object)prodSalPropEntry.getAmount(), index);
            model.setValue(CURRENCY, (Object)prodSalPropEntry.getCurrency(), index);
            model.setValue(RATE, (Object)prodSalPropEntry.getRate(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void searchMaterialEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String EntryStr = this.getPageCache().get("showEntryList");
        if (EntryStr == null || EntryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)EntryStr, List.class);
        ArrayList<ProdSalPropEntry> showList = new ArrayList<ProdSalPropEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            ProdSalPropEntry entry = (ProdSalPropEntry)JSON.toJavaObject((JSON)jsonObject, ProdSalPropEntry.class);
            if ((entry.getMaterialName() == null || !entry.getMaterialName().contains(search.getText())) && (entry.getModel() == null || !entry.getModel().contains(search.getText()))) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataValue(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{ENTRY});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{ENTRY});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String materialEntryStr = this.getPageCache().get("showEntryList");
            if (materialEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)materialEntryStr, List.class);
        }
        ArrayList<ProdSalPropEntry> materialEntryList = new ArrayList<ProdSalPropEntry>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            ProdSalPropEntry entry = (ProdSalPropEntry)JSON.toJavaObject((JSON)jsonObject, ProdSalPropEntry.class);
            materialEntryList.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            Collections.sort(materialEntryList, (e1, e2) -> e2.getAmount().compareTo(e1.getAmount()));
        } else {
            this.getPageCache().put("sortDirection", "up");
            Collections.sort(materialEntryList, Comparator.comparing(ProdSalPropEntry::getAmount));
        }
        this.sortAndSearchSetData(materialEntryList);
    }

    private void sortAndSearchSetData(List<ProdSalPropEntry> prodSalPropEntryList) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (int index = 0; index < prodSalPropEntryList.size(); ++index) {
            ProdSalPropEntry prodSalPropEntry = prodSalPropEntryList.get(index);
            model.setValue(MATERIAL, (Object)prodSalPropEntry.getMaterial(), index);
            model.setValue(QTY, (Object)prodSalPropEntry.getQty(), index);
            model.setValue(UNIT, (Object)prodSalPropEntry.getUnit(), index);
            model.setValue(CURRENCY, (Object)prodSalPropEntry.getCurrency(), index);
            model.setValue(AMOUNT, (Object)prodSalPropEntry.getAmount(), index);
            model.setValue(RATE, (Object)prodSalPropEntry.getRate(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchMaterialEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchMaterialEntry();
    }
}

