/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class QuerySalesAnalysisDataPlugin {
    private static final Long CNY = 1L;

    public static Long getCNY() {
        return CNY;
    }

    public static DataSet query(String className, QFilter qFilter, String identification) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter changeStatus = new QFilter("changestatus", "!=", (Object)"B");
        filters.addAll(Arrays.asList(qFilter, billStatus, changeStatus));
        DataSet dataSet = null;
        if ("prodsal".equals(identification)) {
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getMaterialSelectField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"material", "materialnum", "materialname", "modelnum", "currency", "salesunit"}).sum("qty").sum("curtotalallamount").sum("materialamount").finish().orderBy(new String[]{"materialamount desc", "material desc"});
        } else if ("custsal".equals(identification)) {
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getCustomerField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"customer", "org", "customername", "currency"}).sum("curtotalallamount").finish().orderBy(new String[]{"curtotalallamount desc"});
        } else if ("salcoll".equals(identification)) {
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getOperatorCollectionField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"operator", "operatorname", "currency", "settlecurrency", "exchangerate"}).sum("receiptamount").finish().orderBy(new String[]{"receiptamount desc"});
        } else if ("salperfrank".equals(identification)) {
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getOperatorSaleField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"operator", "operatorname", "currency"}).sum("curtotalallamount").finish().orderBy(new String[]{"curtotalallamount desc"});
        } else if ("salorgsalamount".equals(identification)) {
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getSalOrgSalAmountField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"org", "currency"}).sum("curtotalallamount").finish().orderBy(new String[]{"curtotalallamount desc"});
        } else if ("salorgcollamount".equals(identification)) {
            filters.add(new QFilter("exchangerate", "!=", (Object)BigDecimal.ZERO));
            DataSet saleOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)QuerySalesAnalysisDataPlugin.getSalOrgCollAmountField(), (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = saleOrder.groupBy(new String[]{"org", "currency"}).sum("curtotalallamount").finish().orderBy(new String[]{"curtotalallamount desc"});
        }
        return dataSet;
    }

    private static String getMaterialSelectField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("billentry.material.masterid.id as material");
        selectFields.add("billentry.material.masterid.number as materialnum");
        selectFields.add("billentry.material.masterid.name as materialname");
        selectFields.add("billentry.material.masterid.modelnum as modelnum");
        selectFields.add("billentry.baseqty as qty");
        selectFields.add("curtotalallamount");
        selectFields.add("billentry.curamountandtax as materialamount");
        selectFields.add("currency");
        selectFields.add("billentry.baseunit as salesunit");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getOperatorSaleField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("operator");
        selectFields.add("operator.operatorname as operatorname");
        selectFields.add("billentry.curamountandtax as curtotalallamount");
        selectFields.add("currency");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getOperatorCollectionField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("operator");
        selectFields.add("operator.operatorname as operatorname");
        selectFields.add("receiptamount");
        selectFields.add("currency");
        selectFields.add("settlecurrency");
        selectFields.add("exchangerate");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getCustomerField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("customer");
        selectFields.add("org");
        selectFields.add("customer.name as customername");
        selectFields.add("billentry.curamountandtax as curtotalallamount");
        selectFields.add("currency");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getSalOrgSalAmountField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org");
        selectFields.add("curtotalallamount");
        selectFields.add("currency");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getSalOrgCollAmountField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org");
        selectFields.add("receiptamount * exchangerate as curtotalallamount");
        selectFields.add("currency");
        return String.join((CharSequence)",", selectFields);
    }

    public static DataSet getNewCustomer(String className, Long orgId, Date startDate, Date endDate) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgId);
        qFilter.and(new QFilter("createorg", "=", (Object)orgId));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)endDate));
        DataSet newCustomer = QueryServiceHelper.queryDataSet((String)className, (String)"bd_customer", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null);
        return newCustomer;
    }

    public static DataSet getAllCustomer(String className, Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter customer = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        filters.addAll(Arrays.asList(customer, enable));
        DataSet allCustomer = QueryServiceHelper.queryDataSet((String)className, (String)"bd_customer", (String)"id,number,name", (QFilter[])filters.toArray(new QFilter[0]), null);
        return allCustomer;
    }

    public static DataSet getCustomerAmount(String className, Object orgId, List<Long> CustomerColl, Date startDate, Date endDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter org = new QFilter("org", "=", orgId);
        QFilter customer = new QFilter("customer.id", "in", CustomerColl);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter changeStatus = new QFilter("changestatus", "!=", (Object)"B");
        QFilter afterDate = new QFilter("bizdate", ">=", (Object)startDate);
        QFilter beforeDate = new QFilter("bizdate", "<=", (Object)endDate);
        filters.addAll(Arrays.asList(org, customer, billStatus, changeStatus, afterDate, beforeDate));
        DataSet salOrder = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)"id,currency,curtotalallamount", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet allCustomerAmount = salOrder.groupBy(new String[]{"currency"}).sum("curtotalallamount").finish();
        return allCustomerAmount;
    }

    public static DataSet getOrderDeliverTimelyRate(String className, Object orgId, Date startDate, Date endDate) {
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter changeStatus = new QFilter("changestatus", "!=", (Object)"B");
        Long userId = UserServiceHelper.getCurrentUserId();
        QFilter operator = new QFilter("operator.operatorid", "=", (Object)userId);
        QFilter bizType = new QFilter("biztype.number", "=", (Object)"210");
        QFilter org = new QFilter("org", "=", orgId);
        QFilter feature = new QFilter("billentry.deliverydate", "<=", (Object)TimeServiceHelper.today());
        QFilter isVirtualBill = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.addAll(Arrays.asList(billStatus, changeStatus, operator, bizType, org, feature, isVirtualBill));
        String selectField = QuerySalesAnalysisDataPlugin.getOrderDeliverTimelyRateField(startDate, endDate);
        List<QFilter> qFilters = QuerySalesAnalysisDataPlugin.expireFilter(startDate, endDate);
        qFilters.addAll(filter);
        DataSet expire = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)selectField, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet expireSelect = expire.groupBy(new String[]{"customer", "customername"}).sum("expireordernum").finish();
        String imSalOutSelectField = QuerySalesAnalysisDataPlugin.getImSalOutSelectField();
        DataSet salOutBill = QueryServiceHelper.queryDataSet((String)className, (String)"im_saloutbill", (String)imSalOutSelectField, (QFilter[])new QFilter[]{billStatus.and(bizType)}, null);
        DataSet salOrderBill = QueryServiceHelper.queryDataSet((String)className, (String)"sm_salorder", (String)"id,billentry.id as entryid,billentry.deliverydate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,customer,customer.name as customername,closestatus", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet finish1 = salOrderBill.join(salOutBill, JoinType.LEFT).on("id", "srcbillid").on("entryid", "srcbillentryid").select(new String[]{"biztime", "entryid", "srcbillentryid", "customer", "customername"}).finish();
        DataSet biztime = finish1.groupBy(new String[]{"srcbillentryid"}).max("biztime").finish();
        finish1 = salOrderBill.join(biztime, JoinType.LEFT).on("entryid", "srcbillentryid").select(new String[]{"customer", "customername", "deliverydate", "invqty", "qty", "rowclosestatus", "rowterminatestatus", "biztime", "closestatus", "entryid", "srcbillentryid"}).finish();
        DataSet select = finish1.executeSql("select case when (deliverydate >= biztime and invqty >= qty) or (deliverydate >= biztime and invqty < qty and rowclosestatus = 'B') or (deliverydate >= biztime and invqty < qty and rowterminatestatus = 'B') or (closestatus = 'B' and invqty = 0) or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate >= biztime) then 1 else 0 end as ontimenum,customer,customername,srcbillentryid");
        select = select.groupBy(new String[]{"customer", "customername"}).sum("ontimenum").finish();
        DataSet finish = expireSelect.join(select, JoinType.LEFT).on("customer", "customer").on("customername", "customername").select(new String[]{"customer", "customername", "expireordernum", "ontimenum"}).finish();
        return finish.select(QuerySalesAnalysisDataPlugin.getShowFields()).orderBy(new String[]{"customer"});
    }

    private static String getOrderDeliverTimelyRateField(Date startDate, Date endDate) {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.add("closestatus");
        selectFields.add("billentry.id as entryid");
        selectFields.add("billentry.deliverydate as deliverydate");
        selectFields.add("billentry.invqty as invqty");
        selectFields.add("billentry.qty as qty");
        selectFields.add("billentry.rowclosestatus as rowclosestatus");
        selectFields.add("billentry.rowterminatestatus as rowterminatestatus");
        selectFields.add("customer");
        selectFields.add("customer.name as customername");
        selectFields.add("case when to_char(billentry.deliverydate,'yyyy-MM-dd') >= '" + QuerySalesAnalysisDataPlugin.getStringDate(startDate) + "' and to_char(billentry.deliverydate,'yyyy-MM-dd') <= '" + QuerySalesAnalysisDataPlugin.getStringDate(endDate) + "' then 1 else 0 end as expireordernum");
        return String.join((CharSequence)",", selectFields);
    }

    private static String getStringDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private static List<QFilter> expireFilter(Date startDate, Date endDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("billentry.deliverydate", ">=", (Object)startDate);
        QFilter qFilter1 = new QFilter("billentry.deliverydate", "<=", (Object)endDate);
        filters.add(qFilter);
        filters.add(qFilter1);
        return filters;
    }

    private static String getImSalOutSelectField() {
        ArrayList<String> select = new ArrayList<String>();
        select.add("biztime");
        select.add("billentry.mainbillid as srcbillid");
        select.add("billentry.mainbillentryid as srcbillentryid");
        return String.join((CharSequence)",", select);
    }

    private static String getShowFields() {
        String showFields = "customer,customername,expireordernum,ontimenum, case when expireordernum != 0 then ontimenum * 1.0 / expireordernum * 100.0 end as delivertimerate";
        return showFields;
    }
}

