/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.AmountHelper;
import kd.scmc.mobsm.common.entity.salesanalysisentity.SalPerfRankEntry;
import kd.scmc.mobsm.plugin.form.saleanalysis.AbstractInitDataPlugin;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class SalesCollectionRankPlugin
extends AbstractInitDataPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener {
    private static String OPERATOR = "operatorfield";
    private static String CURRENCY = "currencyfield";
    private static String AMOUNT = "amountfield";
    private static String ENTRY = "cardentryflexpanelap2";
    private static String QUERY_KEY = "salcoll";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap5", "mobilesearchap"});
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
    }

    @Override
    public void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        List<SalPerfRankEntry> salCollRankEntryEntries = this.queryData(orgId, startDate, endDate);
        if (!salCollRankEntryEntries.isEmpty()) {
            this.setDataValue(salCollRankEntryEntries);
            this.getPageCache().put("showEntryList", JsonUtil.encodeToString(salCollRankEntryEntries));
        } else {
            this.getPageCache().put("showEntryList", "empty");
        }
    }

    @Override
    public void changeData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (org == null || startDate == null || endDate == null) {
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().put("showEntryList", "empty");
        } else {
            this.getModel().deleteEntryData("entryentity");
            List<SalPerfRankEntry> salCollRankEntryEntries = this.queryData(org.getPkValue(), startDate, endDate);
            if (!salCollRankEntryEntries.isEmpty()) {
                MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
                if (search.getText() == null || search.getText().equals("")) {
                    this.setDataValue(salCollRankEntryEntries);
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(salCollRankEntryEntries));
                } else {
                    this.getPageCache().put("showEntryList", JsonUtil.encodeToString(salCollRankEntryEntries));
                    this.searchOperatorEntry();
                }
            } else {
                this.getPageCache().put("showEntryList", "empty");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("flexpanelap5".equals(key)) {
            this.sortEntryData();
        }
    }

    private List<SalPerfRankEntry> queryData(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        DataSet salCollRank = QuerySalesAnalysisDataPlugin.query(((Object)((Object)this)).getClass().getName(), qFilter, QUERY_KEY);
        List<SalPerfRankEntry> salCollRankEntryColl = this.setEntryInfo(salCollRank);
        return salCollRankEntryColl;
    }

    private List<SalPerfRankEntry> setEntryInfo(DataSet salCollRank) {
        ArrayList<SalPerfRankEntry> salCollRankEntryColl = new ArrayList<SalPerfRankEntry>(10);
        while (salCollRank.hasNext()) {
            Row row = salCollRank.next();
            BigDecimal receiptAmount = row.getBigDecimal("receiptamount");
            if (receiptAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            SalPerfRankEntry salCollRankEntry = new SalPerfRankEntry();
            salCollRankEntry.setOperator(row.getLong("operator"));
            String operatorName = row.getString("operatorname") == null ? ResManager.loadKDString((String)"\u5176\u4ed6", (String)"other", (String)"scmc-mobsm-form", (Object[])new Object[0]) : row.getString("operatorname");
            salCollRankEntry.setOperatorName(operatorName);
            if (row.getLong("currency").compareTo(row.getLong("settlecurrency")) == 0) {
                salCollRankEntry.setAmount(receiptAmount);
            } else {
                BigDecimal amount = receiptAmount.multiply(row.getBigDecimal("exchangerate"));
                salCollRankEntry.setAmount(AmountHelper.getStripDecimalAmount(amount));
            }
            salCollRankEntry.setCurrency(row.getLong("currency"));
            salCollRankEntryColl.add(salCollRankEntry);
        }
        return salCollRankEntryColl;
    }

    private void setDataValue(List<SalPerfRankEntry> salCollRankEntries) {
        this.getModel().batchCreateNewEntryRow("entryentity", salCollRankEntries.size());
        this.sortAndSearchSetData(salCollRankEntries);
    }

    private void searchOperatorEntry() {
        int i;
        MobileSearch search = (MobileSearch)this.getControl("mobilesearchap");
        String EntryStr = this.getPageCache().get("showEntryList");
        if (EntryStr == null || EntryStr.equals("empty")) {
            return;
        }
        List entryList = (List)JsonUtil.decodeFromString((String)EntryStr, List.class);
        ArrayList<SalPerfRankEntry> showList = new ArrayList<SalPerfRankEntry>(entryList.size());
        for (JSONObject jsonObject : entryList) {
            SalPerfRankEntry entry = (SalPerfRankEntry)JSON.toJavaObject((JSON)jsonObject, SalPerfRankEntry.class);
            if (!entry.getOperatorName().contains(search.getText())) continue;
            showList.add(entry);
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        if (!showList.isEmpty()) {
            this.setDataValue(showList);
        }
        int showCount = showList.size();
        for (i = 0; i < showList.size(); ++i) {
            cardEntry.setChildVisible(true, i, new String[]{ENTRY});
        }
        for (i = showCount; i < entryList.size(); ++i) {
            cardEntry.setChildVisible(false, i, new String[]{ENTRY});
        }
        this.getPageCache().put("tempEntryList", JsonUtil.encodeToString(showList));
    }

    private void sortEntryData() {
        String tempEntryColl = this.getPageCache().get("tempEntryList");
        List entryRow = (List)JsonUtil.decodeFromString((String)tempEntryColl, List.class);
        if (entryRow == null || entryRow.isEmpty()) {
            String salPerfRankEntryStr = this.getPageCache().get("showEntryList");
            if (salPerfRankEntryStr.equals("empty")) {
                return;
            }
            entryRow = (List)JsonUtil.decodeFromString((String)salPerfRankEntryStr, List.class);
        }
        ArrayList<SalPerfRankEntry> materialEntryList = new ArrayList<SalPerfRankEntry>(entryRow.size());
        for (JSONObject jsonObject : entryRow) {
            SalPerfRankEntry entry = (SalPerfRankEntry)JSON.toJavaObject((JSON)jsonObject, SalPerfRankEntry.class);
            materialEntryList.add(entry);
        }
        String direct = this.getPageCache().get("sortDirection");
        if ("up".equals(direct)) {
            this.getPageCache().put("sortDirection", "down");
            Collections.sort(materialEntryList, (e1, e2) -> e2.getAmount().compareTo(e1.getAmount()));
        } else {
            this.getPageCache().put("sortDirection", "up");
            Collections.sort(materialEntryList, Comparator.comparing(SalPerfRankEntry::getAmount));
        }
        this.sortAndSearchSetData(materialEntryList);
    }

    private void sortAndSearchSetData(List<SalPerfRankEntry> salPerfRankEntryList) {
        String other = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"other", (String)"scmc-mobsm-form", (Object[])new Object[0]);
        int rowIndex = 0;
        int listIndex = 0;
        IDataModel model = this.getModel();
        model.beginInit();
        while (listIndex < salPerfRankEntryList.size()) {
            SalPerfRankEntry salPerfRankEntry = salPerfRankEntryList.get(listIndex);
            if (salPerfRankEntry.getOperatorName().equals(other)) {
                ++listIndex;
                continue;
            }
            model.setValue(OPERATOR, (Object)salPerfRankEntry.getOperatorName(), rowIndex);
            model.setValue(CURRENCY, (Object)salPerfRankEntry.getCurrency(), rowIndex);
            model.setValue(AMOUNT, (Object)salPerfRankEntry.getAmount(), rowIndex);
            ++rowIndex;
            ++listIndex;
        }
        List otherSalPerfEntries = salPerfRankEntryList.stream().filter(salPerf -> salPerf.getOperatorName().equals(other)).collect(Collectors.toList());
        for (int index = 0; index < otherSalPerfEntries.size(); ++index) {
            SalPerfRankEntry otherSalPerfRankEntry = (SalPerfRankEntry)otherSalPerfEntries.get(index);
            model.setValue(OPERATOR, (Object)otherSalPerfRankEntry.getOperatorName(), rowIndex);
            model.setValue(CURRENCY, (Object)otherSalPerfRankEntry.getCurrency(), rowIndex);
            model.setValue(AMOUNT, (Object)otherSalPerfRankEntry.getAmount(), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void focus() {
        this.getModel().deleteEntryData("entryentity");
        this.searchOperatorEntry();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getModel().deleteEntryData("entryentity");
        this.searchOperatorEntry();
    }
}

