/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.saleanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.AmountHelper;
import kd.scmc.mobsm.business.helper.PermissionHelper;
import kd.scmc.mobsm.common.entity.salesanalysisentity.SalOrgAmountInfo;
import kd.scmc.mobsm.common.utils.DateUtils;
import kd.scmc.mobsm.plugin.form.saleanalysis.QuerySalesAnalysisDataPlugin;

public class SalesOrgRevenueAnalysisPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SalesOrgRevenueAnalysisPlugin.class);
    private static String ORGID = "fbasedataid";
    private static String SAL_ORG = "orgfield";
    private static String SAL_CURRENCY = "currencyfield";
    private static String SAL_AMOUNT = "amountfield";
    private static String SAL_QUERY_KEY = "salorgsalamount";
    private static String COLL_ORG = "orgfield1";
    private static String COLL_CURRENCY = "currencyfield1";
    private static String COLL_AMOUNT = "amountfield1";
    private static String COLL_ENTRY = "entryentity1";
    private static String COLL_QUERY_KEY = "salorgcollamount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit salOrgF7 = (BasedataEdit)this.getControl("multipleorg");
        salOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDateOfWeek(new Date());
        Date startDate = startAndEndDate.get("startdate");
        Date endDate = startAndEndDate.get("enddate");
        this.getModel().setValue("daterange_startdate", (Object)startDate);
        this.getModel().setValue("daterange_enddate", (Object)endDate);
        Object orgId = parameter.getCustomParam("org");
        if (orgId == null) {
            return;
        }
        this.getModel().setValue("multipleorg", (Object)new Object[]{orgId});
        this.assignmentOfCalculationResults(orgId, startDate, endDate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "multipleorg": 
            case "daterange_startdate": 
            case "daterange_enddate": {
                this.changeData();
                break;
            }
        }
    }

    private void assignmentOfCalculationResults(Object orgId, Date startDate, Date endDate) {
        this.queryDataAndSetValue(orgId, startDate, endDate);
    }

    private void queryDataAndSetValue(Object orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgId);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        DataSet salOrgSalAmount = QuerySalesAnalysisDataPlugin.query(((Object)((Object)this)).getClass().getName(), qFilter, SAL_QUERY_KEY);
        DataSet salOrgCollAmount = QuerySalesAnalysisDataPlugin.query(((Object)((Object)this)).getClass().getName(), qFilter, COLL_QUERY_KEY);
        List<SalOrgAmountInfo> salOrgSalAmountInfos = this.buildSalAmountInfo(salOrgSalAmount);
        List<SalOrgAmountInfo> salOrgCollAmountInfos = this.buildSalAmountInfo(salOrgCollAmount);
        this.setDataValue(salOrgSalAmountInfos, salOrgCollAmountInfos);
    }

    private void setDataValue(List<SalOrgAmountInfo> salOrgSalAmountInfos, List<SalOrgAmountInfo> salOrgCollAmountInfos) {
        int index;
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (!salOrgSalAmountInfos.isEmpty()) {
            model.batchCreateNewEntryRow("entryentity", salOrgSalAmountInfos.size());
            for (index = 0; index < salOrgSalAmountInfos.size(); ++index) {
                SalOrgAmountInfo salOrgSalAmountInfo = salOrgSalAmountInfos.get(index);
                model.setValue(SAL_ORG, (Object)salOrgSalAmountInfo.getOrg(), index);
                model.setValue(SAL_CURRENCY, (Object)salOrgSalAmountInfo.getCurrency(), index);
                model.setValue(SAL_AMOUNT, (Object)salOrgSalAmountInfo.getAmount(), index);
            }
        }
        model.deleteEntryData(COLL_ENTRY);
        if (!salOrgCollAmountInfos.isEmpty()) {
            model.batchCreateNewEntryRow(COLL_ENTRY, salOrgCollAmountInfos.size());
            for (index = 0; index < salOrgCollAmountInfos.size(); ++index) {
                SalOrgAmountInfo salOrgCollAmountInfo = salOrgCollAmountInfos.get(index);
                model.setValue(COLL_ORG, (Object)salOrgCollAmountInfo.getOrg(), index);
                model.setValue(COLL_CURRENCY, (Object)salOrgCollAmountInfo.getCurrency(), index);
                model.setValue(COLL_AMOUNT, (Object)salOrgCollAmountInfo.getAmount(), index);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().updateView(COLL_ENTRY);
    }

    private void changeData() {
        DynamicObjectCollection multipleOrg = (DynamicObjectCollection)this.getModel().getValue("multipleorg");
        Date startDate = (Date)this.getModel().getValue("daterange_startdate");
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        if (multipleOrg == null || multipleOrg.isEmpty() || startDate == null || endDate == null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            DynamicObjectCollection entryEntity1 = this.getModel().getEntryEntity(COLL_ENTRY);
            if (entryEntity != null) {
                this.getModel().deleteEntryData("entryentity");
            }
            if (entryEntity1 != null) {
                this.getModel().deleteEntryData(COLL_ENTRY);
            }
        } else {
            ArrayList<Object> orgIdColl = new ArrayList<Object>(10);
            for (DynamicObject org : multipleOrg) {
                Object orgId = org.getDynamicObject(ORGID).getPkValue();
                orgIdColl.add(orgId);
            }
            QFilter qFilter = new QFilter("org", "in", orgIdColl);
            qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
            qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
            this.queryDataAndSetValue(orgIdColl, startDate, endDate);
        }
    }

    private List<SalOrgAmountInfo> buildSalAmountInfo(DataSet salOrgSalAmount) {
        ArrayList<SalOrgAmountInfo> salOrgSalAmountInfos = new ArrayList<SalOrgAmountInfo>(10);
        if (salOrgSalAmount.isEmpty()) {
            return salOrgSalAmountInfos;
        }
        while (salOrgSalAmount.hasNext()) {
            Row row = salOrgSalAmount.next();
            BigDecimal amount = row.getBigDecimal("curtotalallamount");
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            SalOrgAmountInfo salOrgAmountInfo = new SalOrgAmountInfo();
            salOrgAmountInfo.setOrg(row.getLong("org"));
            salOrgAmountInfo.setAmount(AmountHelper.getStripDecimalAmount(amount));
            salOrgAmountInfo.setCurrency(row.getLong("currency"));
            salOrgSalAmountInfos.add(salOrgAmountInfo);
        }
        if (!salOrgSalAmountInfos.isEmpty()) {
            Collections.sort(salOrgSalAmountInfos, Comparator.comparing(SalOrgAmountInfo::getAmount).reversed());
        }
        return salOrgSalAmountInfos;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("multipleorg".equals(name)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            List<Object> saleOrgColl = PermissionHelper.getAllHasPermSaleOrgs("id");
            formShowParameter.setCustomParam("range", saleOrgColl);
        }
    }
}

