/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.salorderbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobsm.business.helper.BotpFilterHelper;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.utils.ConverterUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.botp.BotpSrcBillPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.service.mservice.mobdata.IMobDataService;

public class SalOrderBillBotpToReturnApplyBillPlugin
extends BotpSrcBillPlugin {
    public void setDefaultDate() {
        super.setDefaultDate();
        this.getModel().setValue("daterangefield_startdate", null);
        this.getModel().setValue("daterangefield_enddate", null);
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("org");
        if (orgId != null) {
            FilterCondition condition = new FilterCondition("org", "=", (Object)Long.valueOf(orgId.toString()));
            filters.add(condition);
        }
        return filters;
    }

    public Map<String, BillSortType> getSortMap() {
        Map sortMap = super.getSortMap();
        sortMap.put("bizdate", BillSortType.DESC);
        sortMap.put("createtime", BillSortType.DESC);
        return sortMap;
    }

    public void setModelValue() {
        super.setModelValue();
        boolean showEntryBox = (Boolean)this.getModel().getValue("showentrybox");
        if (showEntryBox) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            int entryRowCount = this.getModel().getEntryRowCount(this.getEntryEntity());
            for (int i = 0; i < entryRowCount; ++i) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"totalallamount"});
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"amountandtax"});
            }
        } else {
            this.summaryFields(new String[]{"material"});
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            int entryRowCount = this.getModel().getEntryRowCount(this.getEntryEntity());
            for (int i = 0; i < entryRowCount; ++i) {
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"totalallamount"});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"amountandtax"});
            }
        }
    }

    public String getTargetMobFormKey() {
        return "mobsm_returnapply_edit";
    }

    public void updateData() {
        List<FilterCondition> filters = this.getFilters();
        List<FilterCondition> pushFilterConditions = this.getPushListFilterConditions();
        filters.addAll(pushFilterConditions);
        FilterConstructor filterConstructor = super.getFilterConstructor(new FilterConstructor());
        filterConstructor.setFilters(filters);
        IMobDataService mobDataService = this.getMobDataService();
        this.curData = mobDataService.loadData(this.getFormKey(), filterConstructor, this.getDataSourceConfig());
        this.setModelValue();
        this.getView().updateView();
    }

    private List<FilterCondition> getPushListFilterConditions() {
        DynamicObject[] dynamicObjectArray = this.curData = this.curData == null || this.curData.length == 0 ? this.readData() : this.curData;
        if (this.curData == null || this.curData.length == 0) {
            return new ArrayList<FilterCondition>(10);
        }
        DataSourceConfig targetDataSourceConfig = this.getTargetDataSourceConfig();
        String targetEntityKey = targetDataSourceConfig.getPcEntityKey();
        String mainEntryKey = this.getMainEntryKeyOfTarget();
        QFilter pushFilter = BotpFilterHelper.getAvailableRuleFilters(this.curData, this.getPcEntityKey(), targetEntityKey, mainEntryKey);
        return ConverterUtils.getFilterConditionList(Collections.singletonList(pushFilter));
    }
}

