/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.salorderbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.scmc.mobsm.business.helper.SalesAddRowHandler;
import kd.scmc.mobsm.business.helper.SalesChangedHandler;
import kd.scmc.mobsm.business.helper.SalesDeleteHandler;
import kd.scmc.mobsm.plugin.form.salorderbill.ISalOrderPagePlugin;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;

public class SalOrderBillEditPlugin
extends MobPushTargetBillInfoPlugin
implements ISalOrderPagePlugin,
IMobBillEditable,
BeforeF7SelectListener {
    public SalOrderBillEditPlugin() {
        this.registerPropertyChangedHandler(new SalesChangedHandler());
        this.registerEntryRowDeletedHandler(new SalesDeleteHandler());
        this.registerEntryRowAddedHandler(new SalesAddRowHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizType = (BasedataEdit)this.getControl("biztype");
        if (bizType != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public String getEntryFormKey() {
        return this.getEntryEditFormKey(this.getEntryEntity());
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    protected void initDataOfNewPcEntity(DynamicObject newPcEntity) {
        super.initDataOfNewPcEntity(newPcEntity);
        IDataModel model = this.getModel();
        String pcEntityKey = this.getPcEntityKey();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        model.setValue("org", orgId);
        newPcEntity.set("org", this.getModel().getValue("org"));
        newPcEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObject billType = this.queryDefaultBillType();
        newPcEntity.set("billtype", (Object)billType);
        DynamicObject bizType = BizTypeHelper.getDefaultBizTypeObject((String)pcEntityKey, (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
        newPcEntity.set("biztype", (Object)bizType);
        model.setValue("biztype", (Object)bizType);
        long userId = UserServiceHelper.getCurrentUserId();
        model.setValue("creator", (Object)userId);
        newPcEntity.set("creator", model.getValue("creator"));
        this.initOperatorAndGroup(newPcEntity, userId);
        newPcEntity.set("exratedate", (Object)new Date());
        newPcEntity.set("paymode", (Object)"CREDIT");
        newPcEntity.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
        newPcEntity.set("changestatus", (Object)"A");
        newPcEntity.set("version", (Object)"1");
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService4Mobile", (String)"createNewData4Mob", (Object[])new Object[]{newPcEntity});
    }

    protected void newDefaultEntryRow(DynamicObject newPcEntity) {
        super.newDefaultEntryRow(newPcEntity);
        IDataModel model = this.getModel();
        String pcEntryKey = DataSourceConfigHelper.getPcEntryKey((DataSourceConfig)this.getDataSourceConfig(), (String)this.getEntryEntity());
        DynamicObjectCollection newPcEntryCollection = newPcEntity.getDynamicObjectCollection(pcEntryKey);
        DynamicObject newPcEntryRow = newPcEntryCollection.addNew();
        long entryId = DB.genLongId((String)this.getPcEntityKey());
        newPcEntryRow.set("id", (Object)entryId);
        newPcEntryRow.set("seq", (Object)1);
        String mobEntryKey = this.getEntryEntity();
        model.createNewEntryRow(mobEntryKey);
        int currEntryRowCount = model.getEntryCurrentRowIndex(mobEntryKey);
        int nextEntryRowSeq = currEntryRowCount + 1;
        model.beginInit();
        model.setValue("mobentryid", (Object)entryId, nextEntryRowSeq - 1);
        model.endInit();
        ArrayList<Long> entryIdList = new ArrayList<Long>(12);
        entryIdList.add(entryId);
        newPcEntity = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService4Mobile", (String)"addRow4Mob", (Object[])new Object[]{newPcEntity, pcEntryKey, entryIdList});
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
        this.updateEntityCache(mainEntityType, newPcEntity);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String fieldKey = evt.getProperty().getName();
        if ("biztype".equals(fieldKey)) {
            DynamicObject billType = this.queryDefaultBillType();
            List bizTypes = BizTypeHelper.getAllBizTypes((String)this.getPcEntityKey(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            if (bizTypes != null && !bizTypes.isEmpty()) {
                QFilter qFilter1 = new QFilter("id", "in", (Object)bizTypes);
                showParameter.getListFilterParameter().getQFilters().add(qFilter1);
            } else {
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "=", (Object)0)));
            }
        }
    }

    public void click(EventObject e) {
        this.editabilityPlugin.click(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.setBillNo(operationResult);
                Boolean isModify = this.checkModifyPermission();
                if (!Boolean.TRUE.equals(isModify)) break;
                StringBuilder errMsg = new StringBuilder();
                Object pkId = operationResult.getSuccessPkIds().get(0);
                MutexHelper.require((IFormView)this.getView(), (String)this.getPcEntityKey(), pkId, (String)"modify", (boolean)Boolean.TRUE, (StringBuilder)errMsg);
                break;
            }
            case "submit": {
                this.updateModelValue();
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private void initOperatorAndGroup(DynamicObject newPcEntity, long userId) {
        QFilter qFilter13;
        QFilter qFilter12;
        QFilter qFilter11;
        DynamicObject[] operators;
        QFilter qFilter03;
        QFilter qFilter02;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue()), qFilter03 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (map.size() != 0 && (operators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11 = new QFilter("operatorgrpid", "in", map.keySet()), qFilter12 = new QFilter("operatorid", "=", (Object)userId), qFilter13 = new QFilter("invalid", "=", (Object)Boolean.FALSE)})) != null && operators.length > 0) {
            newPcEntity.set("operator", (Object)operators[0]);
            Long operatorGrpId = (Long)operators[0].get("operatorgrpid");
            QFilter filter = new QFilter("id", "=", (Object)operatorGrpId);
            DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{filter});
            newPcEntity.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private DynamicObject queryDefaultBillType() {
        QFilter qFilter = new QFilter("billformid", "=", (Object)this.getPcEntityKey());
        qFilter.and(new QFilter("isdefault", "=", (Object)"1"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])qFilter.toArray());
    }

    private void updateEntityCache(MainEntityType dataEntityType, DynamicObject pcEntity) {
        if (pcEntity == null || dataEntityType == null) {
            return;
        }
        DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)pcEntity, (boolean)true);
    }

    private void updateModelValue() {
        DynamicObject pcEntityCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        this.curData = new DynamicObject[]{pcEntityCache};
        this.setModelValue();
    }

    private void setBillNo(OperationResult operationResult) {
        if ("".equals(this.getModel().getValue("billno"))) {
            String pcId = operationResult.getSuccessPkIds().get(0).toString();
            String billNo = (String)operationResult.getBillNos().get(pcId);
            this.getModel().setValue("billno", (Object)billNo);
        }
    }
}

