/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.form.salorderbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.mobsm.business.helper.MaterialHelper;
import kd.scmc.mobsm.business.helper.SalesChangedHandler;
import kd.scmc.mobsm.plugin.form.salorderbill.ISalOrderPagePlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class SalOrderBillEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
IMobBillEditable,
ISalOrderPagePlugin {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "settlecurrency", "deliverydate", "amountandtax", "priceandtax", "qty", "taxrateid", "unit", "billid", "pcentitykey", "mobentryid"};
    private static final String[] F7_FIELD_KEYS = new String[]{"material", "taxrateid"};

    public SalOrderBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new SalesChangedHandler());
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean existTax = this.existTax();
        this.setPriceEditable(existTax);
        this.setTaxTipNotification(existTax);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setModelNumVisible();
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        this.setModelNumVisible();
        Boolean existTax = this.existTax();
        this.setPriceEditable(existTax);
    }

    private void setModelNumVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)material.getString("masterid.modelnum"));
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }

    private Boolean existTax() {
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        Boolean tax = pcEntity.getBoolean("istax");
        return tax;
    }

    private void setPriceEditable(Boolean tax) {
        if (Boolean.TRUE.equals(tax)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"priceandtax"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"priceandtax"});
        }
    }

    private void setTaxTipNotification(Boolean tax) {
        if (!Boolean.TRUE.equals(tax)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u542b\u7a0e\uff0c\u65e0\u6cd5\u4fee\u6539\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SalOrderBillEntryEditPlugin_4", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        DynamicObject billType = pcEntity.getDynamicObject("billtype");
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9ed8\u8ba4\u5355\u636e\u7c7b\u578b\u3002", (String)"SalOrderBillEntryEditPlugin_0", (String)"scmc-mobsm-form", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "material": {
                DynamicObject org = (DynamicObject)this.getParentModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9ed8\u8ba4\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillEntryEditPlugin_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject bizType = (DynamicObject)this.getParentModel().getValue("biztype");
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u3002", (String)"SalOrderBillEntryEditPlugin_2", (String)"scmc-mobsm-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject lineType = null;
                DynamicObjectCollection billEntry = pcEntity.getDynamicObjectCollection(this.getPcEntryName());
                Long mobEntryId = (Long)this.getParentModel().getValue("mobentryid");
                for (DynamicObject row : billEntry) {
                    Long rowPkValue = (Long)row.getPkValue();
                    if (mobEntryId.compareTo(rowPkValue) != 0) continue;
                    lineType = row.getDynamicObject("linetype");
                }
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9ed8\u8ba4\u884c\u7c7b\u578b\u3002", (String)"SalOrderBillEntryEditPlugin_3", (String)"scmc-mobsm-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<QFilter> qf = MaterialHelper.getQFilterByLineType((Long)billType.getPkValue(), (Long)bizType.getPkValue(), (Long)lineType.getPkValue(), true);
                if (qf.isEmpty()) break;
                showParameter.getListFilterParameter().getQFilters().addAll(qf);
                break;
            }
            case "taxrateid": {
                Date bizDate = pcEntity.getDate("bizdate");
                List<Long> taxRateList = this.queryTaxRate(bizDate);
                QFilter filter = taxRateList.isEmpty() ? QFilter.of((String)"1=-1", (Object[])new Object[0]) : new QFilter("id", "in", taxRateList);
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
        }
    }

    private List<Long> queryTaxRate(Date bizDate) {
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizDate);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizDate);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxRate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<Long> taxRateList = new ArrayList<Long>(bdTaxRate.size());
        if (!bdTaxRate.isEmpty()) {
            for (Map.Entry next : bdTaxRate.entrySet()) {
                Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
                taxRateList.add((Long)pkValue);
            }
        }
        return taxRateList;
    }
}

