/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.plugin.op.validator.dataanalysis.customervalue;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import org.apache.commons.lang3.StringUtils;

public class RfmBasicSettingValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            int mPercentage;
            int rPercentage;
            int fPercentage;
            int count;
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("saleorg");
            boolean isAllOrg = bill.getBoolean("isallsaleorg");
            if (!isAllOrg && org == null) {
                String msg = ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u672a\u8bbe\u7f6e\u7684\u7ec4\u7ec7\u7ef4\u5ea6", (String)"RfmBasicSettingValidator_0", (String)"scmc-mobsm-form", (Object[])new Object[0]);
                this.addMessage(entity, msg, ErrorLevel.Error);
            }
            if ((count = (fPercentage = bill.getInt("fpercentage")) + (rPercentage = bill.getInt("rpercentage")) + (mPercentage = bill.getInt("mpercentage"))) != 100) {
                String msg = ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684\u6743\u91cd\u8bbe\u7f6e\u603b\u548c\u4e0d\u7b49\u4e8e100\uff01", (String)"RfmBasicSettingValidator_1", (String)"scmc-mobsm-form", (Object[])new Object[0]);
                this.addMessage(entity, msg, ErrorLevel.Error);
            }
            this.rValidator(entity, bill);
            this.fValidator(entity, bill);
            this.mValidator(entity, bill);
        }
    }

    private void mValidator(ExtendedDataEntity entity, DynamicObject bill) {
        HashSet<Integer> mSet = new HashSet<Integer>(5);
        DynamicObjectCollection mEntry = bill.getDynamicObjectCollection("entrym");
        for (int i = 0; i < mEntry.size() - 1; ++i) {
            DynamicObject preM = (DynamicObject)mEntry.get(i);
            DynamicObject m = (DynamicObject)mEntry.get(i + 1);
            Object preMin = preM.get("minvaluem");
            Object min = m.get("minvaluem");
            if (preMin == null) {
                mSet.add(i + 1);
            }
            if (min == null) {
                mSet.add(i + 2);
            }
            if (preMin == null || min == null || ((BigDecimal)preMin).compareTo((BigDecimal)min) > 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684M\u503c\uff0c\u7b2c%s\u884c\u8bbe\u7f6e\u4e0d\u662f\u8fde\u7eed\u7684\uff01", (String)"RfmBasicSettingValidator_4", (String)"scmc-mobsm-form", (Object[])new Object[0]), i + 1);
            this.addMessage(entity, msg, ErrorLevel.Error);
            break;
        }
        if (mSet.size() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684M\u503c\uff0c\u7b2c\u3010%s\u3011\u884c\u4e3a\u7a7a\uff01", (String)"RfmBasicSettingValidator_7", (String)"scmc-mobsm-form", (Object[])new Object[0]), StringUtils.join(mSet, (String)","));
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }

    private void fValidator(ExtendedDataEntity entity, DynamicObject bill) {
        HashSet<Integer> fSet = new HashSet<Integer>(5);
        DynamicObjectCollection fEntry = bill.getDynamicObjectCollection("entryf");
        for (int i = 0; i < fEntry.size() - 1; ++i) {
            DynamicObject preF = (DynamicObject)fEntry.get(i);
            DynamicObject f = (DynamicObject)fEntry.get(i + 1);
            Object preMin = preF.get("minvaluef");
            Object min = f.get("minvaluef");
            if (preMin == null) {
                fSet.add(i + 1);
            }
            if (min == null) {
                fSet.add(i + 2);
            }
            if (preMin == null || min == null || Long.parseLong(String.valueOf(preMin)) > Long.parseLong(String.valueOf(min))) continue;
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684F\u503c\uff0c\u7b2c%s\u884c\u8bbe\u7f6e\u4e0d\u662f\u8fde\u7eed\u7684\uff01", (String)"RfmBasicSettingValidator_3", (String)"scmc-mobsm-form", (Object[])new Object[0]), i + 1);
            this.addMessage(entity, msg, ErrorLevel.Error);
            break;
        }
        if (fSet.size() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684F\u503c\uff0c\u7b2c\u3010%s\u3011\u884c\u4e3a\u7a7a\uff01", (String)"RfmBasicSettingValidator_6", (String)"scmc-mobsm-form", (Object[])new Object[0]), StringUtils.join(fSet, (String)","));
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }

    private void rValidator(ExtendedDataEntity entity, DynamicObject bill) {
        DynamicObjectCollection rEntry = bill.getDynamicObjectCollection("entryr");
        HashSet<Integer> rSet = new HashSet<Integer>(5);
        for (int i = 0; i < rEntry.size() - 1; ++i) {
            DynamicObject preR = (DynamicObject)rEntry.get(i);
            DynamicObject r = (DynamicObject)rEntry.get(i + 1);
            Object preMin = preR.get("minvaluer");
            Object min = r.get("minvaluer");
            if (preMin == null) {
                rSet.add(i + 1);
            }
            if (min == null) {
                rSet.add(i + 2);
            }
            if (preMin == null || min == null || Long.parseLong(String.valueOf(preMin)) < Long.parseLong(String.valueOf(min))) continue;
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684R\u503c\uff0c\u7b2c%s\u884c\u8bbe\u7f6e\u4e0d\u662f\u8fde\u7eed\u7684\uff01", (String)"RfmBasicSettingValidator_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), i + 1);
            this.addMessage(entity, msg, ErrorLevel.Error);
            break;
        }
        if (rSet.size() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"RFM\u57fa\u7840\u8bbe\u7f6e\u7684R\u503c\uff0c\u7b2c\u3010%s\u3011\u884c\u4e3a\u7a7a\uff01", (String)"RfmBasicSettingValidator_5", (String)"scmc-mobsm-form", (Object[])new Object[0]), StringUtils.join(rSet, (String)","));
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }
}

