/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobsm.webapi;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.kuep.capp.sdk.TopBoardCardProxy;
import kd.scmc.mobsm.business.helper.PermissionHelper;
import kd.scmc.mobsm.common.utils.DateUtils;

public class TopBoardCardWebAPI
implements IBillWebApiPlugin {
    private Log LOG = LogFactory.getLog(TopBoardCardWebAPI.class);
    private static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    private static final BigDecimal TEN_BILLION = new BigDecimal("100000000");

    public ApiResult doCustomService(Map<String, Object> params) {
        Date endDate;
        Date startDate;
        TopBoardCardProxy topBoardCardProxy = new TopBoardCardProxy();
        List<Long> orgIds = PermissionHelper.getUserAllHasPermOrgs();
        this.LOG.info("\u9876\u90e8\u6570\u636e\u770b\u677f:\u6267\u884c\u65b9\u6cd5\u3010doCustomService\u3011\u53c2\u6570\u3010{}\u3011", orgIds);
        if (orgIds.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7528\u6237\u65e0\u6709\u6743\u7ec4\u7ec7\u3002", (String)"TopBoardCardWebAPI_0", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDate = sdf.parse((String)params.get("startDate"));
            endDate = sdf1.parse((String)params.get("endDate"));
        }
        catch (ParseException e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\u3002", (String)"TopBoardCardWebAPI_1", (String)"scmc-mobsm-form", (Object[])new Object[0]));
        }
        DataSet saleAmountData = this.query(orgIds, startDate, endDate);
        HashMap<String, BigDecimal> amountColl = new HashMap<String, BigDecimal>(2);
        amountColl.put("totalamount", BigDecimal.ZERO);
        amountColl.put("receiptamount", BigDecimal.ZERO);
        if (saleAmountData.hasNext()) {
            Row row = saleAmountData.next();
            BigDecimal curTotalAllAmount = row.getBigDecimal("curtotalallamount").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("curtotalallamount");
            BigDecimal receiptAllAmount = row.getBigDecimal("receiptallamount").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("receiptallamount");
            amountColl.put("totalamount", curTotalAllAmount);
            amountColl.put("receiptamount", receiptAllAmount);
        }
        topBoardCardProxy.setMainData(ResManager.loadKDString((String)"\u9500\u552e\u4e1a\u7ee9", (String)"TopBoardCardWebAPI_2", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getMagnitude((BigDecimal)amountColl.get("totalamount")), "#ffffff", "#ffffff");
        topBoardCardProxy.addDataList(ResManager.loadKDString((String)"\u56de\u6b3e", (String)"TopBoardCardWebAPI_3", (String)"scmc-mobsm-form", (Object[])new Object[0]), this.getMagnitude((BigDecimal)amountColl.get("receiptamount")), "#ffffff", "#ffffff");
        int newCustomer = this.getNewCustomer(orgIds, startDate, endDate);
        topBoardCardProxy.addDataList(ResManager.loadKDString((String)"\u65b0\u589e\u5ba2\u6237", (String)"TopBoardCardWebAPI_4", (String)"scmc-mobsm-form", (Object[])new Object[0]), String.valueOf(newCustomer), "#ffffff", "#ffffff");
        return ApiResult.success((Object)topBoardCardProxy.getTopBoardCard());
    }

    private DataSet query(List<Long> orgIds, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("bizdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        qFilter.and(new QFilter("exchangerate", "!=", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("changestatus", "!=", (Object)"B"));
        DataSet saleOrder = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sm_salorder", (String)this.getSaleAmountField(), (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = saleOrder.groupBy(new String[]{"orgname", "currency"}).sum("curtotalallamount").sum("receiptallamount").finish();
        return dataSet;
    }

    private String getSaleAmountField() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("org.name as orgname");
        selectFields.add("currency");
        selectFields.add("curtotalallamount");
        selectFields.add("receiptamount * exchangerate as receiptallamount");
        return String.join((CharSequence)",", selectFields);
    }

    private int getNewCustomer(List<Long> orgIds, Date startDate, Date endDate) {
        Map<String, Date> startAndEndDate = DateUtils.getStartAndEndDate(endDate);
        Date custEndDate = startAndEndDate.get("enddate");
        QFilter qFilter = new QFilter("createorg", "in", orgIds);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)custEndDate));
        DataSet newCustomer = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_customer", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null);
        int count = newCustomer.count("id", false);
        return count;
    }

    private String getMagnitude(BigDecimal amount) {
        String magnitudeAmount = amount.stripTrailingZeros().toPlainString();
        if (amount.compareTo(TEN_THOUSAND) >= 0 && amount.compareTo(TEN_BILLION) < 0) {
            magnitudeAmount = String.format(ResManager.loadKDString((String)"%1$s\u4e07", (String)"TopBoardCardWebAPI_getMagnitude_0", (String)"scmc-mobsm-form", (Object[])new Object[0]), amount.divide(TEN_THOUSAND, 2, 4).stripTrailingZeros().toPlainString());
        } else if (amount.compareTo(TEN_BILLION) >= 0) {
            magnitudeAmount = String.format(ResManager.loadKDString((String)"%1$s\u4ebf", (String)"TopBoardCardWebAPI_getMagnitude_1", (String)"scmc-mobsm-form", (Object[])new Object[0]), amount.divide(TEN_BILLION, 2, 4).stripTrailingZeros().toPlainString());
        }
        return magnitudeAmount;
    }
}

