/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.plat.business.helper.pricemodel.helper.FetchPriceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.PriceParameterHelper;

public class SCMCBillQuoteConvertPlugin
extends AbstractConvertPlugIn {
    private String pricePosition;
    private String schemeEntry;
    private static String HEAD_FLAG = "header";
    private static String ENTRY_FLAG = "entry";
    private static final String QUOTE_RESULT_SEPARATOR = "\\$\\$";
    private static final String SPLIT_DONT = "\\.";
    private static final String RESULT_SPLIT = "$$";
    public static final String ISCOVER_KEY = "iscover";
    private static final Log log = LogFactory.getLog(SCMCBillQuoteConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        BillEntityType tgtMainType = this.getTgtMainType();
        String appId = tgtMainType.getAppId();
        HashMap<Long, Boolean> paramCache = new HashMap<Long, Boolean>();
        HashMap<Long, List> orgToBills = new HashMap<Long, List>();
        log.info(this.getLogMsg("\u4e0b\u63a8\u81ea\u52a8\u53d6\u4ef7\u5f00\u59cb"));
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = (DynamicObject)bill.get(this.getQuoteOrgField());
            if (org == null) continue;
            paramCache.computeIfAbsent((Long)org.getPkValue(), key -> {
                Object param = null;
                if ("sm".equals(appId)) {
                    log.info(this.getLogMsg("\u9500\u552e"));
                    param = PriceParameterHelper.getSmAppParameter((Long)((Long)org.getPkValue()), (String)"isautoquote");
                }
                if ("pm".equals(appId)) {
                    log.info(this.getLogMsg("\u91c7\u8d2d"));
                    param = PriceParameterHelper.getPmAppParameter((Long)((Long)org.getPkValue()), (String)"isautoquote");
                }
                if (param == null) {
                    log.info(this.getLogMsg("PARAM is NULL"));
                    param = Boolean.TRUE;
                }
                return (Boolean)param;
            });
            boolean isAutoQuote = (Boolean)paramCache.get(org.getPkValue());
            if (!isAutoQuote) {
                log.info(this.getLogMsg("end"));
                continue;
            }
            log.info(this.getLogMsg("\u771f\u6b63\u5f00\u59cb\u81ea\u52a8\u4e0b\u63a8\u53d6\u4ef7"));
            List billList = orgToBills.computeIfAbsent((Long)org.getPkValue(), key -> new ArrayList());
            billList.add(bill);
        }
        orgToBills.forEach((k, v) -> this.autoQuote((Long)k, v.toArray(new DynamicObject[v.size()]), (EntityType)tgtMainType));
        log.info(this.getLogMsg("\u4e0b\u63a8\u81ea\u52a8\u53d6\u4ef7\u7ed3\u675f"));
    }

    protected String getQuoteOrgField() {
        String orgProperty = this.getTgtMainType().getMainOrg();
        if (("im".equals(this.getTgtMainType().getAppId()) || "pm_requirapplybill".equals(this.getTgtMainType().getName())) && this.getTgtMainType().getAllFields().containsKey("bizorg")) {
            orgProperty = "bizorg";
        }
        return orgProperty;
    }

    private void autoQuote(Long orgID, DynamicObject[] bills, EntityType tgtMainType) {
        List resultFileds = null;
        log.info(this.getLogMsg("\u771f\u6b63\u5f00\u59cb\u81ea\u52a8\u4e0b\u63a8\u53d6\u4ef7"));
        HashSet<Long> orgIDSet = new HashSet<Long>(1);
        orgIDSet.add(orgID);
        Map priceMapKey = FetchPriceHelper.fetchPriceConditonKey(orgIDSet, (String)tgtMainType.getName());
        if (priceMapKey != null && priceMapKey.get(orgID) != null && ((Map)priceMapKey.get(orgID)).get("result") != null) {
            resultFileds = (List)((Map)priceMapKey.get(orgID)).get("result");
        }
        if (resultFileds == null) {
            return;
        }
        log.info(this.getLogMsg("\u83b7\u53d6\u4e86\u952e\u503c"));
        List<String> priceFileds = this.checkPostion(resultFileds);
        if (priceFileds == null || priceFileds.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> pkToBill = new HashMap<Long, DynamicObject>(bills.length);
        HashMap<Long, List<Integer>> entryQuoteRows = new HashMap<Long, List<Integer>>(bills.length);
        HashMap<Long, Boolean> headQuote = new HashMap<Long, Boolean>(bills.length);
        for (DynamicObject bill : bills) {
            Long pk = this.setBillPkValue(bill);
            pkToBill.put(pk, bill);
            if (HEAD_FLAG.equals(this.pricePosition)) {
                headQuote.put(pk, this.isHeadQuote(bill, priceFileds));
            }
            if (!ENTRY_FLAG.equals(this.pricePosition)) continue;
            List<Integer> seqs = this.getEntryQuoteRows(bill, priceFileds);
            entryQuoteRows.put(pk, seqs);
        }
        log.info(this.getLogMsg("\u5f00\u59cb\u53d6\u4ef7"));
        HashMap<Long, List<DynamicObject>> billMap = new HashMap<Long, List<DynamicObject>>();
        billMap.put(orgID, Arrays.asList(bills));
        Map propertiesMap = FetchPriceHelper.buildMap4Entry((Map)priceMapKey, billMap);
        HashMap<String, String> quoteParam = new HashMap<String, String>();
        quoteParam.put("auto", "1");
        Map priceTotalMap = FetchPriceHelper.fetchPrice((String)tgtMainType.getName(), (Map)propertiesMap, quoteParam);
        Map priceMap = (Map)priceTotalMap.get(orgID);
        if (priceMap == null || priceMap != null && Boolean.FALSE.equals(priceMap.get("success"))) {
            log.info("orgid=" + orgID + " " + this.getLogMsg("\u53d6\u4ef7\u5f02\u5e38"));
            return;
        }
        log.info(this.getLogMsg("\u586b\u5145\u4ef7\u683c"));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)tgtMainType.getName());
        Map allFields = mainEntityType.getAllFields();
        priceMap.forEach((k, v) -> {
            String[] fileds = k.split(QUOTE_RESULT_SEPARATOR);
            if (fileds.length == 2) {
                Long billID = Long.valueOf(fileds[0]);
                String resultField = fileds[1];
                IDataEntityProperty filedProperty = (IDataEntityProperty)allFields.get(resultField);
                if (pkToBill.get(billID) != null && headQuote.size() > 0 && ((Boolean)headQuote.get(billID)).booleanValue()) {
                    DynamicObject bill = (DynamicObject)pkToBill.get(billID);
                    this.setPriceValue(filedProperty, bill, resultField, v, mainEntityType);
                }
            } else if (fileds.length == 4) {
                Long billID = Long.valueOf(fileds[0]);
                int seq = Integer.parseInt(fileds[2]);
                String resultField = fileds[3];
                IDataEntityProperty filedProperty = (IDataEntityProperty)allFields.get(resultField);
                boolean setting = false;
                if (!ISCOVER_KEY.equals(resultField)) {
                    String iscover_Key = fileds[0] + RESULT_SPLIT + fileds[1] + RESULT_SPLIT + fileds[2] + RESULT_SPLIT + ISCOVER_KEY;
                    Object iscover_value = priceMap.get(iscover_Key);
                    if (iscover_value == null || !"B".equals(iscover_value.toString())) {
                        if (entryQuoteRows.get(billID) != null && ((List)entryQuoteRows.get(billID)).contains(seq)) {
                            setting = true;
                        }
                    } else {
                        setting = true;
                    }
                }
                if (setting && pkToBill.get(billID) != null && StringUtils.isNotEmpty((String)this.schemeEntry)) {
                    DynamicObject entryInfo = (DynamicObject)((DynamicObject)pkToBill.get(billID)).getDynamicObjectCollection(this.schemeEntry).get(seq - 1);
                    this.setPriceValue(filedProperty, entryInfo, resultField, v, mainEntityType);
                }
            }
        });
    }

    private List<String> checkPostion(List<String> resultFileds) {
        ArrayList resultTotalFields = new ArrayList();
        resultFileds.forEach(p -> {
            if (p != null && !resultTotalFields.contains(p)) {
                resultTotalFields.add(p);
            }
        });
        ArrayList<String> priceTotalFields = new ArrayList<String>();
        if (resultTotalFields.size() > 0) {
            String resultFields = (String)resultTotalFields.get(0);
            this.pricePosition = resultFields.split(SPLIT_DONT).length == 1 ? HEAD_FLAG : ENTRY_FLAG;
            if (HEAD_FLAG.equals(this.pricePosition)) {
                priceTotalFields = resultTotalFields;
            } else {
                for (int i = 0; i < resultTotalFields.size(); ++i) {
                    String r = (String)resultTotalFields.get(i);
                    String[] resultField = r.split(SPLIT_DONT);
                    priceTotalFields.add(resultField[resultField.length - 1]);
                    this.schemeEntry = resultField[resultField.length - 2];
                }
            }
        }
        return priceTotalFields;
    }

    private boolean isHeadQuote(DynamicObject curObj, List<String> priceFileds) {
        boolean needQuote = true;
        for (String filed : priceFileds) {
            if (!(curObj.get(filed) instanceof BigDecimal) || ((BigDecimal)curObj.get(filed)).compareTo(BigDecimal.ZERO) == 0) continue;
            needQuote = false;
            break;
        }
        return needQuote;
    }

    private List<Integer> getEntryQuoteRows(DynamicObject bill, List<String> priceFileds) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.schemeEntry);
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (DynamicObject entryInfo : entrys) {
            for (String filed : priceFileds) {
                if (entryInfo.get(filed) instanceof BigDecimal && ((BigDecimal)entryInfo.get(filed)).compareTo(BigDecimal.ZERO) != 0) break;
                rows.add(entryInfo.getInt("seq"));
            }
        }
        return rows;
    }

    private void setPriceValue(IDataEntityProperty filedProperty, DynamicObject entryInfo, String resultField, Object v, MainEntityType mainEntityType) {
        if (filedProperty instanceof BasedataProp) {
            this.setBaseDataFiled(entryInfo, resultField, v, (EntityType)mainEntityType);
        } else {
            entryInfo.set(resultField, v);
        }
    }

    private void setBaseDataFiled(DynamicObject curObj, String filed, Object value, EntityType tgtMainType) {
        BasedataProp prop = (BasedataProp)tgtMainType.findProperty(filed);
        EntityType entityType = (EntityType)prop.getComplexType();
        DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
        object.set("id", value);
        curObj.set(filed, (Object)object);
    }

    private Long setBillPkValue(DynamicObject bill) {
        Long pk = this.genPKValue(bill);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.schemeEntry);
        for (DynamicObject entryInfo : entrys) {
            this.genPKValue(entryInfo);
        }
        return pk;
    }

    private Long genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            return (Long)curObj.get("id");
        }
        return (Long)curObj.getPkValue();
    }

    private String getLogMsg(String msg) {
        return "quote=" + msg;
    }
}

