/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.changemodel;

import java.util.Date;
import java.util.UUID;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.plat.business.helper.changemodel.ChangeModelHelper;
import kd.scmc.plat.business.helper.changemodel.XBillDoHelper;

public class SrcBillChangePlugin
extends AbstractFormPlugin {
    public static Log logger = LogFactory.getLog(SrcBillChangePlugin.class);
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("bizchange")) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u8981\u5bf9\u5f53\u524d\u5355\u636e\u8fdb\u884c\u53d8\u66f4\uff1f", (String)"SrcBillChangePlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        } else if (operate.getOperateKey().equals("bizchangelog")) {
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId("plat_xbilllog");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setCustomParam("srcbillid", (Object)(this.getModel().getValue("id") + ""));
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("bizchange") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("bizchange", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && operate.getOperateKey().equals("bizchange")) {
            long begintime = System.currentTimeMillis();
            logger.info("BizChangePerformance----xbillgenerate begin\uff1a" + new Date(begintime));
            String srcBillEntity = this.getModel().getDataEntityType().getName();
            Long srcBillId = (Long)this.getModel().getValue("id");
            DynamicObject xBill = ChangeModelHelper.generateXBilll((String)srcBillEntity, (long)srcBillId);
            long generatefinishtime = System.currentTimeMillis();
            logger.info("BizChangePerformance----xbillgenerate finish\uff1a" + new Date(generatefinishtime));
            logger.info("BizChangePerformance----xbillgenerate use time :" + (generatefinishtime - begintime) + " ms");
            String cacheXPageId = UUID.randomUUID().toString();
            logger.info("BizChangePerformance----PutParam_key: " + cacheXPageId);
            if (xBill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u6e90\u5355\u636e\u4e3a\uff1a%s\u7684\u53d8\u66f4\u6a21\u578b\u662f\u5426\u5b9a\u4e49\u6b63\u786e\u3002", (String)"SrcBillChangePlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[]{srcBillEntity}));
                return;
            }
            String xBillFormID = this.loadXBillLayoutFormId(xBill);
            XBillDoHelper.putXBillDo((String)cacheXPageId, (DynamicObject)xBill, (String)srcBillEntity);
            logger.info("BizChangePerformance----PutParamInstanceID: " + Instance.getInstanceId());
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId(StringUtils.isNotBlank((CharSequence)xBillFormID) ? xBillFormID : xBill.getDataEntityType().getName());
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.ADDNEW);
            fsp.setBillStatus(BillOperationStatus.ADDNEW);
            fsp.setHasRight(true);
            fsp.setCustomParam("cacheXPageId", (Object)cacheXPageId);
            fsp.setCustomParam("srcBillEntiy", (Object)srcBillEntity);
            fsp.setCustomParam("srcBillID", (Object)srcBillId);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private String loadXBillLayoutFormId(DynamicObject xBill) {
        String layoutId;
        QFilter[] filter;
        DynamicObject billtype;
        Long billTypeId;
        String xBillNum;
        BillEntityType xBillMainType;
        String layoutNum = null;
        if (xBill != null && StringUtils.isNotBlank((CharSequence)(xBillMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)(xBillNum = xBill.getDataEntityType().getName()))).getBillType()) && (billTypeId = Long.valueOf(xBill.getLong(xBillMainType.getBillType() + "_id"))) != null && Long.compare(0L, billTypeId) != 0 && (billtype = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id, number, billformid, layoutsolution", (QFilter[])(filter = new QFilter[]{new QFilter("id", "=", (Object)billTypeId)}))) != null && StringUtils.isNotBlank((CharSequence)(layoutId = billtype.getString("layoutsolution"))) && !StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)layoutId)) {
            layoutNum = MetadataDao.getNumberById((String)layoutId);
        }
        return layoutNum;
    }
}

