/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.changemodel;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.plat.business.helper.changemodel.ChangeModelHelper;
import kd.scmc.plat.business.helper.changemodel.XBillDoHelper;
import kd.scmc.plat.common.consts.changemodel.ChangeTypeEnum;
import kd.scmc.plat.common.util.CommonUtils;

public class XBillChangePlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    public static Log logger = LogFactory.getLog(XBillChangePlugin.class);

    protected Map<String, Map<String, String>> getXBillEntryAndOp() {
        Map<String, Map<String, String>> result = new HashMap();
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill((String)this.getModel().getDataEntityType().getName());
        result = ChangeModelHelper.getXBillEntryAndOp((DynamicObject)changeModel);
        if (result.size() != 0) {
            return result;
        }
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("entity", "billentry");
        value.put("entry_toolbar", "tbmainentry");
        value.put("btn_add", "addrow");
        value.put("btn_delete", "deleterow");
        value.put("btn_modify", "modifyrow");
        value.put("changetype", "billentrychangetype");
        value.put("srcid", "billentrysrcid");
        result.put("entity", value);
        return result;
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        String pageId = (String)bsp.getCustomParam("cacheXPageId");
        String srcBillEntiy = (String)bsp.getCustomParam("srcBillEntiy");
        Long srcBillId = (Long)bsp.getCustomParam("srcBillID");
        if (StringUtils.isBlank((CharSequence)pageId) || StringUtils.isBlank((CharSequence)srcBillEntiy)) {
            logger.info("BizChangePerformance----pageId: " + pageId);
            logger.info("BizChangePerformance----srcBillEntiy: " + srcBillEntiy);
            return;
        }
        logger.info("BizChangePerformance----GetParamInstanceID: " + Instance.getInstanceId());
        DynamicObject dataEntity = XBillDoHelper.getXBillDo((String)pageId, (String)srcBillEntiy);
        if (dataEntity == null) {
            if (srcBillId == null) {
                return;
            }
            dataEntity = ChangeModelHelper.generateXBilll((String)srcBillEntiy, (long)srcBillId);
        }
        e.setDataEntity((Object)dataEntity);
        bsp.setCustomParam("cacheXPageId", null);
        XBillDoHelper.removeCacheXBillDo((String)pageId, (String)srcBillEntiy);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        if (rows == null || rows.size() == 0) {
            return;
        }
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        if (xBillEntrys == null || xBillEntrys.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryEntity = entryGrid.getKey();
        if (!xBillEntrys.containsKey(entryEntity)) {
            return;
        }
        Map<String, String> xBillEntry = xBillEntrys.get(entryEntity);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)entryEntity);
        String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)entryEntity);
        for (RowDataEntity row : rows) {
            int index = row.getRowIndex();
            String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), index);
            if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, index, unEnableEntryPropertys);
                this.getView().setEnable(Boolean.TRUE, index, enableEntryProperrtys);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
            this.getView().setEnable(Boolean.FALSE, index, unEnableEntryPropertys);
            this.getView().setEnable(Boolean.FALSE, index, enableEntryProperrtys);
        }
    }

    public void beforeBindData(EventObject e) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (entityType instanceof BillEntityType) {
            ((BillEntityType)entityType).setBillNo("changebillno");
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel bill = this.getModel();
        long afterCreateNewDataTime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterCreateNewData)BeginTime:" + new Date(afterCreateNewDataTime));
        for (IDataEntityProperty entityProperty : bill.getDataEntityType().getProperties()) {
            if (entityProperty instanceof SubEntryProp || !(entityProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)bill.getValue(entityProperty.getName());
            for (DynamicObject entry : entrys) {
                entry.getDataEntityState().setDirty(true);
                entry.getDataEntityState().setBizChanged(true);
                entry.getDataEntityState().setBizChangeFlags(entry.getDataEntityState().getDirtyFlags());
                for (IDataEntityProperty subEntityProperty : entry.getDataEntityType().getProperties()) {
                    if (!(subEntityProperty instanceof SubEntryProp)) continue;
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(subEntityProperty.getName());
                    for (DynamicObject subEntry : subEntrys) {
                        subEntry.getDataEntityState().setDirty(true);
                        subEntry.getDataEntityState().setBizChanged(true);
                        subEntry.getDataEntityState().setBizChangeFlags(subEntry.getDataEntityState().getDirtyFlags());
                    }
                }
            }
        }
        long seteditbegintime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterCreateNewData)BillEditedSetBegin\uff1a" + new Date(seteditbegintime));
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnablePropertys = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt);
        String[] enablePropertys = ChangeModelHelper.getEnableProperty((IDataEntityType)dt);
        if (!CommonUtils.isNull((Object)unEnablePropertys)) {
            this.getView().setEnable(Boolean.FALSE, unEnablePropertys);
        }
        if (!CommonUtils.isNull((Object)enablePropertys)) {
            this.getView().setEnable(Boolean.TRUE, enablePropertys);
        }
        long seteditendtime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterCreateNewData)BillEditedSetEnd" + new Date(seteditendtime));
        logger.info("BizChangePerformance----Function(afterCreateNewData)BillEditedSetUseTime \uff1a" + (seteditendtime - seteditbegintime) + " ms");
    }

    public void afterBindData(EventObject e) {
        long begintime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetBegin\uff1a" + new Date(begintime));
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnablePropertys = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt);
        String[] enablePropertys = ChangeModelHelper.getEnableProperty((IDataEntityType)dt);
        if (!CommonUtils.isNull((Object)unEnablePropertys)) {
            this.getView().setEnable(Boolean.FALSE, unEnablePropertys);
        }
        if (!CommonUtils.isNull((Object)enablePropertys)) {
            this.getView().setEnable(Boolean.TRUE, enablePropertys);
        }
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            DynamicObject[] dynamicObjects;
            String entryEntity = entry.getKey();
            Map<String, String> xBillEntry = result.get(entryEntity);
            String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)entryEntity);
            String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)entryEntity);
            EntryGrid entrygrid = (EntryGrid)this.getControl(entryEntity);
            if (entrygrid == null || entrygrid.getEntryData() == null) {
                logger.info("I can't find the entry that name's  " + entryEntity);
                continue;
            }
            EntryData entrydata = entrygrid.getEntryData();
            boolean blon = entrygrid.isSplitPage();
            int pageCount = entrydata.getPageCount();
            if (blon) {
                if (pageCount > 0) {
                    int startIdx = entrydata.getStartIndex();
                    int endIdx = entrydata.getEndIndex();
                    for (int i = startIdx; i < endIdx; ++i) {
                        String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                        if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                            this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                            continue;
                        }
                        if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                    }
                }
            } else if (entrydata.getDataEntitys() != null && (dynamicObjects = entrydata.getDataEntitys()).length > 0) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                    if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        this.getView().setEnable(Boolean.TRUE, i, enableEntryProperrtys);
                        continue;
                    }
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                    this.getView().setEnable(Boolean.FALSE, i, enableEntryProperrtys);
                }
            }
            logger.info("\u53d8\u66f4\u8c03\u4f18----afterbindata...........entry\uff1a " + entryEntity + "pagerowcount:" + pageCount);
        }
        long endtime = System.currentTimeMillis();
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetEnd \uff1a" + new Date(endtime));
        logger.info("BizChangePerformance----Function(afterBindData)EntryEditedSetUseTime \uff1a" + (endtime - begintime) + " ms");
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row != -1) {
            String key = ((EntryGrid)evt.getSource()).getKey();
            Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
            if (!xBillEntrys.containsKey(key)) {
                return;
            }
            Map<String, String> xBillEntry = xBillEntrys.get(key);
            String[] unEnableEntryPropertys = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)key);
            String[] enableEntryProperrtys = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)key);
            String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), row);
            if (ChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, row, unEnableEntryPropertys);
                this.getView().setEnable(Boolean.TRUE, row, enableEntryProperrtys);
            } else if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, row, unEnableEntryPropertys);
                this.getView().setEnable(Boolean.FALSE, row, enableEntryProperrtys);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        RowDataEntity[] rowDataEntitys;
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        for (RowDataEntity rowDataEntity : rowDataEntitys = evt.getRowDataEntities()) {
            xBill.setValue(xBillEntry.get("changetype"), (Object)ChangeTypeEnum.ADDNEW.getValue(), rowDataEntity.getRowIndex());
        }
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        String changeType = result.get(entryEntity).get("changetype");
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)entryEntity);
        String[] enableProperty = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)entryEntity);
        int rowCount = this.getModel().getEntryRowCount(entryEntity);
        for (int i = 0; i < rowCount; ++i) {
            if (!ChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(changeType, i))) continue;
            if (!CommonUtils.isNull((Object)unEnableProperty)) {
                this.getView().setEnable(Boolean.FALSE, i, unEnableProperty);
            }
            if (CommonUtils.isNull((Object)enableProperty)) continue;
            this.getView().setEnable(Boolean.TRUE, i, enableProperty);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        String[] allEntryProperties = ChangeModelHelper.getProperty4Entry((IDataEntityType)dt, (String)entryEntity);
        for (int curRow : evt.getRowIndexs()) {
            if (!ChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow)) && !ChangeTypeEnum.CANCEL.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow))) continue;
            xBill.setValue(xBillEntry.get("changetype"), (Object)ChangeTypeEnum.CANCEL.getValue(), curRow);
            this.getView().setEnable(Boolean.FALSE, curRow, allEntryProperties);
            evt.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : xBillEntrys.entrySet()) {
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid)) continue;
            ((EntryGrid)entryGrid).addDataBindListener((EntryGridBindDataListener)this);
            ((EntryGrid)entryGrid).addRowClickListener((RowClickEventListener)this);
            this.addItemClickListeners(new String[]{entry.getValue().get("entry_toolbar")});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String evtItemKey = evt.getItemKey();
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            int[] selectRows;
            if (!evtItemKey.equals(entry.getValue().get("btn_modify")) && !evt.getItemKey().equals(entry.getValue().get("btn_delete"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = ((EntryGrid)entryGrid).getSelectRows()).length > 0) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"XBillChangePlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        IDataModel xBill = this.getModel();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            int[] selectRows;
            if (!evt.getItemKey().equals(entry.getValue().get("btn_modify"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = ((EntryGrid)entryGrid).getSelectRows()).length <= 0) continue;
            boolean nocanmodidataflag = true;
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            String[] unEnableProperty = ChangeModelHelper.getUnEnableProperty((IDataEntityType)dt, (String)entryEntity);
            String[] enableProperty = ChangeModelHelper.getEnableProperty((IDataEntityType)dt, (String)entryEntity);
            for (int selectRow : selectRows) {
                if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow)) || ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow))) continue;
                xBill.setValue(result.get(entryEntity).get("changetype"), (Object)ChangeTypeEnum.UPDATE.getValue(), selectRow);
                this.getView().setEnable(Boolean.FALSE, selectRow, unEnableProperty);
                this.getView().setEnable(Boolean.TRUE, selectRow, enableProperty);
                nocanmodidataflag = false;
            }
            if (!nocanmodidataflag) continue;
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\u72b6\u6001\u7684\u5206\u5f55\u884c\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"XBillChangePlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String xMDJson;
        QFilter qf;
        DynamicObject xPurOrderBillLog;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        Long xBillID = (Long)this.getModel().getValue("id");
        if (xBillID != null && "bizchangelog".equals(operate.getOperateKey()) && (xPurOrderBillLog = BusinessDataServiceHelper.loadSingleFromCache((String)"plat_xbilllog", (QFilter[])new QFilter[]{qf = new QFilter("xbillid", "=", (Object)xBillID)})) != null && (xMDJson = xPurOrderBillLog.getString("xmdjson_tag")) != null) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("plat_xbilllogshow");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setCaption("");
            fsp.setCustomParam("mdlog", (Object)xMDJson);
            this.getView().showForm(fsp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject changeModel;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("audit".equalsIgnoreCase(args.getOperateKey()) && args.getOperationResult().isSuccess() && (changeModel = ChangeModelHelper.getChangeModel4XBill((String)operate.getEntityId())) != null && "auto".equals(changeModel.getString("updatetype"))) {
            this.getView().invokeOperation("bizvalid");
        }
    }
}

