/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.devtool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import org.apache.commons.lang.StringUtils;

public class SQLExportPlugin
extends AbstractFormPlugin {
    private static final String TARGET_OBJ = "targetobj";
    private static final String TARGET_OBJ_IDS = "targetobjid";
    private static final String TARGET_OBJ_NAME = "targetobjname";
    private static final String BUTTON_EXECUTE = "execute";
    private static final String CODE_EDIT_SQL = "sqlcodeeditap";
    private static final String CODE_EDIT_JAVA = "javacodeeditap";
    private static final String SELECT_F7_CB = "selectF7CB";
    private static final String E_DATA_INFO = "datainfo";
    private static final String TABLE_NAME = "tablename";
    private static final String TABLE_COLUMN = "tablecolumn";
    private static final String FIELD_KEY = "fieldkey";
    private static final String FIELD_NAME = "fieldname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_EXECUTE, TARGET_OBJ_IDS});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "targetobj": {
                this.targetObjChange(e);
                break;
            }
        }
    }

    private void targetObjChange(PropertyChangedArgs e) {
        this.getModel().setValue(TARGET_OBJ_IDS, (Object)"");
        this.getModel().setValue(TARGET_OBJ_NAME, (Object)"");
        this.getModel().deleteEntryData(E_DATA_INFO);
        DynamicObject newBillEntity = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newBillEntity == null) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)newBillEntity.getString("number"));
        this.loadTargetObjInfo(entityType);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjid": {
                this.clickTargetObjIds();
                break;
            }
            case "execute": {
                this.export();
                break;
            }
        }
    }

    private void clickTargetObjIds() {
        String selectList = (String)this.getModel().getValue(TARGET_OBJ_IDS);
        Object[] pkIds = null;
        if (StringUtils.isNotEmpty((String)selectList)) {
            List list = SerializationUtils.fromJsonStringToList((String)selectList, Object.class);
            pkIds = list.toArray();
        }
        ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)this.getTargetObjName(), (boolean)false);
        basedataF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_F7_CB));
        basedataF7Param.setMultiSelect(true);
        if (pkIds != null) {
            basedataF7Param.setSelectedRows(pkIds);
        }
        this.getView().showForm((FormShowParameter)basedataF7Param);
    }

    private void export() {
        this.showCodeText("", "");
        EntryGrid grid = (EntryGrid)this.getView().getControl(E_DATA_INFO);
        int[] rowIndexs = grid.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7684\u5b57\u6bb5\u3002", (String)"plsSelectNeedField", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetObjName());
        String dbRouteKey = entityType.getDBRouteKey();
        Map<String, String> whereInfo = this.getWhereInfo(entityType, this.getTargetObjIds());
        Map<String, Set<String>> selectTableAndColumns = this.getSelectTableAndColumns(rowIndexs);
        StringBuilder sqls = new StringBuilder();
        for (Map.Entry<String, Set<String>> tableAndColumn : selectTableAndColumns.entrySet()) {
            String tableName = tableAndColumn.getKey();
            Set<String> columns = tableAndColumn.getValue();
            String whereFiled = whereInfo.get(tableName);
            if (StringUtils.isEmpty((String)whereFiled)) continue;
            String sql = this.generateSql(dbRouteKey, tableName, this.collectionToStr(columns, null), whereFiled);
            sqls.append(sql);
        }
        String botpTracker = this.generateSql("sys", "T_BOTP_BILLTRACKER", "fid,fstableid,fsbillid,fttableid,ftbillid,fcreatetime", "ftbillid in (" + this.collectionToStr(this.getTargetObjIds(), null) + ")");
        this.showCodeText(sqls.toString(), botpTracker);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"codeGenerateSuccess", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
    }

    private Map<String, String> getWhereInfo(MainEntityType entityType, List<Object> targetObjIds) {
        HashMap<String, String> tablePkField = new HashMap<String, String>(16);
        Map entities = entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            ISimpleProperty primaryKey;
            if (StringUtils.isEmpty((String)entryEntityType.getAlias()) || StringUtils.isEmpty((String)(primaryKey = entryEntityType.getPrimaryKey()).getAlias())) continue;
            List<Object> ids = null;
            if (entryEntityType instanceof LinkEntryType) {
                IDataEntityType parent = entryEntityType.getParent();
                String whereInfo = "FID in (" + this.collectionToStr(targetObjIds, null) + ")";
                if (parent instanceof EntryType) {
                    List<Object> entryIds = this.getObjIds((IDataEntityType)entityType, targetObjIds, (EntityType)((EntryType)parent), parent.getPrimaryKey());
                    whereInfo = "FENTRYID in (" + this.collectionToStr(entryIds, null) + ")";
                } else {
                    whereInfo = "FID in (" + this.collectionToStr(targetObjIds, null) + ")";
                }
                tablePkField.put(entryEntityType.getAlias().toUpperCase(), whereInfo);
                continue;
            }
            ids = this.getObjIds((IDataEntityType)entityType, targetObjIds, entryEntityType, primaryKey);
            if (ids == null || ids.isEmpty()) continue;
            String whereInfo = primaryKey.getAlias() + " in (" + this.collectionToStr(ids, primaryKey.getPropertyType()) + ")";
            String tableName = entryEntityType.getAlias().toUpperCase();
            if (StringUtils.isEmpty((String)tableName)) continue;
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableGroup = prop.getTableGroup();
                String grouptableName = tableName;
                if (StringUtils.isNotEmpty((String)tableGroup)) {
                    grouptableName = grouptableName + "_" + tableGroup;
                }
                tablePkField.put(grouptableName, whereInfo);
            }
            tablePkField.put(tableName + "_L", whereInfo);
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityType.getName());
        if (linkSet != null && StringUtils.isNotEmpty((String)linkSet.getTrackerTable())) {
            tablePkField.put(linkSet.getTrackerTable().toUpperCase(), "FTBillId in (" + this.collectionToStr(targetObjIds, null) + ")");
        }
        return tablePkField;
    }

    private List<Object> getObjIds(IDataEntityType entityType, List<Object> targetObjIds, EntityType entryEntityType, ISimpleProperty primaryKey) {
        List<Object> ids;
        if (entryEntityType instanceof EntryType) {
            String entryIdKey = entryEntityType.getName() + "." + primaryKey.getName();
            DynamicObjectCollection queryids = QueryServiceHelper.query((String)entityType.getName(), (String)entryIdKey, (QFilter[])new QFilter(entityType.getPrimaryKey().getName(), "in", targetObjIds).toArray());
            ids = new ArrayList<Object>(queryids.size());
            for (DynamicObject idObj : queryids) {
                ids.add(idObj.get(entryIdKey));
            }
        } else {
            ids = targetObjIds;
        }
        return ids;
    }

    private String generateSql(String dbRouteKey, String tableName, String selectField, String whereField) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)dbRouteKey), tableName, selectField, whereField, "", "");
        }
        catch (Exception var48) {
            throw new KDBizException((Throwable)var48, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", var48.getMessage())});
        }
        String sql = (String)map.get("sql");
        return sql.replaceAll("0E-10", "0");
    }

    private void showCodeText(String sql, String botpTrackerSql) {
        this.showCodeEdit(this.getView(), this.transSQLToScript(sql, botpTrackerSql), CODE_EDIT_SQL);
        this.showCodeEdit(this.getView(), this.transSQLToJava(sql, botpTrackerSql), CODE_EDIT_JAVA);
    }

    private String transSQLToScript(String sql, String botpTrackerSql) {
        StringBuilder sqlScript = new StringBuilder();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetObjName());
        sqlScript.append("-- ");
        String dbKey = String.format(ResManager.loadKDString((String)"\u5728%s\u5e93\u6267\u884c\u4ee5\u4e0b\u6570\u636e", (String)"SQLExportPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]), entityType.getDBRouteKey());
        sqlScript.append(dbKey).append(this.getModel().getValue(TARGET_OBJ_NAME)).append(System.lineSeparator());
        sqlScript.append(sql);
        if (StringUtils.isNotEmpty((String)botpTrackerSql)) {
            sqlScript.append(System.lineSeparator());
            sqlScript.append("-- ");
            String sysDBKey = String.format(ResManager.loadKDString((String)"\u5728%s\u5e93\u6267\u884c\u4ee5\u4e0b\u6570\u636e", (String)"SQLExportPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]), "sys");
            sqlScript.append(sysDBKey).append(System.lineSeparator()).append(this.getModel().getValue(TARGET_OBJ_NAME));
            sqlScript.append(botpTrackerSql);
        }
        return sqlScript.toString();
    }

    private String transSQLToJava(String sql, String botpTrackerSql) {
        if (StringUtils.isEmpty((String)sql)) {
            return sql;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetObjName());
        StringBuilder javaCode = new StringBuilder();
        javaCode.append("/**").append(System.lineSeparator());
        javaCode.append(" * ");
        javaCode.append(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\uff1a", (String)"SQLExportPlugin_3", (String)"scmc-plat-formplugin", (Object[])new Object[0])).append(entityType.getDisplayName()).append(System.lineSeparator());
        javaCode.append(" * ");
        javaCode.append(ResManager.loadKDString((String)"\u6570\u636e\u4fe1\u606f\uff1a", (String)"SQLExportPlugin_4", (String)"scmc-plat-formplugin", (Object[])new Object[0])).append(this.getModel().getValue(TARGET_OBJ_NAME)).append(System.lineSeparator());
        javaCode.append(" * ");
        javaCode.append(ResManager.loadKDString((String)"\u4f5c\u8005\uff1a", (String)"SQLExportPlugin_5", (String)"scmc-plat-formplugin", (Object[])new Object[0])).append(RequestContext.get().getUserName()).append(System.lineSeparator());
        javaCode.append("**/").append(System.lineSeparator());
        javaCode.append("public static DynamicObject prepareData(){").append(System.lineSeparator());
        String transSQL = String.format("\tString sql = \"%s\";", sql.replaceAll("\"", "\\\""));
        transSQL = transSQL.replaceAll(System.lineSeparator(), "\"" + System.lineSeparator() + "\t\t+ \"");
        javaCode.append(transSQL).append(System.lineSeparator());
        javaCode.append(String.format("\tDB.execute(new DBRoute(\"%s\"), sql);", entityType.getDBRouteKey())).append(System.lineSeparator());
        if (StringUtils.isNotEmpty((String)botpTrackerSql)) {
            javaCode.append(System.lineSeparator()).append("\t//").append(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb", (String)"SQLExportPlugin_6", (String)"scmc-plat-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            String appendSql = String.format("\tString botpTrackerSql = \"%s\";", botpTrackerSql.replaceAll("\"", "\\\""));
            appendSql = appendSql.replaceAll(System.lineSeparator(), "\"" + System.lineSeparator() + "\t\t+ \"");
            javaCode.append(appendSql).append(System.lineSeparator());
            javaCode.append("\tDB.execute(new DBRoute(\"sys\"), botpTrackerSql);").append(System.lineSeparator());
        }
        javaCode.append(String.format("\tDynamicObject obj = BusinessDataServiceHelper.loadSingle(%sL, \"%s\");", this.getTargetObjIds().get(0), this.getTargetObjName())).append(System.lineSeparator());
        javaCode.append("\treturn obj;").append(System.lineSeparator());
        javaCode.append('}');
        return javaCode.toString();
    }

    private void showCodeEdit(IFormView view, String sql, String codeEditKey) {
        CodeEdit codeSQLshow = (CodeEdit)view.getControl(codeEditKey);
        if (codeSQLshow == null) {
            throw new KDBizException(SQLExportPlugin.controlNotExist(codeEditKey));
        }
        String sqlContent = sql;
        if (sql.length() > 100000) {
            sqlContent = SQLExportPlugin.scriptTooLong() + System.lineSeparator() + sql.substring(0, 100000);
        }
        codeSQLshow.setText(sqlContent);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "selectF7CB": {
                this.selectF7CloseCallBack((ListSelectedRowCollection)returnData);
                break;
            }
        }
    }

    private void selectF7CloseCallBack(ListSelectedRowCollection rows) {
        IDataModel model = this.getModel();
        if (rows == null || rows.isEmpty()) {
            return;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>(rows.size());
        ArrayList<String> nameValues = new ArrayList<String>(rows.size());
        for (ListSelectedRow row : rows) {
            pkValues.add(row.getPrimaryKeyValue());
            String name = row.getName();
            if (StringUtils.isEmpty((String)name)) {
                name = row.getBillNo();
            }
            nameValues.add(name);
        }
        model.setValue(TARGET_OBJ_IDS, (Object)SerializationUtils.toJsonString(pkValues));
        model.setValue(TARGET_OBJ_NAME, (Object)SerializationUtils.toJsonString(nameValues));
    }

    private Map<String, Set<String>> getSelectTableAndColumns(int[] rowIndexs) {
        LinkedHashMap<String, Set<String>> tablesName = new LinkedHashMap<String, Set<String>>(16);
        for (int rowIndex : rowIndexs) {
            String tableColumn = (String)this.getModel().getValue(TABLE_COLUMN, rowIndex);
            String tableName = (String)this.getModel().getValue(TABLE_NAME, rowIndex);
            if (StringUtils.isEmpty((String)tableName)) continue;
            LinkedHashSet<String> columns = (LinkedHashSet<String>)tablesName.get(tableName);
            if (columns == null) {
                columns = new LinkedHashSet<String>(16);
                tablesName.put(tableName, columns);
            }
            columns.add(tableColumn);
        }
        return tablesName;
    }

    private void loadTargetObjInfo(MainEntityType entityType) {
        Map entities = entityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            DataEntityPropertyCollection properties = entryEntityType.getProperties();
            if (entryEntityType.getAlias() == null) continue;
            String tableName = entryEntityType.getAlias().toUpperCase();
            HashSet<String> groups = new HashSet<String>(16);
            HashSet<String> multiLangField = new HashSet<String>(16);
            for (IDataEntityProperty property : properties) {
                DynamicProperty prop = (DynamicProperty)property;
                String tableColumn = prop.getAlias();
                if (StringUtils.isEmpty((String)tableColumn) || prop.isDbIgnore()) continue;
                if (prop instanceof MuliLangTextProp) {
                    multiLangField.add(prop.getAlias());
                }
                String tableGroup = prop.getTableGroup();
                String grouptableName = tableName;
                if (StringUtils.isNotEmpty((String)tableGroup)) {
                    grouptableName = grouptableName + "_" + tableGroup;
                    groups.add(grouptableName);
                }
                this.fillDataInfo((IDataEntityProperty)prop, grouptableName);
            }
            for (String group : groups) {
                this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), group);
            }
            if (entryEntityType instanceof EntryType) {
                ISimpleProperty mainPkId = entryEntityType.getParent().getPrimaryKey();
                this.fillDataInfo((IDataEntityProperty)mainPkId, tableName);
                for (String group : groups) {
                    this.fillDataInfo((IDataEntityProperty)mainPkId, group);
                }
            }
            if (multiLangField.isEmpty()) continue;
            String multiLangTable = tableName + "_L";
            this.fillDataInfo("FPKID", "FPKID", "FPKID", multiLangTable);
            this.fillDataInfo((IDataEntityProperty)entryEntityType.getPrimaryKey(), multiLangTable);
            this.fillDataInfo("FLOCALEID", "FLOCALEID", "FLOCALEID", multiLangTable);
            for (String multiLangF : multiLangField) {
                this.fillDataInfo(multiLangF, multiLangF, multiLangF, multiLangTable);
            }
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityType.getName());
        if (linkSet != null && StringUtils.isNotEmpty((String)linkSet.getTrackerTable())) {
            String tcTableName = linkSet.getTrackerTable().toUpperCase();
            this.fillDataInfo("fid", "fid", "fid", tcTableName);
            this.fillDataInfo("ftbillid", "ftbillid", "ftbillid", tcTableName);
            this.fillDataInfo("fttableid", "fttableid", "fttableid", tcTableName);
            this.fillDataInfo("ftid", "ftid", "ftid", tcTableName);
            this.fillDataInfo("fsbillid", "fsbillid", "fsbillid", tcTableName);
            this.fillDataInfo("fstableid", "fstableid", "fstableid", tcTableName);
            this.fillDataInfo("fsid", "fsid", "fsid", tcTableName);
        }
    }

    private void fillDataInfo(IDataEntityProperty prop, String tableName) {
        String tableColumn = prop.getAlias();
        LocaleString displayName = prop.getDisplayName();
        String fieldName = displayName != null ? displayName.getLocaleValue() : prop.getName();
        this.fillDataInfo(fieldName, prop.getName(), tableColumn, tableName);
    }

    private void fillDataInfo(String fieldName, String fieldKey, String tableColumn, String tableName) {
        int rowIndex = this.getModel().createNewEntryRow(E_DATA_INFO);
        this.getModel().setValue(FIELD_NAME, (Object)fieldName, rowIndex);
        this.getModel().setValue(FIELD_KEY, (Object)fieldKey, rowIndex);
        this.getModel().setValue(TABLE_COLUMN, (Object)tableColumn.toUpperCase(), rowIndex);
        this.getModel().setValue(TABLE_NAME, (Object)tableName, rowIndex);
    }

    private String getTargetObjName() {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue(TARGET_OBJ);
        if (targetObj == null) {
            throw new KDBizException("...");
        }
        String entityName = targetObj.getString("number");
        return entityName;
    }

    private List<Object> getTargetObjIds() {
        String selectList = (String)this.getModel().getValue(TARGET_OBJ_IDS);
        if (StringUtils.isNotEmpty((String)selectList)) {
            return SerializationUtils.fromJsonStringToList((String)selectList, Object.class);
        }
        return new ArrayList<Object>();
    }

    private String collectionToStr(Collection<?> list, Class<?> clazz) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (Object object : list) {
            if (clazz != null && clazz.equals(String.class)) {
                str.append('\'');
                str.append(object);
                str.append('\'');
            } else {
                str.append(object);
            }
            str.append(',');
        }
        String string = str.toString();
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    private static String controlNotExist(String codeEditKey) {
        return String.format(ResManager.loadKDString((String)"\u63a7\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"SQLExportPlugin_7", (String)"scmc-plat-formplugin", (Object[])new Object[0]), codeEditKey);
    }

    private static String scriptTooLong() {
        return ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad...", (String)"SQLExportPlugin_8", (String)"scmc-plat-formplugin", (Object[])new Object[0]);
    }
}

