/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.plat.business.helper.pricemodel.pojo.PriceBatchAdjustInfo;
import kd.scmc.plat.common.enums.price.PriceAdjustModelEnum;

public class BatchAdjustPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String TAXRATE_FILTER = "taxrate_filter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxrateid = (BasedataEdit)this.getView().getControl("basedata");
        if (taxrateid != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        this.getModel().setValue("currency", parentModel.getValue("currency"));
        Boolean istax = (Boolean)parentModel.getValue("istax");
        this.setBatchChangeField(istax);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date bizTime = (Date)this.getView().getParentView().getModel().getValue("createtime");
        List<String> taxratelist = this.getTaxRateFilter(bizTime);
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }

    private void setBatchChangeField(Boolean istax) {
        ComboEdit batchchangefield = (ComboEdit)this.getControl("batchchangefield");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (istax != null && istax.booleanValue()) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"BatchAdjustPlugin_6", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjpriceandtax"));
        } else {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u4ef7", (String)"BatchAdjustPlugin_7", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjprice"));
        }
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7a0e\u7387", (String)"BatchAdjustPlugin_8", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjtaxrateid"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u4f4e\u9650\u4ef7", (String)"BatchAdjustPlugin_9", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjpricefloor"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u9ad8\u9650\u4ef7", (String)"BatchAdjustPlugin_10", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjpriceceiling"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f", (String)"BatchAdjustPlugin_11", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjpriceeffectdate"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f", (String)"BatchAdjustPlugin_12", (String)"scmc-plat-formplugin", (Object[])new Object[0])), "adjpriceexpirydate"));
        batchchangefield.setComboItems(items);
        if (istax != null && istax.booleanValue()) {
            this.getModel().setValue("batchchangefield", (Object)"adjpriceandtax");
        } else {
            this.getModel().setValue("batchchangefield", (Object)"adjprice");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "basedata": {
                if (!"bd_taxrate".equals(this.getModel().getValue("itemclasstype"))) break;
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                if (StringUtils.isNotEmpty((String)(taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1)))) {
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "radiogroup": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("priceentryentity");
                int[] rows = entryGrid.getSelectRows();
                String radiogroup = (String)e.getChangeSet()[0].getNewValue();
                if (rows.length != 0 || !"2".equals(radiogroup)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6279\u91cf\u8c03\u6574\u7684\u884c\u3002", (String)"BatchAdjustPlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("radiogroup", (Object)"1");
                break;
            }
            case "price": 
            case "uppercent": 
            case "downpercent": {
                String changemode = (String)this.getModel().getValue("changemode");
                if (e.getChangeSet()[0].getNewValue() == null) {
                    return;
                }
                if (StringUtils.isEmpty((String)changemode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6574\u65b9\u5f0f\u3002", (String)"BatchAdjustPlugin_4", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                    model.setValue(key, null);
                    return;
                }
                this.numberLimitsCheck();
                break;
            }
            case "changemode": {
                model.setValue("price", null);
                model.setValue("uppercent", null);
                model.setValue("downpercent", null);
                break;
            }
            case "batchchangefield": {
                model.beginInit();
                model.setValue("changemode", (Object)"up");
                model.setValue("price", null);
                model.setValue("uppercent", null);
                model.setValue("downpercent", null);
                model.setValue("date", null);
                model.setValue("basedata", null);
                model.endInit();
                this.getView().updateView();
                break;
            }
        }
    }

    private void numberLimitsCheck() {
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String scope = (String)model.getValue("radiogroup");
        String changeMode = (String)model.getValue("changemode");
        BigDecimal adjPrice = (BigDecimal)this.getModel().getValue("price");
        BigDecimal uppercent = (BigDecimal)this.getModel().getValue("uppercent");
        BigDecimal downpercent = (BigDecimal)this.getModel().getValue("downpercent");
        int count = parentModel.getEntryRowCount("priceentryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("priceentryentity");
        int[] rows = entryGrid.getSelectRows();
        if ("1".equals(scope)) {
            rows = new int[count];
            for (int i = 0; i < count; ++i) {
                rows[i] = i;
            }
        }
        HashMap<Integer, BigDecimal> priceMap = new HashMap<Integer, BigDecimal>((int)((double)rows.length / 0.75) + 1);
        String filed = (String)this.getModel().getValue("batchchangefield");
        for (int i = 0; i < rows.length; ++i) {
            priceMap.put(rows[i], this.getValue(map.get(String.valueOf(rows[i])), filed));
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(8);
        PriceAdjustModelEnum changeModeEnum = PriceAdjustModelEnum.valueOf((String)changeMode.toUpperCase());
        switch (changeModeEnum) {
            case UP: {
                for (Map.Entry entry : priceMap.entrySet()) {
                    BigDecimal price = (BigDecimal)entry.getValue();
                    if (errorMsgList.size() > 1500) {
                        errorMsgList.add("...");
                        break;
                    }
                    if (price == null || adjPrice == null || price.add(adjPrice).compareTo(new BigDecimal(9999999999999L)) <= 0) continue;
                    errorMsgList.add(String.valueOf((Integer)entry.getKey() + 1));
                }
                if (errorMsgList.size() <= 0) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u5355\u7b2c%s\u884c\u8ba1\u7b97\u540e\u7ed3\u679c\u8d85\u8fc7\u6570\u503c\u4e0a\u9650\u30109999999999999\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchAdjustPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]), ((Object)errorMsgList).toString()));
                model.setValue("price", null);
                break;
            }
            case DOWN: {
                for (Map.Entry entry : priceMap.entrySet()) {
                    BigDecimal price = (BigDecimal)entry.getValue();
                    if (errorMsgList.size() > 1500) {
                        errorMsgList.add("...");
                        break;
                    }
                    if (price == null || adjPrice == null || price.subtract(adjPrice).compareTo(BigDecimal.ZERO) > 0) continue;
                    errorMsgList.add(String.valueOf((Integer)entry.getKey() + 1));
                }
                if (errorMsgList.size() <= 0) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u5355\u7b2c%s\u884c\u8ba1\u7b97\u540e\u7ed3\u679c\u5c0f\u4e8e\u7b49\u4e8e\u30100\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchAdjustPlugin_3", (String)"scmc-plat-formplugin", (Object[])new Object[0]), ((Object)errorMsgList).toString()));
                model.setValue("price", null);
                break;
            }
            case UPPERCENT: {
                for (Map.Entry entry : priceMap.entrySet()) {
                    BigDecimal price = (BigDecimal)entry.getValue();
                    if (errorMsgList.size() > 1500) {
                        errorMsgList.add("...");
                        break;
                    }
                    if (price == null || uppercent == null || price.multiply(BigDecimal.ONE.add(uppercent.divide(new BigDecimal(100)))).compareTo(new BigDecimal(9999999999999L)) <= 0) continue;
                    errorMsgList.add(String.valueOf((Integer)entry.getKey() + 1));
                }
                if (errorMsgList.size() <= 0) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u5355\u7b2c%s\u884c\u8ba1\u7b97\u540e\u7ed3\u679c\u8d85\u8fc7\u6570\u503c\u4e0a\u9650\u30109999999999999\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatchAdjustPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]), ((Object)errorMsgList).toString()));
                model.setValue("uppercent", null);
                break;
            }
            case DOWNPERCENT: {
                if (downpercent == null || downpercent.compareTo(new BigDecimal(100)) != 0) break;
                model.setValue("downpercent", null);
                break;
            }
        }
    }

    private BigDecimal getValue(Object o, String field) {
        Map m = (Map)SerializationUtils.fromJsonString((String)o.toString(), Map.class);
        if (m.get(field) instanceof Integer) {
            return new BigDecimal((Integer)m.get(field));
        }
        return (BigDecimal)m.get(field);
    }

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equalsIgnoreCase("btnok")) {
            String scope = (String)this.getModel().getValue("radiogroup");
            String field = (String)this.getModel().getValue("batchchangefield");
            String changemode = (String)this.getModel().getValue("changemode");
            BigDecimal price = (BigDecimal)this.getModel().getValue("price");
            BigDecimal uppercent = (BigDecimal)this.getModel().getValue("uppercent");
            BigDecimal downpercent = (BigDecimal)this.getModel().getValue("downpercent");
            Date date = (Date)this.getModel().getValue("date");
            DynamicObject basedata = (DynamicObject)this.getModel().getValue("basedata");
            if (StringUtils.isEmpty((String)field)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u6539\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchAdjustPlugin_13", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!(price != null && price.compareTo(BigDecimal.ZERO) != 0 || uppercent != null && uppercent.compareTo(BigDecimal.ZERO) != 0 || downpercent != null && downpercent.compareTo(BigDecimal.ZERO) != 0 || date != null || basedata != null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchAdjustPlugin_5", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                return;
            }
            PriceBatchAdjustInfo adjustInFo = new PriceBatchAdjustInfo();
            adjustInFo.setField(field);
            adjustInFo.setChangeMode(changemode);
            adjustInFo.setDateValue(date);
            if (basedata != null && "bd_taxrate".equals(this.getModel().getValue("itemclasstype"))) {
                basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)"bd_taxrate");
                adjustInFo.setBaseDataValue(basedata);
            }
            PriceAdjustModelEnum changeModeEnum = PriceAdjustModelEnum.valueOf((String)changemode.toUpperCase());
            switch (changeModeEnum) {
                case UP: 
                case DOWN: 
                case EQUALS: {
                    adjustInFo.setPriceValue(price);
                    break;
                }
                case UPPERCENT: {
                    adjustInFo.setPriceValue(uppercent);
                    break;
                }
                case DOWNPERCENT: {
                    adjustInFo.setPriceValue(downpercent);
                }
            }
            HashMap<String, String> returnMap = new HashMap<String, String>(16);
            returnMap.put("radiogroup", "1".equals(scope) ? "ALL" : "SELECTED");
            returnMap.put("batchadjustinfo", (String)adjustInFo);
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private List<String> getTaxRateFilter(Date createtime) {
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        QFilter q1 = new QFilter("activedate", "<=", (Object)createtime);
        QFilter q2 = new QFilter("expdate", ">", (Object)createtime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        if (org != null) {
            QFilter baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_taxrate", (Long)((Long)org.getPkValue()));
            q1.and(baseDataOrgFilter);
        }
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<String> taxratelist = new ArrayList<String>(bdTaxrate.size());
        for (Map.Entry next : bdTaxrate.entrySet()) {
            Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
            taxratelist.add(pkValue.toString());
        }
        return taxratelist;
    }
}

