/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class FormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String CHANGESOURCEBILL = "changesourcebill";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_FunctionTypes = "functiontypes";
    public static final String Key_FExpression = "fexpression";
    public static final String Key_FDescription = "fdescription";
    public static final String Key_FTranExpr = "ftranexpr";
    public static final String Key_FFilterGrid = "ffiltergrid";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_btnFunction = "btnfunction";
    public static final String Key_btnClr = "clr";
    public static final String Key_btnBackSpace = "backspace";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnFunction, Key_btnClr, Key_btnBackSpace});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFilterGrid();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String flsNodes = this.BuildTreeNode();
        if (StringUtils.isNotBlank((CharSequence)flsNodes)) {
            this.fillTreeNodes(flsNodes);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnFunction)) {
            this.showFuncSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnClr)) {
            this.getModel().setValue(Key_FExpression, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)Key_FExpression, (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnBackSpace)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)Key_btnBackSpace, (String)Key_FExpression);
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            FilterGrid grid = (FilterGrid)this.getControl(Key_FFilterGrid);
            FilterCondition condition = grid.getFilterGridState().getFilterCondition();
            String baseJsonStr = SerializationUtils.toJsonString((Object)condition);
            this.getModel().setValue("quotesourceconditon", (Object)baseJsonStr);
            String formulaJson = (String)this.getModel().getValue("quoteconditon");
            CRFormula formula = this.deserialize(formulaJson);
            this.getConditionObj(formula);
            try {
                String tranExpr = this.tranFormula(formula);
                formula.setExprTran(tranExpr);
            }
            catch (FormulaException exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u5176\u4ed6\u6761\u4ef6\u3011\u4e2d\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                args.setCancel(true);
                return;
            }
            catch (Throwable exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u5176\u4ed6\u6761\u4ef6\u3011\u4e2d\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]), exp.getMessage()));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("quoteconditon", (Object)SerializationUtils.toJsonString((Object)formula));
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)Key_TreeView, (String)Key_FExpression, (String)e.getNodeId().toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25", (String)"FormulaEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        } else if (e.getProperty().getName().equalsIgnoreCase("pricesourceentity")) {
            this.setFilterGrid();
            String flsNodes = this.BuildTreeNode();
            if (StringUtils.isNotBlank((CharSequence)flsNodes)) {
                this.fillTreeNodes(flsNodes);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_btnFunction)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "changesourcebill": {
                if (!"No".equals(evt.getResultValue())) break;
                this.setFilterGrid();
                String flsNodes = this.BuildTreeNode();
                if (!StringUtils.isNotBlank((CharSequence)flsNodes)) break;
                this.fillTreeNodes(flsNodes);
                break;
            }
        }
    }

    protected CRFormula deserialize(String json) {
        CRCondition conditionObj = null;
        conditionObj = StringUtils.isBlank((CharSequence)json) ? new CRCondition() : (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
        return conditionObj;
    }

    protected void getConditionObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(Key_FDescription);
        formulaObj.setDescription(new LocaleString(desc));
    }

    void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.deleteAllNodes();
        tree.addNode(node);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)Key_FExpression, (String)compareValue);
        }
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            String[] scripts = new String[]{"", ""};
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)" \u4e14 ", (String)"ConditionEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = this.BuildTreeNode();
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(vars.length);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void showFuncSetting() {
        String funcsXML = this.getPageCache().get(CustParamKey_FunctionTypes);
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put(CustParamKey_FunctionTypes, funcsXML);
        }
        String jsonNode = this.BuildTreeNode();
        String entityNumber = this.getEntityNumber();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_btnFunction);
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)Key_btnFunction, (String)Key_FExpression, (String)funcSetting);
    }

    public String BuildTreeNode() {
        String number = this.getEntityNumber();
        if (number == null) {
            return "";
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        return flsNodes;
    }

    public String getEntityNumber() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("pricesourceentity");
        if (sourceBill == null) {
            return null;
        }
        String number = sourceBill.getString("number");
        return number;
    }

    public void setFilterGrid() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("pricesourceentity");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(Key_FFilterGrid);
        if (sourceBill == null) {
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
            return;
        }
        String number = sourceBill.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String entityNumber = dataEntityType.getName();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            this.getView().updateView(Key_FFilterGrid);
        }
    }
}

