/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scmc.plat.business.helper.pricemodel.helper.LicenseHelper;

public class PriceBatchAdjustTplPlugin
extends AbstractBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs e) {
        Map result;
        super.preOpenForm(e);
        if (e.getFormShowParameter() != null && Boolean.TRUE.equals((result = LicenseHelper.checkLicense((String)e.getFormShowParameter().getAppId(), null)).get("isCancel"))) {
            e.setCancelMessage((String)result.get("cancelMessage"));
            e.setCancel(true);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if ("execute".equals(key)) {
            BigDecimal price = (BigDecimal)model.getValue("price");
            BigDecimal priceUpPer = (BigDecimal)model.getValue("priceupper");
            BigDecimal priceDownPer = (BigDecimal)model.getValue("pricedownper");
            BigDecimal priceandtax = (BigDecimal)model.getValue("priceandtax");
            BigDecimal priceandtaxUpPer = (BigDecimal)model.getValue("priceandtaxupper");
            BigDecimal priceandtaxDownPer = (BigDecimal)model.getValue("priceandtaxdownper");
            Object taxrate = model.getValue("taxrate");
            BigDecimal pricefloor = (BigDecimal)model.getValue("pricefloor");
            BigDecimal pricefloorUpPer = (BigDecimal)model.getValue("pricefloorupper");
            BigDecimal pricefloorDownPer = (BigDecimal)model.getValue("pricefloordownper");
            BigDecimal priceceiling = (BigDecimal)model.getValue("priceceiling");
            BigDecimal priceceilingUpPer = (BigDecimal)model.getValue("priceceilingupper");
            BigDecimal priceceilingDownPer = (BigDecimal)model.getValue("priceceilingdownper");
            Object priceeffectdate = model.getValue("priceeffectdate");
            Object priceexpirydate = model.getValue("priceexpirydate");
            if (taxrate == null && priceeffectdate == null && priceexpirydate == null && BigDecimal.ZERO.compareTo(price) == 0 && BigDecimal.ZERO.compareTo(priceUpPer) == 0 && BigDecimal.ZERO.compareTo(priceDownPer) == 0 && BigDecimal.ZERO.compareTo(priceandtax) == 0 && BigDecimal.ZERO.compareTo(priceandtaxUpPer) == 0 && BigDecimal.ZERO.compareTo(priceandtaxDownPer) == 0 && BigDecimal.ZERO.compareTo(pricefloor) == 0 && BigDecimal.ZERO.compareTo(pricefloorUpPer) == 0 && BigDecimal.ZERO.compareTo(pricefloorDownPer) == 0 && BigDecimal.ZERO.compareTo(priceceiling) == 0 && BigDecimal.ZERO.compareTo(priceceilingUpPer) == 0 && BigDecimal.ZERO.compareTo(priceceilingDownPer) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8c03\u6574\u4e00\u4e2a\u5b57\u6bb5\u503c\u3002", (String)"PriceBatchAdjustTplPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("STOP".equals(this.getPageCache().get("STOP"))) {
            return;
        }
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "istax": {
                if (((Boolean)newValue).booleanValue()) {
                    model.setValue("price", (Object)BigDecimal.ZERO);
                    model.setValue("priceupper", (Object)BigDecimal.ZERO);
                    model.setValue("pricedownper", (Object)BigDecimal.ZERO);
                    break;
                }
                model.setValue("priceandtax", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxupper", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxdownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "price": 
            case "priceupper": 
            case "pricedownper": {
                BigDecimal price = (BigDecimal)newValue;
                if (price.compareTo(BigDecimal.ZERO) == 0) break;
                String adjPrice = (String)model.getValue("priceadjmode");
                this.numberLimitsCheck(adjPrice, price, propName);
                Boolean istax = (Boolean)model.getValue("istax");
                if (!istax.booleanValue()) break;
                model.setValue("price", (Object)BigDecimal.ZERO);
                model.setValue("priceupper", (Object)BigDecimal.ZERO);
                model.setValue("pricedownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "priceandtax": 
            case "priceandtaxupper": 
            case "priceandtaxdownper": {
                BigDecimal priceAndTax = (BigDecimal)newValue;
                if (priceAndTax.compareTo(BigDecimal.ZERO) == 0) break;
                String adjPriceAndTax = (String)model.getValue("priceandtaxadjmode");
                this.numberLimitsCheck(adjPriceAndTax, priceAndTax, propName);
                Boolean istax = (Boolean)model.getValue("istax");
                if (istax.booleanValue()) break;
                model.setValue("priceandtax", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxupper", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxdownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "pricefloor": 
            case "pricefloorupper": 
            case "pricefloordownper": {
                BigDecimal priceFloor = (BigDecimal)newValue;
                if (priceFloor.compareTo(BigDecimal.ZERO) == 0) break;
                String adjPriceFloor = (String)model.getValue("priceflooradjmode");
                this.numberLimitsCheck(adjPriceFloor, priceFloor, propName);
                break;
            }
            case "priceceiling": 
            case "priceceilingupper": 
            case "priceceilingdownper": {
                BigDecimal priceCeiling = (BigDecimal)newValue;
                if (priceCeiling.compareTo(BigDecimal.ZERO) == 0) break;
                String adjPriceCeiling = (String)model.getValue("priceceilingadjmode");
                this.numberLimitsCheck(adjPriceCeiling, priceCeiling, propName);
                break;
            }
            case "priceadjmode": {
                model.setValue("price", (Object)BigDecimal.ZERO);
                model.setValue("priceupper", (Object)BigDecimal.ZERO);
                model.setValue("pricedownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "priceandtaxadjmode": {
                model.setValue("priceandtax", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxupper", (Object)BigDecimal.ZERO);
                model.setValue("priceandtaxdownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "priceceilingadjmode": {
                model.setValue("priceceiling", (Object)BigDecimal.ZERO);
                model.setValue("priceceilingupper", (Object)BigDecimal.ZERO);
                model.setValue("priceceilingdownper", (Object)BigDecimal.ZERO);
                break;
            }
            case "priceflooradjmode": {
                model.setValue("pricefloor", (Object)BigDecimal.ZERO);
                model.setValue("pricefloorupper", (Object)BigDecimal.ZERO);
                model.setValue("pricefloordownper", (Object)BigDecimal.ZERO);
                break;
            }
        }
    }

    private void numberLimitsCheck(String key, BigDecimal value, String propName) {
        if (key == null) {
            return;
        }
        if (value != null && "downpercent".equals(key) && value.compareTo(new BigDecimal(100)) >= 0) {
            this.getModel().setValue(propName, null);
        }
    }
}

