/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.helper.EntityParseHelper;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteNewHelper;
import kd.scmc.plat.formplugin.pricemodel.QuoteSchemePlugin;

public class QuoteFactorPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QuoteSchemePlugin.class);
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String CALLBACK_SOURCEFIELD = "sourcefieldcallback";
    private static final String CALLBACK_CALLBACKQUOTEBILL = "callbackquotebill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit quoteBillField = (BasedataEdit)this.getView().getControl("quotebill");
        quoteBillField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"quotefactorname", CALLBACK_SOURCEFIELD});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (oldValue == null) {
            return;
        }
        if ("quotebill".equals(key)) {
            DynamicObject dy = (DynamicObject)oldValue;
            String numberbill = (String)dy.getPkValue();
            IPageCache pageCache = this.getPageCache();
            pageCache.put("quotebill", numberbill);
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CALLBACK_CALLBACKQUOTEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u3010\u53d6\u4ef7\u5355\u636e\u3011\u5b57\u6bb5\u5c06\u6e05\u7a7a\u53d6\u4ef7\u56e0\u7d20\u5b57\u6bb5\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"QuoteFactorPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "quotebill": {
                QuoteNewHelper.registerQuoteBill((BeforeF7SelectEvent)e);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (c.getKey().equals("quotefactorname")) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("quotebill");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteFactorPlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showSortBillTree();
        }
    }

    private void showSortBillTree() {
        DynamicObject quoteSrcType = (DynamicObject)this.getModel().getValue("quotebill");
        String number = quoteSrcType.getString("number");
        Set<String> propertyChangeFields = this.getPropertyChangeFields(number);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        Map allFields = dataEntityType.getAllFields();
        HashSet<String> numbers = new HashSet<String>();
        for (String s : allFields.keySet()) {
            boolean contains = propertyChangeFields.contains(s);
            if (contains) continue;
            numbers.add(s);
        }
        if (numbers.size() > 0) {
            for (String num : numbers) {
                boolean b = allFields.containsKey(num);
                if (!b) continue;
                allFields.remove(num);
            }
        }
        ArrayList sortFieldsList = new ArrayList();
        ArrayList sortEntryFieldsList = new ArrayList();
        DynamicObject priceSource = (DynamicObject)this.getModel().getValue("quotebill");
        String rootName = priceSource.getString("name");
        String rootNumber = priceSource.getString("number");
        TreeNode root = new TreeNode();
        root.setId(rootNumber);
        root.setText(rootName);
        for (Map.Entry entry : allFields.entrySet()) {
            String sourceSignName_origin;
            String sourceSignName;
            String sourceSign;
            HashMap<String, String> StringMap;
            IDataEntityProperty field = (IDataEntityProperty)entry.getValue();
            String parentName = field.getParent().getName();
            IDataEntityType parent = field.getParent();
            if (parent instanceof SubEntryType) continue;
            if (!number.equals(parentName)) {
                StringMap = new HashMap<String, String>(2);
                sourceSign = parentName.concat(".").concat(field.getName());
                sourceSignName = field.getParent().getDisplayName().getLocaleValue().concat(".").concat(field.getDisplayName().getLocaleValue());
                log.info("\u5b57\u6bb5\u5168\u8def\u5f84===".concat(sourceSignName));
                sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===".concat(sourceSignName_origin));
                StringMap.put("number", sourceSign);
                StringMap.put("name", sourceSignName);
                sortEntryFieldsList.add(StringMap);
                continue;
            }
            StringMap = new HashMap(2);
            sourceSign = field.getName();
            sourceSignName = field.getDisplayName().getLocaleValue();
            log.info("\u5b57\u6bb5\u5168\u8def\u5f84===".concat(sourceSignName));
            sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
            log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===".concat(sourceSignName_origin));
            StringMap.put("number", sourceSign);
            StringMap.put("name", sourceSignName);
            sortFieldsList.add(StringMap);
        }
        ArrayList<Map<String, String>> allSortFieldsList = new ArrayList<Map<String, String>>(sortFieldsList.size() + sortEntryFieldsList.size());
        allSortFieldsList.addAll(sortFieldsList);
        allSortFieldsList.addAll(sortEntryFieldsList);
        if (allSortFieldsList.size() != 0) {
            this.buildSortFieldsTree(allSortFieldsList);
        }
    }

    private void buildSortFieldsTree(List<Map<String, String>> allSortFieldsList) {
        DynamicObject priceSource = (DynamicObject)this.getModel().getValue("quotebill");
        String rootName = priceSource.getString("name");
        String rootNumber = priceSource.getString("number");
        TreeNode root = new TreeNode();
        root.setId(rootNumber);
        root.setText(rootName);
        ArrayList<String> entryNumbers = new ArrayList<String>();
        for (Map<String, String> sortFields : allSortFieldsList) {
            TreeNode grandSon;
            TreeNode child;
            String nodeNumber = sortFields.get("number");
            String nodeName = sortFields.get("name");
            String[] splitNumber = nodeNumber.split("\\.");
            if (splitNumber.length == 1) {
                TreeNode child2 = new TreeNode();
                child2.setText(nodeName);
                child2.setId(nodeNumber);
                root.addChild(child2);
                continue;
            }
            if (splitNumber.length <= 1) continue;
            String[] splitName = nodeName.split("\\.");
            if (entryNumbers.contains(splitNumber[0])) {
                child = root.getTreeNodeByText(splitName[0], 1);
                grandSon = new TreeNode();
                grandSon.setId(splitNumber[1]);
                grandSon.setText(splitName[1]);
                log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID===".concat(splitNumber[1]));
                log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84===".concat(splitName[1]));
                child.addChild(grandSon);
                continue;
            }
            child = new TreeNode();
            child.setText(splitName[0]);
            child.setId(splitNumber[0]);
            root.addChild(child);
            grandSon = new TreeNode();
            grandSon.setId(splitNumber[1]);
            grandSon.setText(splitName[1]);
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID0===".concat(splitNumber[0]));
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f840===".concat(splitName[0]));
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID===".concat(splitNumber[1]));
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84===".concat(splitName[1]));
            child.addChild(grandSon);
            entryNumbers.add(splitNumber[0]);
        }
        root.setIsOpened(true);
        if (root.getChildren() == null) {
            return;
        }
        this.showSrcFieldForm(root);
    }

    private Set<String> getPropertyChangeFields(String entityName) {
        HashSet<String> keySet = new HashSet<String>();
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return keySet;
        }
        MetaCategory metaCategory = MetaCategory.Form;
        String id = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)metaCategory);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return keySet;
        }
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)metaCategory);
        List items = ((FormMetadata)metadata).getItems();
        if (items == null) {
            return keySet;
        }
        for (ControlAp item : items) {
            if (!(item instanceof FieldAp) || !((FieldAp)item).isFireUpdEvt() || item.isHidden()) continue;
            keySet.add(item.getKey());
        }
        return keySet;
    }

    private void showSrcFieldForm(TreeNode billNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SOURCEFIELD));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        if (CALLBACK_SOURCEFIELD.equals(actionId)) {
            String number = (String)e.getReturnData();
            if (StringUtils.isEmpty((CharSequence)actionId) || number == null) {
                return;
            }
            int entirety = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object quotebill = this.getModel().getValue("quotebill");
            String bill = (String)((DynamicObject)quotebill).getPkValue();
            MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)bill);
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(false);
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)number);
            this.getModel().setValue("quotefactorname", (Object)fieldCaption, entirety);
            this.getModel().setValue("quotefactornumber", (Object)number, entirety);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (CALLBACK_CALLBACKQUOTEBILL.equals(actionId)) {
            if ("Yes".equals(event.getResultValue())) {
                DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject entity : entitys) {
                    entity.set("quotefactorname", null);
                    entity.set("quotefactornumber", null);
                }
                this.getModel().deleteEntryData("entryentity");
                this.getModel().createNewEntryRow("entryentity");
            } else if ("No".equals(event.getResultValue())) {
                IPageCache pageCache = this.getPageCache();
                String quotebill = pageCache.get("quotebill");
                this.getModel().beginInit();
                this.getModel().setValue("quotebill", (Object)quotebill);
                this.getModel().endInit();
                this.getView().updateView("quotebill");
            }
        }
    }
}

