/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.plat.common.consts.pricemodel.QuoteLogConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteLogViewConst;
import kd.scmc.plat.common.enums.price.LogTypeEnum;

public class QuoteLogQueryPlugin
extends AbstractReportListDataPlugin {
    private static final List<String> billKeys = Arrays.asList("id", "entryid");
    private static final List<String> logKeys = Arrays.asList("quotebillid", "quotebillentryid");
    private static final String sm_tpl = "/S39P74P5==6";
    private static final String sm_basetpl = "/MN8E05AKBSU";

    public DataSet query(ReportQueryParam queryParam, Object arg1) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection quoteBills = filterInfo.getDynamicObjectCollection("quotebillfield");
        ArrayList<String> billNoList = new ArrayList<String>();
        String billNoStr = filterInfo.getString("quotebillnofield");
        if (StringUtils.isNotEmpty((CharSequence)billNoStr.trim())) {
            String[] billNos;
            for (String subBillNo : billNos = billNoStr.split(",")) {
                String[] subBillNos;
                for (String billNo : subBillNos = subBillNo.split("\uff0c")) {
                    billNoList.add(billNo);
                }
            }
        }
        ArrayList<Date> quoteBillDates = new ArrayList<Date>(2);
        Date quotebillDate_start = filterInfo.getDate("quotedatefield_startdate");
        Date quoteDate_end = filterInfo.getDate("quotedatefield_enddate");
        if (quotebillDate_start != null) {
            quoteBillDates.add(quotebillDate_start);
            quoteBillDates.add(quoteDate_end);
        }
        ArrayList<Long> materialList = new ArrayList<Long>();
        DynamicObjectCollection materialColl = filterInfo.getDynamicObjectCollection("materialfield");
        if (materialColl != null && materialColl.size() > 0) {
            materialColl.forEach(m -> materialList.add(m.getLong("masterid")));
        }
        ArrayList<Date> quoteStartTimes = new ArrayList<Date>(2);
        Date quoteStartTime_start = filterInfo.getDate("quotestarttimefield_start");
        Date quoteStartTime_end = filterInfo.getDate("quotestarttimefield_end");
        if (quoteStartTime_start != null) {
            quoteStartTimes.add(quoteStartTime_start);
            quoteStartTimes.add(quoteStartTime_end);
        }
        DataSet totaldataSet4AllBill = null;
        for (DynamicObject quoteBill : quoteBills) {
            String quoteBillType = (String)quoteBill.getPkValue();
            DataSet quoteLogDataSet = this.queryQuoteLog4SingleQuoteType(filterInfo, quoteStartTimes, quoteBillType);
            HashSet<Long> quoteBillIDs = new HashSet<Long>();
            try (DataSet quoteLogDataSetCopy = quoteLogDataSet.copy();){
                for (Row row : quoteLogDataSetCopy) {
                    Long quoteBillID = row.getLong("quotebillid");
                    quoteBillIDs.add(quoteBillID);
                }
            }
            DataSet quoteBillDataSet = this.queryBillInfo4SingleQuoteType(billNoList, quoteBillDates, materialList, quoteBillType, quoteBillIDs);
            JoinDataSet joinDataSet = quoteBillDataSet.join(quoteLogDataSet, JoinType.INNER);
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            for (int i = 0; i < billKeys.size(); ++i) {
                joinDataSet = joinDataSet.on(billKeys.get(i), logKeys.get(i)).hint(hint);
            }
            DataSet totalLogDataSet = joinDataSet.select(QuoteLogViewConst.getQuotelogviewBillfields(), QuoteLogViewConst.getQuotelogviewLogfields()).finish();
            DataSet quoteExpLogDataSet = this.queryQuoteExpLog4SingleQuoteType(filterInfo, quoteStartTimes, quoteBillType);
            JoinDataSet joinExpDataSet = quoteExpLogDataSet.join(quoteBillDataSet, JoinType.LEFT);
            for (int i = 0; i < billKeys.size(); ++i) {
                joinExpDataSet = joinExpDataSet.on(logKeys.get(i), billKeys.get(i)).hint(hint);
            }
            DataSet totalExpLogDataSet = joinExpDataSet.select(QuoteLogViewConst.getQuotelogviewLogfields(), QuoteLogViewConst.getQuotelogviewBillfields()).finish();
            totalExpLogDataSet = totalExpLogDataSet.select(QuoteLogViewConst.getQuotelogviewAllfields());
            DataSet totalDataSet = totalLogDataSet.union(totalExpLogDataSet);
            if (totaldataSet4AllBill == null) {
                totaldataSet4AllBill = totalDataSet;
                continue;
            }
            totaldataSet4AllBill = totaldataSet4AllBill.union(totalDataSet);
        }
        if (totaldataSet4AllBill != null) {
            totaldataSet4AllBill = totaldataSet4AllBill.orderBy(QuoteLogViewConst.getORDERKEYS().toArray(new String[QuoteLogViewConst.getORDERKEYS().size()]));
        }
        return totaldataSet4AllBill;
    }

    private DataSet queryBillInfo4SingleQuoteType(List<String> billNoList, List<Date> quoteBillDates, List<Long> materialList, String quoteBillType, Set<Long> quoteBillIds) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBillType);
        Map allfields = headType.getAllFields();
        Map allEntities = headType.getAllEntities();
        String billNoField = "billno";
        if (headType instanceof BasedataEntityType) {
            billNoField = "number";
        }
        ArrayList<QFilter> quoteBillfilters = new ArrayList<QFilter>();
        QFilter billIDFilter = new QFilter("id", "in", quoteBillIds);
        quoteBillfilters.add(billIDFilter);
        if (billNoList.size() > 0) {
            QFilter billNoFilter = new QFilter(billNoField, "in", billNoList);
            quoteBillfilters.add(billNoFilter);
        }
        String dateField = null;
        if (allfields.containsKey("bizdate") || allfields.containsKey("biztime")) {
            dateField = headType.getInheritPath().contains(sm_tpl) || headType.getInheritPath().contains(sm_basetpl) ? "bizdate" : "biztime";
            if (quoteBillDates.size() > 0) {
                QFilter quotebillDateStartFilter = new QFilter(dateField, ">=", (Object)quoteBillDates.get(0));
                QFilter quotebillDateEndFilter = new QFilter(dateField, "<=", (Object)quoteBillDates.get(1));
                quoteBillfilters.add(quotebillDateStartFilter);
                quoteBillfilters.add(quotebillDateEndFilter);
            }
        }
        if (materialList.size() > 0 && allfields.containsKey("material")) {
            QFilter materialFilter = new QFilter("billentry.material.masterid", "in", materialList);
            quoteBillfilters.add(materialFilter);
        }
        String selectBillFields = this.getQuoteBillSelector(billNoField, dateField, allfields);
        DataSet quoteBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)quoteBillType, (String)selectBillFields, (QFilter[])quoteBillfilters.toArray(new QFilter[quoteBillfilters.size()]), null);
        return quoteBillDataSet;
    }

    private String getQuoteBillSelector(String billNoField, String dateField, Map<String, IDataEntityProperty> allfields) {
        ArrayList<String> selectorSet = new ArrayList<String>(32);
        selectorSet.add("id");
        selectorSet.add(billNoField + " as " + "quotebillno");
        if (StringUtils.isNotEmpty((CharSequence)dateField)) {
            selectorSet.add(dateField + " as " + "quotebillbizdate");
        } else {
            selectorSet.add("null as " + "quotebillbizdate");
        }
        selectorSet.add("billentry.id as entryid");
        selectorSet.add("billentry.seq as " + "quotebillseq");
        if (allfields.containsKey("material")) {
            selectorSet.add("billentry.material.masterid as " + "materialnum");
            selectorSet.add("billentry.material.masterid as " + "materialname");
        }
        if (allfields.containsKey("unit")) {
            selectorSet.add("billentry.unit as " + "unit");
        }
        if (allfields.containsKey("auxpty")) {
            selectorSet.add("billentry.auxpty as " + "auxpty");
        }
        return String.join((CharSequence)",", selectorSet);
    }

    private DataSet queryQuoteLog4SingleQuoteType(FilterInfo filterInfo, List<Date> quoteStartTimes, String quoteBillType) {
        ArrayList<QFilter> logQFilters = new ArrayList<QFilter>();
        QFilter quoteOrgFitler = new QFilter("quoteorg", "=", filterInfo.getDynamicObject("quoteorgfield").getPkValue());
        logQFilters.add(quoteOrgFitler);
        QFilter quoteBillFitler = new QFilter("quotebill", "=", (Object)quoteBillType);
        logQFilters.add(quoteBillFitler);
        QFilter logTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
        logQFilters.add(logTypeFilter);
        if (quoteStartTimes.size() > 0) {
            QFilter quoteStartTimeFilter_start = new QFilter("quotestarttime", ">=", (Object)quoteStartTimes.get(0));
            QFilter quoteStartTimeFilter_end = new QFilter("quotestarttime", "<=", (Object)quoteStartTimes.get(1));
            logQFilters.add(quoteStartTimeFilter_start);
            logQFilters.add(quoteStartTimeFilter_end);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"plat_quotelog", (String)this.getQuoteLogSelector(), (QFilter[])logQFilters.toArray(new QFilter[logQFilters.size()]), null);
    }

    private DataSet queryQuoteExpLog4SingleQuoteType(FilterInfo filterInfo, List<Date> quoteStartTimes, String quoteBillType) {
        ArrayList<QFilter> logQFilters = new ArrayList<QFilter>();
        QFilter quoteOrgFitler = new QFilter("quoteorg", "=", filterInfo.getDynamicObject("quoteorgfield").getPkValue());
        logQFilters.add(quoteOrgFitler);
        QFilter quoteBillFitler = new QFilter("quotebill", "=", (Object)quoteBillType);
        logQFilters.add(quoteBillFitler);
        QFilter logTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
        logQFilters.add(logTypeFilter);
        if (quoteStartTimes.size() > 0) {
            QFilter quoteStartTimeFilter_start = new QFilter("quotestarttime", ">=", (Object)quoteStartTimes.get(0));
            QFilter quoteStartTimeFilter_end = new QFilter("quotestarttime", "<=", (Object)quoteStartTimes.get(1));
            logQFilters.add(quoteStartTimeFilter_start);
            logQFilters.add(quoteStartTimeFilter_end);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"plat_quotelog", (String)this.getQuoteLogSelector(), (QFilter[])logQFilters.toArray(new QFilter[logQFilters.size()]), null);
    }

    private String getQuoteLogSelector() {
        return String.join((CharSequence)",", QuoteLogConst.getQUOTELOGFIELDS());
    }
}

