/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.DataSetHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.LicenseHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.common.enums.price.QuotePatternEnum;

public class QuoteSchemePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QuoteSchemePlugin.class);
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String CALLBACK_SOURCEFIELD = "sourcefieldcallback";
    private static final String CALLBACK_QUOTEFIELD = "quotefieldcallback";
    private static final String CALLBACK_SORTFIELD = "sortfieldcallback";
    private static final String CHANGESOURCEBILL = "changesourcebill";
    private static final String CHANGEQUOTEBILL = "changequotebill";
    private static final String SELECT_QUOTESOURCE = "quoteSource";
    private static final String SELECT_QUOTE = "quote";
    private static final String SELECT_QUOTESORT = "quoteSort";
    private static List<String> SALBILLS = Arrays.asList("sm_salorder", "im_saloutbill", "sm_quotationbill", "sm_delivernotice");
    private static List<String> PURBILLS = Arrays.asList("pm_purorderbill", "pm_transferbill", "im_purinbill", "pm_vmisettle", "pm_purapplybill", "pm_om_purorderbill", "pm_requirapplybill", "sctm_scpo");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sourcesignname"});
        this.addClickListeners(new String[]{"quotesignname"});
        this.addClickListeners(new String[]{"sortsignname"});
        this.addClickListeners(new String[]{"sourcesetting"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit quoteEntityEdit = (BasedataEdit)this.getView().getControl("quoteentity");
        if (quoteEntityEdit != null) {
            quoteEntityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter listParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "quoteentity": {
                String number = this.getView().getFormShowParameter().getAppId();
                if ("pms".equals(number)) {
                    QFilter addFilter = new QFilter("number", "not in", PURBILLS);
                    listParameter.getListFilterParameter().getQFilters().add(addFilter);
                    break;
                }
                if (!"pmp".equals(number)) break;
                QFilter addFilter = new QFilter("number", "not in", SALBILLS);
                listParameter.getListFilterParameter().getQFilters().add(addFilter);
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map result;
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getAppId();
        String formId = e.getFormShowParameter().getFormId();
        if (e.getFormShowParameter() != null && Boolean.TRUE.equals((result = LicenseHelper.checkLicense((String)appId, (String)formId)).get("isCancel"))) {
            e.setCancelMessage((String)result.get("cancelMessage"));
            e.setCancel(true);
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.sourceBillChanged("pricesourceentity", "filtergridap");
        this.bindUnParseCols("quotesourceconditon", "filtergridap");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMatchFlagEnable();
        boolean a = true;
        boolean b = false;
        this.getModel().setValue("enablematch", (Object)a);
        this.getModel().setDataChanged(b);
        ComboEdit orderEdit = (ComboEdit)this.getControl("order");
        orderEdit.setMustInput(a);
        this.getView().setEnable(Boolean.valueOf(b), new String[]{"use"});
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getFormShowParameter().getAppId())) {
            String number = AppMetadataCache.getAppInfo((String)this.getView().getFormShowParameter().getAppId()).getNumber();
            if ("pms".equals(number)) {
                this.getModel().setValue("use", (Object)"sal");
            } else if ("pmp".equals(number)) {
                this.getModel().setValue("use", (Object)"pur");
            } else {
                this.getModel().setValue("use", (Object)"pur");
            }
        } else {
            this.getModel().setValue("use", (Object)"pur");
        }
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("sourcesignname".equals(c.getKey().toLowerCase())) {
            this.showBillTree("pricesourceentity");
        }
        if ("quotesignname".equals(c.getKey().toLowerCase())) {
            this.showBillTree("quoteentity");
        }
        if ("sortsignname".equals(c.getKey().toLowerCase())) {
            this.showSortBillTree();
        }
        if ("sourcesetting".equals(c.getKey())) {
            this.showCondition();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase("btnautomatchfield")) {
            this.autoMatchFields();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "pricesourceentity": {
                DynamicObject dy = (DynamicObject)oldValue;
                if (oldValue != null) {
                    this.getPageCache().put("pricesourceentityOldValue", dy.get("number").toString());
                    this.confirmSourceChange();
                    break;
                }
                this.sourceBillChanged("pricesourceentity", "filtergridap");
                this.bindUnParseCols("quotesourceconditon", "filtergridap");
                break;
            }
            case "quoteentity": {
                DynamicObject dy2 = (DynamicObject)oldValue;
                if (oldValue == null) break;
                this.getPageCache().put("priceQuoteOldValue", dy2.get("number").toString());
                this.confirmQuoteChange();
                break;
            }
            case "sourcesign": {
                break;
            }
            case "quotesign": {
                break;
            }
            case "quotepattern": {
                this.changeQuotePattern(newValue.toString(), row);
                break;
            }
            case "sourcesignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sourcesign", null, row);
                break;
            }
            case "quotesignname": {
                if (newValue == null || !StringUtils.isEmpty((CharSequence)newValue.toString())) break;
                this.getModel().setValue("quotesign", null, row);
                break;
            }
            case "sortsignname": {
                if (newValue == null || !StringUtils.isBlank((CharSequence)newValue.toString())) break;
                this.getModel().setValue("sortsign", null, row);
                break;
            }
            case "enablematch": {
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    private void setMatchFlagEnable() {
        int rows = this.getModel().getEntryEntity("entryentity").getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (!QuotePatternEnum.RESULT.getValue().equals(this.getModel().getValue("quotepattern", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"matchflag"});
        }
    }

    private void confirmSourceChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        if (mappingEntry.size() > 0 && this.confirmMappingField().booleanValue() || StringUtils.isNotEmpty((CharSequence)this.getFilterGridCondition("filtergridap")) || this.getModel().getEntryRowCount("pricesortentity") > 0) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGESOURCEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u3010\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3011\u5b57\u6bb5\u5c06\u4f1a\u6e05\u7a7a\u5b57\u6bb5\u6620\u5c04.\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u503c\u3001\u5176\u4ed6\u6761\u4ef6\u548c\u4ef7\u683c\u6392\u5e8f\u3002\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_4", (String)"scmc-plat-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    private void confirmQuoteChange() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        if (mappingEntry.size() > 0 && this.confirmMappingField().booleanValue()) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CHANGEQUOTEBILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6216\u6e05\u9664\u3010\u53d6\u4ef7\u5355\u636e\u3011\u5b57\u6bb5\u5c06\u4f1a\u6e05\u7a7a\u5b57\u6bb5\u6620\u5c04.\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u503c\u3002\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemePlugin_9", (String)"scmc-plat-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        }
    }

    private Boolean confirmMappingField() {
        DynamicObjectCollection mappingEntry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : mappingEntry) {
            String source = entry.getString("sourcesign");
            String quote = entry.getString("quotesign");
            if (!StringUtils.isNotBlank((CharSequence)source) && !StringUtils.isNotBlank((CharSequence)quote)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            IDataModel model = this.getModel();
            String sourceFs = this.getFilterGridCondition("filtergridap");
            model.setValue("quotesourceconditon", (Object)sourceFs);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "changesourcebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < entitys.size(); ++i) {
                        ((DynamicObject)entitys.get(i)).set("sourcesignname", null);
                        ((DynamicObject)entitys.get(i)).set("sourcesign", null);
                    }
                    this.getView().updateView("entryentity");
                    this.getModel().deleteEntryData("pricesortentity");
                    this.getModel().createNewEntryRow("pricesortentity");
                    this.getModel().setValue("quotesourceconditon", null);
                    this.sourceBillChanged("pricesourceentity", "filtergridap");
                    this.bindUnParseCols("quotesourceconditon", "filtergridap");
                    this.setMatchFlagEnable();
                    break;
                }
                String pricesourceentityOldValue = this.getPageCache().get("pricesourceentityOldValue");
                this.getModel().beginInit();
                this.getModel().setValue("pricesourceentity", (Object)pricesourceentityOldValue);
                this.getModel().endInit();
                this.getView().updateView("pricesourceentity");
                break;
            }
            case "changequotebill": {
                if ("Yes".equals(evt.getResultValue())) {
                    DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
                    int size = entitys.size();
                    for (int i = 0; i < size; ++i) {
                        ((DynamicObject)entitys.get(i)).set("quotesignname", null);
                        ((DynamicObject)entitys.get(i)).set("quotesign", null);
                    }
                    this.getView().updateView("entryentity");
                    this.setMatchFlagEnable();
                    break;
                }
                String pricequoteOldValue = this.getPageCache().get("priceQuoteOldValue");
                this.getModel().beginInit();
                this.getModel().setValue("quoteentity", (Object)pricequoteOldValue);
                this.getModel().endInit();
                this.getView().updateView("quoteentity");
                break;
            }
        }
    }

    private String getFilterGridCondition(String gridName) {
        FilterGrid grid = (FilterGrid)this.getControl(gridName);
        if (grid == null) {
            return "";
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    private void changeQuotePattern(String newValue, int row) {
        this.getModel().setValue("quotesign", null, row);
        this.getModel().setValue("quotesignname", null, row);
        if (QuotePatternEnum.CONDITION.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"matchflag"});
            if (this.getModel().getValue("matchflag") == null) {
                this.getView().setEnable(Boolean.TRUE, row, new String[]{"matchflag"});
                this.getModel().setValue("matchflag", (Object)"A", row);
            }
        } else if (QuotePatternEnum.RESULT.getValue().equals(newValue)) {
            this.getModel().setValue("matchflag", null, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"matchflag"});
        }
    }

    private void sourceBillChanged(String billName, String filterGridap) {
        DynamicObject bill = (DynamicObject)this.getModel().getValue(billName);
        MainEntityType dataEntityType = null;
        if (bill != null) {
            String number = bill.getString("number");
            dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        }
        this.setCols4FilterGrid(dataEntityType, filterGridap);
    }

    private void setCols4FilterGrid(MainEntityType entityType, String controlName) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(controlName);
        EntityTypeUtil helper = new EntityTypeUtil();
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            List cols = helper.getFilterColumns((IDataEntityType)entityType);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(controlName);
    }

    private void bindUnParseCols(String priceConditionField, String gridap) {
        String priceSourceFsStr = this.getModel().getDataEntity().getString(priceConditionField);
        FilterCondition condition = QuoteHelper.convertStringToCondition((String)priceSourceFsStr);
        if (condition == null) {
            condition = new FilterCondition();
        }
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridap);
        reserveFilter.SetValue(condition);
    }

    private void showSortBillTree() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        if (null == entries) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u3002", (String)"QuoteSchemePlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject quoteSrcType = (DynamicObject)this.getModel().getValue("pricesourceentity");
        if (quoteSrcType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_6", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = quoteSrcType.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        Map allFields = dataEntityType.getAllFields();
        ArrayList sortFieldsList = new ArrayList();
        ArrayList sortEntryFieldsList = new ArrayList();
        allFields.forEach((k, v) -> {
            Class propertyType = v.getPropertyType();
            if (Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType)) {
                String parentName = v.getParent().getName();
                if (!number.equals(parentName) && !parentName.contains("lk")) {
                    String[] entryFields = new String[2];
                    String sourceSign = parentName.concat(".").concat(v.getName());
                    String sourceSignName = v.getParent().getDisplayName().getLocaleValue().concat(".").concat(v.getDisplayName().getLocaleValue());
                    log.info("\u5b57\u6bb5\u5168\u8def\u5f84===" + sourceSignName);
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===" + sourceSignName_origin);
                    entryFields[0] = sourceSign;
                    entryFields[1] = sourceSignName;
                    sortEntryFieldsList.add(entryFields);
                } else {
                    String[] fields = new String[2];
                    String sourceSign = v.getName();
                    String sourceSignName = v.getDisplayName().getLocaleValue();
                    log.info("\u5b57\u6bb5\u5168\u8def\u5f84===" + sourceSignName);
                    String sourceSignName_origin = EntityParseHelper.buildPropFullCaption((EntityType)dataEntityType, (String)sourceSign);
                    log.info("\u5b57\u6bb5\u539f\u59cb\u5168\u8def\u5f84===" + sourceSignName_origin);
                    fields[0] = sourceSign;
                    fields[1] = sourceSignName;
                    sortFieldsList.add(fields);
                }
            }
        });
        ArrayList<String[]> allSortFieldsList = new ArrayList<String[]>(sortFieldsList.size() + sortEntryFieldsList.size());
        allSortFieldsList.addAll(sortFieldsList);
        allSortFieldsList.addAll(sortEntryFieldsList);
        if (allSortFieldsList.size() != 0) {
            this.buildSortFieldsTree(allSortFieldsList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u6765\u6e90\u5355\u636e\u4e2d\u6ca1\u6709\u53ef\u53c2\u4e0e\u6392\u5e8f\u7684\u5b57\u6bb5\uff1a\u53c2\u4e0e\u6392\u5e8f\u7684\u5b57\u6bb5\u5fc5\u987b\u662f\u6570\u503c\u578b\u6216\u65e5\u671f\u578b\u3002", (String)"QuoteSchemePlugin_3", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildSortFieldsTree(List<String[]> allSortFieldsList) {
        DynamicObject priceSource = (DynamicObject)this.getModel().getValue("pricesourceentity");
        String rootName = priceSource.getString("name");
        String rootNumber = priceSource.getString("number");
        TreeNode root = new TreeNode();
        root.setId(rootNumber);
        root.setText(rootName);
        ArrayList<String> entryNumbers = new ArrayList<String>();
        for (String[] sortFields : allSortFieldsList) {
            TreeNode grandSon;
            TreeNode child;
            String nodeNumber = sortFields[0];
            String nodeName = sortFields[1];
            String[] splitNumber = nodeNumber.split("\\.");
            if (splitNumber.length == 1) {
                TreeNode child2 = new TreeNode();
                child2.setText(nodeName);
                child2.setId(nodeNumber);
                root.addChild(child2);
                continue;
            }
            if (splitNumber.length <= 1) continue;
            String[] splitName = nodeName.split("\\.");
            if (entryNumbers.contains(splitNumber[0])) {
                child = root.getTreeNodeByText(splitName[0], 1);
                grandSon = new TreeNode();
                grandSon.setId(splitNumber[1]);
                grandSon.setText(splitName[1]);
                log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID===" + splitNumber[1]);
                log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84===" + splitName[1]);
                child.addChild(grandSon);
                continue;
            }
            child = new TreeNode();
            child.setText(splitName[0]);
            child.setId(splitNumber[0]);
            root.addChild(child);
            grandSon = new TreeNode();
            grandSon.setId(splitNumber[1]);
            grandSon.setText(splitName[1]);
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID0===" + splitNumber[0]);
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f840===" + splitName[0]);
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84ID===" + splitNumber[1]);
            log.info("\u5b57\u6bb5\u5206\u89e3\u8def\u5f84===" + splitName[1]);
            child.addChild(grandSon);
            entryNumbers.add(splitNumber[0]);
        }
        root.setIsOpened(true);
        if (root.getChildren() == null) {
            return;
        }
        this.showSrcFieldForm(root, "pricesortentity");
    }

    public void showBillTree(String selectBill) {
        TreeNode treeNode;
        String currentBill;
        DynamicObject bill = (DynamicObject)this.getModel().getValue(selectBill);
        String anotherBill = null;
        if ("pricesourceentity".equals(selectBill)) {
            currentBill = "pricesourceentity";
            anotherBill = "quoteentity";
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            currentBill = "quoteentity";
            anotherBill = "pricesourceentity";
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteSchemePlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(currentBill);
        String sourceNumber = sourceBill.getString("number");
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)sourceNumber);
        DynamicObject targetBill = (DynamicObject)this.getModel().getValue(anotherBill);
        String targetFieldValue = "";
        MainEntityType targetEntityType = null;
        if (targetBill == null) {
            return;
        }
        String targetNumber = targetBill.getString("number");
        targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetNumber);
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        targetFieldValue = (String)this.getModel().getValue("pricesourceentity".equals(currentBill) ? "quotesign" : "sourcesign", row);
        boolean includePKField = true;
        if (StringUtils.isEmpty((CharSequence)sourceEntityType.getAlias())) {
            includePKField = false;
        }
        if ("".equals(targetFieldValue) || targetFieldValue == null) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(includePKField);
            option.setOnlyPhysicsField(false);
            treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
        } else {
            IDataEntityProperty targetProperty = DataSetHelper.findPropertys((EntityType)targetEntityType, (String)(targetFieldValue = this.subEntryField(targetFieldValue, targetEntityType)));
            if (targetProperty == null) {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(includePKField);
                option.setOnlyPhysicsField(false);
                treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
            } else {
                Boolean enablematch = (Boolean)this.getModel().getValue("enablematch");
                if (enablematch.booleanValue()) {
                    BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceEntityType, null, targetProperty);
                    parameter.setIncludePKField(includePKField);
                    parameter.setOnlyPhysicsField(false);
                    if (targetProperty instanceof LongProp) {
                        PropTreeBuildOption option = new PropTreeBuildOption(null, LongProp.class);
                        option.addMatchedClassTypes(BigIntProp.class);
                        option.setOnlyPhysicsField(false);
                        option.setIncludePKField(includePKField);
                        treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
                    } else {
                        treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                    }
                } else {
                    PropTreeBuildOption option = new PropTreeBuildOption();
                    option.setIncludePKField(includePKField);
                    option.setOnlyPhysicsField(false);
                    treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
                }
            }
        }
        this.removeIDNodeFromTree(treeNode, sourceEntityType);
        this.showSrcFieldForm(treeNode, selectBill);
    }

    private void showSrcFieldForm(TreeNode billNode, String billName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        if ("pricesourceentity".equals(billName)) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SOURCEFIELD));
        } else if ("quoteentity".equals(billName)) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_QUOTEFIELD));
        } else if ("pricesortentity".equals(billName)) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SORTFIELD));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        if (returnData instanceof String) {
            String returnDataStr = (String)returnData;
            String[] returnDataArray = returnDataStr.split("\\.");
            DynamicObject quoteSrcType = (DynamicObject)this.getModel().getValue("pricesourceentity");
            DynamicObject quoteQuoteType = (DynamicObject)this.getModel().getValue("quoteentity");
            if (returnDataArray != null && returnDataArray.length > 0) {
                if (quoteSrcType != null && quoteSrcType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if ("billhead".equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                } else if (quoteQuoteType != null && quoteQuoteType.get("id").equals(returnDataArray[returnDataArray.length - 1])) {
                    returnData = "id";
                }
            }
        }
        switch (actionId) {
            case "sourcefieldcallback": {
                this.setCallBackResult(returnData, SELECT_QUOTESOURCE, "pricesourceentity");
                break;
            }
            case "quotefieldcallback": {
                this.setCallBackResult(returnData, SELECT_QUOTE, "quoteentity");
                break;
            }
            case "sortfieldcallback": {
                this.setCallBackResult(returnData, SELECT_QUOTESORT, "pricesourceentity");
                break;
            }
            case "sourcesetting": {
                FilterCondition condition = QuoteHelper.convertFullStringToCondition((String)((String)returnData));
                if (condition == null) {
                    condition = new FilterCondition();
                }
                this.getModel().setValue("quotesourceconditon", (Object)SerializationUtils.toJsonString((Object)condition));
                this.getModel().setValue("quoteconditon", returnData);
                this.bindUnParseCols("quotesourceconditon", "filtergridap");
                break;
            }
        }
    }

    private void setCallBackResult(Object returnData, String selectPart, String billModel) {
        String fieldId = returnData.toString();
        Object srcBill = this.getModel().getValue(billModel);
        String srcBillId = (String)((DynamicObject)srcBill).getPkValue();
        MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldId);
        String[] split = fieldId.split("\\.");
        String tempFieldId = split[0];
        IDataEntityProperty findProperty = srcBillMainType.findProperty(tempFieldId);
        boolean isEntryField = false;
        if (findProperty != null) {
            String parentName = findProperty.getParent().getName();
            fieldId = this.getEntryFullField(srcBillMainType, fieldId, srcBillId, parentName);
            if (!srcBillId.equals(parentName)) {
                isEntryField = true;
            }
        }
        String[] fieldIds = fieldId.split("\\.");
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        String quotePattern = (String)this.getModel().getValue("quotepattern", row);
        if (SELECT_QUOTESOURCE.equals(selectPart) || SELECT_QUOTE.equals(selectPart) && QuotePatternEnum.CONDITION.getValue().equals(quotePattern)) {
            if (fieldIds != null && fieldIds.length > 4) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e\u56db\u7ea7\u7684\u5b57\u6bb5\u3002", (String)"QuoteSchemePlugin_5", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            }
        } else if (SELECT_QUOTE.equals(selectPart) && QuotePatternEnum.RESULT.getValue().equals(quotePattern) && (isEntryField && fieldIds.length > 2 || !isEntryField && fieldIds.length > 1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u672c\u8eab\u7684\u5b57\u6bb5\u3002", (String)"QuoteSchemePlugin_7", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
        }
        if (SELECT_QUOTESOURCE.equals(selectPart)) {
            this.getModel().setValue("sourcesignname", (Object)fieldCaption, row);
            this.getModel().setValue("sourcesign", (Object)fieldId, row);
        } else if (SELECT_QUOTE.equals(selectPart)) {
            this.getModel().setValue("quotesignname", (Object)fieldCaption, row);
            this.getModel().setValue("quotesign", (Object)fieldId, row);
        } else if (SELECT_QUOTESORT.equals(selectPart)) {
            row = this.getModel().getEntryCurrentRowIndex("pricesortentity");
            this.getModel().setValue("sortsignname", (Object)fieldCaption, row);
            this.getModel().setValue("sortsign", (Object)fieldId, row);
            this.getModel().setValue("order", (Object)"A", row);
        }
    }

    public void autoMatchFields() {
        DynamicObject source = (DynamicObject)this.getModel().getValue("pricesourceentity");
        DynamicObject target = (DynamicObject)this.getModel().getValue("quoteentity");
        if (source == null || target == null) {
            return;
        }
        String sourceNumber = source.getString("number");
        String targetNumber = target.getString("number");
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)sourceNumber);
        MainEntityType tgtMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String targetFieldKey;
            String sourceFieldKey = (String)this.getModel().getValue("sourcesign", rowIndex);
            if (StringUtils.isBlank((CharSequence)sourceFieldKey) || StringUtils.isNotBlank((CharSequence)(targetFieldKey = (String)this.getModel().getValue("quotesign", rowIndex)))) continue;
            String[] split = sourceFieldKey.split("\\.");
            String tempSourceFieldKey = sourceFieldKey;
            if (split.length > 1) {
                tempSourceFieldKey = split[1];
            }
            DynamicProperty sourceField = (DynamicProperty)srcMainType.findProperty(tempSourceFieldKey);
            DynamicProperty targetField = (DynamicProperty)tgtMainType.findProperty(tempSourceFieldKey);
            if (targetField == null || !targetField.getClass().isInstance(sourceField) || !StringUtils.isNotBlank((CharSequence)sourceField.getAlias())) continue;
            String fieldId = targetField.getName();
            IDataEntityProperty findProperty = tgtMainType.findProperty(fieldId);
            if (findProperty != null) {
                String parentName = findProperty.getParent().getName();
                fieldId = this.getEntryFullField(tgtMainType, fieldId, targetNumber, parentName);
            }
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)targetField);
            this.getModel().setValue("quotesign", (Object)fieldId, rowIndex);
            this.getModel().setValue("quotesignname", (Object)targetFieldName, rowIndex);
        }
    }

    private String subEntryField(String fieldKey, MainEntityType mainType) {
        IDataEntityProperty tempProperty;
        if (mainType == null) {
            return fieldKey;
        }
        String[] split = fieldKey.split("\\.");
        if (split.length > 1 && (tempProperty = mainType.findProperty(split[0])) instanceof EntryProp) {
            ArrayList<String> list = new ArrayList<String>(split.length);
            for (int i = 0; i < split.length; ++i) {
                list.add(split[i]);
            }
            list.remove(0);
            fieldKey = StringUtils.join((Object[])list.toArray(), (String)".");
        }
        return fieldKey;
    }

    private void showCondition() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("pricesourceentity");
        if (sourceBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ef7\u683c\u6765\u6e90\u5355\u636e\u3002", (String)"QuoteSchemePlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBill.getString("number"));
        String conditionJson = this.buildFullFormula();
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "sourcesetting");
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put(SOURCETREENODES, fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String buildFullFormula() {
        String conditionJson;
        String fullFormula = (String)this.getModel().getValue("quoteconditon");
        String filterFormula = this.getFilterGridCondition("filtergridap");
        if (StringUtils.isNotEmpty((CharSequence)fullFormula)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)fullFormula, CRCondition.class);
            FilterCondition fc = QuoteHelper.convertStringToCondition((String)filterFormula);
            crCondition.setFilterCondition(fc);
            conditionJson = SerializationUtils.toJsonString((Object)crCondition);
        } else {
            CRCondition crCondition = new CRCondition();
            FilterCondition fc = QuoteHelper.convertStringToCondition((String)filterFormula);
            crCondition.setFilterCondition(fc);
            conditionJson = SerializationUtils.toJsonString((Object)crCondition);
        }
        return conditionJson;
    }

    private void removeIDNodeFromTree(TreeNode treeNode, MainEntityType entityType) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            int size = treeNode.getChildren().size();
            for (int i = size - 1; i >= 0; --i) {
                IDataEntityProperty parentProperty;
                TreeNode childNode = (TreeNode)treeNode.getChildren().get(i);
                if (childNode.getId().endsWith(".id") && !((parentProperty = DataSetHelper.findPropertys((EntityType)entityType, (String)childNode.getParentid())) instanceof EntryProp)) {
                    treeNode.getChildren().remove(i);
                    continue;
                }
                IDataEntityProperty property = DataSetHelper.findPropertys((EntityType)entityType, (String)childNode.getId());
                if (property instanceof MaterielProp) {
                    String materialExtraName;
                    String baseEntityId = ((MaterielProp)property).getBaseEntityId();
                    if ("bd_materialinventoryinfo".equals(baseEntityId) || "bd_materialpurchaseinfo".equals(baseEntityId) || "bd_materialsalinfo".equals(baseEntityId)) {
                        MainEntityType materialEntity = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        materialExtraName = "(" + materialEntity.getDisplayName().toString() + ")";
                        childNode.setText(childNode.getText() + materialExtraName);
                        int subSize = childNode.getChildren().size();
                        String parentID = childNode.getId();
                        for (int j = subSize - 1; j >= 0; --j) {
                            String subBaseEntityId;
                            TreeNode subChildNode = (TreeNode)childNode.getChildren().get(j);
                            if ((parentID + ".number").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".name").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            } else if ((parentID + ".id").equals(subChildNode.getId())) {
                                childNode.getChildren().remove(j);
                            }
                            IDataEntityProperty subProperty = DataSetHelper.findPropertys((EntityType)entityType, (String)subChildNode.getId());
                            if (!(subProperty instanceof MasterBasedataProp) || !"bd_material".equals(subBaseEntityId = ((MasterBasedataProp)subProperty).getBaseEntityId())) continue;
                            String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"QuoteSchemePlugin_8", (String)"scmc-plat-formplugin", (Object[])new Object[0]);
                            subChildNode.setText(subChildNode.getText() + "(" + subMaterialExtraName + ")");
                        }
                        this.removeIDNodeFromTree(childNode, entityType);
                        continue;
                    }
                    if (!"bd_material".equals(baseEntityId)) continue;
                    String subMaterialExtraName = ResManager.loadKDString((String)"\u7269\u6599\u4e3b\u6570\u636e", (String)"QuoteSchemePlugin_8", (String)"scmc-plat-formplugin", (Object[])new Object[0]);
                    materialExtraName = "(" + subMaterialExtraName + ")";
                    childNode.setText(childNode.getText() + materialExtraName);
                    this.removeIDNodeFromTree(childNode, entityType);
                    continue;
                }
                this.removeIDNodeFromTree(childNode, entityType);
            }
        }
    }

    private void resetMaterialName(TreeNode subChildNode) {
        String subChildNodeText = subChildNode.getText();
        CharSequence[] subChildNodeStrs = subChildNodeText.split("\\.");
        subChildNodeStrs[1] = ResManager.loadKDString((String)"\u7269\u6599", (String)"QuoteSchemePlugin_10", (String)"scmc-plat-formplugin", (Object[])new Object[0]);
        subChildNodeText = String.join((CharSequence)".", subChildNodeStrs);
        subChildNode.setText(subChildNodeText);
        List subNextLevelNodes = subChildNode.getChildren();
        for (int s = 0; subNextLevelNodes != null && s < subNextLevelNodes.size(); ++s) {
            this.resetMaterialName((TreeNode)subNextLevelNodes.get(s));
        }
    }

    private String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }
}

