/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.util.StringUtils;
import kd.scmc.plat.formplugin.pricemodel.DynamicEnum;

public class QuoteSignSettingPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        Button btOK;
        super.registerListener(e);
        if (this.getView().getControl("priceresultfieldlist") != null) {
            this.addClickListeners(new String[]{"priceresultfieldlist"});
        }
        if ((btOK = (Button)this.getView().getControl("btnok")) != null) {
            this.addClickListeners(new String[]{"btnok"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equals(c.getKey().toLowerCase())) {
            this.confirm(evt);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List list = this.resolve();
        ComboEdit edit = (ComboEdit)this.getView().getControl("priceresultfieldlist");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(list.size());
        list.forEach(new DynamicEnum(items));
        edit.setComboItems(items);
        if (list.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u4ef7\u65b9\u6848\u4e2d\u6ca1\u6709\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u7684\u5b57\u6bb5\u3002", (String)"QuoteSignSettingPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String sign = (String)showParameter.getCustomParam("sign");
        if (StringUtils.isNotEmpty((String)sign)) {
            this.getModel().setValue("priceresultfieldlist", (Object)sign);
        } else {
            String key = ((String[])list.get(0))[1];
            this.getModel().setValue("priceresultfieldlist", (Object)key);
        }
    }

    private void confirm(EventObject evt) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getModel().getValue("priceresultfieldlist") == null || "".equals(this.getModel().getValue("priceresultfieldlist"))) {
            map.put("terminationsigndesc", null);
            map.put("terminationsign", null);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
        List list = this.resolve();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(list.size());
        list.forEach(new DynamicEnum(items));
        if (this.getModel().getValue("priceresultfieldlist") != null) {
            String[] signs = this.getModel().getValue("priceresultfieldlist").toString().split(",");
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < signs.length; ++i) {
                String value = new DynamicEnum(items).getValue(signs[i]);
                if (value == null) continue;
                builder.append(value).append(',');
            }
            if (StringUtils.isEmpty((String)builder.toString())) {
                return;
            }
            String signstr = this.getModel().getValue("priceresultfieldlist").toString();
            ArrayList<String> signList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)signstr)) {
                String[] signArray;
                for (String sign : signArray = signstr.split(",")) {
                    if (!StringUtils.isNotEmpty((String)sign)) continue;
                    signList.add(sign);
                }
            }
            map.put("terminationsigndesc", builder.toString().substring(0, builder.lastIndexOf(",")));
            map.put("terminationsign", String.join((CharSequence)",", signList));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private List resolve() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String priceresultfieldlist = (String)showParameter.getCustomParam("priceresultfieldlist");
        List list = SerializationUtils.fromJsonStringToList((String)priceresultfieldlist, String[].class);
        return list;
    }
}

