/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.pricemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.LicenseHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteNewHelper;
import kd.scmc.plat.common.util.CommonUtils;

public class QuoteStrategyPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String FORMID_SELECTCONDITION = "botp_condition";
    private static final String ACTIONID = "mulcombofield";

    public void registerListener(EventObject e) {
        BasedataEdit quoteEntity;
        BasedataEdit quotesheme;
        super.registerListener(e);
        if (this.getView().getControl("qu_preconditiondesc") != null) {
            this.addClickListeners(new String[]{"qu_preconditiondesc"});
        }
        if (this.getView().getControl("terminationsigndesc") != null) {
            this.addClickListeners(new String[]{"terminationsigndesc"});
        }
        if (this.getView().getControl("qs_preconditiondesc") != null) {
            this.addClickListeners(new String[]{"qs_preconditiondesc"});
        }
        if ((quotesheme = (BasedataEdit)this.getView().getControl("quotescheme")) != null) {
            quotesheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((quoteEntity = (BasedataEdit)this.getView().getControl("quotebill")) != null) {
            quoteEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map result;
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getAppId();
        String formId = e.getFormShowParameter().getFormId();
        if (e.getFormShowParameter() != null && Boolean.TRUE.equals((result = LicenseHelper.checkLicense((String)appId, (String)formId)).get("isCancel"))) {
            e.setCancelMessage((String)result.get("cancelMessage"));
            e.setCancel(true);
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("qu_preconditiondesc")) {
            this.showCondition();
        }
        if (c.getKey().equalsIgnoreCase("terminationsigndesc")) {
            this.showResultField();
        }
        if (c.getKey().equalsIgnoreCase("qs_preconditiondesc")) {
            this.showQsCondition();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        if (createorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"QuoteStrategyPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "quotescheme": {
                QFilter filter = new QFilter("status", "=", (Object)"C");
                filter.and(new QFilter("enable", "=", (Object)"1"));
                Map quoteschemeIds = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)"masterid,number", (QFilter[])new QFilter[]{filter});
                ArrayList<String> list = new ArrayList<String>();
                if (quoteschemeIds.size() > 0) {
                    Iterator iterator = quoteschemeIds.entrySet().iterator();
                    while (iterator.hasNext()) {
                        DynamicObject quotescheme = (DynamicObject)iterator.next().getValue();
                        String number = quotescheme.getString("number");
                        list.add(number);
                    }
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("number", "in", list));
                showParameter.getCustomParams().put("fromstrategy", "1");
            }
            case "quotebill": {
                QuoteNewHelper.registerQuoteBill((BeforeF7SelectEvent)e);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (CommonUtils.isRealChanged((ChangeData)changeSet[0])) {
            switch (key) {
                case "quotescheme": {
                    int index = 0;
                    int index_c = 1;
                    for (int j = 0; j < changeSet.length; ++j) {
                        int row = changeSet[j].getRowIndex();
                        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
                        this.getModel().setValue("terminationsigndesc", null, row);
                        this.getModel().setValue("terminationsign", null, row);
                        this.getModel().setValue("qu_preconditiondesc", null, row);
                        this.getModel().setValue("qu_precondition", null, row);
                        this.getModel().setValue("preconditionjson_tag", null, row);
                        if (quotescheme == null) continue;
                        String number = quotescheme.getString("number");
                        List<String[]> list = this.queryField(number);
                        if (list.size() == 0) {
                            this.getModel().setValue("terminationsigndesc", null, row);
                            this.getModel().setValue("terminationsign", null, row);
                            continue;
                        }
                        String value = list.get(index)[index];
                        String sign = list.get(index)[index_c];
                        this.getModel().setValue("terminationsigndesc", (Object)value, row);
                        this.getModel().setValue("terminationsign", (Object)sign, row);
                    }
                    break;
                }
                case "quotebill": {
                    for (int j = 0; j < changeSet.length; ++j) {
                        int row = changeSet[j].getRowIndex();
                        this.getModel().setValue("qs_preconditiondesc", null, row);
                        this.getModel().setValue("qs_precondition", null, row);
                        this.getModel().setValue("qs_precondition_tag", null, row);
                    }
                    break;
                }
                case "qu_preconditiondesc": {
                    int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("preconditionjson_tag", null, row);
                    this.getModel().setValue("qu_precondition", null, row);
                    break;
                }
                case "qs_preconditiondesc": {
                    int rowC = this.getModel().getEntryCurrentRowIndex("conditionentryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("qs_precondition_tag", null, rowC);
                    this.getModel().setValue("qs_precondition", null, rowC);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase("qu_preconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "entryentity", "preconditionjson_tag", "qu_preconditiondesc");
        }
        if (e.getActionId().equalsIgnoreCase("qs_preconditiondesc")) {
            this.receiveCondition((String)e.getReturnData(), "conditionentryentity", "qs_precondition_tag", "qs_preconditiondesc");
        }
        if (e.getActionId().equalsIgnoreCase(ACTIONID)) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            Map map = (Map)returnData;
            this.getModel().setValue("terminationsigndesc", map.get("terminationsigndesc"));
            this.getModel().setValue("terminationsign", map.get("terminationsign"));
        }
    }

    private void showResultField() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
        String sign = (String)this.getModel().getValue("terminationsign", row);
        if (quotescheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteStrategyPlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = quotescheme.getString("number");
        List<String[]> list = this.queryField(number);
        this.showDynForm(list, sign);
    }

    private List<String[]> queryField(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] plat_quoteschemes = BusinessDataServiceHelper.load((String)"plat_quotescheme", (String)"pricesourceentity,quotepattern,sourcesignname,sourcesign", (QFilter[])new QFilter[]{filter});
        ArrayList<String[]> list = new ArrayList<String[]>();
        HashSet<String> sourcesignSet = new HashSet<String>();
        if (plat_quoteschemes.length > 0) {
            DynamicObject plat_quotescheme = plat_quoteschemes[0];
            String quoteentity_number = plat_quotescheme.getDynamicObject("pricesourceentity").getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)quoteentity_number);
            Map quoteentity1 = dataEntityType.getAllFields();
            Iterator iterator = quoteentity1.entrySet().iterator();
            ArrayList<String> filed = new ArrayList<String>();
            while (iterator.hasNext()) {
                IDataEntityProperty value;
                Map.Entry next = iterator.next();
                String key = (String)next.getKey();
                IDataEntityProperty property = dataEntityType.findProperty(key);
                if (property != null) {
                    String parentName = property.getParent().getName();
                    key = this.getEntryFullField(dataEntityType, property.getName(), quoteentity_number, parentName);
                }
                if (!((value = (IDataEntityProperty)next.getValue()) instanceof PriceProp) && !(value instanceof AmountProp)) continue;
                filed.add(key);
            }
            DynamicObjectCollection entryentity = plat_quotescheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                String quotepattern = entity.getString("quotepattern");
                String sourcesignname = entity.getString("sourcesignname");
                String sourcesign = entity.getString("sourcesign");
                if (!"B".equals(quotepattern) || !filed.contains(sourcesign) || !sourcesignSet.add(sourcesign)) continue;
                String[] string = new String[]{sourcesignname, sourcesign};
                list.add(string);
            }
        }
        return list;
    }

    private void showDynForm(List<String[]> list, String sign) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("plat_quotesignsetting");
        String jsonString = SerializationUtils.toJsonString(list);
        parameter.setCustomParam("priceresultfieldlist", (Object)jsonString);
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            parameter.setCustomParam("sign", (Object)sign);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID));
        this.getView().showForm(parameter);
    }

    private void showCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject quotescheme = (DynamicObject)this.getModel().getValue("quotescheme", row);
        if (quotescheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteStrategyPlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject quoteentity1 = quotescheme.getDynamicObject("quoteentity");
        String number = quoteentity1.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("preconditionjson_tag", row);
        String conditionJsonOld = (String)this.getModel().getValue("qu_precondition", row);
        if (StringUtils.isBlank((CharSequence)conditionJson) && StringUtils.isNotBlank((CharSequence)conditionJsonOld)) {
            conditionJson = conditionJsonOld;
        }
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "qu_preconditiondesc");
    }

    private void showQsCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("conditionentryentity");
        DynamicObject quoteBill = (DynamicObject)this.getModel().getValue("quotebill", row);
        if (quoteBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteStrategyPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = quoteBill.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("qs_precondition_tag", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "qs_preconditiondesc");
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTCONDITION);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)exprTran);
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)exprTran, row);
            }
        }
    }

    private String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }
}

