/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.tpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.plat.business.helper.AmountHelper;
import kd.scmc.plat.business.helper.MetaDataHelper;
import kd.scmc.plat.common.enums.DiscountTypeEnum;
import kd.scmc.plat.common.util.CommonUtils;

@Deprecated
public class BillBizAmountPlugin
extends AbstractBillPlugIn {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String CURRENCY_AMTPRECISION = "amtprecision";
    private static final String CURRENCY_PRICEPRECISION = "priceprecision";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block22: for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            Object oldValue = valueSet[i].getOldValue();
            Object newValue = valueSet[i].getNewValue();
            int rowIndex = valueSet[i].getRowIndex();
            switch (fieldName) {
                case "settlecurrency": {
                    this.changeSettleCur(oldValue, newValue);
                    continue block22;
                }
                case "istax": {
                    this.changeIsNotTax(newValue);
                    this.changeIsTax(newValue);
                    continue block22;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    continue block22;
                }
                case "price": 
                case "priceandtax": 
                case "qty": 
                case "taxrate": {
                    this.changeAmountField(rowIndex);
                    continue block22;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    continue block22;
                }
                case "discounttype": 
                case "discountrate": {
                    this.changeDiscountType(fieldName, oldValue, newValue, rowIndex);
                    this.changeAmountField(rowIndex);
                    continue block22;
                }
                case "exchangerate": {
                    this.changeExChangeRate(newValue);
                    continue block22;
                }
            }
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void changeExChangeRate(Object newValue) {
        DynamicObject currency;
        BigDecimal exChangeRate = newValue == null ? ZERO : (BigDecimal)newValue;
        int currencyPrecision = 10;
        IDataModel model = this.getModel();
        boolean existCurrency = false;
        if (MetaDataHelper.isExistField((IDataEntityType)model.getDataEntityType(), (String)"currency")) {
            existCurrency = true;
        }
        boolean existAmount = false;
        if (this.existFieldCache(model, "billentry", "amount").booleanValue() && this.existFieldCache(model, "billentry", "curamount").booleanValue()) {
            existAmount = true;
        }
        boolean existTaxAmount = false;
        if (this.existFieldCache(model, "billentry", "taxamount").booleanValue() && this.existFieldCache(model, "billentry", "curtaxamount").booleanValue()) {
            existTaxAmount = true;
        }
        boolean existAmountAndTax = false;
        if (this.existFieldCache(model, "billentry", "amountandtax").booleanValue() && this.existFieldCache(model, "billentry", "curamountandtax").booleanValue()) {
            existAmountAndTax = true;
        }
        boolean existIsTax = false;
        if (MetaDataHelper.isExistField((IDataEntityType)model.getDataEntityType(), (String)"istax")) {
            existIsTax = true;
        }
        if (existCurrency && (currency = (DynamicObject)this.getModel().getValue("currency")) != null) {
            currencyPrecision = currency.getInt(CURRENCY_AMTPRECISION);
        }
        if (existIsTax && existAmount && existTaxAmount && existAmountAndTax) {
            boolean isTax = (Boolean)model.getValue("istax");
            int entryRowCount = model.getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal amount = (BigDecimal)model.getValue("amount", i);
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", i);
                BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", i);
                BigDecimal curTaxAmout = taxAmount.multiply(exChangeRate);
                curTaxAmout = curTaxAmout.setScale(currencyPrecision, RoundingMode.HALF_UP);
                BigDecimal curAmountAndTax = ZERO;
                BigDecimal curAmount = ZERO;
                if (isTax) {
                    curAmountAndTax = amountAndTax.multiply(exChangeRate);
                    curAmountAndTax = curAmountAndTax.setScale(currencyPrecision, RoundingMode.HALF_UP);
                    curAmount = curAmountAndTax.subtract(curTaxAmout);
                } else {
                    curAmount = amount.multiply(exChangeRate);
                    curAmount = curAmount.setScale(currencyPrecision, RoundingMode.HALF_UP);
                    curAmountAndTax = curAmount.add(curTaxAmout);
                }
                model.setValue("curamount", (Object)curAmount, i);
                model.setValue("curtaxamount", (Object)curTaxAmout, i);
                model.setValue("curamountandtax", (Object)curAmountAndTax, i);
            }
        }
    }

    private void changeAmountField(int rowIndex) {
        IDataModel model = this.getModel();
        AmountHelper.setAmount((IDataModel)model, (int)rowIndex);
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("priceandtax", rowIndex);
    }

    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (this.existFieldCache(model, "billentry", "discounttype").booleanValue() && this.existFieldCache(model, "billentry", "discountrate").booleanValue()) {
            String discountType = (String)model.getValue("discounttype", rowIndex);
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
            if (discountRate != null && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
                double rate = discountRate.doubleValue();
                if (rate > 100.0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u503c\u8303\u56f4\u4e3a[0,100]\u3002", (String)"BillBizAmountPlugin_0", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
                double amount = discountRate.doubleValue();
                boolean isTax = (Boolean)model.getValue("istax");
                if (isTax) {
                    BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                    if (amount > priceAndTax.doubleValue()) {
                        model.setValue(fieldName, oldValue, rowIndex);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillBizAmountPlugin_1", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                    if (amount > price.doubleValue()) {
                        model.setValue(fieldName, oldValue, rowIndex);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillBizAmountPlugin_2", (String)"scmc-plat-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            } else {
                model.setValue("discountrate", null, rowIndex);
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            }
        }
    }

    private void changeSettleCur(Object oldValue, Object newValue) {
        if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
            DynamicObject oldSettleCur = (DynamicObject)oldValue;
            DynamicObject newSettleCur = (DynamicObject)newValue;
            if (oldSettleCur.getInt(CURRENCY_AMTPRECISION) != newSettleCur.getInt(CURRENCY_AMTPRECISION) || oldSettleCur.getInt(CURRENCY_PRICEPRECISION) != newSettleCur.getInt(CURRENCY_PRICEPRECISION)) {
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.changeAmountField(i);
                }
            }
        }
    }

    private void changeIsNotTax(Object newValue) {
        int rows;
        boolean isTax = (Boolean)newValue;
        if (isTax) {
            return;
        }
        IDataModel model = this.getModel();
        if (this.existFieldCache(model, "billentry", "discounttype").booleanValue() && this.existFieldCache(model, "billentry", "discountrate").booleanValue() && (rows = model.getEntryRowCount("billentry")) > 0) {
            StringBuilder incorrectRowIndexs = new StringBuilder();
            for (int i = 0; i < rows; ++i) {
                BigDecimal price;
                double amount;
                String discountType = (String)model.getValue("discounttype", i);
                BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", i);
                if (discountRate == null || !DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || !((amount = discountRate.doubleValue()) > (price = (BigDecimal)model.getValue("price", i)).doubleValue())) continue;
                model.setValue("discountrate", null, i);
                incorrectRowIndexs.append(i + 1).append(',');
            }
            if (incorrectRowIndexs != null && incorrectRowIndexs.length() > 0) {
                StringBuilder errorMsg = new StringBuilder(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c", (String)"BillBizAmountPlugin_3", (String)"scmc-plat-formplugin", (Object[])new Object[0])).append("\u3010").append(incorrectRowIndexs.substring(0, incorrectRowIndexs.length() - 1)).append("\u3011");
                this.getView().showErrorNotification(errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u89c4\u5219\uff1a\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002\u5df2\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"BillBizAmountPlugin_4", (String)"scmc-plat-formplugin", (Object[])new Object[0])).toString());
                return;
            }
        }
    }

    private void changeIsTax(Object newValue) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        if (this.existFieldCache(model, "billentry", "ispresent").booleanValue()) {
            for (int i = 0; i < entryRowCount; ++i) {
                boolean isPrensent = (Boolean)model.getValue("ispresent");
                if (isPrensent) continue;
                this.changeAmountField(i);
            }
        } else {
            for (int i = 0; i < entryRowCount; ++i) {
                this.changeAmountField(i);
            }
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        if (newValue == null) {
            return;
        }
        boolean isPresent = (Boolean)newValue;
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        if (isPresent) {
            if (isTax) {
                model.setValue("priceandtax", (Object)ZERO, rowIndex);
            } else {
                model.setValue("price", (Object)ZERO, rowIndex);
            }
            model.setValue("taxrate", (Object)ZERO, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            if (this.existFieldCache(model, "billentry", "discounttype").booleanValue() && this.existFieldCache(model, "billentry", "discountrate").booleanValue()) {
                model.setValue("discountrate", (Object)ZERO, rowIndex);
            }
        }
    }

    private Boolean existFieldCache(IDataModel bill, String entryName, String fieldName) {
        MainEntityType dataEntityType = bill.getDataEntityType();
        Boolean existField = Boolean.FALSE;
        String cache = this.getPageCache().get(fieldName);
        if (StringUtils.isBlank((CharSequence)cache)) {
            existField = MetaDataHelper.isExistField((MainEntityType)dataEntityType, (String)entryName, (String)fieldName);
            this.getPageCache().put(fieldName, existField.toString());
        } else {
            existField = Boolean.valueOf(cache);
        }
        return existField;
    }
}

