/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.formplugin.tpl;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.scmc.plat.business.helper.AmountHelper;
import kd.scmc.plat.business.helper.CurrencyHelper;
import kd.scmc.plat.business.helper.MetaDataHelper;
import kd.scmc.plat.common.util.CommonUtils;

@Deprecated
public class BillFiInfoPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org == null) {
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
        if (map != null) {
            if (this.existFieldCache(bill, "currency").booleanValue()) {
                if (bill.getValue("currency") == null) {
                    bill.setValue("currency", map.get("baseCurrencyID"));
                }
                if (bill.getValue("settlecurrency") == null) {
                    bill.setValue("settlecurrency", map.get("baseCurrencyID"));
                    bill.setValue("exchangerate", (Object)BigDecimal.ONE);
                }
            }
            if (this.existFieldCache(bill, "exratetable").booleanValue() && bill.getValue("exratetable") == null) {
                bill.setValue("exratetable", map.get("exchangeRateTableID"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.exChangeRateEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "currency": {
                this.changeCurOrTable("currency", newValue);
                break;
            }
            case "settlecurrency": {
                this.changeCurOrTable("settlecurrency", newValue);
                break;
            }
            case "exratetable": {
                this.changeCurOrTable("exratetable", newValue);
                break;
            }
            case "exratedate": {
                this.changeCurOrTable("exratedate", newValue);
                break;
            }
        }
    }

    private void changeCurOrTable(String fieldName, Object newValue) {
        IDataModel bill = this.getModel();
        if (this.existFieldCache(bill, "currency").booleanValue() && this.existFieldCache(bill, "settlecurrency").booleanValue() && this.existFieldCache(bill, "exratetable").booleanValue() && this.existFieldCache(bill, "exratedate").booleanValue()) {
            AmountHelper.setExChangeRate((IDataModel)bill, (String)fieldName, (Object)newValue);
            this.exChangeRateEnable();
        }
    }

    private void exChangeRateEnable() {
        IDataModel bill = this.getModel();
        if (this.existFieldCache(bill, "exchangerate").booleanValue()) {
            BigDecimal exChangeRate = (BigDecimal)bill.getValue("exchangerate");
            if (exChangeRate != null && exChangeRate.compareTo(BigDecimal.ONE) == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"exchangerate"});
            }
        }
    }

    private Boolean existFieldCache(IDataModel bill, String fieldName) {
        MainEntityType dataEntityType = bill.getDataEntityType();
        Boolean existField = Boolean.FALSE;
        String cache = this.getPageCache().get(fieldName);
        if (StringUtils.isBlank((CharSequence)cache)) {
            existField = MetaDataHelper.isExistField((IDataEntityType)dataEntityType, (String)fieldName);
            this.getPageCache().put(fieldName, existField.toString());
        } else {
            existField = Boolean.valueOf(cache);
        }
        return existField;
    }
}

