/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.common2.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.scmc.plat.common2.cache.ISimpleCache;

public final class SimpleCacheImpl
implements ISimpleCache {
    private final Map<String, Object> cache;
    private static int Count_Max = 5000;
    private final String region;
    private static final long Clear_Time = 1800000L;
    private static final String SYSTimeKey = "SystemCurrentTimeMillis";
    private static final Map<String, SimpleCacheImpl> caches = new ConcurrentHashMap<String, SimpleCacheImpl>();

    private SimpleCacheImpl(String region) {
        this.region = region;
        this.cache = new ConcurrentHashMap<String, Object>();
    }

    public static SimpleCacheImpl getCacheImpl(String region) {
        return SimpleCacheImpl.getCacheImpl(region, 1);
    }

    public static SimpleCacheImpl getCacheImpl(String region, int cacheLevel) {
        return SimpleCacheImpl.getCacheImpl(region, Count_Max * cacheLevel, 1800000L);
    }

    public static SimpleCacheImpl getCacheImpl(String region, int cacheMax, long clearTime) {
        SimpleCacheImpl cache = caches.get(region);
        if (cache == null) {
            cache = caches.computeIfAbsent(region, k -> new SimpleCacheImpl((String)k));
        }
        if (cache.get(SYSTimeKey) == null || cache.size() == 1 && cache.contains(SYSTimeKey)) {
            cache.put(SYSTimeKey, System.currentTimeMillis());
        } else {
            long lastCurrentTimeMillis = (Long)cache.get(SYSTimeKey);
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - lastCurrentTimeMillis > clearTime || cache.size() > cacheMax) {
                cache.clear();
            }
        }
        return cache;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void put(String key, Object value) {
        this.cache.put(key, value);
        this.cache.put(SYSTimeKey, System.currentTimeMillis());
    }

    @Override
    public Object get(String key) {
        Object value = this.cache.get(key);
        return value;
    }

    public void remove(String key) {
        this.cache.remove(key);
        this.cache.put(SYSTimeKey, System.currentTimeMillis());
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (caches.containsKey(this.region)) {
            caches.remove(this.region);
        }
    }

    @Override
    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void remove(String ... keys) {
        for (String key : keys) {
            this.cache.remove(key);
        }
    }

    public <T> T get(String arg0, Class<T> arg1) {
        return null;
    }

    public void put(String arg0, Object arg1, int arg2) {
    }
}

