/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.scmc.plat.business.helper.CurrencyHelper;
import kd.scmc.plat.business.helper.MetaDataHelper;
import kd.scmc.plat.common.enums.DiscountTypeEnum;

@Deprecated
public class AmountHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;

    public static void setExChangeRate(IDataModel model, String fieldName, Object newValue) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        Date bizTime = (Date)model.getValue("exratedate");
        switch (fieldName) {
            case "currency": {
                currency = (DynamicObject)newValue;
                break;
            }
            case "settlecurrency": {
                settleCurrency = (DynamicObject)newValue;
                break;
            }
            case "exratetable": {
                exRateTable = (DynamicObject)newValue;
                break;
            }
            case "exratedate": {
                bizTime = (Date)newValue;
                break;
            }
        }
        if (currency != null && settleCurrency != null && exRateTable != null && bizTime != null) {
            model.setValue("exchangerate", (Object)CurrencyHelper.getExChangeRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime));
        }
    }

    public static void setAmount(IDataModel model, int rowIndex) {
        DynamicObject currency;
        MainEntityType dataEntityType = model.getDataEntityType();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        BigDecimal hundred = new BigDecimal(100);
        taxRate = taxRate != null ? taxRate.divide(hundred) : ZERO;
        Boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal taxAmout = ZERO;
        BigDecimal amount = ZERO;
        int precision = 10;
        if (MetaDataHelper.isExistField((IDataEntityType)dataEntityType, "settlecurrency") && (currency = (DynamicObject)model.getValue("settlecurrency")) != null) {
            precision = currency.getInt("amtprecision");
        }
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "discounttype") && MetaDataHelper.isExistField(dataEntityType, "billentry", "discountrate")) {
            String discountType = (String)model.getValue("discounttype", rowIndex);
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
            if (isTax.booleanValue()) {
                if (priceAndTax != null) {
                    price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                }
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (discountRate != null) {
                        discountRate = discountRate.divide(hundred);
                    }
                    if (discountRate != null && priceAndTax != null) {
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                        discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                        amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount);
                        amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate);
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    if (priceAndTax != null) {
                        amountAndTax = qty.multiply(priceAndTax.subtract(discountRate));
                    }
                    amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                } else {
                    amountAndTax = qty.multiply(priceAndTax);
                    amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                }
                taxAmout = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
                taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmout);
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                model.beginInit();
                model.setValue("price", (Object)price, rowIndex);
                model.endInit();
            } else {
                priceAndTax = price.multiply(ONE.add(taxRate));
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (discountRate != null) {
                        discountRate = discountRate.divide(hundred);
                        discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                        discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                        amount = qty.multiply(price).multiply(ONE.subtract(discountRate));
                        amount = amount.setScale(precision, RoundingMode.HALF_UP);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate));
                    discountAmount = discountAmount.setScale(precision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate));
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                } else {
                    amount = qty.multiply(price);
                    amount = amount.setScale(precision, RoundingMode.HALF_UP);
                }
                taxAmout = amount.multiply(taxRate);
                taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmout);
                amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                model.beginInit();
                model.setValue("priceandtax", (Object)priceAndTax, rowIndex);
                model.endInit();
            }
        } else if (isTax.booleanValue()) {
            price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
            amountAndTax = qty.multiply(priceAndTax);
            amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
            taxAmout = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
            taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
            amount = amountAndTax.subtract(taxAmout);
            amount = amount.setScale(precision, RoundingMode.HALF_UP);
            model.beginInit();
            model.setValue("price", (Object)price, rowIndex);
            model.endInit();
        } else {
            priceAndTax = price.multiply(ONE.add(taxRate));
            amount = qty.multiply(price);
            amount = amount.setScale(precision, RoundingMode.HALF_UP);
            taxAmout = amount.multiply(taxRate);
            taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
            amountAndTax = amount.add(taxAmout);
            amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
            model.beginInit();
            model.setValue("priceandtax", (Object)priceAndTax, rowIndex);
            model.endInit();
        }
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "discountamount")) {
            model.setValue("discountamount", (Object)discountAmount, rowIndex);
        }
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "amountandtax")) {
            model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
        }
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "taxamount")) {
            model.setValue("taxamount", (Object)taxAmout, rowIndex);
        }
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "amount")) {
            model.setValue("amount", (Object)amount, rowIndex);
        }
        if (MetaDataHelper.isExistField((IDataEntityType)dataEntityType, "exchangerate") && MetaDataHelper.isExistField((IDataEntityType)dataEntityType, "currency")) {
            DynamicObject currencyObj = (DynamicObject)model.getValue("currency");
            int currencyPrecision = 10;
            if (currencyObj != null) {
                currencyPrecision = currencyObj.getInt("amtprecision");
            }
            BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
            BigDecimal curTaxAmout = taxAmout.multiply(exChangeRate);
            curTaxAmout = curTaxAmout.setScale(currencyPrecision, RoundingMode.HALF_UP);
            BigDecimal curAmountAndTax = ZERO;
            BigDecimal curAmount = ZERO;
            if (isTax.booleanValue()) {
                curAmountAndTax = amountAndTax.multiply(exChangeRate);
                curAmountAndTax = curAmountAndTax.setScale(currencyPrecision, RoundingMode.HALF_UP);
                curAmount = curAmountAndTax.subtract(curTaxAmout);
            } else {
                curAmount = amount.multiply(exChangeRate);
                curAmount = curAmount.setScale(currencyPrecision, RoundingMode.HALF_UP);
                curAmountAndTax = curAmount.add(curTaxAmout);
            }
            if (MetaDataHelper.isExistField(dataEntityType, "billentry", "curamountandtax")) {
                model.setValue("curamountandtax", (Object)curAmountAndTax, rowIndex);
            }
            if (MetaDataHelper.isExistField(dataEntityType, "billentry", "curtaxamount")) {
                model.setValue("curtaxamount", (Object)curTaxAmout, rowIndex);
            }
            if (MetaDataHelper.isExistField(dataEntityType, "billentry", "curamount")) {
                model.setValue("curamount", (Object)curAmount, rowIndex);
            }
        }
    }

    public static void setTotalAmount(IDataModel model, String fieldName, String headFieldName) {
        BigDecimal totalAmount = ZERO;
        int entryRowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal amount = (BigDecimal)model.getValue(fieldName, i);
            totalAmount = totalAmount.add(amount);
        }
        model.setValue(headFieldName, (Object)totalAmount);
    }

    public static Map<String, Object> getAmount(BigDecimal priceQty, boolean isTax, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, BigDecimal exChangeRate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal curAmount = ZERO;
        BigDecimal curTaxAmount = ZERO;
        BigDecimal curAmountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal(100);
        if (taxRate != null) {
            taxRate = taxRate.divide(hundred);
        }
        if (priceQty != null && priceQty.compareTo(ZERO) != 0) {
            if (discountType == null || discountRate == null || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                    price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                    amountAndTax = priceQty.multiply(priceAndTax);
                    taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
                    amount = amountAndTax.subtract(taxAmount);
                } else if (price != null && price.compareTo(ZERO) != 0) {
                    priceAndTax = price.multiply(ONE.add(taxRate));
                    amount = priceQty.multiply(price);
                    taxAmount = amount.multiply(taxRate);
                    amountAndTax = amount.add(taxAmount);
                }
            } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(hundred);
                    discountAmount = priceQty.multiply(priceAndTax).multiply(discountRate);
                    amountAndTax = priceQty.multiply(priceAndTax).subtract(discountAmount);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = priceQty.multiply(discountRate);
                    amountAndTax = priceQty.multiply(priceAndTax.subtract(discountRate));
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
                amount = amountAndTax.subtract(taxAmount);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate));
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(hundred);
                    discountAmount = priceQty.multiply(priceAndTax).multiply(discountRate);
                    amount = priceQty.multiply(price).multiply(ONE.subtract(discountRate));
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = priceQty.multiply(discountRate);
                    amount = priceQty.multiply(price.subtract(discountRate));
                }
                taxAmount = amount.multiply(taxRate);
                amountAndTax = amount.add(taxAmount);
            }
            if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
                curAmount = amount.multiply(exChangeRate);
                curTaxAmount = taxAmount.multiply(exChangeRate);
                curAmountAndTax = amountAndTax.multiply(exChangeRate);
            }
        }
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("amount", amount);
        map.put("discountamount", discountAmount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        map.put("curamount", curAmount);
        map.put("curtaxamount", curTaxAmount);
        map.put("curamountandtax", curAmountAndTax);
        return map;
    }

    public static Map<String, Object> getAmount(BigDecimal qty, boolean isTax, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, BigDecimal exChangeRate, Integer settlePrecision, Integer currencyPrecision) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal curAmount = ZERO;
        BigDecimal curTaxAmount = ZERO;
        BigDecimal curAmountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal(100);
        if (taxRate != null) {
            taxRate = taxRate.divide(hundred);
        }
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (discountType == null || discountRate == null || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                    price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                    amountAndTax = qty.multiply(priceAndTax);
                    amountAndTax = amountAndTax.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
                    taxAmount = taxAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amount = amountAndTax.subtract(taxAmount);
                    amount = amount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                } else if (price != null && price.compareTo(ZERO) != 0) {
                    priceAndTax = price.multiply(ONE.add(taxRate));
                    amount = qty.multiply(price);
                    amount = amount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amount.multiply(taxRate);
                    taxAmount = taxAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = amount.add(taxAmount);
                    amountAndTax = amountAndTax.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                }
            } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(hundred);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                    discountAmount = discountAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount);
                    amountAndTax = amountAndTax.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate);
                    discountAmount = discountAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax.subtract(discountRate));
                    amountAndTax = amountAndTax.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate);
                taxAmount = taxAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount);
                amount = amount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate));
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(hundred);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate);
                    discountAmount = discountAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).multiply(ONE.subtract(discountRate));
                    amount = amount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate);
                    discountAmount = discountAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate));
                    amount = amount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate);
                taxAmount = taxAmount.setScale((int)settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale((int)settlePrecision, RoundingMode.HALF_UP);
            }
            if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
                curTaxAmount = taxAmount.multiply(exChangeRate);
                curTaxAmount = curTaxAmount.setScale((int)currencyPrecision, RoundingMode.HALF_UP);
                if (isTax) {
                    curAmountAndTax = amountAndTax.multiply(exChangeRate);
                    curAmountAndTax = curAmountAndTax.setScale((int)currencyPrecision, RoundingMode.HALF_UP);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = amount.multiply(exChangeRate);
                    curAmount = curAmount.setScale((int)currencyPrecision, RoundingMode.HALF_UP);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
            }
        }
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("amount", amount);
        map.put("discountamount", discountAmount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        map.put("curamount", curAmount);
        map.put("curtaxamount", curTaxAmount);
        map.put("curamountandtax", curAmountAndTax);
        return map;
    }
}

