/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.plat.business.helper.MaterialHelper;
import kd.scmc.plat.business.helper.MetaDataHelper;
import kd.scmc.plat.common.consts.Constants;
import kd.scmc.plat.common.enums.PrecisionAccountEnum;
import kd.scmc.plat.common.util.CommonUtils;

@Deprecated
public class BillQtyAndUnitHelper {
    private static final BigDecimal zero = BigDecimal.ZERO;
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";

    public static void setBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        MainEntityType dataEntityType = bill.getDataEntityType();
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowindex);
        BigDecimal unitRate = (BigDecimal)bill.getValue("unitrate", rowindex);
        BigDecimal qtyBizUnit = null;
        BigDecimal bizUnitRate = null;
        int baseUnitPrecision = 10;
        int baseUnitPrecisionType = 4;
        int bizUnitPrecision = 10;
        int bizUnitPrecisionType = 4;
        if (MetaDataHelper.isExistField(dataEntityType, "billentry", "qtybizunit") && MetaDataHelper.isExistField(dataEntityType, "billentry", "bizunitrate") && MetaDataHelper.isExistField(dataEntityType, "billentry", "bizunit")) {
            qtyBizUnit = (BigDecimal)bill.getValue("qtybizunit", rowindex);
            bizUnitRate = (BigDecimal)bill.getValue("bizunitrate", rowindex);
            DynamicObject bizUnit = (DynamicObject)bill.getValue("bizunit", rowindex);
            if (bizUnit != null) {
                bizUnitPrecision = bizUnit.getInt(UNIT_PRECISION);
                if (!CommonUtils.isNull((Object)bizUnit.get(UNIT_PRECISIONTYPE))) {
                    bizUnitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)bizUnit.getInt(UNIT_PRECISIONTYPE));
                }
            }
        }
        if (baseUnit != null) {
            baseUnitPrecision = baseUnit.getInt(UNIT_PRECISION);
            if (!CommonUtils.isNull((Object)baseUnit.get(UNIT_PRECISIONTYPE))) {
                baseUnitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)baseUnit.getInt(UNIT_PRECISIONTYPE));
            }
        }
        if (unitRate != null) {
            unitRate = unitRate.setScale(10, 4);
        }
        if (bizUnitRate != null) {
            bizUnitRate = bizUnitRate.setScale(10, 4);
        }
        switch (fieldName) {
            case "qty": {
                BigDecimal bigDecimal = qty = newValue == null ? zero : (BigDecimal)newValue;
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                }
                baseQty = baseQty.setScale(baseUnitPrecision, baseUnitPrecisionType);
                bill.setValue("baseqty", (Object)baseQty, rowindex);
                if (bizUnitRate == null || bizUnitRate.compareTo(zero) == 0 || !MetaDataHelper.isExistField(dataEntityType, "billentry", "qtybizunit")) break;
                qtyBizUnit = baseQty.divide(bizUnitRate, 10, 4);
                qtyBizUnit = qtyBizUnit.setScale(bizUnitPrecision, bizUnitPrecisionType);
                bill.setValue("qtybizunit", (Object)qtyBizUnit, rowindex);
                break;
            }
            case "unit": {
                DynamicObject masterMaterial;
                DynamicObject unit = (DynamicObject)newValue;
                if (unit != null) {
                    int precision = unit.getInt(UNIT_PRECISION);
                    String precisionaccountStr = unit.getString(UNIT_PRECISIONTYPE);
                    int precisionaccount = 4;
                    if (!StringUtils.isEmpty((String)precisionaccountStr)) {
                        precisionaccount = PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionaccountStr));
                    }
                    qty = qty.setScale(precision, precisionaccount);
                    bill.setValue("qty", (Object)qty, rowindex);
                }
                if ((masterMaterial = (DynamicObject)bill.getValue("materialmasterid", rowindex)) == null) {
                    DynamicObject material = (DynamicObject)bill.getValue("material", rowindex);
                    masterMaterial = MaterialHelper.getMaterialByMatBizOfNew(material);
                }
                if (masterMaterial != null && unit != null && baseUnit != null) {
                    unitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                }
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                }
                bill.setValue("unitrate", (Object)unitRate, rowindex);
                baseQty = baseQty.setScale(baseUnitPrecision, baseUnitPrecisionType);
                bill.setValue("baseqty", (Object)baseQty, rowindex);
                if (!MetaDataHelper.isExistField(dataEntityType, "billentry", "qtybizunit") || !MetaDataHelper.isExistField(dataEntityType, "billentry", "bizunitrate")) break;
                if (bizUnitRate != null && bizUnitRate.compareTo(zero) != 0) {
                    qtyBizUnit = baseQty.divide(bizUnitRate, 10, 4);
                }
                if (qtyBizUnit != null) {
                    qtyBizUnit = qtyBizUnit.setScale(bizUnitPrecision, bizUnitPrecisionType);
                }
                bill.setValue("qtybizunit", (Object)qtyBizUnit, rowindex);
                break;
            }
        }
    }

    public static void setPriceQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        BigDecimal unitRate = (BigDecimal)bill.getValue("unitrate", rowindex);
        BigDecimal priceQty = (BigDecimal)bill.getValue("priceqty", rowindex);
        DynamicObject priceUnit = (DynamicObject)bill.getValue("priceunit", rowindex);
        BigDecimal priceUnitRate = (BigDecimal)bill.getValue("priceunitrate", rowindex);
        int priceUnitPrecision = 10;
        int priceUnitPrecisionType = 4;
        if (priceUnit != null) {
            priceUnitPrecision = priceUnit.getInt(UNIT_PRECISION);
            if (!CommonUtils.isNull((Object)priceUnit.get(UNIT_PRECISIONTYPE))) {
                priceUnitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)priceUnit.getInt(UNIT_PRECISIONTYPE));
            }
        }
        unitRate = unitRate.setScale(10, 4);
        priceUnitRate = priceUnitRate.setScale(10, 4);
        switch (fieldName) {
            case "qty": {
                if (priceUnitRate != null && priceUnitRate.compareTo(zero) != 0) {
                    priceQty = baseQty.divide(priceUnitRate, 10, 4);
                }
                priceQty = priceQty.setScale(priceUnitPrecision, priceUnitPrecisionType);
                bill.setValue("priceqty", (Object)priceQty, rowindex);
                break;
            }
            case "unit": {
                if (priceUnitRate != null && priceUnitRate.compareTo(zero) != 0) {
                    priceQty = baseQty.divide(priceUnitRate, 10, 4);
                }
                priceQty = priceQty.setScale(priceUnitPrecision, priceUnitPrecisionType);
                bill.setValue("priceqty", (Object)priceQty, rowindex);
                break;
            }
            case "priceqty": {
                priceQty = (BigDecimal)newValue;
                if (priceQty != null && priceQty.compareTo(zero) != 0) {
                    priceUnitRate = baseQty.divide(priceQty, 10, 4);
                }
                bill.setValue("priceunitrate", (Object)priceUnitRate, rowindex);
                break;
            }
            case "priceunit": {
                priceUnit = (DynamicObject)newValue;
                DynamicObject masterMaterial = (DynamicObject)bill.getValue("materialmasterid", rowindex);
                if (masterMaterial == null) {
                    DynamicObject material = (DynamicObject)bill.getValue("material", rowindex);
                    masterMaterial = MaterialHelper.getMaterialByMatBizOfNew(material);
                }
                if (masterMaterial != null && baseUnit != null && priceUnit != null) {
                    priceUnitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)priceUnit.getPkValue(), (Long)baseUnit.getPkValue());
                }
                if (priceUnitRate != null && priceUnitRate.compareTo(zero) != 0) {
                    priceQty = baseQty.divide(priceUnitRate, 10, 4);
                }
                bill.setValue("priceunitrate", (Object)priceUnitRate, rowindex);
                priceQty = priceQty.setScale(priceUnitPrecision, priceUnitPrecisionType);
                bill.setValue("priceqty", (Object)priceQty, rowindex);
            }
        }
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = Constants.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = Constants.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = Constants.ZERO;
        }
        return unitRate;
    }

    public static Map<String, Object> getQty(DynamicObject material, BigDecimal baseQty, DynamicObject baseUnit, DynamicObject unit, BigDecimal unitRate, DynamicObject bizUnit, BigDecimal bizUnitRate, DynamicObject priceUnit, BigDecimal priceUnitRate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal qty = Constants.ZERO;
        BigDecimal qtyBizUnit = Constants.ZERO;
        BigDecimal priceQty = Constants.ZERO;
        int priceUnitPrecision = 10;
        int unitPrecision = 10;
        int bizUnitPrecision = 10;
        int priceUnitPrecisionType = 4;
        int unitPrecisionType = 4;
        int bizUnitPrecisionType = 4;
        if (material != null && baseUnit != null) {
            Long baseUnitId = (Long)baseUnit.getPkValue();
            DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBizOfNew(material);
            if (unit == null) {
                unit = MaterialHelper.getMaterialBizUnit(material);
            }
            if (unit != null) {
                unitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), baseUnitId);
                unitPrecision = unit.getInt(UNIT_PRECISION);
                if (!CommonUtils.isNull((Object)unit.get(UNIT_PRECISIONTYPE))) {
                    unitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)unit.getInt(UNIT_PRECISIONTYPE));
                }
            }
            if (bizUnit == null) {
                bizUnit = MaterialHelper.getMaterialBizUnit(material);
            }
            if (bizUnit != null) {
                bizUnitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)bizUnit.getPkValue(), baseUnitId);
                bizUnitPrecision = bizUnit.getInt(UNIT_PRECISION);
                if (!CommonUtils.isNull((Object)bizUnit.get(UNIT_PRECISIONTYPE))) {
                    bizUnitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)bizUnit.getInt(UNIT_PRECISIONTYPE));
                }
            }
            if (priceUnit == null) {
                priceUnit = MaterialHelper.getMaterialPriceUnit(material);
            }
            if (priceUnit != null) {
                priceUnitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)priceUnit.getPkValue(), baseUnitId);
                priceUnitPrecision = priceUnit.getInt(UNIT_PRECISION);
                if (!CommonUtils.isNull((Object)priceUnit.get(UNIT_PRECISIONTYPE))) {
                    priceUnitPrecisionType = PrecisionAccountEnum.getEnumByVal((int)priceUnit.getInt(UNIT_PRECISIONTYPE));
                }
            }
        }
        if (baseQty != null) {
            if (unitRate != null && unitRate.compareTo(zero) != 0) {
                qty = baseQty.divide(unitRate, unitPrecision, unitPrecisionType);
            }
            if (bizUnitRate != null && bizUnitRate.compareTo(zero) != 0) {
                qtyBizUnit = baseQty.divide(bizUnitRate, bizUnitPrecision, bizUnitPrecisionType);
            }
            if (priceUnitRate != null && priceUnitRate.compareTo(zero) != 0) {
                priceQty = baseQty.divide(priceUnitRate, priceUnitPrecision, priceUnitPrecisionType);
            }
        }
        map.put("qty", qty);
        map.put("unit", unit);
        map.put("unitrate", unitRate);
        map.put("qtybizunit", qtyBizUnit);
        map.put("bizunit", bizUnit);
        map.put("bizunitrate", bizUnitRate);
        map.put("priceqty", priceQty);
        map.put("priceunit", priceUnit);
        map.put("priceunitrate", priceUnitRate);
        return map;
    }
}

