/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.changemodel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.plat.business.helper.BillTypeHelper;
import kd.scmc.plat.common.consts.changemodel.ChangeTypeEnum;
import kd.scmc.plat.common.enums.BizCancelStatusEnum;
import kd.scmc.plat.common.enums.BizChangeStatusEnum;
import kd.scmc.plat.common.enums.BizValidStatusEnum;
import kd.scmc.plat.common.enums.EnableStatusEnum;
import kd.scmc.plat.common.enums.StatusEnum;
import kd.scmc.plat.common.util.CommonUtils;

public class ChangeModelHelper {
    private static final Log LOGGER = LogFactory.getLog(ChangeModelHelper.class);

    public static DynamicObject getChangeModel4SrcBill(String srcBillEntiyId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)srcBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject getChangeModel4XBill(String xBillEntiyId) {
        QFilter qf1 = new QFilter("xbill", "=", (Object)xBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"plat_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static DynamicObject generateXBilll(String srcBillEntiy, long srcBillId) {
        long beginquerycmtime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModel Begin: " + new Date(beginquerycmtime));
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4SrcBill(srcBillEntiy);
        if (changeModel == null) {
            return null;
        }
        Map<String, Map<String, String>> entryAndOp = ChangeModelHelper.getXBillEntryAndOp(changeModel);
        long endquerycmtime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModelAndSrcEntryInfo Finish: " + new Date(endquerycmtime));
        LOGGER.info("BizChangePerformance----generateXBilll:1.QueryChangeModel UseTime: " + (endquerycmtime - beginquerycmtime) + " ms");
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle Begin: " + new Date(endquerycmtime));
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)srcBillEntiy);
        if (CommonUtils.isNull((Object)srcBill)) {
            return null;
        }
        ChangeModelHelper.excutePluginMethod(changeModel, "beforeSrcBillChange", srcBill);
        long endqsrctime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle Finish: " + new Date(endqsrctime));
        LOGGER.info("BizChangePerformance----generateXBilll:2.QuerySrcBillLoadSingle UseTime: " + (endqsrctime - endquerycmtime) + " ms");
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") == null || changeModel.getDynamicObject("xbill").getPkValue() == null) {
            return null;
        }
        xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities((IDataEntityType)xBillDt);
        IDataEntityType srcBillET = srcBill.getDataEntityType();
        List<EntityType> srcBillentryEntitys = ChangeModelHelper.getChildEntities(srcBillET);
        DynamicObject xBill = new DynamicObject((DynamicObjectType)xBillDt);
        DynamicObjectCollection mapplingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        long begingenXbillTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry Begin: " + new Date(begingenXbillTime));
        HashSet<String> notRegistedEntryInfoSet = new HashSet<String>();
        for (DynamicObject mapplingEntity : mapplingEntitys) {
            try {
                DynamicObject xBillEntry;
                DynamicObject srcBillEntry;
                int i;
                DynamicObjectCollection srcBillEntrys;
                DynamicObjectCollection xBillEntrys;
                String targetFieldName = mapplingEntity.getString("targetfieldname");
                String sourceFieldName = mapplingEntity.getString("sourcefieldname");
                if (CommonUtils.isNull((Object)sourceFieldName)) continue;
                String[] targetItems = targetFieldName.split("\\.");
                String[] sourceItems = sourceFieldName.split("\\.");
                if (ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0])) {
                    xBill.set(mapplingEntity.getString("targetfield"), srcBill.get(mapplingEntity.getString("sourcefield")));
                    continue;
                }
                if (targetItems.length != 2 || sourceItems.length != 2 || ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0])) continue;
                EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
                EntityType srcBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(srcBillentryEntitys, sourceItems[0]);
                if (xBillEntryType == null || srcBillEntryType == null) continue;
                String entryTypeName = xBillEntryType.getName();
                if (entryAndOp.get(entryTypeName) == null) {
                    notRegistedEntryInfoSet.add(entryTypeName);
                    continue;
                }
                String entrychangetype = entryAndOp.get(xBillEntryType.getName()).get("changetype");
                String entrysrcid = entryAndOp.get(xBillEntryType.getName()).get("srcid");
                if (xBillEntryType.getClass() == EntryType.class) {
                    xBillEntrys = xBill.getDynamicObjectCollection(xBillEntryType.getName());
                    srcBillEntrys = srcBill.getDynamicObjectCollection(srcBillEntryType.getName());
                    if (entryAndOp.get(xBillEntryType.getName()) == null) continue;
                    if (srcBillEntrys.size() > 0 && xBillEntrys.size() == 0) {
                        for (i = 0; i < srcBillEntrys.size(); ++i) {
                            DynamicObject xBillEntry2 = xBillEntrys.addNew();
                            try {
                                xBillEntry2.set(entrysrcid, ((DynamicObject)srcBillEntrys.get(i)).getPkValue());
                                xBillEntry2.set(entrychangetype, (Object)ChangeTypeEnum.UPDATE.getValue());
                                continue;
                            }
                            catch (KDException e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                    }
                    for (i = 0; i < srcBillEntrys.size(); ++i) {
                        srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                        xBillEntry = (DynamicObject)xBillEntrys.get(i);
                        try {
                            if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid)) continue;
                            xBillEntry.set(mapplingEntity.getString("targetfield"), srcBillEntry.get(mapplingEntity.getString("sourcefield")));
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Throwable)e);
                        }
                    }
                    continue;
                }
                if (xBillEntryType.getClass() != SubEntryType.class) continue;
                xBillEntrys = xBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
                srcBillEntrys = srcBill.getDynamicObjectCollection(((EntryType)srcBillEntryType.getParent()).getName());
                for (i = 0; i < srcBillEntrys.size(); ++i) {
                    int j;
                    srcBillEntry = (DynamicObject)srcBillEntrys.get(i);
                    xBillEntry = (DynamicObject)xBillEntrys.get(i);
                    DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(srcBillEntryType.getName());
                    DynamicObjectCollection subXBillEntrys = xBillEntry.getDynamicObjectCollection(xBillEntryType.getName());
                    if (subSrcBillEntrys.size() > 0 && subXBillEntrys.size() == 0) {
                        for (j = 0; j < subSrcBillEntrys.size(); ++j) {
                            DynamicObject subXBillEntry = subXBillEntrys.addNew();
                            try {
                                subXBillEntry.set(entrysrcid, ((DynamicObject)subSrcBillEntrys.get(j)).getPkValue());
                                subXBillEntry.set(entrychangetype, (Object)ChangeTypeEnum.UPDATE.getValue());
                                continue;
                            }
                            catch (Exception e) {
                                LOGGER.warn((Throwable)e);
                            }
                        }
                    }
                    for (j = 0; j < subSrcBillEntrys.size(); ++j) {
                        DynamicObject subSrcBillEntry = (DynamicObject)subSrcBillEntrys.get(j);
                        DynamicObject subXBillEntry = (DynamicObject)subXBillEntrys.get(j);
                        try {
                            if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid)) continue;
                            subXBillEntry.set(mapplingEntity.getString("targetfield"), subSrcBillEntry.get(mapplingEntity.getString("sourcefield")));
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Throwable)e);
                        }
                    }
                }
            }
            catch (Exception ee) {
                LOGGER.warn((Throwable)ee);
            }
        }
        long endgenXbillTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry, These Entrys are not registed: " + notRegistedEntryInfoSet);
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry, Please check plugin!");
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry Finish: " + new Date(endgenXbillTime));
        LOGGER.info("BizChangePerformance----generateXBill:3.xbillSetValueByMapEntry UseTime: " + (endgenXbillTime - begingenXbillTime) + " ms");
        long beginGenXbillOtherTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueXPro Begin\uff1a " + new Date(beginGenXbillOtherTime));
        xBill.set("billtype", (Object)BillTypeHelper.getBillTypeByEntity(xBill.getDataEntityType().getName()));
        if (changeModel.getBoolean("isnotupdateversion")) {
            xBill.set("changebillno", (Object)(srcBill.get("billno") + "_" + srcBill.get("version") + "_" + srcBill.get("subversion")));
        } else {
            xBill.set("changebillno", (Object)(srcBill.get("billno") + "_" + srcBill.get("version")));
        }
        xBill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        xBill.set("changebizdate", (Object)new Date(System.currentTimeMillis()));
        xBill.set("sourcebillid", srcBill.getPkValue());
        xBill.set("sourcebillentity", (Object)srcBill.getDataEntityType().getName());
        xBill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        xBill.set("valider", null);
        xBill.set("validdate", null);
        xBill.set("changecancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
        xBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
        xBill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        xBill.set("creator", (Object)currentUserDO);
        xBill.set("createtime", (Object)new Date(System.currentTimeMillis()));
        xBill.set("modifier", (Object)currentUserDO);
        xBill.set("modifytime", (Object)new Date(System.currentTimeMillis()));
        ChangeModelHelper.excutePluginMethod(changeModel, "afterSrcBillChange", srcBill);
        long endGenXbillOtherTime = System.currentTimeMillis();
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueByXPro Finish: " + new Date(endGenXbillOtherTime));
        LOGGER.info("BizChangePerformance----generateXBill:4.xbillSetValueByXPro UseTime: " + (endGenXbillOtherTime - beginGenXbillOtherTime) + " ms");
        return xBill;
    }

    public static DynamicObject[] generateXBilll(DynamicObject[] srcBills) {
        ArrayList<DynamicObject> xBills = new ArrayList<DynamicObject>();
        for (DynamicObject srcBill : srcBills) {
            DynamicObject xBill = ChangeModelHelper.generateXBilll(srcBill.getDataEntityType().getName(), (Long)srcBill.getPkValue());
            if (CommonUtils.isNull((Object)xBill)) continue;
            xBills.add(xBill);
        }
        if (xBills.size() == 0) {
            return null;
        }
        return xBills.toArray(new DynamicObject[xBills.size()]);
    }

    public static String[] getProperty4Entry(IDataEntityType dt, String entryName) {
        DynamicPropertyCollection dynPropColl = (DynamicPropertyCollection)dt.getProperties();
        Iterator it = dynPropColl.iterator();
        ArrayList<String> arPropName = new ArrayList<String>();
        while (it.hasNext()) {
            DataEntityPropertyCollection entry;
            IDataEntityProperty dataEntityProp = (IDataEntityProperty)it.next();
            if (dataEntityProp instanceof EntryProp && dataEntityProp.getName().equals(entryName)) {
                entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropEntry : entry) {
                    if (dataEntityPropEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropEntry.getName());
                }
                continue;
            }
            if (!(dataEntityProp instanceof EntryProp)) continue;
            entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty dataEntityPropEntry : entry) {
                if (!(dataEntityPropEntry instanceof EntryProp) || !dataEntityPropEntry.getName().equals(entryName)) continue;
                DataEntityPropertyCollection subEntry = ((EntryProp)dataEntityPropEntry).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropSubEntry : subEntry) {
                    if (dataEntityPropSubEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropSubEntry.getName());
                }
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            if (!ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canwriteback");
            String[] targetItems = targetFieldname.split("\\.");
            if (!ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getEnableProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            if (!ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getUnEnableProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            if (!ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canwriteback");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getEnableProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || !canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getUnEnableProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelHelper.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>();
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelHelper.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelHelper.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]).equals(targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(ChangeModelHelper.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    public static EntityType getChildEntitiesByAlias(List<EntityType> childEntities, String alias) {
        for (EntityType childEntity : childEntities) {
            if (alias == null || !alias.equals(childEntity.getDisplayName().getLocaleValue())) continue;
            return childEntity;
        }
        return null;
    }

    public static String[] getChangeService(DynamicObject changeModel) {
        if (CommonUtils.isNull((Object)changeModel)) {
            return null;
        }
        DynamicObjectCollection plugins = changeModel.getDynamicObjectCollection("pluginentity");
        if (CommonUtils.isNull((Object)plugins)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (DynamicObject plugin : plugins) {
            Boolean pluginenable = plugin.getBoolean("pluginenable");
            String classname = plugin.getString("classname");
            if (!pluginenable.booleanValue() || CommonUtils.isNull((Object)classname)) continue;
            res.add(classname);
        }
        if (res.size() != 0) {
            return res.toArray(new String[res.size()]);
        }
        return null;
    }

    public static String[] getAllWritebackProperty(IDataEntityType xbillDt) {
        String[] enablePropertys = ChangeModelHelper.getEnableProperty(xbillDt);
        String[] canwritebackPropertys = ChangeModelHelper.getCanWritebackProperty(xbillDt);
        ArrayList allwritebackPropertys = new ArrayList();
        if (enablePropertys != null && enablePropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, enablePropertys);
        }
        if (canwritebackPropertys != null && canwritebackPropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, canwritebackPropertys);
        }
        if (allwritebackPropertys != null && allwritebackPropertys.size() > 0) {
            return allwritebackPropertys.toArray(new String[0]);
        }
        return null;
    }

    public static String[] getAllWritebackProperty(IDataEntityType xBillDt, String entryEntity) {
        String[] enablePropertys = ChangeModelHelper.getEnableProperty(xBillDt, entryEntity);
        String[] canwritebackPropertys = ChangeModelHelper.getCanWritebackProperty(xBillDt, entryEntity);
        ArrayList allwritebackPropertys = new ArrayList();
        if (enablePropertys != null && enablePropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, enablePropertys);
        }
        if (canwritebackPropertys != null && canwritebackPropertys.length > 0) {
            Collections.addAll(allwritebackPropertys, canwritebackPropertys);
        }
        if (allwritebackPropertys != null && allwritebackPropertys.size() > 0) {
            return allwritebackPropertys.toArray(new String[0]);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOp(DynamicObject changeModel) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        String[] plugins = ChangeModelHelper.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("entity", "billentry");
            value.put("entry_toolbar", "tbmainentry");
            value.put("btn_add", "addrow");
            value.put("btn_delete", "deleterow");
            value.put("btn_modify", "modifyrow");
            value.put("changetype", "billentrychangetype");
            value.put("srcid", "billentrysrcid");
            result.put((String)value.get("entity"), (Map<String, String>)value);
            return result;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod("getXBillEntryAndOp", new Class[0]);
                Object r = m.invoke(c.newInstance(), new Object[0]);
                if (r == null || !(r instanceof Map)) continue;
                result.putAll((Map)r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void excutePluginMethod(DynamicObject changeModel, String methodName, DynamicObject arg) {
        String[] plugins = ChangeModelHelper.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            return;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod(methodName, DynamicObject.class);
                m.invoke(c.newInstance(), arg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            condition.createMetaData();
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static Map<Long, List<Object>> getAreaConditionArray(Long changeModel, String srcType) {
        DynamicObject changemodel = BusinessDataServiceHelper.loadSingleFromCache((Object)changeModel, (String)"plat_changemodel");
        String runcondition = "";
        String runconditionDesc = "";
        HashMap<Long, List<Object>> areaFilterMap = new HashMap<Long, List<Object>>();
        if (changemodel != null) {
            runcondition = changemodel.getString("areaconditionjson");
            runconditionDesc = changemodel.getString("areaconditiondesc");
            FilterBuilder fb = ChangeModelHelper.convertStringToQFilter(runcondition, srcType);
            ArrayList<Object> filterlist = new ArrayList<Object>(2);
            if (fb != null) {
                filterlist.add(fb);
                filterlist.add(runconditionDesc);
                areaFilterMap.put(changeModel, filterlist);
            } else {
                areaFilterMap.put(changeModel, null);
            }
            return areaFilterMap;
        }
        return null;
    }

    public static ConditionValidation convertStringToValidate(String validconditionjson) {
        if (StringUtils.isNotEmpty((String)validconditionjson)) {
            ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>();
            dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
            ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
            Map parameter = (Map)SerializationUtils.fromJsonString((String)validconditionjson, Map.class);
            ConditionValidation validation = (ConditionValidation)new DcJsonSerializer((DcBinder)binder).deserializeFromMap(parameter, null);
            return validation;
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId) {
        DynamicObject changmodel = ChangeModelHelper.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObjectCollection validcol = changmodel.getDynamicObjectCollection("validentity");
            ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>();
            for (DynamicObject valid : validcol) {
                ConditionValidation validation = ChangeModelHelper.convertStringToValidate(valid.getString("validconditionjson_tag"));
                if (validation == null || !validation.getEnabled()) continue;
                vallist.add(validation);
            }
            return vallist;
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId, String opkey) {
        DynamicObject changmodel = ChangeModelHelper.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObject changemodelDO = changmodel;
            String validoptype = changemodelDO.getString("validoptype");
            if (StringUtils.isNotEmpty((String)validoptype) && validoptype.contains(opkey)) {
                DynamicObjectCollection validcol = changemodelDO.getDynamicObjectCollection("validentity");
                ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>();
                for (DynamicObject valid : validcol) {
                    ConditionValidation validation = ChangeModelHelper.convertStringToValidate(valid.getString("validconditionjson_tag"));
                    if (validation == null || !validation.getEnabled()) continue;
                    vallist.add(validation);
                }
                return vallist;
            }
            return null;
        }
        return null;
    }

    private static DynamicObjectCollection getMappingColFromXBillDT(IDataEntityType xBillDt) {
        if (xBillDt == null) {
            return null;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(xBillDt.getName());
        if (changeModel == null) {
            return null;
        }
        DynamicObjectCollection mappingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        return mappingEntitys;
    }
}

