/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.builder;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.scmc.plat.business.helper.pricemodel.helper.MarkDownHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.common.enums.price.OperatorEnum;
import kd.scmc.plat.common.enums.price.OrderEnum;

public abstract class QuoteLogBuilder {
    private String sceneType;

    public QuoteLogBuilder(String sceneType) {
        this.sceneType = sceneType;
    }

    public String build(QuoteSchemeColl quoteSchemeColl, String schemeID, int seq, List<String> resultList, Row row) {
        StringBuilder logSchemeText = new StringBuilder();
        QuoteSchemeInfo quoteSchemeInfo = quoteSchemeColl.getQuoteSchemes(schemeID);
        String schemeName = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\uff1a", (String)"QuoteLogBuilder_0", (String)"scmc-plat-business", (Object[])new Object[0]), seq);
        StringBuilder schemeName_s = new StringBuilder(schemeName).append(quoteSchemeInfo.getName());
        logSchemeText.append((CharSequence)MarkDownHelper.getFourLevel(schemeName_s));
        String preConditionDesc = quoteSchemeInfo.getQuotePreConditonDesc();
        String terminationSign = quoteSchemeInfo.getTerminationSign();
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditon(seq, preConditionDesc));
        logSchemeText.append("\n\n");
        logSchemeText.append(this.preConditonResult(seq));
        if (!this.getCancel()) {
            logSchemeText.append("\n\n");
            StringBuilder analysisScheme = new StringBuilder();
            analysisScheme.append(ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u65b9\u6848\uff1a", (String)"QuoteLogBuilder_5", (String)"scmc-plat-business", (Object[])new Object[0]));
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(analysisScheme)));
            logSchemeText.append("\n\n");
            String fieldMapping = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff1a", (String)"QuoteLogBuilder_10", (String)"scmc-plat-business", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(fieldMapping)));
            for (int s = 0; s < quoteSchemeInfo.getQuoteDimensionsDes().size(); ++s) {
                logSchemeText.append("\n\n");
                StringBuilder mappingField = new StringBuilder();
                mappingField.append(quoteSchemeInfo.getQuoteSourceDimensionsDes().get(s)).append("/").append(OperatorEnum.getName((String)quoteSchemeInfo.getOperators().get(s))).append("/").append(quoteSchemeInfo.getQuoteDimensionsDes().get(s));
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(mappingField));
            }
            logSchemeText.append("\n\n");
            String otherConditon = ResManager.loadKDString((String)"\u5176\u4ed6\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_6", (String)"scmc-plat-business", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(otherConditon)));
            logSchemeText.append("\n\n");
            if (StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSrcFilterDes())) {
                String quoteSrcFilterDes = MarkDownHelper.formatConditon(quoteSchemeInfo.getQuoteSrcFilterDes());
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(quoteSrcFilterDes)));
            } else {
                String unSettring = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_7", (String)"scmc-plat-business", (Object[])new Object[0]);
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(unSettring)));
            }
            logSchemeText.append("\n\n");
            String priceSort = ResManager.loadKDString((String)"\u4ef7\u683c\u6392\u5e8f\uff1a", (String)"QuoteLogBuilder_8", (String)"scmc-plat-business", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(priceSort)));
            if (quoteSchemeInfo.getSortSignsDes().size() > 0) {
                for (int s = 0; s < quoteSchemeInfo.getSortSignsDes().size(); ++s) {
                    logSchemeText.append("\n\n");
                    StringBuilder sortField = new StringBuilder();
                    sortField.append(quoteSchemeInfo.getSortSignsDes().get(s)).append("/").append(OrderEnum.getName((String)quoteSchemeInfo.getSortOrders().get(s)));
                    logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(sortField));
                }
            } else {
                logSchemeText.append("\n\n");
                String unSort = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6392\u5e8f", (String)"QuoteLogBuilder_9", (String)"scmc-plat-business", (Object[])new Object[0]);
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(new StringBuilder(unSort)));
            }
            logSchemeText.append("\n\n");
            String resultStr = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\uff1a", (String)"QuoteLogBuilder_12", (String)"scmc-plat-business", (Object[])new Object[0]);
            logSchemeText.append((CharSequence)MarkDownHelper.putFourSpace(MarkDownHelper.thicker(new StringBuilder(resultStr))));
            if (resultList == null || resultList.size() == 0) {
                logSchemeText.append("\n\n");
                logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c", (String)"QuoteLogProxy_1", (String)"scmc-plat-business", (Object[])new Object[0])))));
            } else {
                for (String result : resultList) {
                    logSchemeText.append("\n\n");
                    logSchemeText.append((CharSequence)MarkDownHelper.putSixSpace(MarkDownHelper.thicker(new StringBuilder(result))));
                }
            }
            logSchemeText.append("\n\n");
            logSchemeText.append(this.multiValueResult());
            logSchemeText.append("\n\n");
            String schemeTemination = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u7ec8\u6b62\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_3", (String)"scmc-plat-business", (Object[])new Object[0]), seq);
            MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)quoteSchemeInfo.getQuoteSrcType());
            Map allFileds = quoteBillType.getAllFields();
            String[] subFields = terminationSign.split("__");
            String terminationSignField = subFields[subFields.length - 1];
            String terminationSignName = ((IDataEntityProperty)allFileds.get(terminationSignField)).getDisplayName().toString();
            logSchemeText.append(MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(schemeTemination).append(this.getTerminationResult(terminationSignName)))).toString());
        }
        return logSchemeText.toString();
    }

    abstract boolean getCancel();

    abstract boolean getPreConditonResult();

    abstract String getTerminationResult(String var1);

    private String preConditonResult(int seq) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6\u7ed3\u679c\uff1a", (String)"QuoteLogBuilder_1", (String)"scmc-plat-business", (Object[])new Object[0]), seq));
        boolean preConditonResult = this.getPreConditonResult();
        result.append(preConditonResult);
        if (preConditonResult) {
            result = MarkDownHelper.thicker(result);
        }
        return MarkDownHelper.putTwoSpace(result).toString();
    }

    private String preConditon(int seq, String preConditionDesc) {
        StringBuilder result = new StringBuilder();
        result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6\uff1a", (String)"QuoteLogBuilder_4", (String)"scmc-plat-business", (Object[])new Object[0]), seq));
        result = MarkDownHelper.putTwoSpace(result);
        result.append("\n\n");
        if (StringUtils.isNotEmpty((CharSequence)preConditionDesc)) {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(preConditionDesc)));
        } else {
            result.append((CharSequence)MarkDownHelper.putFourSpace(new StringBuilder(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u53d6\u4ef7\u65b9\u6848\u524d\u7f6e\u6761\u4ef6", (String)"QuoteLogBuilder_11", (String)"scmc-plat-business", (Object[])new Object[0]))));
        }
        return result.toString();
    }

    abstract String multiValueResult();
}

