/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;

public class DataSetHelper {
    private static final Log LOGGER = LogFactory.getLog(DataSetHelper.class);

    public static DataSet toDataSetByMap(List<Map<String, Object>> listEntrys, String entityType, List<String> dimensions, List<String> alias, QuoteKeyInfo qccInfo) {
        if (listEntrys.size() <= 0) {
            return null;
        }
        ArrayList<String> headerProperties = new ArrayList<String>();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerAlias = new ArrayList<String>();
        ArrayList<String> entryAlias = new ArrayList<String>();
        for (int i = 0; i < dimensions.size(); ++i) {
            String property = dimensions.get(i);
            if (property.contains(qccInfo.getEntryName())) {
                entryProperties.add(property);
                entryAlias.add(alias.get(i));
                continue;
            }
            headerProperties.add(property);
            headerAlias.add(alias.get(i));
        }
        RowMeta quoteRowMeta = DataSetHelper.getRowMeta(entityType, qccInfo, headerProperties, entryProperties, headerAlias, entryAlias);
        PropertySort propertySort = new PropertySort(qccInfo, headerProperties, entryProperties, headerAlias, entryAlias).invoke();
        List<String> allProperties = propertySort.getAllProperties();
        ArrayList<Object[]> quoteBillList = new ArrayList<Object[]>();
        if (listEntrys.size() > 0) {
            for (int i = 0; i < listEntrys.size(); ++i) {
                Object[] quoteRow = new Object[quoteRowMeta.getFieldCount()];
                Map<String, Object> properties = listEntrys.get(i);
                for (int p = 0; p < allProperties.size(); ++p) {
                    quoteRow[p] = DataSetHelper.defaultValue4Null(properties.get(allProperties.get(p)), quoteRowMeta.getFields()[p].getDataType());
                }
                quoteBillList.add(quoteRow);
            }
        }
        return Algo.create((String)"DateSetHelper").createDataSet(quoteBillList.iterator(), quoteRowMeta);
    }

    public static DataSet toDataSet(DynamicObject[] cc, String entityType, String[] properties, String[] alias, QuoteKeyInfo qccInfo) {
        if (cc.length <= 0) {
            return null;
        }
        if (qccInfo.getEntryCount() == 0) {
            return DataSetHelper.dataSet4Header(cc, entityType, properties, alias, qccInfo);
        }
        return DataSetHelper.dataSet4Whole(cc, entityType, properties, alias, qccInfo);
    }

    private static DataSet dataSet4Header(DynamicObject[] cc, String entityType, String[] properties, String[] alias, QuoteKeyInfo qccInfo) {
        RowMeta quoteRowMeta = DataSetHelper.getRowMeta(entityType, qccInfo, Arrays.asList(properties), null, Arrays.asList(alias), null);
        ArrayList<Object[]> quoteBillList = new ArrayList<Object[]>(cc.length);
        for (int i = 0; i < cc.length; ++i) {
            DynamicObject quoteBill = cc[i];
            Object[] quoteRow = new Object[quoteRowMeta.getFieldCount()];
            for (int k = 0; k < properties.length; ++k) {
                String headProperty = properties[k];
                String[] headDividePropertys = headProperty.split("\\.");
                quoteRow[k] = DataSetHelper.getValue(headDividePropertys, 0, quoteBill, quoteRowMeta.getFields()[k].getDataType());
            }
            quoteRow[quoteRowMeta.getFieldCount() - 1] = quoteBill.getPkValue() == null ? Long.valueOf(0L) : quoteBill.getPkValue();
            quoteBillList.add(quoteRow);
        }
        return DataSetHelper.createDataSet(quoteRowMeta, quoteBillList);
    }

    private static DataSet dataSet4Whole(DynamicObject[] cc, String entityType, String[] properties, String[] alias, QuoteKeyInfo qccInfo) {
        ArrayList<String> headerProperties = new ArrayList<String>();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerAlias = new ArrayList<String>();
        ArrayList<String> entryAlias = new ArrayList<String>();
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (property.contains(qccInfo.getEntryName())) {
                entryProperties.add(property);
                entryAlias.add(alias[i]);
                continue;
            }
            headerProperties.add(property);
            headerAlias.add(alias[i]);
        }
        RowMeta quoteRowMeta = DataSetHelper.getRowMeta(entityType, qccInfo, headerProperties, entryProperties, headerAlias, entryAlias);
        ArrayList<Object[]> quoteBillList = new ArrayList<Object[]>();
        for (int i = 0; i < cc.length; ++i) {
            DynamicObjectCollection quoteEntry;
            DynamicObject quoteBill = cc[i];
            try {
                quoteEntry = quoteBill.getDynamicObjectCollection(qccInfo.getEntryName());
            }
            catch (Exception e) {
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u5355\u636e\u672a\u4f20\u9012\u5206\u5f55\u4fe1\u606f\u3002", (String)"DataSetHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            if (quoteEntry != null && quoteEntry.size() > 0) {
                for (int j = 0; j < quoteEntry.size(); ++j) {
                    DynamicObject quoteEntryInfo = (DynamicObject)quoteEntry.get(j);
                    Object[] quoteRow = new Object[quoteRowMeta.getFieldCount()];
                    for (int k = 0; k < headerProperties.size(); ++k) {
                        String headProperty = (String)headerProperties.get(k);
                        String[] headDividePropertys = headProperty.split("\\.");
                        quoteRow[k] = DataSetHelper.getValue(headDividePropertys, 0, quoteBill, quoteRowMeta.getFields()[k].getDataType());
                    }
                    for (int s = 0; s < entryProperties.size(); ++s) {
                        String entryProperty = (String)entryProperties.get(s);
                        String[] entryDividePropertys = entryProperty.split("\\.");
                        quoteRow[s + headerProperties.size()] = DataSetHelper.getValue(entryDividePropertys, 1, quoteEntryInfo, quoteRowMeta.getFields()[s + headerProperties.size()].getDataType());
                    }
                    quoteRow[quoteRowMeta.getFieldCount() - 3] = quoteBill.getPkValue() == null ? Long.valueOf(0L) : quoteBill.getPkValue();
                    quoteRow[quoteRowMeta.getFieldCount() - 2] = quoteEntryInfo.getPkValue() == null ? Long.valueOf(0L) : quoteEntryInfo.getPkValue();
                    quoteRow[quoteRowMeta.getFieldCount() - 1] = j + 1;
                    quoteBillList.add(quoteRow);
                }
                continue;
            }
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u5355\u636e\u672a\u7ef4\u62a4\u5206\u5f55\u4fe1\u606f\u3002", (String)"DataSetHelper_2", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return DataSetHelper.createDataSet(quoteRowMeta, quoteBillList);
    }

    private static DataSet createDataSet(RowMeta quoteRowMeta, Collection<Object[]> quoteBillList) {
        return Algo.create((String)"DateSetHelper").createDataSet(quoteBillList.iterator(), quoteRowMeta);
    }

    private static RowMeta getRowMeta(String entityType, QuoteKeyInfo qccInfo, List<String> headerProperties, List<String> entryProperties, List<String> headerAlias, List<String> entryAlias) {
        PropertySort propertySort = new PropertySort(qccInfo, headerProperties, entryProperties, headerAlias, entryAlias).invoke();
        List<String> allProperties = propertySort.getAllProperties();
        List<String> allAlias = propertySort.getAllAlias();
        if (qccInfo.isHasTable()) {
            for (int i = 0; i < allProperties.size(); ++i) {
                allProperties.set(i, new StringBuffer(allProperties.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(allAlias.get(i))).toString());
            }
            String selectProperties = String.join((CharSequence)",", allProperties);
            DataSet stereotype = null;
            try {
                stereotype = QueryServiceHelper.queryDataSet((String)"DateSetHelper", (String)entityType, (String)selectProperties, (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id", (int)1);
                return stereotype.getRowMeta();
            }
            catch (Exception e) {
                try {
                    if (stereotype != null) {
                        stereotype.close();
                    }
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                }
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u5355\u636e\u5143\u6570\u636e\u53ef\u80fd\u5b58\u5728\u8868\u540d\u6216\u5b57\u6bb5\u53d8\u66f4\u5bfc\u81f4\u65e0\u6cd5\u5b8c\u6210\u8bfb\u53d6\u3002", (String)"DataSetHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
        }
        ArrayList dataTypes_head = new ArrayList(headerProperties.size());
        ArrayList dataTypes_entry = new ArrayList(entryProperties != null ? entryProperties.size() : 0);
        ArrayList dataType_key = new ArrayList(qccInfo.getIDFIELDS().size());
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        try {
            headerProperties.forEach(p -> {
                IDataEntityProperty ep = DataSetHelper.findPropertys((EntityType)headType, p);
                dataTypes_head.add(DataSetHelper.transferDataType(ep));
            });
            if (entryProperties != null && entryProperties.size() > 0) {
                EntityType entryType = (EntityType)headType.getAllEntities().get(qccInfo.getEntryName());
                entryProperties.forEach(p -> {
                    p = p.replace(new StringBuffer(qccInfo.getEntryName()).append("."), "");
                    IDataEntityProperty ep = DataSetHelper.findPropertys(entryType, p);
                    dataTypes_entry.add(DataSetHelper.transferDataType(ep));
                });
            }
            qccInfo.getIDFIELDS().forEach(p -> {
                IDataEntityProperty ep = DataSetHelper.findPropertys((EntityType)headType, p);
                if (ep == null && "id".equals(p)) {
                    dataType_key.add(DataSetHelper.transferDataType((IDataEntityProperty)new PKFieldProp()));
                } else {
                    dataType_key.add(DataSetHelper.transferDataType(ep));
                }
            });
            ArrayList dataTypes = new ArrayList(allAlias.size());
            dataTypes.addAll(dataTypes_head);
            dataTypes.addAll(dataTypes_entry);
            dataTypes.addAll(dataType_key);
            RowMeta rowMeta = new RowMeta(allAlias.toArray(new String[0]), dataTypes.toArray(new DataType[0]));
            return rowMeta;
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u5355\u636e\u5143\u6570\u636e\u53ef\u80fd\u5b58\u5728\u5b57\u6bb5\u65e0\u6cd5\u786e\u5b9a\u6570\u636e\u7c7b\u578b\u5bfc\u81f4\u65e0\u6cd5\u5b8c\u6210\u8bfb\u53d6\u3002", (String)"DataSetHelper_4", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    public static RowMeta getRowMetaLight(String entityType, QuoteKeyInfo qccInfo, List<String> resultFields) {
        ArrayList alias = new ArrayList(resultFields.size());
        if (qccInfo.isHasTable()) {
            resultFields.forEach(r -> {
                String[] entryDividePropertys = r.split("\\.");
                alias.add(entryDividePropertys[entryDividePropertys.length - 1]);
            });
            for (int i = 0; i < resultFields.size(); ++i) {
                resultFields.set(i, new StringBuffer(resultFields.get(i)).append(new StringBuffer(" ")).append(new StringBuffer((String)alias.get(i))).toString());
            }
            DataSet stereotype = QueryServiceHelper.queryDataSet((String)"DateSetHelper", (String)entityType, (String)String.join((CharSequence)",", resultFields), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id", (int)1);
            RowMeta quoteResultMeta = stereotype.getRowMeta();
            return quoteResultMeta;
        }
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList dataTypes = new ArrayList(resultFields.size());
        resultFields.forEach(p -> {
            String[] entryDividePropertys = p.split("\\.");
            if (p.contains(qccInfo.getEntryName())) {
                EntityType entryType = (EntityType)headType.getAllEntities().get(qccInfo.getEntryName());
                p = p.replace(new StringBuffer(qccInfo.getEntryName()).append("."), "");
                IDataEntityProperty ep = DataSetHelper.findPropertys(entryType, p);
                dataTypes.add(DataSetHelper.transferDataType(ep));
            } else {
                IDataEntityProperty ep = DataSetHelper.findPropertys((EntityType)headType, p);
                dataTypes.add(DataSetHelper.transferDataType(ep));
            }
            alias.add(entryDividePropertys[entryDividePropertys.length - 1]);
        });
        RowMeta rowMeta = new RowMeta(alias.toArray(new String[0]), dataTypes.toArray(new DataType[0]));
        return rowMeta;
    }

    private static Object getValue(String[] dividePropertys, int startIndex, DynamicObject source, DataType type) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return DataSetHelper.defaultValue4Null(source.get(dividePropertys[startIndex]), type);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return DataSetHelper.getValue(dividePropertys, ++startIndex, source, type);
            }
            catch (Exception e) {
                return DataSetHelper.defaultValue4Null(null, type);
            }
        }
        return null;
    }

    public static Object defaultValue4Null(Object value, DataType type) {
        if (value == null) {
            if (type.getName().equals("Long")) {
                return 0L;
            }
            if (type.getName().equals("String")) {
                return null;
            }
            if (type.getName().equals("BigDecimal")) {
                return BigDecimal.ZERO;
            }
            if (type.getName().equals("Timestamp")) {
                return null;
            }
            if (type.getName().equals("Date")) {
                return null;
            }
            if (type.getName().equals("Integer")) {
                return 0;
            }
            if (type.getName().equals("Boolean")) {
                return Boolean.FALSE;
            }
        } else {
            return value;
        }
        return value;
    }

    private static DataType transferDataType(IDataEntityProperty ep) {
        if (ep instanceof BasedataProp) {
            return DataType.LongType;
        }
        if (ep instanceof TextProp) {
            return DataType.StringType;
        }
        if (ep instanceof BooleanProp) {
            return DataType.BooleanType;
        }
        if (ep instanceof IntegerProp) {
            return DataType.IntegerType;
        }
        if (ep instanceof DecimalProp) {
            return DataType.BigDecimalType;
        }
        if (ep instanceof ComboProp) {
            return DataType.StringType;
        }
        if (ep instanceof DateProp) {
            return DataType.DateType;
        }
        if (ep instanceof DateTimeProp) {
            return DataType.DateType;
        }
        if (ep instanceof TimeProp) {
            return DataType.TimestampType;
        }
        if (ep instanceof LongProp) {
            return DataType.LongType;
        }
        if (ep instanceof PKFieldProp) {
            return DataType.LongType;
        }
        return null;
    }

    public static IDataEntityProperty findPropertys(EntityType mainType, String fullPropName) {
        String[] keys = fullPropName.split("\\.");
        ArrayList<String> list = new ArrayList<String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            list.add(keys[i]);
        }
        IDataEntityProperty property = mainType.findProperty(fullPropName);
        if (property != null) {
            return property;
        }
        IDataEntityProperty headProp = mainType.findProperty((String)list.get(0));
        if (headProp == null) {
            return null;
        }
        if (headProp instanceof EntryProp) {
            list.remove(0);
            String leftString = StringUtils.join((Object[])list.toArray(), (String)".");
            if (mainType instanceof MainEntityType) {
                EntityType entryType = (EntityType)((MainEntityType)mainType).getAllEntities().get(headProp.getName());
                return DataSetHelper.findPropertys(entryType, leftString);
            }
            return null;
        }
        if (!(headProp instanceof BasedataProp)) {
            return null;
        }
        BasedataProp headProp1 = (BasedataProp)headProp;
        MainEntityType baseEntityType2 = (MainEntityType)headProp1.getComplexType();
        list.remove(0);
        String leftString = StringUtils.join((Object[])list.toArray(), (String)".");
        return DataSetHelper.findPropertys((EntityType)baseEntityType2, leftString);
    }

    public static boolean isIncludeField(String sign, DataSet result) {
        Field[] fields;
        boolean include = false;
        for (Field field : fields = result.getRowMeta().getFields()) {
            if (!field.getName().equals(sign)) continue;
            include = true;
        }
        return include;
    }

    public static List<String> getIncludeFields(List<String> aliasFields, DataSet result) {
        Field[] fields = result.getRowMeta().getFields();
        ArrayList<String> includeFields = new ArrayList<String>();
        for (String aliasField : aliasFields) {
            for (Field field : fields) {
                if (!field.getName().equals(aliasField)) continue;
                includeFields.add(aliasField);
            }
        }
        return includeFields;
    }

    private static class PropertySort {
        private QuoteKeyInfo qccInfo;
        private List<String> headerProperties;
        private List<String> entryProperties;
        private List<String> headerAlias;
        private List<String> entryAlias;
        private List<String> allProperties;
        private List<String> allAlias;

        public PropertySort(QuoteKeyInfo qccInfo, List<String> headerProperties, List<String> entryProperties, List<String> headerAlias, List<String> entryAlias) {
            this.qccInfo = qccInfo;
            this.headerProperties = headerProperties;
            this.entryProperties = entryProperties;
            this.headerAlias = headerAlias;
            this.entryAlias = entryAlias;
        }

        public List<String> getAllProperties() {
            return this.allProperties;
        }

        public List<String> getAllAlias() {
            return this.allAlias;
        }

        public PropertySort invoke() {
            this.allProperties = new ArrayList<String>();
            this.allAlias = new ArrayList<String>();
            this.allProperties.addAll(this.headerProperties);
            this.allAlias.addAll(this.headerAlias);
            if (this.entryProperties != null) {
                this.allProperties.addAll(this.entryProperties);
            }
            if (this.entryAlias != null) {
                this.allAlias.addAll(this.entryAlias);
            }
            this.qccInfo.getIDFIELDS().forEach(f -> this.allProperties.add((String)f));
            this.qccInfo.getLEFTIDFIELDS().forEach(f -> this.allAlias.add((String)f));
            return this;
        }
    }
}

