/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;

public class FetchPriceHelper {
    private static String HEAD_FLAG = "header";
    private static String ENTRY_FLAG = "entry";
    public static final String SPLIT = "\\.";
    private static final Log LOGGER = LogFactory.getLog(FetchPriceHelper.class);

    public static Map<Long, Map<String, Object>> fetchPriceConditonKey(Set<Long> orgIds, String entityType) {
        LOGGER.info("fetchquotekey start==" + TimeServiceHelper.now());
        HashMap quoteParam = new HashMap();
        Map priceMapKey = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{orgIds.toArray(new Long[orgIds.size()]), entityType, quoteParam});
        LOGGER.info("fetchquotekey end==" + TimeServiceHelper.now());
        return priceMapKey;
    }

    public static Map<Long, List<Map<String, Object>>> buildMap4Entry(Map<Long, Map<String, Object>> priceMapKey, Map<Long, List<DynamicObject>> billMap) {
        HashMap<Long, List<Map<String, Object>>> propertiesMap = new HashMap<Long, List<Map<String, Object>>>();
        priceMapKey.forEach((k, v) -> {
            ArrayList parasList = new ArrayList();
            List bills = (List)billMap.get(k);
            String entryName = "";
            List entryKeys = (List)v.get(ENTRY_FLAG);
            if (entryKeys != null && entryKeys.size() > 0) {
                String[] fields = ((String)entryKeys.get(0)).split(SPLIT);
                entryName = fields[0];
            }
            for (int i = 0; bills != null && i < bills.size(); ++i) {
                DynamicObject bill = (DynamicObject)bills.get(i);
                HashMap headMap = new HashMap();
                if (v.get(HEAD_FLAG) != null) {
                    List headKeys = (List)v.get(HEAD_FLAG);
                    FetchPriceHelper.genPKValue(bill);
                    headKeys.forEach(l -> headMap.put(l, FetchPriceHelper.getValue(l.split(SPLIT), 0, bill)));
                }
                if (StringUtils.isNotEmpty((String)entryName)) {
                    DynamicObjectCollection col = bill.getDynamicObjectCollection(entryName);
                    if (col != null && col.size() > 0) {
                        for (int j = 0; col != null && j < col.size(); ++j) {
                            HashMap map = new HashMap();
                            DynamicObject entryInfo = (DynamicObject)col.get(j);
                            FetchPriceHelper.genPKValue(entryInfo);
                            entryKeys.forEach(l -> map.put(l, FetchPriceHelper.getValue(l.split(SPLIT), 1, entryInfo)));
                            map.putAll(headMap);
                            parasList.add(map);
                        }
                        continue;
                    }
                    parasList.add(headMap);
                    continue;
                }
                parasList.add(headMap);
            }
            propertiesMap.put((Long)k, parasList);
        });
        return propertiesMap;
    }

    public static Map<Long, Map<String, Object>> fetchPrice(String entityType, Map<Long, List<Map<String, Object>>> propertiesMap, Map<String, Object> quoteOtherParam) {
        LOGGER.info("fetchPrice start==" + TimeServiceHelper.now());
        Map priceMapObj = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"quoteByMapIgnoreExpWithParam", (Object[])new Object[]{propertiesMap, entityType, quoteOtherParam});
        LOGGER.info("fetchPrice end==" + TimeServiceHelper.now());
        return priceMapObj;
    }

    public static Map<Long, Map<String, Object>> integrationFetchPrice(Map<Long, List<DynamicObject>> billMap, String entityType, Map<String, Object> quoteOtherParam) {
        Set<Long> orgIds = billMap.keySet();
        Map<Long, Map<String, Object>> priceMapKey = FetchPriceHelper.fetchPriceConditonKey(orgIds, entityType);
        if (priceMapKey == null) {
            return null;
        }
        Map<Long, List<Map<String, Object>>> propertiesMap = FetchPriceHelper.buildMap4Entry(priceMapKey, billMap);
        Map<Long, Map<String, Object>> result = FetchPriceHelper.fetchPrice(entityType, propertiesMap, quoteOtherParam);
        return result;
    }

    private static void genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
    }

    private static Object getValue(String[] dividePropertys, int startIndex, DynamicObject source) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return source.get(dividePropertys[startIndex]);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return FetchPriceHelper.getValue(dividePropertys, ++startIndex, source);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

