/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.PriceAdjustLogAssemble;
import kd.scmc.plat.business.helper.pricemodel.pojo.PriceBatchAdjustInfo;
import kd.scmc.plat.common.enums.price.AdjustFlagEnum;
import kd.scmc.plat.common.enums.price.AdjustModelEnum;
import kd.scmc.plat.common.enums.price.PriceAdjustModelEnum;
import kd.scmc.plat.common.enums.price.StatusEnum;
import kd.scmc.plat.common.enums.price.ValidEnum;

public class PriceAdjustHelper {
    private static final int PRECISION = 10;
    private static Map<String, String> adjustPriceMapping = new HashMap<String, String>();

    public static void batchGenAdjustBill(Map cusMap, DynamicObject bill, IFormView view) {
        if (cusMap == null || cusMap.isEmpty() || bill == null) {
            return;
        }
        List<DynamicObject> adjustBillList = PriceAdjustHelper.genAdjustBill(cusMap);
        if (adjustBillList == null || adjustBillList.isEmpty()) {
            return;
        }
        List<PriceBatchAdjustInfo> adjustInfoList = PriceAdjustHelper.getAdjustInfoList(bill);
        ArrayList<String> errorMsg = new ArrayList<String>(8);
        Long batchAdjNO = System.currentTimeMillis();
        int errorCount = 0;
        int totalCount = 0;
        for (DynamicObject adjustBill : adjustBillList) {
            DynamicObjectCollection entrys = adjustBill.getDynamicObjectCollection("priceentryentity");
            totalCount += entrys.size();
            adjustBill.set("batchadjnumber", (Object)batchAdjNO);
            List<String> returnMsg = PriceAdjustHelper.caclAdjustResult(adjustInfoList, adjustBill, null);
            if (returnMsg.size() <= 0) continue;
            errorMsg.addAll(returnMsg);
            errorCount += returnMsg.size();
        }
        if (errorCount > 0) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$d\u6761\u6570\u636e\uff0c\u5b58\u5728\u9519\u8bef\u6570\u636e%2$d\u6761\uff0c\u6279\u91cf\u8c03\u6574\u6267\u884c\u5931\u8d25\u3002", (String)"PriceAdjustHelper_4", (String)"scmc-plat-business", (Object[])new Object[0]), totalCount, errorCount), PriceAdjustHelper.toString(errorMsg), MessageTypes.Default);
        } else {
            String entityId = adjustBillList.get(0).getDataEntityType().getName();
            SaveServiceHelper.save((DynamicObject[])adjustBillList.toArray(new DynamicObject[0]));
            PriceAdjustLogAssemble priceAdjustLogAssemble = new PriceAdjustLogAssemble();
            DynamicObject adjustLog = priceAdjustLogAssemble.saveAdjustmentLog(bill, String.valueOf(batchAdjNO), entityId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustLog});
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(entityId);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter listFilter = new ListFilterParameter();
            lsp.setCustomParam("org", bill.getDynamicObject("org").getPkValue());
            listFilter.getQFilters().add(new QFilter("batchadjnumber", "=", (Object)String.valueOf(batchAdjNO)));
            lsp.setListFilterParameter(listFilter);
            view.showForm((FormShowParameter)lsp);
        }
    }

    public static List<DynamicObject> genAdjustBill(Map cusMap) {
        String entityId = (String)cusMap.get("entityid");
        String changeMode = (String)cusMap.get("changemode");
        DynamicObject[] bills = (DynamicObject[])cusMap.get("bills");
        String[] headFieldArr = (String[])cusMap.get("headfield");
        String[] cusFieldArr = (String[])cusMap.get("cusfield");
        String[] priceFieldArr = (String[])cusMap.get("pricefield");
        String selectRows = (String)cusMap.get("selectrows");
        Long materialId = (Long)cusMap.get("material");
        ArrayList<DynamicObject> adjustBillList = new ArrayList<DynamicObject>(8);
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        MainEntityType adjustBillDt = MetadataServiceHelper.getDataEntityType((String)entityId);
        for (DynamicObject bill : bills) {
            DynamicObject adjustBill = new DynamicObject((DynamicObjectType)adjustBillDt);
            for (int i = 0; i < headFieldArr.length; ++i) {
                adjustBill.set(headFieldArr[i], bill.get(headFieldArr[i]));
            }
            PriceAdjustHelper.setAdjustBillDefaultValue(bill, adjustBill, currentUser, entityId, changeMode);
            if (cusFieldArr != null && cusFieldArr.length > 0) {
                PriceAdjustHelper.setAdjustCustomEntryValue(bill, adjustBill, cusFieldArr);
            }
            if (priceFieldArr != null && priceFieldArr.length > 0) {
                String rows = selectRows;
                if (rows == null) {
                    rows = PriceAdjustHelper.setSelectRows(bill, materialId);
                }
                PriceAdjustHelper.setAdjustPriceEntryValue(bill, adjustBill, priceFieldArr, rows);
            }
            adjustBillList.add(adjustBill);
        }
        return adjustBillList;
    }

    private static String setSelectRows(DynamicObject bill, Long materialId) {
        StringBuilder rows = new StringBuilder();
        DynamicObjectCollection priceEntrys = bill.getDynamicObjectCollection("priceentryentity");
        if (materialId == null) {
            for (DynamicObject entry : priceEntrys) {
                rows.append(entry.getInt("seq") - 1).append(',');
            }
        } else {
            for (int i = 0; i < priceEntrys.size(); ++i) {
                DynamicObject materialGroup;
                DynamicObject entry = (DynamicObject)priceEntrys.get(i);
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null && material.getPkValue().equals(materialId)) {
                    rows.append(entry.getInt("seq") - 1).append(',');
                }
                if (!"sm_salepricelist".equals(bill.getDataEntityType().getName()) || (materialGroup = entry.getDynamicObject("materialgroup")) == null || !materialGroup.getPkValue().equals(materialId)) continue;
                rows.append(entry.getInt("seq") - 1).append(',');
            }
        }
        return rows.toString();
    }

    public static List<DynamicObject> priceWriteBack(Map cusMap) {
        String entityId = (String)cusMap.get("entityid");
        DynamicObject[] bills = (DynamicObject[])cusMap.get("bills");
        String[] cusFieldArr = (String[])cusMap.get("cusfield");
        String[] priceFieldArr = (String[])cusMap.get("pricefield");
        if (StringUtils.isBlank((CharSequence)entityId) || bills == null || bills.length == 0) {
            return new ArrayList<DynamicObject>(4);
        }
        ArrayList<DynamicObject> srcBillList = new ArrayList<DynamicObject>(8);
        List<DynamicObject> adjustBillList = Arrays.asList(bills);
        Map<Object, DynamicObject> srcBillMap = PriceAdjustHelper.getSrcBillMap(adjustBillList, entityId);
        for (DynamicObject bill : bills) {
            DynamicObject srcBill = bill.getDynamicObject(PriceAdjustHelper.getPriceListField(entityId));
            if ((srcBill = srcBillMap.get(srcBill.getPkValue())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u539f\u4ef7\u76ee\u8868\uff0c\u53ef\u80fd\u539f\u4ef7\u76ee\u8868\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"SalePriceAdjustActiveOp_0", (String)"scmc-pms-opplugin", (Object[])new Object[0]));
            }
            if (cusFieldArr != null && cusFieldArr.length > 0) {
                PriceAdjustHelper.customeEntryWriteBack(bill, srcBill, cusFieldArr);
            }
            if (priceFieldArr != null && priceFieldArr.length > 0) {
                PriceAdjustHelper.priceEntryWriteBack(bill, srcBill, priceFieldArr);
            }
            srcBillMap.put(srcBill.getPkValue(), srcBill);
        }
        srcBillList.addAll(srcBillMap.values());
        return srcBillList;
    }

    public static List<String> caclAdjustResult(List<PriceBatchAdjustInfo> adjustInfoList, DynamicObject bill, int[] selectedRows) {
        String priceListNumber = PriceAdjustHelper.getPriceListNumber(bill);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("priceentryentity");
        if (selectedRows == null) {
            selectedRows = new int[entrys.size()];
            for (int i = 0; i < entrys.size(); ++i) {
                selectedRows[i] = i;
            }
        }
        ArrayList<String> returnErrMsg = new ArrayList<String>(8);
        String errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u7ed3\u679c\u5c0f\u4e8e\u7b49\u4e8e\u30100\u3011\u6216\u8d85\u8fc7\u6570\u503c\u4e0a\u9650\u30109999999999999\u3011\u3002", (String)"PriceAdjustHelper_2", (String)"scmc-plat-business", (Object[])new Object[0]);
        for (int i = 0; i < selectedRows.length; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(selectedRows[i]);
            Boolean isError = Boolean.FALSE;
            for (PriceBatchAdjustInfo adjustInfo : adjustInfoList) {
                String field = adjustInfo.getField();
                if (adjustInfo.isValueNull()) continue;
                switch (field) {
                    case "adjprice": 
                    case "adjpriceandtax": 
                    case "adjpricefloor": 
                    case "adjpriceceiling": {
                        isError = PriceAdjustHelper.adjustPrice(field, adjustInfo.getChangeMode(), adjustInfo.getPriceValue(), entry);
                        break;
                    }
                    case "adjtaxrateid": {
                        entry.set(field, (Object)adjustInfo.getBaseDataValue());
                        break;
                    }
                    case "adjpriceeffectdate": 
                    case "adjpriceexpirydate": {
                        entry.set(field, (Object)adjustInfo.getDateValue());
                    }
                }
                if (!isError.booleanValue()) continue;
                break;
            }
            String materialNumber = PriceAdjustHelper.getMaterialNumber(bill, entry);
            if (isError.booleanValue()) {
                returnErrMsg.add(ResManager.loadKDString((String)"\u4ef7\u76ee\u8868", (String)"PriceAdjustHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]) + " " + priceListNumber + " " + materialNumber + " " + errorMsg);
                continue;
            }
            DynamicObject taxRateId = entry.getDynamicObject("adjtaxrateid");
            if (taxRateId == null) continue;
            BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
            BigDecimal price = entry.getBigDecimal("adjprice");
            BigDecimal priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))));
            if (priceAndTax.compareTo(new BigDecimal(9999999999999L)) <= 0) continue;
            returnErrMsg.add(ResManager.loadKDString((String)"\u4ef7\u76ee\u8868", (String)"PriceAdjustHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]) + " " + priceListNumber + " " + materialNumber + " " + errorMsg);
        }
        PriceAdjustHelper.caclPrice4Bill(bill);
        return returnErrMsg;
    }

    private static void priceEntryWriteBack(DynamicObject bill, DynamicObject srcBill, String[] priceFieldArr) {
        DynamicObjectCollection adjPriceentrys = bill.getDynamicObjectCollection("priceentryentity");
        DynamicObjectCollection srcPriceentrys = srcBill.getDynamicObjectCollection("priceentryentity");
        if (srcPriceentrys != null) {
            for (DynamicObject entry : adjPriceentrys) {
                String priceadjustflag = entry.getString("adjustflag");
                if (AdjustFlagEnum.RETAIN.getValue().equals(priceadjustflag)) {
                    for (DynamicObject srcEntry : srcPriceentrys) {
                        if (!srcEntry.getPkValue().equals(entry.getLong("srcpriceentryid"))) continue;
                        srcEntry.set("adjustbillid", bill.getPkValue());
                        srcEntry.set("adjustbillno", (Object)bill.getString("billno"));
                        for (Map.Entry<String, String> next : adjustPriceMapping.entrySet()) {
                            srcEntry.set(next.getValue(), entry.get(next.getKey()));
                        }
                    }
                }
                if (!AdjustFlagEnum.NEW.getValue().equals(priceadjustflag)) continue;
                DynamicObject newEntry = srcPriceentrys.addNew();
                newEntry.set("seq", (Object)srcPriceentrys.size());
                newEntry.set("adjustbillid", bill.getPkValue());
                newEntry.set("adjustbillno", (Object)bill.getString("billno"));
                for (int i = 0; i < priceFieldArr.length; ++i) {
                    if (adjustPriceMapping.containsKey(priceFieldArr[i])) continue;
                    newEntry.set(priceFieldArr[i], entry.get(priceFieldArr[i]));
                }
                for (Map.Entry<String, String> next : adjustPriceMapping.entrySet()) {
                    newEntry.set(next.getValue(), entry.get(next.getKey()));
                }
            }
        }
    }

    private static void customeEntryWriteBack(DynamicObject bill, DynamicObject srcBill, String[] cusFieldArr) {
        DynamicObjectCollection adjCustomerentrys = bill.getDynamicObjectCollection("customerentryentity");
        DynamicObjectCollection srcCustomerentrys = srcBill.getDynamicObjectCollection("customerentryentity");
        if (srcCustomerentrys != null) {
            for (DynamicObject entry : adjCustomerentrys) {
                String cusadjustflag = entry.getString("cusadjustflag");
                if (!AdjustFlagEnum.CANCEL.getValue().equals(cusadjustflag)) continue;
                Iterator iterator = srcCustomerentrys.iterator();
                while (iterator.hasNext()) {
                    if (!((DynamicObject)iterator.next()).getPkValue().equals(entry.getLong("srccustomerentryid"))) continue;
                    iterator.remove();
                }
            }
            int seq = 1;
            if (srcCustomerentrys.size() > 0) {
                seq = ((DynamicObject)srcCustomerentrys.get(srcCustomerentrys.size() - 1)).getInt("seq");
            }
            for (DynamicObject entry : adjCustomerentrys) {
                String cusadjustflag = entry.getString("cusadjustflag");
                if (!AdjustFlagEnum.NEW.getValue().equals(cusadjustflag)) continue;
                DynamicObject newEntry = srcCustomerentrys.addNew();
                newEntry.set("seq", (Object)(++seq));
                for (int i = 0; i < cusFieldArr.length; ++i) {
                    newEntry.set(cusFieldArr[i], entry.get(cusFieldArr[i]));
                }
            }
        }
    }

    public static void caclPrice(int rowIndex, IDataModel model) {
        BigDecimal price = (BigDecimal)model.getValue("adjprice", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)model.getValue("adjpriceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        if (taxRate == null) {
            return;
        }
        taxRate = taxRate.divide(new BigDecimal(100));
        Boolean istax = (Boolean)model.getValue("istax");
        if (istax.booleanValue()) {
            if (priceAndTax != null) {
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4);
                model.setValue("adjprice", (Object)price, rowIndex);
            }
        } else if (price != null) {
            priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
            model.setValue("adjpriceandtax", (Object)priceAndTax, rowIndex);
        }
    }

    public static void caclPrice4Bill(DynamicObject bill) {
        int precision = 10;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (currency != null) {
            precision = currency.getInt("priceprecision");
        }
        boolean istax = bill.getBoolean("istax");
        DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("priceentryentity");
        for (DynamicObject entry : entryCol) {
            BigDecimal price = entry.getBigDecimal("adjprice");
            BigDecimal priceAndTax = entry.getBigDecimal("adjpriceandtax");
            DynamicObject taxRateId = entry.getDynamicObject("adjtaxrateid");
            BigDecimal taxRate = BigDecimal.ZERO;
            if (taxRateId != null) {
                taxRate = taxRateId.getBigDecimal("taxrate");
                entry.set("taxrate", (Object)taxRate);
            }
            taxRate = taxRate.divide(new BigDecimal(100));
            if (istax) {
                if (priceAndTax == null) continue;
                entry.set("adjpriceandtax", (Object)priceAndTax.setScale(precision, RoundingMode.HALF_UP));
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_UP);
                entry.set("adjprice", (Object)price);
                continue;
            }
            if (price == null) continue;
            entry.set("adjprice", (Object)price.setScale(precision, RoundingMode.HALF_UP));
            priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(precision, RoundingMode.HALF_UP);
            entry.set("adjpriceandtax", (Object)priceAndTax);
        }
    }

    private static void setAdjustCustomEntryValue(DynamicObject bill, DynamicObject adjustBill, String[] cusFieldArr) {
        DynamicObjectCollection cutomeEntrys = bill.getDynamicObjectCollection("customerentryentity");
        DynamicObjectCollection adjCutomeEntrys = adjustBill.getDynamicObjectCollection("customerentryentity");
        for (DynamicObject entry : cutomeEntrys) {
            DynamicObject adjEntry = adjCutomeEntrys.addNew();
            adjEntry.set("srccustomerentryid", entry.getPkValue());
            adjEntry.set("cusadjustflag", (Object)AdjustFlagEnum.RETAIN.getValue());
            for (int i = 0; i < cusFieldArr.length; ++i) {
                adjEntry.set(cusFieldArr[i], entry.get(cusFieldArr[i]));
            }
        }
    }

    private static void setAdjustPriceEntryValue(DynamicObject bill, DynamicObject adjustBill, String[] priceFieldArr, String selectRow) {
        DynamicObjectCollection priceEntrys = bill.getDynamicObjectCollection("priceentryentity");
        DynamicObjectCollection adjPriceEntrys = adjustBill.getDynamicObjectCollection("priceentryentity");
        if (selectRow != null) {
            String[] rows = selectRow.split(",");
            HashSet<String> rowSet = new HashSet<String>();
            for (String row : rows) {
                if (!StringUtils.isNotBlank((CharSequence)row)) continue;
                rowSet.add(row);
            }
            for (DynamicObject entry2 : priceEntrys) {
                if (rowSet == null || !rowSet.contains(String.valueOf(entry2.getInt("seq") - 1))) continue;
                DynamicObject adjEntry = adjPriceEntrys.addNew();
                PriceAdjustHelper.setEntryAdjustFiledValue(adjEntry, entry2, bill.getPkValue());
                for (int i = 0; i < priceFieldArr.length; ++i) {
                    adjEntry.set(priceFieldArr[i], entry2.get(priceFieldArr[i]));
                }
            }
        }
        AtomicInteger seq = new AtomicInteger(1);
        adjPriceEntrys.forEach(entry -> entry.set("seq", (Object)seq.getAndIncrement()));
    }

    private static void setAdjustBillDefaultValue(DynamicObject bill, DynamicObject adjustBill, DynamicObject currentUser, String entityId, String changeMode) {
        String billType = bill.getDataEntityType().getName();
        adjustBill.set(PriceAdjustHelper.getPriceListField(billType), (Object)bill);
        adjustBill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        adjustBill.set("adjustmode", (Object)(changeMode == null ? AdjustModelEnum.SINGLE.getValue() : changeMode));
        adjustBill.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)adjustBill, null));
        adjustBill.set("creator", (Object)currentUser);
        adjustBill.set("createtime", (Object)TimeServiceHelper.now());
        adjustBill.set("modifier", (Object)currentUser);
        adjustBill.set("modifytime", (Object)TimeServiceHelper.now());
        adjustBill.set("validstatus", (Object)ValidEnum.UNVALID.getValue());
        PriceAdjustHelper.caclPrice4Bill(adjustBill);
    }

    private static void setEntryAdjustFiledValue(DynamicObject adjustEntry, DynamicObject entry, Object pkValue) {
        adjustEntry.set("srcpriceentryid", entry.getPkValue());
        adjustEntry.set("srcpricelist", pkValue);
        adjustEntry.set("adjustflag", (Object)AdjustFlagEnum.RETAIN.getValue());
        for (Map.Entry<String, String> next : adjustPriceMapping.entrySet()) {
            adjustEntry.set(next.getKey(), entry.get(next.getValue()));
        }
    }

    private static Map<Object, DynamicObject> getSrcBillMap(List<DynamicObject> adjustBillList, String entityId) {
        DynamicObject[] srcBills;
        HashMap<Object, DynamicObject> srcBillMap = new HashMap<Object, DynamicObject>(8);
        if (adjustBillList == null) {
            return srcBillMap;
        }
        ArrayList srcids = new ArrayList(8);
        MainEntityType adjustBillDt = MetadataServiceHelper.getDataEntityType((String)entityId);
        adjustBillList.forEach(bill -> srcids.add(bill.getDynamicObject(PriceAdjustHelper.getPriceListField(entityId)).getPkValue()));
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((Object[])srcids.toArray(), (DynamicObjectType)adjustBillDt)) {
            srcBillMap.put(srcBill.getPkValue(), srcBill);
        }
        return srcBillMap;
    }

    private static String getPriceListField(String entityId) {
        if ("sm_salepricelist".equals(entityId)) {
            return "salepricelist";
        }
        if ("pm_purpricelist".equals(entityId)) {
            return "purpricelist";
        }
        return "";
    }

    private static Boolean adjustPrice(String adjustFiled, String changemode, BigDecimal adjustValue, DynamicObject entry) {
        BigDecimal price = entry.getBigDecimal(adjustFiled);
        Boolean isError = Boolean.FALSE;
        if (price == null || adjustValue == null || StringUtils.isBlank((CharSequence)changemode)) {
            return isError;
        }
        PriceAdjustModelEnum changeModeEnum = PriceAdjustModelEnum.valueOf((String)changemode.toUpperCase());
        switch (changeModeEnum) {
            case UP: {
                BigDecimal result = price.add(adjustValue);
                if (result.compareTo(new BigDecimal(9999999999999L)) > 0) {
                    isError = Boolean.TRUE;
                    break;
                }
                entry.set(adjustFiled, (Object)result);
                break;
            }
            case DOWN: {
                BigDecimal result = price.subtract(adjustValue);
                if (result.compareTo(BigDecimal.ZERO) <= 0) {
                    isError = Boolean.TRUE;
                    break;
                }
                entry.set(adjustFiled, (Object)result);
                break;
            }
            case UPPERCENT: {
                BigDecimal result = price.multiply(BigDecimal.ONE.add(adjustValue.divide(new BigDecimal(100))));
                if (result.compareTo(new BigDecimal(9999999999999L)) > 0) {
                    isError = Boolean.TRUE;
                    break;
                }
                entry.set(adjustFiled, (Object)result);
                break;
            }
            case DOWNPERCENT: {
                BigDecimal result = price.multiply(BigDecimal.ONE.subtract(adjustValue.divide(new BigDecimal(100))));
                entry.set(adjustFiled, (Object)result);
                break;
            }
            case EQUALS: {
                entry.set(adjustFiled, (Object)adjustValue);
            }
        }
        return isError;
    }

    private static String getPriceListNumber(DynamicObject bill) {
        DynamicObject priceList;
        String billType = bill.getDataEntityType().getName();
        String priceListNumber = "";
        if ("sm_salepriceadjust".equals(billType)) {
            priceList = bill.getDynamicObject("salepricelist");
            if (priceList == null) {
                return null;
            }
            priceListNumber = priceList.getString("number");
        }
        if ("pm_purpriceadjust".equals(billType)) {
            priceList = bill.getDynamicObject("purpricelist");
            if (priceList == null) {
                return null;
            }
            priceListNumber = priceList.getString("number");
        }
        return priceListNumber;
    }

    private static String getMaterialNumber(DynamicObject bill, DynamicObject entry) {
        DynamicObject material;
        String billType = bill.getDataEntityType().getName();
        String materialNumber = "";
        if ("sm_salepriceadjust".equals(billType)) {
            DynamicObject materialGroup;
            DynamicObject material2;
            String applymateerial = bill.getString("applymaterial");
            if ("A".equals(applymateerial) && (material2 = entry.getDynamicObject("material")) != null) {
                materialNumber = ResManager.loadKDString((String)"\u7269\u6599", (String)"PriceAdjustHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]) + " " + material2.getDynamicObject("masterid").getString("number");
            }
            if ("B".equals(applymateerial) && (materialGroup = entry.getDynamicObject("materialgroup")) != null) {
                materialNumber = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b", (String)"PriceAdjustHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]) + " " + materialGroup.getString("number");
            }
        }
        if ("pm_purpriceadjust".equals(billType) && (material = entry.getDynamicObject("material")) != null) {
            materialNumber = ResManager.loadKDString((String)"\u7269\u6599", (String)"PriceAdjustHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]) + " " + material.getDynamicObject("masterid").getString("number");
        }
        return materialNumber;
    }

    public static List<PriceBatchAdjustInfo> getAdjustInfoList(DynamicObject bill) {
        ArrayList<PriceBatchAdjustInfo> adjustInfoList = new ArrayList<PriceBatchAdjustInfo>(16);
        PriceBatchAdjustInfo taxRate = new PriceBatchAdjustInfo();
        taxRate.setField("adjtaxrateid");
        taxRate.setBaseDataValue(bill.getDynamicObject("taxrate"));
        adjustInfoList.add(taxRate);
        PriceBatchAdjustInfo effectDate = new PriceBatchAdjustInfo();
        effectDate.setField("adjpriceeffectdate");
        effectDate.setDateValue(bill.getDate("priceeffectdate"));
        adjustInfoList.add(effectDate);
        PriceBatchAdjustInfo expiryDate = new PriceBatchAdjustInfo();
        expiryDate.setField("adjpriceexpirydate");
        expiryDate.setDateValue(bill.getDate("priceexpirydate"));
        adjustInfoList.add(expiryDate);
        PriceBatchAdjustInfo price = new PriceBatchAdjustInfo();
        price.setField("adjprice");
        price.setChangeMode(bill.getString("priceadjmode"));
        price.setPriceValue(PriceAdjustHelper.getPriceValue("adjprice", bill));
        adjustInfoList.add(price);
        PriceBatchAdjustInfo priceAndTax = new PriceBatchAdjustInfo();
        priceAndTax.setField("adjpriceandtax");
        priceAndTax.setChangeMode(bill.getString("priceandtaxadjmode"));
        priceAndTax.setPriceValue(PriceAdjustHelper.getPriceValue("adjpriceandtax", bill));
        adjustInfoList.add(priceAndTax);
        PriceBatchAdjustInfo Maxprice = new PriceBatchAdjustInfo();
        Maxprice.setField("adjpriceceiling");
        Maxprice.setChangeMode(bill.getString("priceceilingadjmode"));
        Maxprice.setPriceValue(PriceAdjustHelper.getPriceValue("adjpriceceiling", bill));
        adjustInfoList.add(Maxprice);
        PriceBatchAdjustInfo Minprice = new PriceBatchAdjustInfo();
        Minprice.setField("adjpricefloor");
        Minprice.setChangeMode(bill.getString("priceflooradjmode"));
        Minprice.setPriceValue(PriceAdjustHelper.getPriceValue("adjpricefloor", bill));
        adjustInfoList.add(Minprice);
        return adjustInfoList;
    }

    public static BigDecimal getPriceValue(String field, DynamicObject bill) {
        switch (field) {
            case "adjprice": {
                return PriceAdjustHelper.getNotZeroValue(bill.getBigDecimal("price"), bill.getBigDecimal("priceupper"), bill.getBigDecimal("pricedownper"));
            }
            case "adjpriceandtax": {
                return PriceAdjustHelper.getNotZeroValue(bill.getBigDecimal("priceandtax"), bill.getBigDecimal("priceandtaxupper"), bill.getBigDecimal("priceandtaxdownper"));
            }
            case "adjpriceceiling": {
                return PriceAdjustHelper.getNotZeroValue(bill.getBigDecimal("priceceiling"), bill.getBigDecimal("priceceilingupper"), bill.getBigDecimal("priceceilingdownper"));
            }
            case "adjpricefloor": {
                return PriceAdjustHelper.getNotZeroValue(bill.getBigDecimal("pricefloor"), bill.getBigDecimal("pricefloorupper"), bill.getBigDecimal("pricefloordownper"));
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getNotZeroValue(BigDecimal bigDecimal, BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (BigDecimal.ZERO.compareTo(bigDecimal) != 0) {
            return bigDecimal;
        }
        if (BigDecimal.ZERO.compareTo(bigDecimal1) != 0) {
            return bigDecimal1;
        }
        return bigDecimal2;
    }

    public static QFilter getQFilter(DynamicObject bill, String[] qfilterFields) {
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (String field : qfilterFields) {
            DynamicObject dym = "pricelisttypeid".equals(field) ? bill.getDynamicObject("pricelisttype") : bill.getDynamicObject(field.contains(".") ? field.replace("customerentryentity.", "").replace("priceentryentity.", "") : field);
            if (dym == null) continue;
            filter.and(new QFilter(field, "=", dym.getPkValue()));
        }
        Boolean isTax = bill.getBoolean("istax");
        filter.and(new QFilter("istax", "=", (Object)isTax));
        filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return filter;
    }

    private static String toString(List<String> errorMsg) {
        StringBuilder msg = new StringBuilder();
        for (String m : errorMsg) {
            msg.append(m).append('\n');
        }
        return msg.toString();
    }

    static {
        adjustPriceMapping.putIfAbsent("adjprice", "price");
        adjustPriceMapping.putIfAbsent("adjpriceandtax", "priceandtax");
        adjustPriceMapping.putIfAbsent("adjtaxrateid", "taxrateid");
        adjustPriceMapping.putIfAbsent("taxrate", "taxrate");
        adjustPriceMapping.putIfAbsent("adjpricefloor", "pricefloor");
        adjustPriceMapping.putIfAbsent("adjpriceceiling", "priceceiling");
        adjustPriceMapping.putIfAbsent("adjpriceeffectdate", "priceeffectdate");
        adjustPriceMapping.putIfAbsent("adjpriceexpirydate", "priceexpirydate");
    }
}

