/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.PriceAdjustHelper;
import kd.scmc.plat.common.enums.price.AdjustLogTypeEnum;
import kd.scmc.plat.common.enums.price.PriceAdjustModelEnum;

public class PriceAdjustLogAssemble {
    public static final String BR = "\n";
    public static final String BL = "\u3000";
    String SALE = ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\uff1a", (String)"PriceAdjustLogAssemble_0", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICELISTTYPE = ResManager.loadKDString((String)"\u4ef7\u76ee\u7c7b\u578b\uff1a", (String)"PriceAdjustLogAssemble_1", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String GROUP = ResManager.loadKDString((String)"\u4ef7\u76ee\u8868\u5206\u7ec4\uff1a", (String)"PriceAdjustLogAssemble_2", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String MATERIAL = ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"PriceAdjustLogAssemble_3", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String CURRENCY = ResManager.loadKDString((String)"\u5e01\u79cd\uff1a", (String)"PriceAdjustLogAssemble_4", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String ISTAX = ResManager.loadKDString((String)"\u542b\u7a0e\uff1a", (String)"PriceAdjustLogAssemble_5", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICE = ResManager.loadKDString((String)"\u5355\u4ef7\uff1a", (String)"PriceAdjustLogAssemble_6", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICEANDTAX = ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7\uff1a", (String)"PriceAdjustLogAssemble_7", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String TAXRATE = ResManager.loadKDString((String)"\u7a0e\u7387\uff1a", (String)"PriceAdjustLogAssemble_8", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICEFLOOR = ResManager.loadKDString((String)"\u6700\u4f4e\u9650\u4ef7\uff1a", (String)"PriceAdjustLogAssemble_9", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICECEILING = ResManager.loadKDString((String)"\u6700\u9ad8\u9650\u4ef7\uff1a", (String)"PriceAdjustLogAssemble_10", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICEEFFECTDATE = ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\uff1a", (String)"PriceAdjustLogAssemble_11", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PRICEEXPIRYDATE = ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\uff1a", (String)"PriceAdjustLogAssemble_12", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String CUSTOMER = ResManager.loadKDString((String)"\u5ba2\u6237\uff1a", (String)"PriceAdjustLogAssemble_13", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String CUSTOMERGROUP = ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7c7b\uff1a", (String)"PriceAdjustLogAssemble_14", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String MATERIALGROUP = ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\uff1a", (String)"PriceAdjustLogAssemble_15", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String PUR = ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\uff1a", (String)"PriceAdjustLogAssemble_16", (String)"scmc-plat-business", (Object[])new Object[0]);
    private String SUPPLIERID = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\uff1a", (String)"PriceAdjustLogAssemble_17", (String)"scmc-plat-business", (Object[])new Object[0]);

    private static String getLocalDescription(String adjMode) {
        if (adjMode == null) {
            return "";
        }
        PriceAdjustModelEnum adjModeEnum = PriceAdjustModelEnum.valueOf((String)adjMode.toUpperCase());
        switch (adjModeEnum) {
            case UP: {
                adjMode = ResManager.loadKDString((String)"\u4e0a\u8c03\u6570\u503c", (String)"PriceAdjustLogAssemble_18", (String)"scmc-plat-business", (Object[])new Object[0]);
                break;
            }
            case DOWN: {
                adjMode = ResManager.loadKDString((String)"\u4e0b\u8c03\u6570\u503c", (String)"PriceAdjustLogAssemble_19", (String)"scmc-plat-business", (Object[])new Object[0]);
                break;
            }
            case UPPERCENT: {
                adjMode = ResManager.loadKDString((String)"\u4e0a\u8c03\u767e\u5206\u6bd4", (String)"PriceAdjustLogAssemble_20", (String)"scmc-plat-business", (Object[])new Object[0]);
                break;
            }
            case DOWNPERCENT: {
                adjMode = ResManager.loadKDString((String)"\u4e0b\u8c03\u767e\u5206\u6bd4", (String)"PriceAdjustLogAssemble_21", (String)"scmc-plat-business", (Object[])new Object[0]);
                break;
            }
            case EQUALS: {
                adjMode = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"PriceAdjustLogAssemble_22", (String)"scmc-plat-business", (Object[])new Object[0]);
            }
        }
        return adjMode;
    }

    private String isLogType(String logType) {
        AdjustLogTypeEnum logTypeNum = AdjustLogTypeEnum.valueOf((String)logType.toUpperCase());
        switch (logTypeNum) {
            case SALE: {
                logType = this.SALE;
                break;
            }
            case PUR: {
                logType = this.PUR;
                break;
            }
        }
        return logType;
    }

    public DynamicObject saveAdjustmentLog(DynamicObject bill, String billNo, String entityId) {
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"plat_priceadjustlog");
        DynamicObject adjustLog = new DynamicObject((DynamicObjectType)dataEntityType);
        String logType = "";
        if ("sm_salepriceadjust".equals(entityId)) {
            logType = AdjustLogTypeEnum.SALE.getValue();
        }
        if ("pm_purpriceadjust".equals(entityId)) {
            logType = AdjustLogTypeEnum.PUR.getValue();
        }
        Map<String, String> map = this.getLogValueMap(bill, logType);
        adjustLog.set("batchadjnumber", (Object)billNo);
        adjustLog.set("operator", (Object)currentUser);
        adjustLog.set("operatetime", (Object)new Date());
        adjustLog.set("org", bill.get("org"));
        adjustLog.set("logtype", (Object)logType);
        String logTypeCN = this.isLogType(logType);
        if (AdjustLogTypeEnum.SALE.getValue().equals(logType)) {
            adjustLog.set("filtercondition", (Object)(logTypeCN + BL + map.get("org") + BR + this.PRICELISTTYPE + BL + map.get("pricelisttype") + BR + this.GROUP + BL + map.get("group") + BR + this.CUSTOMER + BL + map.get("customer") + BR + this.CUSTOMERGROUP + BL + map.get("customergroup") + BR + this.MATERIAL + BL + map.get("material") + BR + this.MATERIALGROUP + BL + map.get("materialgroup") + BR + this.CURRENCY + BL + map.get("currency") + BR + this.ISTAX + BL + map.get("istax")));
        }
        if (AdjustLogTypeEnum.PUR.getValue().equals(logType)) {
            adjustLog.set("filtercondition", (Object)(logTypeCN + BL + map.get("org") + BR + this.PRICELISTTYPE + BL + map.get("pricelisttype") + BR + this.GROUP + BL + map.get("group") + BR + this.SUPPLIERID + BL + map.get("supplierid") + BR + this.MATERIAL + BL + map.get("material") + BR + this.CURRENCY + BL + map.get("currency") + BR + this.ISTAX + BL + map.get("istax")));
        }
        adjustLog.set("batchadjustment", (Object)((!bill.getBoolean("istax") ? this.PRICE + BL + this.getAdjustMode(bill, "priceadjmode") + BL + map.get("price") + BR : this.PRICEANDTAX + BL + this.getAdjustMode(bill, "priceandtaxadjmode") + BL + map.get("priceandtax") + BR) + this.TAXRATE + BL + map.get("taxrate") + BR + this.PRICEFLOOR + BL + this.getAdjustMode(bill, "priceflooradjmode") + BL + map.get("pricefloor") + BR + this.PRICECEILING + BL + this.getAdjustMode(bill, "priceceilingadjmode") + BL + map.get("priceceiling") + BR + this.PRICEEFFECTDATE + BL + map.get("priceeffectdate") + BR + this.PRICEEXPIRYDATE + BL + map.get("priceexpirydate") + BR));
        return adjustLog;
    }

    private String getAdjustMode(DynamicObject bill, String adjustModeField) {
        String adjustMode = " ";
        switch (adjustModeField) {
            case "priceadjmode": {
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("price")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceupper")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("pricedownper")) == 0) break;
                adjustMode = PriceAdjustLogAssemble.getLocalDescription(bill.getString(adjustModeField));
                break;
            }
            case "priceandtaxadjmode": {
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceandtax")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceandtaxupper")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceandtaxdownper")) == 0) break;
                adjustMode = PriceAdjustLogAssemble.getLocalDescription(bill.getString(adjustModeField));
                break;
            }
            case "priceflooradjmode": {
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("pricefloor")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("pricefloorupper")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("pricefloordownper")) == 0) break;
                adjustMode = PriceAdjustLogAssemble.getLocalDescription(bill.getString(adjustModeField));
                break;
            }
            case "priceceilingadjmode": {
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceceiling")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceceilingupper")) == 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("priceceilingdownper")) == 0) break;
                adjustMode = PriceAdjustLogAssemble.getLocalDescription(bill.getString(adjustModeField));
            }
        }
        return adjustMode;
    }

    private Map<String, String> getLogValueMap(DynamicObject bill, String logType) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org != null) {
            String orgName = org.getString("name");
            map.put("org", orgName);
        } else {
            map.put("org", " ");
        }
        DynamicObject pricelisttype = (DynamicObject)bill.get("pricelisttype");
        if (pricelisttype != null) {
            String pricelisttypeName = pricelisttype.getString("name");
            map.put("pricelisttype", pricelisttypeName);
        } else {
            map.put("pricelisttype", " ");
        }
        DynamicObject group = (DynamicObject)bill.get("group");
        if (group != null) {
            String groupName = group.getString("name");
            map.put("group", groupName);
        } else {
            map.put("group", " ");
        }
        DynamicObject material = (DynamicObject)bill.get("material");
        if (material != null) {
            DynamicObject masterid = material.getDynamicObject("masterid");
            String materialName = masterid.getString("name");
            map.put("material", materialName);
        } else {
            map.put("material", " ");
        }
        if (AdjustLogTypeEnum.SALE.getValue().equals(logType)) {
            DynamicObject customer = (DynamicObject)bill.get("customer");
            if (customer != null) {
                String customerName = customer.getString("name");
                map.put("customer", customerName);
            } else {
                map.put("customer", " ");
            }
            DynamicObject customerGroup = (DynamicObject)bill.get("customergroup");
            if (customerGroup != null) {
                String customerGroupName = customerGroup.getString("name");
                map.put("customergroup", customerGroupName);
            } else {
                map.put("customergroup", " ");
            }
            DynamicObject materialGroup = (DynamicObject)bill.get("materialgroup");
            if (materialGroup != null) {
                String materialGroupName = materialGroup.getString("name");
                map.put("materialgroup", materialGroupName);
            } else {
                map.put("materialgroup", " ");
            }
        }
        if (AdjustLogTypeEnum.PUR.getValue().equals(logType)) {
            DynamicObject supplierId = (DynamicObject)bill.get("supplierid");
            if (supplierId != null) {
                String supplierIdName = supplierId.getString("name");
                map.put("supplierid", supplierIdName);
            } else {
                map.put("supplierid", " ");
            }
        }
        DynamicObject currency = (DynamicObject)bill.get("currency");
        int precision = 10;
        if (currency != null) {
            precision = currency.getInt("priceprecision");
            String currencyName = currency.getString("name");
            map.put("currency", currencyName);
        } else {
            map.put("currency", " ");
        }
        DynamicObject taxrate = (DynamicObject)bill.get("taxrate");
        if (taxrate != null) {
            String taxrateName = taxrate.getString("name");
            map.put("taxrate", taxrateName);
        } else {
            map.put("taxrate", " ");
        }
        Boolean istax = (Boolean)bill.get("istax");
        if (istax.booleanValue()) {
            map.put("istax", ResManager.loadKDString((String)"\u662f", (String)"PriceAdjustLogAssemble_23", (String)"scmc-plat-business", (Object[])new Object[0]));
        } else {
            map.put("istax", ResManager.loadKDString((String)"\u5426", (String)"PriceAdjustLogAssemble_24", (String)"scmc-plat-business", (Object[])new Object[0]));
        }
        BigDecimal price = PriceAdjustHelper.getPriceValue("adjprice", bill);
        if (price != null && price.compareTo(BigDecimal.ZERO) > 0) {
            if (!PriceAdjustModelEnum.UPPERCENT.getValue().equals(bill.getString("priceadjmode")) && !PriceAdjustModelEnum.DOWNPERCENT.getValue().equals(bill.getString("priceadjmode"))) {
                price = price.setScale(precision, RoundingMode.HALF_UP);
            }
            map.put("price", price.toString());
        } else {
            map.put("price", " ");
        }
        BigDecimal priceandtax = PriceAdjustHelper.getPriceValue("adjpriceandtax", bill);
        if (priceandtax != null && priceandtax.compareTo(BigDecimal.ZERO) > 0) {
            if (!PriceAdjustModelEnum.UPPERCENT.getValue().equals(bill.getString("priceandtaxadjmode")) && !PriceAdjustModelEnum.DOWNPERCENT.getValue().equals(bill.getString("priceandtaxadjmode"))) {
                priceandtax = priceandtax.setScale(precision, RoundingMode.HALF_UP);
            }
            map.put("priceandtax", priceandtax.toString());
        } else {
            map.put("priceandtax", " ");
        }
        BigDecimal pricefloor = PriceAdjustHelper.getPriceValue("adjpricefloor", bill);
        if (pricefloor != null && pricefloor.compareTo(BigDecimal.ZERO) > 0) {
            if (!PriceAdjustModelEnum.UPPERCENT.getValue().equals(bill.getString("priceflooradjmode")) && !PriceAdjustModelEnum.DOWNPERCENT.getValue().equals(bill.getString("priceflooradjmode"))) {
                pricefloor = pricefloor.setScale(precision, RoundingMode.HALF_UP);
            }
            map.put("pricefloor", pricefloor.toString());
        } else {
            map.put("pricefloor", " ");
        }
        BigDecimal priceceiling = PriceAdjustHelper.getPriceValue("adjpriceceiling", bill);
        if (priceceiling != null && priceceiling.compareTo(BigDecimal.ZERO) > 0) {
            if (!PriceAdjustModelEnum.UPPERCENT.getValue().equals(bill.getString("priceceilingadjmode")) && !PriceAdjustModelEnum.DOWNPERCENT.getValue().equals(bill.getString("priceceilingadjmode"))) {
                priceceiling = priceceiling.setScale(precision, RoundingMode.HALF_UP);
            }
            map.put("priceceiling", priceceiling.toString());
        } else {
            map.put("priceceiling", " ");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date priceEffectDate = (Date)bill.get("priceeffectdate");
        if (priceEffectDate != null) {
            String effectDate = formatter.format((Object)priceEffectDate);
            map.put("priceeffectdate", effectDate);
        } else {
            map.put("priceeffectdate", " ");
        }
        Date priceExpiryDate = bill.getDate("priceexpirydate");
        if (priceExpiryDate != null) {
            String expiryDate = formatter.format((Object)priceExpiryDate);
            map.put("priceexpirydate", expiryDate);
        } else {
            map.put("priceexpirydate", " ");
        }
        return map;
    }
}

