/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.DataSetHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSrcKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteStrategySeqInfo;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeEntryConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeSortEntryConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteStrategyEntryConst;
import kd.scmc.plat.common.enums.EnableStatusEnum;
import kd.scmc.plat.common.enums.StatusEnum;

public class QuoteHelper {
    private static final Log LOGGER = LogFactory.getLog(QuoteHelper.class);
    private static final String HEADER = "header";
    private static final String ENTRY = "entry";
    private static final String RESULT = "result";

    public static QuoteSchemeColl fetchQuoteSchemeFromST(Long orgID, String type) {
        QuoteSchemeColl quoteSchemeColl = new QuoteSchemeColl();
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter orgIdFilter = new QFilter("createorg", "=", (Object)orgID);
        String selecties = new StringBuffer("id,").append(new StringBuffer(String.join((CharSequence)",", QuoteStrategyEntryConst.getSelectorList()))).toString();
        DynamicObject quoteStrategy = BusinessDataServiceHelper.loadSingleFromCache((String)"plat_quotestrategy", (String)selecties, (QFilter[])new QFilter[]{orgIdFilter, statusFilter, enableFilter});
        ArrayList<Object> schemePKs = new ArrayList<Object>();
        ArrayList<QuoteStrategySeqInfo> quoteSeqInfoList = new ArrayList<QuoteStrategySeqInfo>(16);
        if (quoteStrategy != null) {
            quoteSchemeColl.setQuoteStratege(quoteStrategy);
            DynamicObjectCollection entrys = quoteStrategy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject quoteScheme = ((DynamicObject)entrys.get(i)).getDynamicObject("quotescheme");
                if (quoteScheme == null || !type.equals(quoteScheme.getDynamicObject("quoteentity").getPkValue())) continue;
                schemePKs.add(quoteScheme.getPkValue());
                String preCondition = ((DynamicObject)entrys.get(i)).getString("preconditionjson_tag");
                String preConditionOld = ((DynamicObject)entrys.get(i)).getString("qu_precondition");
                if (StringUtils.isBlank((CharSequence)preCondition) && StringUtils.isNotBlank((CharSequence)preConditionOld)) {
                    preCondition = preConditionOld;
                }
                quoteSeqInfoList.add(new QuoteStrategySeqInfo(i + 1, ((DynamicObject)entrys.get(i)).getString("terminationsign"), preCondition, ((DynamicObject)entrys.get(i)).getString("qu_preconditiondesc")));
            }
            ArrayList quoteSchemes = new ArrayList();
            ArrayList quoteSeqInfoCheckList = new ArrayList();
            if (schemePKs.size() <= 0) {
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u53d6\u4ef7\u5355\u5339\u914d\u7684\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteHelper_2", (String)"scmc-plat-business", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            StringBuilder props = new StringBuilder(String.join((CharSequence)",", QuoteSchemeConst.getSelectorList()));
            StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeEntryConst.getSelectorList()));
            StringBuilder sortEntryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeSortEntryConst.getSelectorList()));
            String selector = props.append(',').append((CharSequence)entryProps).append(',').append((CharSequence)sortEntryProps).toString();
            QFilter schemeStatusFilter = new QFilter("status", "=", (Object)"C");
            QFilter schemeEnableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter schemeIDFilter = new QFilter("id", "in", schemePKs);
            Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{schemeStatusFilter, schemeEnableFilter, schemeIDFilter});
            for (int s = 0; s < schemePKs.size(); ++s) {
                Object pk = schemePKs.get(s);
                if (schemeMap.get(pk) == null) continue;
                quoteSchemes.add(schemeMap.get(pk));
                quoteSeqInfoCheckList.add(quoteSeqInfoList.get(s));
            }
            for (int s = 0; s < quoteSchemes.size(); ++s) {
                quoteSchemeColl.applyScheme((DynamicObject)quoteSchemes.get(s), (QuoteStrategySeqInfo)quoteSeqInfoCheckList.get(s));
            }
        } else {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u672a\u7ef4\u62a4\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (quoteSchemeColl.getQuoteSchemes().size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return quoteSchemeColl;
    }

    public static Map<Object, DynamicObject> fetchQuoteScheme4QuoteLog(Long orgID) {
        Map schemeMap;
        String selector = "quoteentity" + "," + "org";
        if (orgID != null) {
            QFilter schemeOrgFilter = new QFilter("org", "in", (Object)orgID);
            schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{schemeOrgFilter});
        } else {
            schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        }
        return schemeMap;
    }

    public static DataSet buildQuoteDataSet(DynamicObject[] bills, String entityType, QuoteSchemeColl quoteSchemeColl, QuoteKeyInfo qccInfo) {
        String[] dimensions = new String[]{};
        String[] alias = new String[]{};
        dimensions = quoteSchemeColl.mergeDimension().toArray(dimensions);
        alias = quoteSchemeColl.mergeAlias().toArray(alias);
        return DataSetHelper.toDataSet(bills, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSetByMap(List<Map<String, Object>> entryMapList, String entityType, QuoteSchemeColl quoteSchemeColl, QuoteKeyInfo qccInfo) {
        if (entryMapList == null || entryMapList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u672a\u5411\u53d6\u4ef7\u670d\u52a1\u63a5\u53e3\u4f20\u9012\u53d6\u4ef7\u5355\u636e\u4fe1\u606f\u3002", (String)"QuoteHelper_10", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        List<String> dimensions = quoteSchemeColl.mergeDimension();
        List<String> alias = quoteSchemeColl.mergeAlias();
        return DataSetHelper.toDataSetByMap(entryMapList, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSetByIDs(Long[] ids, QuoteSchemeColl quoteSchemeColl, String entityType, QuoteKeyInfo qccInfo) {
        List<String> dimensions = quoteSchemeColl.mergeDimension();
        List<String> alias = quoteSchemeColl.mergeAlias();
        qccInfo.getIDFIELDS().forEach(f -> dimensions.add((String)f));
        qccInfo.getLEFTIDFIELDS().forEach(f -> alias.add((String)f));
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensions.set(i, new StringBuffer(dimensions.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(alias.get(i))).toString());
        }
        DataSet result = QueryServiceHelper.queryDataSet((String)"QuoteHelper", (String)entityType, (String)String.join((CharSequence)",", dimensions), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, (String)"id");
        return result;
    }

    public static FilterCondition convertStringToCondition(String runcondition) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            return condition;
        }
        return null;
    }

    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static FilterCondition convertFullStringToCondition(String runcondition) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)runcondition, CRCondition.class);
            return crCondition.getFilterCondition();
        }
        return null;
    }

    public static FilterBuilder convertFullStringToQFilter(String runcondition, String srcType) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)runcondition, CRCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), crCondition.getFilterCondition());
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static QuoteKeyInfo getQuoteCommonConst(String entityType, QuoteSchemeColl quoteSchemeColl) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> dimensions = quoteSchemeColl.mergeDimension();
        List<String> results = quoteSchemeColl.mergeQuoteResult();
        dimensions.addAll(results);
        String allStr = String.join((CharSequence)",", dimensions);
        QuoteKeyInfo qccInfo = new QuoteKeyInfo(entityType);
        ArrayList<String> entryNames = new ArrayList<String>();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setLEFT_BILLENTRY_ID(qccInfo.getEntryIDAlias());
                qccInfo.setLEFT_SEQ(qccInfo.getEntrySeqAlias());
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        if (qccInfo.getEntryCount() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u914d\u7f6e\u4e86\u8d85\u8fc71\u4e2a\u53d6\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u53d6\u4ef7\u3002", (String)"QuoteHelper_4", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        boolean hasHeadPriceFiled = QuoteHelper.hasHeadPriceField(results, entryNames);
        qccInfo.setHeadPriceField(hasHeadPriceFiled);
        qccInfo.setHasTable(StringUtils.isNotEmpty((CharSequence)headType.getAlias()));
        return qccInfo;
    }

    public static TreeMap<String, String> getQuoteResultAliasName(QuoteSchemeColl quoteSchemeColl, String quoteBill, List<String> oneSchemeResultFields) {
        List<String> quoteResultAliasSet = quoteSchemeColl.mergeQuoteResultAlias();
        ArrayList<String> quoteResultAliasSetTo = new ArrayList<String>(quoteResultAliasSet.size());
        for (String quoteResultAlias : quoteResultAliasSet) {
            if (!oneSchemeResultFields.contains(quoteResultAlias)) continue;
            quoteResultAliasSetTo.add(quoteResultAlias);
        }
        TreeMap<String, String> nameMapping = new TreeMap<String, String>();
        QuoteHelper.getResultNameMapping(quoteBill, quoteResultAliasSetTo, nameMapping);
        return nameMapping;
    }

    public static String getResultNameMapping(String quoteBill, List<String> quoteResultAliasSet, TreeMap<String, String> nameMapping) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBill);
        Map allFileds = headType.getAllFields();
        quoteResultAliasSet.forEach(qf -> {
            String[] subFields = qf.split("__");
            String priceField = subFields[subFields.length - 1];
            IDataEntityProperty property = (IDataEntityProperty)allFileds.get(priceField);
            if (property != null) {
                IDataEntityProperty taxProperty;
                Class propertyType = ((IDataEntityProperty)allFileds.get(priceField)).getPropertyType();
                if (Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType)) {
                    nameMapping.put((String)qf, ((IDataEntityProperty)allFileds.get(priceField)).getDisplayName().getLocaleValue());
                } else if (priceField.contains("tax") && (taxProperty = (IDataEntityProperty)allFileds.get(priceField)) instanceof BasedataProp && "bd_taxrate".equals(((BasedataProp)taxProperty).getBaseEntityId())) {
                    nameMapping.put(qf + "bd_taxrate", taxProperty.getDisplayName().getLocaleValue());
                }
            }
        });
        return headType.getDisplayName().toString();
    }

    public static QuoteSrcKeyInfo getQuoteSrcCommonConst(String entityType, QuoteSchemeInfo quoteSchemeInfo) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> results = quoteSchemeInfo.getQuoteSourceResult();
        String allStr = String.join((CharSequence)",", results);
        QuoteSrcKeyInfo qccInfo = new QuoteSrcKeyInfo();
        if (headType instanceof BasedataEntityType) {
            if (headType.getAllFields().containsKey("number")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("number")).getAlias())) {
                    qccInfo.setBILLNO("number");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else if (headType instanceof BillEntityType) {
            if (headType.getAllFields().containsKey("billno")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("billno")).getAlias())) {
                    qccInfo.setBILLNO("billno");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else {
            qccInfo.setBILLNO(null);
        }
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        return qccInfo;
    }

    private static boolean hasEntryPriceField(List<String> results, List<String> entryNames) {
        for (String resultField : results) {
            for (String entryName : entryNames) {
                if (!resultField.contains(entryName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEntryPriceField(String resultField, List<String> entryNames) {
        for (String entryName : entryNames) {
            if (!resultField.contains(entryName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasHeadPriceField(List<String> results, List<String> entryNames) {
        int countEntryPrice = 0;
        block0: for (String resultField : results) {
            for (String entryName : entryNames) {
                if (!resultField.contains(entryName)) continue;
                ++countEntryPrice;
                continue block0;
            }
        }
        return countEntryPrice != results.size();
    }

    public static Map<String, List<String>> getHeaderAndEntryKeys(QuoteSchemeColl quoteSchemeColl, QuoteKeyInfo qccInfo) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(3);
        List<String> dimensions = quoteSchemeColl.mergeDimension();
        ArrayList<String> terminationSignList = new ArrayList<String>();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        QuoteHelper.assembleTerminateSign(quoteSchemeColl, terminationSignList);
        if (terminationSignList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoteHelper_9", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        }
        map.put(RESULT, terminationSignList);
        return map;
    }

    public static List<String> getResultFiled(Long orgID, String entityType) {
        QuoteSchemeColl quoteSchemeColl = QuoteHelper.fetchQuoteSchemeFromST(orgID, entityType);
        ArrayList<String> terminationSignList = new ArrayList<String>();
        QuoteHelper.assembleTerminateSign(quoteSchemeColl, terminationSignList);
        if (terminationSignList.size() > 0) {
            return terminationSignList;
        }
        return null;
    }

    public static Map<String, Object> getHeaderAndEntryKeysWithFlag(QuoteSchemeColl quoteSchemeColl, QuoteKeyInfo qccInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        List<String> dimensions = quoteSchemeColl.mergeDimension();
        ArrayList<String> terminationSignList = new ArrayList<String>();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        QuoteHelper.assembleTerminateSign(quoteSchemeColl, terminationSignList);
        if (terminationSignList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoteHelper_9", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        }
        map.put(RESULT, terminationSignList);
        map.put("success", Boolean.TRUE);
        return map;
    }

    public static Map<String, Boolean> setSuccess() {
        HashMap<String, Boolean> successFlag = new HashMap<String, Boolean>();
        successFlag.put("success", Boolean.TRUE);
        return successFlag;
    }

    public static void crossOrgValidate(List<QuoteKeyInfo> qccs) {
        HashSet entryNames = new HashSet();
        HashSet entryCounts = new HashSet();
        qccs.forEach(qccInfo -> {
            entryNames.add(qccInfo.getEntryName());
            entryCounts.add(qccInfo.getEntryCount());
        });
        if (entryCounts.size() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u5355\u5934\u548c\u5206\u5f55\u540c\u65f6\u53d6\u4ef7\u4ee5\u53ca\u591a\u5206\u5f55\u540c\u65f6\u53d6\u4ef7\u3002", (String)"QuoteHelper_7", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (entryNames.size() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u540c\u4e00\u5355\u636e\u53d6\u4ef7\u65b9\u6848\u5728\u4e0d\u540c\u7ec4\u7ec7\u4e0b\u914d\u7f6e\u4e86\u4e0d\u540c\u7684\u53d6\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u53d6\u4ef7\u3002", (String)"QuoteHelper_8", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    public static String generateRowKey(QuoteKeyInfo quoteKeyInfo, Row row) {
        StringBuilder key = new StringBuilder();
        key.append(String.valueOf(row.get(quoteKeyInfo.getLEFTIDFIELDS().get(0))));
        for (int i = 1; i < quoteKeyInfo.getLEFTIDFIELDS().size(); ++i) {
            String idField = quoteKeyInfo.getLEFTIDFIELDS().get(i);
            key.append("__").append(String.valueOf(row.get(idField)));
        }
        return key.toString();
    }

    public static String generateSchemeKey(Object pk, int seq) {
        StringBuilder key = new StringBuilder();
        key.append(pk.toString()).append("__").append(seq);
        return key.toString();
    }

    private static void assembleTerminateSign(QuoteSchemeColl quoteSchemeColl, List<String> terminationSignList) {
        quoteSchemeColl.getQuoteSchemeInfos().forEach(qs -> {
            List<String> quoteSourceResult = qs.getQuoteSourceResultAlias();
            String terminationSigns = qs.getTerminationSign();
            List<String> results = qs.getQuoteResults();
            for (int i = 0; i < quoteSourceResult.size(); ++i) {
                if (!quoteSourceResult.get(i).equals(terminationSigns) || terminationSignList.contains(results.get(i))) continue;
                terminationSignList.add(results.get(i));
            }
        });
    }
}

