/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.builder.QuoteLogBuilder;
import kd.scmc.plat.business.helper.pricemodel.builder.SchemeLogBuilderFactory;
import kd.scmc.plat.business.helper.pricemodel.helper.MarkDownHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteLogNode;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.business.service.pricemodel.log.QuoteStrategeLogProxy;
import kd.scmc.plat.common.enums.price.LogTypeEnum;
import kd.scmc.plat.common.enums.price.PriceCoverEnum;
import kd.scmc.plat.common.enums.price.SceneTypeEnum;

public class QuoteLogTreeNodeHelper {
    public static List<TreeNode> buildSchemeNode(String key, List<String> schemesPks, QuoteSchemeColl quoteSchemeColl, SceneTypeEnum sceneType, Map<String, Map<String, List<String>>> matchAllPriceCache) {
        ArrayList<TreeNode> schemesNodes = new ArrayList<TreeNode>();
        if (schemesPks == null || schemesPks.size() == 0) {
            return schemesNodes;
        }
        schemesPks.forEach(s -> {
            TreeNode schemeNode = new TreeNode();
            QuoteSchemeInfo scheme = quoteSchemeColl.getQuoteSchemes((String)s);
            List results = (List)((Map)matchAllPriceCache.get(s)).get(key);
            schemeNode.setId(scheme.getId());
            schemeNode.setType(sceneType.getValue());
            schemeNode.setData((Object)results);
            schemeNode.setLongNumber(String.valueOf(scheme.getSeq()));
            schemesNodes.add(schemeNode);
        });
        return schemesNodes;
    }

    public static void createQuoteLog(List<TreeNode> totalLogTreeNodes, QuoteLogProxy quoteLogProxy) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteMethod = ResManager.loadKDString((String)"\u53d6\u4ef7\u89e6\u53d1\u65b9\u5f0f", (String)"QuoteLogTreeNodeHelper_9", (String)"scmc-plat-business", (Object[])new Object[0]);
        String fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_2", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteStarage = ResManager.loadKDString((String)"\u53d6\u4ef7\u7b56\u7565\uff1a", (String)"QuoteLogTreeNodeHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteCoverParam = ResManager.loadKDString((String)"\u53d6\u4ef7\u8986\u76d6\u53c2\u6570\uff1a", (String)"QuoteLogTreeNodeHelper_10", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteAuto = ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_11", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteManu = ResManager.loadKDString((String)"\u624b\u5de5\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_12", (String)"scmc-plat-business", (Object[])new Object[0]);
        String readStarage = ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_4", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteStarageResult = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\uff1a", (String)"QuoteLogTreeNodeHelper_5", (String)"scmc-plat-business", (Object[])new Object[0]);
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)quoteLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)quoteLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)quoteLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)quoteLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("quotesrcbill", (Object)node.getQuoteSrcBill());
            quoteLog.set("quotesrcno", (Object)node.getQuoteSrcNo());
            if (StringUtils.isNotEmpty((CharSequence)node.getQuoteSrcSeq())) {
                quoteLog.set("quotesrcseq", (Object)Integer.valueOf(node.getQuoteSrcSeq()));
            }
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder();
            DynamicObject starage = quoteLogProxy.getQuoteSchemeColl().getQuoteStratege();
            if (starage != null) {
                logText = new StringBuilder();
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteMethod)));
                logText.append("\n\n");
                if (quoteLogProxy.isAuto()) {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteAuto)));
                    logText.append("\n\n");
                } else {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteManu)));
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchStarage)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteStarage)));
                logText.append(starage.getString("number")).append("&emsp;&emsp;").append(starage.getString("name"));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteCoverParam)));
                logText.append(PriceCoverEnum.getName((String)starage.getString("pricecoverrule")));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(readStarage)));
                logText.append("\n\n");
                List schemeNodes = rootNode.getChildren();
                for (TreeNode schemeNode : schemeNodes) {
                    String sceneType;
                    QuoteLogBuilder builder;
                    String[] idSeq = schemeNode.getId().split("__");
                    int seq = Integer.parseInt(schemeNode.getLongNumber());
                    if (idSeq.length > 1) {
                        seq = Integer.parseInt(idSeq[1]);
                    }
                    if ((builder = SchemeLogBuilderFactory.getBuilder(sceneType = schemeNode.getType())) != null) {
                        if (schemeNode.getData() == null) {
                            logText.append(builder.build(quoteLogProxy.getQuoteSchemeColl(), schemeNode.getId(), seq, null, node.getRecord()));
                        } else {
                            logText.append(builder.build(quoteLogProxy.getQuoteSchemeColl(), schemeNode.getId(), seq, (List)schemeNode.getData(), node.getRecord()));
                        }
                    }
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteStarageResult)));
                logText.append("\n\n");
                String starageResult = MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(quoteLog.getString("logresult")))).toString();
                logText.append(starageResult);
            }
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            logKeys[i] = logKey = QuoteLogTreeNodeHelper.generateLogKey(quoteLog);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            logArray[i] = quoteLog;
        }
        try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
            try {
                QFilter orgFilter = new QFilter("quoteorg", "=", (Object)quoteLogProxy.getQuoteOrgID());
                QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)quoteLogProxy.getQuoteBill());
                QFilter logKeyFilter = new QFilter("logkey", "in", (Object)logKeys);
                QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, logKeyFilter, lotTypeFilter});
                lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, lotTypeFilter});
                SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
            }
            catch (KDBizException kde) {
                h.markRollback();
                throw kde;
            }
            catch (Exception kde) {
                h.markRollback();
                throw kde;
            }
        }
    }

    public static void createQuoteStrategeLog(List<TreeNode> totalLogTreeNodes, QuoteStrategeLogProxy strategeLogProxy, String reasonType) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"scmc-plat-business", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
        String fetchStarage = "";
        if ("MULTI".equals(reasonType)) {
            fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565\u5931\u8d25\uff0c\u547d\u4e2d\u591a\u6761\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_7", (String)"scmc-plat-business", (Object[])new Object[0]);
        } else if ("NONE".equals(reasonType)) {
            fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565\u5931\u8d25\uff0c\u6ca1\u6709\u547d\u4e2d\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_6", (String)"scmc-plat-business", (Object[])new Object[0]);
        } else if ("NOSCHEME".equals(reasonType)) {
            fetchStarage = ResManager.loadKDString((String)"\u547d\u4e2d\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u53d6\u4ef7\u65b9\u6848", (String)"QuoteLogTreeNodeHelper_8", (String)"scmc-plat-business", (Object[])new Object[0]);
        }
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)strategeLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)strategeLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)strategeLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)strategeLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder();
            logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
            logText.append("\n\n");
            logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
            logText.append("\n\n");
            logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchStarage)));
            logText.append("\n\n");
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            logKeys[i] = logKey = QuoteLogTreeNodeHelper.generateLogKey(quoteLog);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            logArray[i] = quoteLog;
        }
        try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
            try {
                QFilter orgFilter = new QFilter("quoteorg", "=", (Object)strategeLogProxy.getQuoteOrgID());
                QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)strategeLogProxy.getQuoteBill());
                QFilter logKeyFilter = new QFilter("logkey", "in", (Object)logKeys);
                QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, logKeyFilter, lotTypeFilter});
                lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, lotTypeFilter});
                SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
            }
            catch (KDBizException kde) {
                h.markRollback();
                throw kde;
            }
            catch (Exception kde) {
                h.markRollback();
                throw kde;
            }
        }
    }

    public static String generateLogKey(DynamicObject quoteLog) {
        Long billID = quoteLog.getLong("quotebillid");
        Long billEntryID = quoteLog.getLong("quotebillentryid");
        StringBuilder key = new StringBuilder(String.valueOf(billID));
        if (billEntryID != null && billEntryID > 0L) {
            key.append("__").append(String.valueOf(billEntryID));
        }
        return key.toString();
    }
}

