/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterValue;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.DataSetHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.UpgradeQuoteSchemeHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteConditonInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteStrategeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteStrategySeqInfo;
import kd.scmc.plat.common.consts.pricemodel.QuoteConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeEntryConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteSchemeSortEntryConst;
import kd.scmc.plat.common.consts.pricemodel.QuoteStrategyEntryConst;
import kd.scmc.plat.common.enums.EnableStatusEnum;
import kd.scmc.plat.common.enums.StatusEnum;

public class QuoteNewHelper {
    private static final Log LOGGER = LogFactory.getLog(QuoteNewHelper.class);
    private static final String HEADER = "header";
    private static final String ENTRY = "entry";
    private static final String RESULT = "result";

    public static QuoteStrategeColl fetchQuoteSchemeFromST(Long orgID, String type) {
        UpgradeQuoteSchemeHelper.updateQuoteStrategy();
        QuoteStrategeColl quoteStrategeColl = new QuoteStrategeColl();
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"plat_quotestrategy", (Long)orgID);
        String selecties = new StringBuffer("id,").append("pricecoverrule").append(",").append(new StringBuffer(String.join((CharSequence)",", QuoteStrategyEntryConst.getSelectorList()))).toString();
        DynamicObject[] quoteStrategys = BusinessDataServiceHelper.load((String)"plat_quotestrategy", (String)selecties, (QFilter[])new QFilter[]{orgIdFilter, statusFilter, enableFilter}, (String)"number");
        HashMap<Object, DynamicObject> quoteStrategyMap = new HashMap<Object, DynamicObject>(16);
        if (quoteStrategys.length != 0) {
            ArrayList<DynamicObject> conditonMatch = new ArrayList<DynamicObject>(16);
            ArrayList quoteSchemes = new ArrayList(16);
            ArrayList quoteSeqInfoCheckList = new ArrayList(16);
            ArrayList<QuoteStrategySeqInfo> quoteSeqInfoList = new ArrayList<QuoteStrategySeqInfo>(16);
            ArrayList<Object> schemePKs = new ArrayList<Object>(16);
            for (int t = 0; t < quoteStrategys.length; ++t) {
                int s;
                List quoteConditonInfos;
                DynamicObject quoteStrategy = quoteStrategys[t];
                quoteStrategyMap.put(quoteStrategy.getPkValue(), quoteStrategy);
                DynamicObjectCollection conditionEntry = quoteStrategy.getDynamicObjectCollection("conditionentryentity");
                conditonMatch.clear();
                if (conditionEntry.size() == 0) {
                    QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(true);
                    quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                    quoteConditonInfos.add(quoteConditonInfo);
                } else {
                    for (int i = 0; i < conditionEntry.size(); ++i) {
                        DynamicObject condition = (DynamicObject)conditionEntry.get(i);
                        String quoteBillType = condition.getDynamicObject("quotebill").getString("number");
                        if (!quoteBillType.equals(type)) continue;
                        conditonMatch.add(condition);
                    }
                    if (conditonMatch.size() > 0) {
                        conditonMatch.forEach(e -> {
                            QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(true);
                            quoteConditonInfo.generateQuoteConditonInfo((DynamicObject)e, type);
                            List quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                            quoteConditonInfos.add(quoteConditonInfo);
                        });
                    } else {
                        QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(false);
                        quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                        quoteConditonInfos.add(quoteConditonInfo);
                    }
                }
                schemePKs.clear();
                quoteSeqInfoList.clear();
                QuoteSchemeColl quoteSchemeColl = new QuoteSchemeColl();
                quoteSchemeColl.setQuoteStratege(quoteStrategy);
                DynamicObjectCollection entrys = quoteStrategy.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject quoteScheme = ((DynamicObject)entrys.get(i)).getDynamicObject("quotescheme");
                    if (quoteScheme == null || !type.equals(quoteScheme.getDynamicObject("quoteentity").getPkValue())) continue;
                    schemePKs.add(quoteScheme.getPkValue());
                    String preCondition = ((DynamicObject)entrys.get(i)).getString("preconditionjson_tag");
                    String preConditionOld = ((DynamicObject)entrys.get(i)).getString("qu_precondition");
                    if (StringUtils.isBlank((CharSequence)preCondition) && StringUtils.isNotBlank((CharSequence)preConditionOld)) {
                        preCondition = preConditionOld;
                    }
                    quoteSeqInfoList.add(new QuoteStrategySeqInfo(i + 1, ((DynamicObject)entrys.get(i)).getString("terminationsign"), preCondition, ((DynamicObject)entrys.get(i)).getString("qu_preconditiondesc")));
                }
                quoteSchemes.clear();
                quoteSeqInfoCheckList.clear();
                if (schemePKs.size() <= 0) continue;
                StringBuilder props = new StringBuilder(String.join((CharSequence)",", QuoteSchemeConst.getSelectorList()));
                StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeEntryConst.getSelectorList()));
                StringBuilder sortEntryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeSortEntryConst.getSelectorList()));
                String selector = props.append(',').append((CharSequence)entryProps).append(',').append((CharSequence)sortEntryProps).toString();
                QFilter schemeStatusFilter = new QFilter("status", "=", (Object)"C");
                QFilter schemeEnableFilter = new QFilter("enable", "=", (Object)"1");
                QFilter schemeIDFilter = new QFilter("id", "in", schemePKs);
                Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{schemeStatusFilter, schemeEnableFilter, schemeIDFilter});
                for (s = 0; s < schemePKs.size(); ++s) {
                    Object pk = schemePKs.get(s);
                    if (schemeMap.get(pk) == null) continue;
                    quoteSchemes.add(schemeMap.get(pk));
                    quoteSeqInfoCheckList.add(quoteSeqInfoList.get(s));
                }
                if (quoteSchemes.size() > 0) {
                    for (s = 0; s < quoteSchemes.size(); ++s) {
                        quoteSchemeColl.applyScheme((DynamicObject)quoteSchemes.get(s), (QuoteStrategySeqInfo)quoteSeqInfoCheckList.get(s));
                    }
                }
                quoteStrategeColl.getSchemeCollMapping().put(quoteStrategy.getPkValue(), quoteSchemeColl);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u672a\u7ef4\u62a4\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteHelper_3", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (quoteStrategeColl.getSchemeCollMapping().size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        ArrayList totalSchemes = new ArrayList();
        quoteStrategeColl.getSchemeCollMapping().forEach((k, v) -> {
            totalSchemes.addAll(v.getQuoteSchemeInfos());
            if (v.getQuoteSchemeInfos().size() > 0) {
                quoteStrategeColl.getQuoteStrateges().add((DynamicObject)quoteStrategyMap.get(k));
            }
        });
        if (totalSchemes.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u53d6\u4ef7\u65b9\u6848\u3002", (String)"QuoteHelper_1", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return quoteStrategeColl;
    }

    public static QuoteKeyInfo getQuoteCommonConst(String entityType, QuoteStrategeColl quoteStrategeColl) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        ArrayList<String> quoteResultSet = new ArrayList<String>();
        quoteStrategeColl.getSchemeCollMapping().forEach((k, v) -> v.mergeQuoteResult(quoteResultSet));
        dimensions.addAll(quoteResultSet);
        String allStr = String.join((CharSequence)",", dimensions);
        QuoteKeyInfo qccInfo = new QuoteKeyInfo(entityType);
        ArrayList<String> entryNames = new ArrayList<String>();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setLEFT_BILLENTRY_ID(qccInfo.getEntryIDAlias());
                qccInfo.setLEFT_SEQ(qccInfo.getEntrySeqAlias());
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        if (qccInfo.getEntryCount() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u914d\u7f6e\u4e86\u8d85\u8fc71\u4e2a\u53d6\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u53d6\u4ef7\u3002", (String)"QuoteHelper_4", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        boolean hasHeadPriceFiled = QuoteNewHelper.hasHeadPriceField(quoteResultSet, entryNames);
        qccInfo.setHeadPriceField(hasHeadPriceFiled);
        qccInfo.setHasTable(StringUtils.isNotEmpty((CharSequence)headType.getAlias()));
        return qccInfo;
    }

    public static Map<String, Object> getHeaderAndEntryKeysWithFlag(QuoteStrategeColl quoteStrategeColl, QuoteKeyInfo qccInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        ArrayList terminationSignList = new ArrayList();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        quoteStrategeColl.getSchemeCollMapping().forEach((k, v) -> QuoteNewHelper.assembleTerminateSign(v, terminationSignList));
        if (terminationSignList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoteHelper_9", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        }
        map.put(RESULT, terminationSignList);
        map.put("success", Boolean.TRUE);
        return map;
    }

    public static Map<String, List<String>> getHeaderAndEntryKeys(QuoteStrategeColl quoteStrategeColl, QuoteKeyInfo qccInfo) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(3);
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        ArrayList terminationSignList = new ArrayList();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        quoteStrategeColl.getSchemeCollMapping().forEach((k, v) -> QuoteNewHelper.assembleTerminateSign(v, terminationSignList));
        if (terminationSignList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoteHelper_9", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        }
        map.put(RESULT, terminationSignList);
        return map;
    }

    public static DataSet buildQuoteDataSetByMap(List<Map<String, Object>> entryMapList, String entityType, QuoteStrategeColl quoteStrategeColl, QuoteKeyInfo qccInfo) {
        if (entryMapList == null || entryMapList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u672a\u5411\u53d6\u4ef7\u670d\u52a1\u63a5\u53e3\u4f20\u9012\u53d6\u4ef7\u5355\u636e\u4fe1\u606f\u3002", (String)"QuoteHelper_10", (String)"scmc-plat-business", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        List<String> alias = quoteStrategeColl.mergeAlias();
        return DataSetHelper.toDataSetByMap(entryMapList, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSet(DynamicObject[] bills, String entityType, QuoteStrategeColl quoteStrategeColl, QuoteKeyInfo qccInfo) {
        String[] dimensions = new String[]{};
        String[] alias = new String[]{};
        dimensions = quoteStrategeColl.mergeDimension().toArray(dimensions);
        alias = quoteStrategeColl.mergeAlias().toArray(alias);
        return DataSetHelper.toDataSet(bills, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSetByIDs(Long[] ids, QuoteStrategeColl quoteStrategeColl, String entityType, QuoteKeyInfo qccInfo) {
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        List<String> alias = quoteStrategeColl.mergeAlias();
        qccInfo.getIDFIELDS().forEach(f -> dimensions.add((String)f));
        qccInfo.getLEFTIDFIELDS().forEach(f -> alias.add((String)f));
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensions.set(i, new StringBuffer(dimensions.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(alias.get(i))).toString());
        }
        DataSet result = QueryServiceHelper.queryDataSet((String)"QuoteHelper", (String)entityType, (String)String.join((CharSequence)",", dimensions), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, (String)"id");
        return result;
    }

    private static void assembleTerminateSign(QuoteSchemeColl quoteSchemeColl, List<String> terminationSignList) {
        quoteSchemeColl.getQuoteSchemeInfos().forEach(qs -> {
            List<String> quoteSourceResult = qs.getQuoteSourceResultAlias();
            String terminationSigns = qs.getTerminationSign();
            List<String> results = qs.getQuoteResults();
            for (int i = 0; i < quoteSourceResult.size(); ++i) {
                if (!quoteSourceResult.get(i).equals(terminationSigns) || terminationSignList.contains(results.get(i))) continue;
                terminationSignList.add(results.get(i));
            }
        });
    }

    private static boolean hasHeadPriceField(List<String> results, List<String> entryNames) {
        int countEntryPrice = 0;
        block0: for (String resultField : results) {
            for (String entryName : entryNames) {
                if (!resultField.contains(entryName)) continue;
                ++countEntryPrice;
                continue block0;
            }
        }
        return countEntryPrice != results.size();
    }

    public static String dataTypeAdapte(QFilter totalFilter, MainEntityType headType) {
        HashMap<String, Set<String>> convertMap = new HashMap<String, Set<String>>(16);
        QuoteNewHelper.parseFilter(totalFilter, headType, convertMap);
        return QuoteNewHelper.transferDateType(totalFilter.toString(), convertMap);
    }

    private static void parseFilter(QFilter totalFilter, MainEntityType headType, Map<String, Set<String>> converMap) {
        if (!totalFilter.isExpressValue()) {
            QuoteNewHelper.transferAndRecDataType(totalFilter, headType, converMap);
        } else {
            String valueAlias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(totalFilter.getValue().toString().replaceAll("\\.", "__"))).toString();
            totalFilter.__setValue((Object)valueAlias);
        }
        if (!"1".equals(totalFilter.getProperty())) {
            String alias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(totalFilter.getProperty().replaceAll("\\.", "__"))).toString();
            totalFilter.__setProperty(alias);
        }
        List listFilterNest = totalFilter.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            QuoteNewHelper.parseFilter(nestFilter, headType, converMap);
        }
    }

    private static String transferDateType(String conditionStr, Map<String, Set<String>> convertMap) {
        if (convertMap.get("date") != null) {
            for (String date : convertMap.get("date")) {
                Pattern p = Pattern.compile("'" + date + "'");
                Matcher m = p.matcher(conditionStr);
                conditionStr = m.replaceAll("cast('" + date + "' as timestamp)");
            }
        }
        LOGGER.info("final filterstr:" + conditionStr);
        return conditionStr;
    }

    private static void transferAndRecDataType(QFilter totalFilter, MainEntityType headType, Map<String, Set<String>> converMap) {
        block8: {
            Object valueK;
            block12: {
                String value;
                block13: {
                    IDataEntityProperty ep;
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    if (!"is not null".equals(totalFilter.getCP())) break block7;
                                    totalFilter.__setValue(null);
                                    break block8;
                                }
                                if (!(totalFilter.getValue() instanceof QEmptyValue) && (!"not exists".equals(totalFilter.getCP()) || totalFilter.getValue() == null || !(totalFilter.getValue() instanceof QFilterValue) || !"1 = 1".equals(totalFilter.getValue().toString()))) break block9;
                                IDataEntityProperty ep2 = DataSetHelper.findPropertys((EntityType)headType, totalFilter.getProperty());
                                totalFilter.__setCP("is null");
                                totalFilter.__setValue(null);
                                if (ep2 instanceof LongProp && "id".equals(ep2.getName())) {
                                    totalFilter.or(new QFilter(totalFilter.getProperty(), "=", (Object)Long.valueOf("0")));
                                }
                                break block8;
                            }
                            ep = DataSetHelper.findPropertys((EntityType)headType, totalFilter.getProperty());
                            if (!(ep instanceof BooleanProp)) break block10;
                            totalFilter.__setValue((Object)("1".equals(totalFilter.getValue()) ? 1 : 0));
                            break block8;
                        }
                        if (!(ep instanceof DateProp) && !(ep instanceof DateTimeProp)) break block11;
                        if (totalFilter.getValue() != null) {
                            final Date value2 = (Date)totalFilter.getValue();
                            final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            if (converMap.get("date") == null) {
                                converMap.put("date", new HashSet(){
                                    {
                                        this.add(format.format(value2));
                                    }
                                });
                            } else {
                                converMap.get("date").add(format.format(value2));
                            }
                        }
                        break block8;
                    }
                    if (ep instanceof TimeProp || !(ep instanceof TextProp) || totalFilter.getValue() == null) break block8;
                    valueK = totalFilter.getValue();
                    if (!(valueK instanceof String)) break block12;
                    value = (String)totalFilter.getValue();
                    if (!"''".equals(value) && !"' '".equals(value)) break block13;
                    totalFilter.__setValue((Object)"");
                    break block8;
                }
                if (!"\"\"".equals(value) && !"\" \"".equals(value)) break block8;
                totalFilter.__setValue((Object)"");
                break block8;
            }
            if (valueK instanceof List) {
                List valueList = (List)valueK;
                for (int s = 0; s < valueList.size(); ++s) {
                    String value = (String)valueList.get(s);
                    if ("''".equals(value) || "' '".equals(value)) {
                        valueList.set(s, "");
                        continue;
                    }
                    if (!"\"\"".equals(value) && !"\" \"".equals(value)) continue;
                    valueList.set(s, "");
                }
            }
        }
    }

    public static void registerQuoteBill(BeforeF7SelectEvent e) {
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"plat_quotescheme", (String)"quoteentity", (QFilter[])new QFilter[]{statusFilter, enableFilter});
        HashSet<String> quoteBills = new HashSet<String>();
        for (DynamicObject scheme : schemes) {
            String quoteBill = scheme.getString("quoteentity");
            MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBill);
            if (!StringUtils.isNotEmpty((CharSequence)headType.getAlias())) continue;
            quoteBills.add(quoteBill);
        }
        if (quoteBills.size() > 0) {
            QFilter addFilter = new QFilter("number", "in", quoteBills);
            ListShowParameter listParameter = (ListShowParameter)e.getFormShowParameter();
            List filters = listParameter.getListFilterParameter().getQFilters();
            if (filters.size() > 0) {
                listParameter.getListFilterParameter().setFilter(((QFilter)listParameter.getListFilterParameter().getQFilters().get(0)).or(addFilter));
            }
        }
    }
}

