/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.PriceParameterHelper;

public class UpgradeQuoteSchemeHelper {
    private static final Log LOGGER = LogFactory.getLog(UpgradeQuoteSchemeHelper.class);

    public static void update() {
        LOGGER.info("start update quotescheme......");
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        DataSet salDataSet = QueryServiceHelper.queryDataSet((String)"UpgradeQuoteSchemeHelper", (String)"plat_quotescheme", (String)UpgradeQuoteSchemeHelper.getSchemeSelectors(), (QFilter[])new QFilter[]{filter}, null);
        LinkedList<Object[]> updateParamsList = new LinkedList<Object[]>();
        HashMap<String, MainEntityType> mainEntityTypeCache = new HashMap<String, MainEntityType>();
        HashMap<Long, Boolean> hasPurchaseBizCache = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> hasSalBizCache = new HashMap<Long, Boolean>();
        HashMap<String, Integer> isCrossOrgCache = new HashMap<String, Integer>();
        for (Row row : salDataSet) {
            Long orgID;
            String useOld = row.getString("use");
            if (StringUtils.isNotEmpty((CharSequence)useOld) || (orgID = row.getLong("org")) == null || orgID.equals(Long.valueOf("0"))) continue;
            Long id = row.getLong("id");
            MainOrgProp sourceOrgProp = null;
            String pricesource = row.getString("pricesource");
            try {
                if (StringUtils.isNotEmpty((CharSequence)pricesource)) {
                    mainEntityTypeCache.computeIfAbsent(pricesource, k -> {
                        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)pricesource);
                        return sourceEntityType;
                    });
                    MainEntityType sourceEntityType = (MainEntityType)mainEntityTypeCache.get(pricesource);
                    if (sourceEntityType != null && sourceEntityType.getMainOrg() != null) {
                        sourceOrgProp = (MainOrgProp)sourceEntityType.getProperty(sourceEntityType.getMainOrg());
                    }
                }
            }
            catch (Exception e) {
                if (StringUtils.isNotEmpty((CharSequence)pricesource)) {
                    LOGGER.info("sourceEntityType get=......" + pricesource);
                }
                LOGGER.info("sourceEntityType get=......");
            }
            MainOrgProp quoteOrgProp = null;
            String quoteentity = row.getString("quoteentity");
            try {
                if (StringUtils.isNotEmpty((CharSequence)quoteentity)) {
                    LOGGER.info("quoteentity get=......" + quoteentity);
                    mainEntityTypeCache.computeIfAbsent(quoteentity, k -> {
                        MainEntityType quoteEntityType = EntityMetadataCache.getDataEntityType((String)quoteentity);
                        return quoteEntityType;
                    });
                    MainEntityType quoteEntityType = (MainEntityType)mainEntityTypeCache.get(quoteentity);
                    if (quoteEntityType != null && quoteEntityType.getMainOrg() != null) {
                        quoteOrgProp = (MainOrgProp)quoteEntityType.getProperty(quoteEntityType.getMainOrg());
                    }
                }
            }
            catch (Exception e) {
                if (StringUtils.isNotEmpty((CharSequence)quoteentity)) {
                    LOGGER.info("quoteentity get=......" + quoteentity);
                }
                LOGGER.info("quoteentity get=......");
            }
            hasPurchaseBizCache.computeIfAbsent(orgID, k -> {
                boolean hasPurchaseBiz = OrgUnitServiceHelper.checkOrgFunction((Long)orgID, (String)"02");
                return hasPurchaseBiz;
            });
            hasSalBizCache.computeIfAbsent(orgID, k -> {
                boolean hasSalchaseBiz = OrgUnitServiceHelper.checkOrgFunction((Long)orgID, (String)"03");
                return hasSalchaseBiz;
            });
            boolean hasPurchaseBiz = (Boolean)hasPurchaseBizCache.get(orgID);
            boolean hasSaleBiz = (Boolean)hasSalBizCache.get(orgID);
            String use = UpgradeQuoteSchemeHelper.getUse(hasPurchaseBiz, hasSaleBiz, sourceOrgProp, quoteOrgProp);
            String isCrossOrgKey = String.valueOf(orgID) + use;
            isCrossOrgCache.computeIfAbsent(isCrossOrgKey, k -> {
                int isCrossOrg = UpgradeQuoteSchemeHelper.getIsCrossOrg(orgID, use);
                return isCrossOrg;
            });
            int isCrossOrg = (Integer)isCrossOrgCache.get(isCrossOrgKey);
            Object[] updateObjectParam = new Object[]{use, isCrossOrg, id};
            updateParamsList.add(updateObjectParam);
        }
        if (updateParamsList.isEmpty()) {
            LOGGER.info("don't have updata scheme");
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update T_PLAT_QUOTESCHEME set fuse=? , forgdivide=? where fid=?", updateParamsList);
            LOGGER.info("updata success");
        }
    }

    public static void updateQuoteStrategy() {
        LOGGER.info("start update T_plat_QuoteStrategy_u......");
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet quoteStrategy_u = DB.queryDataSet((String)"UpgradeQuoteSchemeHelper", (DBRoute)DBRoute.of((String)"scm"), (String)"select fdataid from T_plat_QuoteStrategy_u");){
            for (Row row : quoteStrategy_u) {
                ids.add(row.getLong("fdataid"));
            }
        }
        LinkedList<Object[]> updateParamsList = new LinkedList<Object[]>();
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        filter.and(new QFilter("ctrlstrategy", "=", (Object)"7"));
        try (DataSet salDataSet = QueryServiceHelper.queryDataSet((String)"UpgradeQuoteSchemeHelper", (String)"plat_quotestrategy", (String)"id, createorg", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : salDataSet) {
                Long id = row.getLong("id");
                Long orgID = row.getLong("createorg");
                if (orgID == null || orgID.equals(Long.valueOf("0")) || ids.contains(id)) continue;
                Object[] updateObjectParam = new Object[]{id, orgID, orgID};
                updateParamsList.add(updateObjectParam);
            }
        }
        if (updateParamsList.isEmpty()) {
            LOGGER.info("don't have init quoteStrategy_u");
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"insert into T_plat_QuoteStrategy_u(fdataid,fcreateorgid,fuseorgid) values(?,?,?)", updateParamsList);
            LOGGER.info("init success");
        }
    }

    private static String getSchemeSelectors() {
        List<String> selectors = Arrays.asList("id", "org", "use", "pricesourceentity.number pricesource", "quoteentity.number quoteentity");
        return String.join((CharSequence)",", selectors);
    }

    private static String getUse(boolean hasPurchaseBiz, boolean hasSaleBiz, MainOrgProp sourceOrgProp, MainOrgProp quoteOrgProp) {
        String use = "";
        if (hasPurchaseBiz && sourceOrgProp != null && "02".equals(sourceOrgProp.getOrgFunc())) {
            return "pur";
        }
        if (hasSaleBiz && sourceOrgProp != null && "03".equals(sourceOrgProp.getOrgFunc())) {
            use = "sal";
            return use;
        }
        if (hasPurchaseBiz && quoteOrgProp != null && "02".equals(quoteOrgProp.getOrgFunc())) {
            return "pur";
        }
        if (hasSaleBiz && quoteOrgProp != null && "03".equals(quoteOrgProp.getOrgFunc())) {
            return "sal";
        }
        return use;
    }

    private static int getIsCrossOrg(Long orgID, String use) {
        Object param;
        boolean isCrossOrg = false;
        if ("pur".equals(use)) {
            Object param2 = PriceParameterHelper.getPmpAppParameter(orgID, "crossorgfetchprice");
            if (param2 != null && ((Boolean)param2).booleanValue()) {
                isCrossOrg = true;
            }
        } else if ("sal".equals(use) && (param = PriceParameterHelper.getPmsAppParameter(orgID, "crossorgfetchsalprice")) != null && ((Boolean)param).booleanValue()) {
            isCrossOrg = true;
        }
        if (!isCrossOrg) {
            return 1;
        }
        return 0;
    }
}

