/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteStrategySeqInfo;
import kd.scmc.plat.common.consts.pricemodel.QuoteConst;

public class QuoteSchemeColl {
    private DynamicObject quoteStratege;
    private List<DynamicObject> quoteSchemes = new ArrayList<DynamicObject>();
    private Map<String, QuoteSchemeInfo> mapping = new HashMap<String, QuoteSchemeInfo>();
    private List<QuoteSchemeInfo> quoteSchemeInfos = new ArrayList<QuoteSchemeInfo>();
    private List<String> quoteResultSet = new ArrayList<String>();
    private List<String> quoteResultAliasSet = new ArrayList<String>();

    public void applyScheme(DynamicObject quoteScheme, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        this.quoteSchemes.add(quoteScheme);
        QuoteSchemeInfo quoteSchemeInfo = new QuoteSchemeInfo();
        this.mapping.put(QuoteHelper.generateSchemeKey(quoteScheme.getPkValue(), quoteStrategySeqInfo.getSeq()), quoteSchemeInfo.generateSchemeInfo(quoteScheme, quoteStrategySeqInfo));
        this.quoteSchemeInfos.add(quoteSchemeInfo);
    }

    public List<String> mergeDimension() {
        ArrayList<String> dimensionSet = new ArrayList<String>();
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteDimensions().forEach(d -> {
                if (!dimensionSet.contains(d)) {
                    dimensionSet.add((String)d);
                }
            });
            q.getQuoteFilters().forEach(f -> {
                if (!dimensionSet.contains(f.getProperty())) {
                    dimensionSet.add(f.getProperty());
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateDimension(dimensionSet, (QFilter)f));
        });
        return dimensionSet;
    }

    public List<String> mergeDimension(List<String> dimensionSet) {
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteDimensions().forEach(d -> {
                if (!dimensionSet.contains(d)) {
                    dimensionSet.add((String)d);
                }
            });
            q.getQuoteFilters().forEach(f -> {
                if (!dimensionSet.contains(f.getProperty())) {
                    dimensionSet.add(f.getProperty());
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateDimension(dimensionSet, (QFilter)f));
        });
        return dimensionSet;
    }

    public List<String> mergeAlias() {
        ArrayList<String> aliasSet = new ArrayList<String>();
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteAlias().forEach(d -> {
                if (!aliasSet.contains(d)) {
                    aliasSet.add((String)d);
                }
            });
            q.getQuoteFilters().forEach(f -> {
                String alias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString();
                if (!aliasSet.contains(alias)) {
                    aliasSet.add(alias);
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateAlias(aliasSet, (QFilter)f));
        });
        return aliasSet;
    }

    public List<String> mergeAlias(List<String> aliasSet) {
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteAlias().forEach(d -> {
                if (!aliasSet.contains(d)) {
                    aliasSet.add((String)d);
                }
            });
            q.getQuoteFilters().forEach(f -> {
                String alias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString();
                if (!aliasSet.contains(alias)) {
                    aliasSet.add(alias);
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateAlias(aliasSet, (QFilter)f));
        });
        return aliasSet;
    }

    public List<String> mergeQuoteResultAlias() {
        this.quoteResultAliasSet = new ArrayList<String>();
        this.quoteSchemeInfos.forEach(q -> q.getQuoteResultsAlias().forEach(d -> {
            if (!this.quoteResultAliasSet.contains(d)) {
                this.quoteResultAliasSet.add((String)d);
            }
        }));
        return this.quoteResultAliasSet;
    }

    public List<String>[] divideHeadAndEntryResults() {
        if (this.getQuoteSchemeInfos().size() == 0) {
            return new List[0];
        }
        if (this.quoteResultSet.size() == 0) {
            this.mergeQuoteResult();
        }
        String quoteType = this.getQuoteSchemeInfos().get(0).getQuoteType();
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteType);
        Map entryTypeMap = headType.getAllEntities();
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> entryNames.add(v.getName()));
        ArrayList headResult = new ArrayList();
        ArrayList entryResult = new ArrayList();
        this.quoteResultSet.forEach(a -> {
            if (QuoteHelper.isEntryPriceField(a, entryNames)) {
                entryResult.add(a);
            } else {
                headResult.add(a);
            }
        });
        List[] result = new List[]{headResult, entryResult};
        return result;
    }

    public List[] divideHeadAndEntryResultsAlias() {
        if (this.getQuoteSchemeInfos().size() == 0) {
            return new List[0];
        }
        if (this.quoteResultAliasSet.size() == 0) {
            this.mergeQuoteResultAlias();
        }
        String quoteType = this.getQuoteSchemeInfos().get(0).getQuoteType();
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteType);
        Map entryTypeMap = headType.getAllEntities();
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> entryNames.add(v.getName()));
        ArrayList headResult = new ArrayList();
        ArrayList entryResult = new ArrayList();
        this.quoteResultAliasSet.forEach(a -> {
            if (QuoteHelper.isEntryPriceField(a, entryNames)) {
                entryResult.add(a);
            } else {
                headResult.add(a);
            }
        });
        List[] result = new List[]{headResult, entryResult};
        return result;
    }

    public List<String> mergeQuoteResult() {
        this.quoteResultSet = new ArrayList<String>();
        this.quoteSchemeInfos.forEach(q -> q.getQuoteResults().forEach(d -> {
            if (!this.quoteResultSet.contains(d)) {
                this.quoteResultSet.add((String)d);
            }
        }));
        return this.quoteResultSet;
    }

    public List<String> mergeQuoteResult(List<String> quoteResultSet) {
        this.quoteSchemeInfos.forEach(q -> q.getQuoteResults().forEach(d -> {
            if (!quoteResultSet.contains(d)) {
                quoteResultSet.add((String)d);
            }
        }));
        return quoteResultSet;
    }

    public List<DynamicObject> getQuoteSchemes() {
        return this.quoteSchemes;
    }

    public QuoteSchemeInfo getQuoteSchemes(String qsID) {
        return this.mapping.get(qsID);
    }

    public DynamicObject getQuoteStratege() {
        return this.quoteStratege;
    }

    public void setQuoteStratege(DynamicObject quoteStratege) {
        this.quoteStratege = quoteStratege;
    }

    public List<QuoteSchemeInfo> getQuoteSchemeInfos() {
        return this.quoteSchemeInfos;
    }

    public List<String> getQuoteResultSet() {
        return this.quoteResultSet;
    }

    public List<String> getQuoteResultAliasSet() {
        return this.quoteResultAliasSet;
    }

    private void generateDimension(List<String> dimensionSet, QFilter f) {
        if (!dimensionSet.contains(f.getProperty())) {
            dimensionSet.add(f.getProperty());
        }
        if (f.isExpressValue() && !dimensionSet.contains(f.getValue())) {
            dimensionSet.add(f.getValue().toString());
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateDimension(dimensionSet, nestFilter);
        }
    }

    private void generateAlias(List<String> aliasSet, QFilter f) {
        String valueAlias;
        String alias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString();
        if (!aliasSet.contains(alias)) {
            aliasSet.add(alias);
        }
        if (f.isExpressValue() && !aliasSet.contains(valueAlias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getValue().toString().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(valueAlias);
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateAlias(aliasSet, nestFilter);
        }
    }
}

