/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.pojo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSrcKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteStrategySeqInfo;
import kd.scmc.plat.common.consts.pricemodel.QuoteConst;
import kd.scmc.plat.common.enums.price.OrderEnum;
import kd.scmc.plat.common.enums.price.QuotePatternEnum;

public class QuoteSchemeInfo {
    private String name;
    private String number;
    private int seq;
    private String id;
    private boolean orgDivide;
    private String use;
    private List<String> quoteDimensions = new ArrayList<String>();
    private List<String> quoteDimensionsDes = new ArrayList<String>();
    private List<String> quoteAlias = new ArrayList<String>();
    private List<String> quoteResults = new ArrayList<String>();
    private List<String> quoteResultsAlias = new ArrayList<String>();
    private List<String> quoteSourceDimensions = new ArrayList<String>();
    private List<String> quoteSourceDimensionsDes = new ArrayList<String>();
    private List<String> quoteSourceAlias = new ArrayList<String>();
    private List<String> quoteSourceResult = new ArrayList<String>();
    private List<String> quoteSourceResultAlias = new ArrayList<String>();
    private String quoteSrcConditon;
    private QFilter quoteSrcFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    private String quoteSrcFilterDes;
    private String quoteConditon;
    private String quotePreConditon;
    private String quotePreConditonDesc;
    private List<QFilter> quoteFilters = new ArrayList<QFilter>();
    private List<QFilter> quotePreFilters = new ArrayList<QFilter>();
    private String terminationSign;
    private QFilter quoteFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    private QFilter quotePreFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
    private String quoteSrcType;
    private QuoteSrcKeyInfo quoteSrcKeyInfo;
    private String quoteType;
    private List<String> operators = new ArrayList<String>();
    private List<String> sortSignFields = new ArrayList<String>();
    private List<String> sortSignsDes = new ArrayList<String>();
    private List<String> sortSignAlias = new ArrayList<String>();
    private List<String> sortOrders = new ArrayList<String>();
    private String returnPattern;

    public QuoteSchemeInfo generateSchemeInfo(DynamicObject quoteScheme, int seq) {
        FilterBuilder quoteBuilder;
        this.id = QuoteHelper.generateSchemeKey(quoteScheme.getPkValue(), seq);
        this.seq = seq;
        DynamicObjectCollection mappingEntry = quoteScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject mappingInfo : mappingEntry) {
            String pattern = mappingInfo.getString("quotepattern");
            String quoteSign = mappingInfo.getString("quotesign");
            String sourceSign = mappingInfo.getString("sourcesign");
            String matchFlag = mappingInfo.getString("matchflag");
            String quoteSignDes = mappingInfo.getString("quotesignname");
            String sourceSignDes = mappingInfo.getString("sourcesignname");
            if (QuotePatternEnum.CONDITION.getValue().equals(pattern)) {
                this.quoteDimensions.add(quoteSign);
                this.quoteDimensionsDes.add(quoteSignDes);
                this.quoteAlias.add(new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(quoteSign.replaceAll("\\.", "__"))).toString());
                this.quoteSourceDimensions.add(sourceSign);
                this.quoteSourceDimensionsDes.add(sourceSignDes);
                this.quoteSourceAlias.add(new StringBuffer(QuoteConst.RIGHT).append(new StringBuffer(sourceSign.replaceAll("\\.", "__"))).toString());
                this.operators.add(matchFlag);
                continue;
            }
            this.quoteResults.add(quoteSign);
            this.quoteResultsAlias.add(new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(quoteSign.replaceAll("\\.", "__"))).toString());
            this.quoteSourceResult.add(sourceSign);
            this.quoteSourceResultAlias.add(new StringBuffer(QuoteConst.RIGHT).append(new StringBuffer(sourceSign.replaceAll("\\.", "__"))).toString());
        }
        this.quoteSrcType = quoteScheme.getDynamicObject("pricesourceentity").getString("number");
        this.quoteType = quoteScheme.getDynamicObject("quoteentity").getString("number");
        this.quoteSrcConditon = quoteScheme.getString("quotesourceconditon");
        this.quoteConditon = quoteScheme.getString("quoteconditon");
        this.quoteSrcKeyInfo = QuoteHelper.getQuoteSrcCommonConst(this.quoteSrcType, this);
        FilterBuilder quoteSrcBuilder = QuoteHelper.convertStringToQFilter(this.quoteSrcConditon, this.quoteSrcType);
        if (quoteSrcBuilder != null) {
            this.quoteSrcFilter.and(quoteSrcBuilder.getQFilter());
            this.quoteSrcFilterDes = quoteSrcBuilder.getFilterStringDesc();
        }
        if ((quoteBuilder = QuoteHelper.convertStringToQFilter(this.quoteConditon, this.quoteType)) != null) {
            this.quoteFilter.and(quoteBuilder.getQFilter());
            this.quoteFilters = quoteBuilder.getQFilters();
        }
        DynamicObjectCollection sortEntry = quoteScheme.getDynamicObjectCollection("pricesortentity");
        for (DynamicObject sortInfo : sortEntry) {
            if (!StringUtils.isNotEmpty((String)sortInfo.getString("sortsign"))) continue;
            this.sortSignFields.add(sortInfo.getString("sortsign"));
            this.sortSignsDes.add(sortInfo.getString("sortsignname"));
            this.sortOrders.add(OrderEnum.getProptery((String)sortInfo.getString("order")));
            this.sortSignAlias.add(new StringBuffer(QuoteConst.RIGHT).append(new StringBuffer(sortInfo.getString("sortsign").replaceAll("\\.", "__"))).toString());
        }
        this.name = quoteScheme.getString("name");
        this.number = quoteScheme.getString("number");
        this.returnPattern = quoteScheme.getString("returnpattern");
        this.orgDivide = quoteScheme.getBoolean("orgdivide");
        this.use = quoteScheme.getString("use");
        return this;
    }

    public QuoteSchemeInfo generateSchemeInfo(DynamicObject quoteScheme, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        this.generateSchemeInfo(quoteScheme, quoteStrategySeqInfo.getSeq());
        this.quotePreConditon = quoteStrategySeqInfo.getPreCondition();
        this.quotePreConditonDesc = quoteStrategySeqInfo.getPreConditionDesc();
        this.terminationSign = StringUtils.isNotEmpty((String)quoteStrategySeqInfo.getTerminationSign()) ? new StringBuffer(QuoteConst.RIGHT).append(new StringBuffer(quoteStrategySeqInfo.getTerminationSign().replaceAll("\\.", "__"))).toString() : "";
        this.seq = quoteStrategySeqInfo.getSeq();
        FilterBuilder quotePreBuilder = QuoteHelper.convertFullStringToQFilter(this.quotePreConditon, this.quoteType);
        if (quotePreBuilder != null) {
            this.quotePreFilter.and(quotePreBuilder.getQFilter());
            this.quotePreFilters = quotePreBuilder.getQFilters();
        }
        return this;
    }

    public List<String> mergeQuoteSourceFields() {
        ArrayList<String> allSourceSelecties = new ArrayList<String>();
        this.getQuoteSourceDimensions().forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.getQuoteSourceResult().forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.getSortSignFields().forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        return allSourceSelecties;
    }

    public List<String> mergeQuoteSourceAlias() {
        ArrayList<String> allAliasSelecties = new ArrayList<String>();
        this.getQuoteSourceAlias().forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.getQuoteSourceResultAlias().forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.getSortSignAlias().forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        return allAliasSelecties;
    }

    public String getQuoteSrcConditon() {
        return this.quoteSrcConditon;
    }

    public String getQuoteConditon() {
        return this.quoteConditon;
    }

    public String getQuotePreConditon() {
        return this.quotePreConditon;
    }

    public String getQuoteSrcType() {
        return this.quoteSrcType;
    }

    public String getQuoteType() {
        return this.quoteType;
    }

    public List<String> getQuoteDimensions() {
        return this.quoteDimensions;
    }

    public List<String> getQuoteSourceDimensions() {
        return this.quoteSourceDimensions;
    }

    public List<String> getQuoteSourceResult() {
        return this.quoteSourceResult;
    }

    public List<String> getQuoteAlias() {
        return this.quoteAlias;
    }

    public List<String> getQuoteResults() {
        return this.quoteResults;
    }

    public List<String> getQuoteResultsAlias() {
        return this.quoteResultsAlias;
    }

    public List<String> getQuoteSourceAlias() {
        return this.quoteSourceAlias;
    }

    public List<String> getQuoteSourceResultAlias() {
        return this.quoteSourceResultAlias;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public List<QFilter> getQuoteFilters() {
        return this.quoteFilters;
    }

    public List<QFilter> getQuotePreFilters() {
        return this.quotePreFilters;
    }

    public QFilter getQuoteFilter() {
        return this.quoteFilter;
    }

    public QFilter getQuotePreFilter() {
        return this.quotePreFilter;
    }

    public QFilter getQuoteSrcFilter() {
        return this.quoteSrcFilter;
    }

    public List<String> getSortSignFields() {
        return this.sortSignFields;
    }

    public List<String> getSortOrders() {
        return this.sortOrders;
    }

    public String getTerminationSign() {
        return this.terminationSign;
    }

    public List<String> getSortSignAlias() {
        return this.sortSignAlias;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getId() {
        return this.id;
    }

    public int getSeq() {
        return this.seq;
    }

    public QuoteSrcKeyInfo getQuoteSrcKeyInfo() {
        return this.quoteSrcKeyInfo;
    }

    public String getQuoteSrcFilterDes() {
        return this.quoteSrcFilterDes;
    }

    public List<String> getSortSignsDes() {
        return this.sortSignsDes;
    }

    public List<String> getQuoteDimensionsDes() {
        return this.quoteDimensionsDes;
    }

    public List<String> getQuoteSourceDimensionsDes() {
        return this.quoteSourceDimensionsDes;
    }

    public String getReturnPattern() {
        return this.returnPattern;
    }

    public String getQuotePreConditonDesc() {
        return this.quotePreConditonDesc;
    }

    public void setQuoteSrcFilter(QFilter quoteSrcFilter) {
        this.quoteSrcFilter = quoteSrcFilter;
    }

    public boolean isOrgDivide() {
        return this.orgDivide;
    }

    public void setOrgDivide(boolean orgDivide) {
        this.orgDivide = orgDivide;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }
}

